/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.til.formplugin.inputtransferout.proportion;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.taxc.bdtaxr.common.constant.RuleTypeEnum;
import kd.taxc.bdtaxr.common.constant.TaxAppEnum;
import kd.taxc.bdtaxr.common.helper.tctb.orgtakerelation.TaxOrgTakeRelationServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.license.plugin.common.AbstractLicenseCheckBillPlugin;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgCheckUtil;
import kd.taxc.bdtaxr.common.util.RuleUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.til.formplugin.inputtransferout.proportion.InvoiceCallBackInfoService;

public class TransferOutProportionFormPlugin
extends AbstractLicenseCheckBillPlugin
implements BeforeF7SelectListener {
    private static Log logger = LogFactory.getLog(TransferOutProportionFormPlugin.class);
    InvoiceCallBackInfoService invoiceCallBackInfoService = new InvoiceCallBackInfoService();
    private static final String ORG = "org";
    private static final String ACCOUNT_ORG = "accountorg";
    private static final String TRANSFER_OUT_DATE = "transferoutdate";
    private static final Set<String> TAX_METHOD_JYZS = new HashSet<String>(){
        {
            this.add("4");
            this.add("5");
        }
    };

    public void registerListener(EventObject e) {
        BasedataEdit listener = (BasedataEdit)this.getControl(ACCOUNT_ORG);
        listener.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        boolean success = this.setAccountOrg();
        this.getModel().setValue(TRANSFER_OUT_DATE, (Object)DateUtils.getFirstDateOfMonth((Date)((Date)this.getModel().getValue(TRANSFER_OUT_DATE))));
        if (success) {
            this.preRunDraf();
        }
    }

    private boolean setAccountOrg() {
        DynamicObject taxOrg = (DynamicObject)this.getModel().getValue(ORG);
        if (ObjectUtils.isEmpty((Object)taxOrg)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7a0e\u52a1\u7ec4\u7ec7", (String)"TransferOutProportionFormPlugin_0", (String)"taxc-til", (Object[])new Object[0]));
            return false;
        }
        DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
        String orgid = org.getString("id");
        TaxAppEnum taxAppEnum = TaxAppEnum.getEnumInstanceByAppid((String)"tcvat");
        Boolean checkResult = OrgCheckUtil.withoutLicenseCheck((IFormView)this.getView(), (String)orgid, (String)"tcvat", (String)(taxAppEnum != null ? taxAppEnum.getCategoryCode() : null));
        if (checkResult.booleanValue()) {
            this.getModel().setValue(ORG, null);
            return false;
        }
        Date transferOuDate = (Date)this.getModel().getValue(TRANSFER_OUT_DATE);
        List<Long> accountOrgIdList = this.getAccountOrgIdList(taxOrg.getLong("id"), transferOuDate);
        this.getModel().setValue(ACCOUNT_ORG, (Object)(accountOrgIdList.size() > 0 ? accountOrgIdList.get(0) : Long.valueOf(taxOrg.getLong("id"))));
        return true;
    }

    private List<Long> getAccountOrgIdList(Long taxorg, Date transferOuDate) {
        List resultList = TaxOrgTakeRelationServiceHelper.getOrgTakeRelation(Collections.singletonList(taxorg), (Date)transferOuDate, (Date)transferOuDate);
        return resultList;
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String name = evt.getProperty().getName();
        if (ACCOUNT_ORG.equals(name)) {
            this.setAccountOrgFilter(evt);
        }
    }

    private void setAccountOrgFilter(BeforeF7SelectEvent evt) {
        DynamicObject taxOrg = (DynamicObject)this.getModel().getValue(ORG);
        if (ObjectUtils.isEmpty((Object)taxOrg)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7a0e\u52a1\u7ec4\u7ec7", (String)"TransferOutProportionFormPlugin_0", (String)"taxc-til", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        Date transferOuDate = (Date)this.getModel().getValue(TRANSFER_OUT_DATE);
        List<Long> accountOrgIdList = this.getAccountOrgIdList(taxOrg.getLong("id"), transferOuDate);
        ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
        QFilter filter = new QFilter("id", "in", accountOrgIdList);
        formShowParameter.getListFilterParameter().setFilter(filter);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        OperationResult opResult;
        super.afterDoOperation(afterDoOperationEventArgs);
        String itemKey = afterDoOperationEventArgs.getOperateKey();
        if ("reset".equals(itemKey) && (opResult = afterDoOperationEventArgs.getOperationResult()) != null && opResult.isSuccess()) {
            Boolean manualregiste = (Boolean)this.getModel().getValue("manualregiste");
            if (manualregiste.booleanValue()) {
                this.getModel().setValue("unablededucttax", (Object)BigDecimal.ZERO);
                this.getModel().setValue("totalsales", (Object)BigDecimal.ZERO);
                this.getModel().setValue("projectsales", (Object)BigDecimal.ZERO);
            } else {
                this.preRunDraf();
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        String itemKey = source.getOperateKey();
        if ("save".equals(itemKey)) {
            DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
            if (org != null && !((Boolean)TaxcMainDataServiceHelper.isTaxcMainByOrgId((Long)org.getLong("id")).getData()).booleanValue()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u52a1\u7ec4\u7ec7\u672a\u5ba1\u6838\u6216\u4e0d\u53ef\u7528\uff0c\u65e0\u6cd5\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u3002", (String)"TransferOutProportionFormPlugin_1", (String)"taxc-til", (Object[])new Object[0]));
                args.setCancel(true);
            }
            String billno = (String)this.getModel().getValue("billno");
            IAppCache cache = AppCache.get((String)"tcvat");
            List list = (List)cache.get(billno, List.class);
            if (list != null) {
                String callbackinfo = SerializationUtils.toJsonString((Object)list);
                this.getModel().setValue("callbackinfo", (Object)callbackinfo);
            }
        }
    }

    private void preRunDraf() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        try {
            DynamicObject transferouttype = (DynamicObject)this.getModel().getValue("transferouttype");
            if (null == transferouttype) {
                return;
            }
            DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
            Date date = (Date)this.getModel().getValue(TRANSFER_OUT_DATE);
            String firstDateOfMonthStr = DateUtils.getFirstDateOfMonthStr((Date)date, (String)"yyyy-MM-dd");
            String lastDateOfMonthStr = DateUtils.getLastDateOfMonthStr((Date)date, (String)"yyyy-MM-dd");
            List<Long> accountOrgIdList = this.getAccountOrgIdList(org.getLong("id"), date);
            params.put("ybnsrOrgRelation", accountOrgIdList);
            params.put(ORG, org.getString("id"));
            params.put("startDate", firstDateOfMonthStr);
            params.put("endDate", lastDateOfMonthStr);
            params.put("taxperiod", DateUtils.formatMonth((Date)date));
            params.put("requestcontext", RequestContext.getOrCreate());
            params.put("taxpayertype", "zzsybnsr");
            params.put("rulePurpose", "nssb");
            params.put("transferouttype", transferouttype.getString("number"));
            Map<String, BigDecimal> incomeAmountMap = this.queryIncomeDraft(params);
            params.put("incomeamount", incomeAmountMap);
            String billno = (String)this.getModel().getValue("billno");
            params.put("billno", billno);
            IAppCache cache = AppCache.get((String)"tcvat");
            cache.remove(billno);
            logger.info("\u8fdb\u9879\u8f6c\u51fa\u6bd4\u4f8b\u5206\u644a\u53c2\u6570" + params);
            Map result = (Map)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tcvat", (String)"TransferOutProportionService", (String)"getAmount", (Object[])new Object[]{params});
            logger.info("\u8fdb\u9879\u8f6c\u51fa\u6bd4\u4f8b\u5206\u644a\u7ed3\u7b97\u7ed3\u679c" + result);
            this.getModel().setValue("unablededucttax", result.get("unablededucttax"));
            this.getModel().setValue("totalsales", result.get("totalsales"));
            this.getModel().setValue("projectsales", result.get("projectsales"));
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u91cd\u65b0\u8ba1\u7b97\u6210\u529f\u3002", (String)"TransferOutProportionFormPlugin_2", (String)"taxc-til", (Object[])new Object[0]));
        }
        catch (Exception ex) {
            logger.error("\u8fdb\u9879\u8f6c\u51fa\u6bd4\u4f8b\u5206\u644a\u5f02\u5e38" + ex.getStackTrace()[0] + ex.getStackTrace()[1]);
        }
    }

    private Map<String, BigDecimal> queryIncomeDraft(Map<String, Object> params) {
        Map<String, BigDecimal> resultMap = new HashMap<String, BigDecimal>(8);
        DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
        Date date = (Date)this.getModel().getValue(TRANSFER_OUT_DATE);
        String transferouttype = (String)params.get("transferouttype");
        List apportionRuleList = (List)RuleUtils.getSharingAndOrgRules((Long)org.getLong("id"), (RuleTypeEnum)RuleTypeEnum.APPORTION, (String)"ybnsr", (String)"nssb").get(RuleTypeEnum.APPORTION);
        DynamicObject resultRule = null;
        for (DynamicObject rule : apportionRuleList) {
            String transferOutType = rule.getString("wfhfzclx");
            if (!transferOutType.equals(transferouttype)) continue;
            resultRule = rule;
            break;
        }
        if (null == resultRule) {
            return resultMap;
        }
        boolean taxAmountFromIncomeDraft = resultRule.getBoolean("isfromdraft1");
        boolean projectSalesFromIncomeDraft = resultRule.getBoolean("1".equals(resultRule.getString("wfhfzclx")) ? "isfromdraft12" : "isfromdraft11");
        if (taxAmountFromIncomeDraft || projectSalesFromIncomeDraft) {
            QFilter taxPeriodFilter;
            QFilter orgFilter = new QFilter(ORG, "=", (Object)org.getLong("id"));
            DynamicObject[] genericObjects = BusinessDataServiceHelper.load((String)"tcvat_account_summary", (String)"description,taxamount,accountingamount,invoiceamount,businessamount,taxmethodtype,taxrate,taxperiod,serialno,jzjt,businesstype,taxreductioncode,taxreductionname,taxreductiontype,taxreductionid,taxmethod,org,ruleid,invoicetaxamount,nonetaxamount,specialinvoiceamount,otherinvoiceamount,othertaxamount,totaltaxamount,pricetaxamount,specialtaxamount,deadline,initaccountingamount,id", (QFilter[])new QFilter[]{orgFilter, taxPeriodFilter = new QFilter("taxperiod", "=", (Object)DateUtils.getLastDateOfMonthStr((Date)date, (String)"yyyy-MM"))});
            if (genericObjects.length > 0) {
                BigDecimal taxAmount = BigDecimal.ZERO;
                BigDecimal jyzsTaxAmount = BigDecimal.ZERO;
                BigDecimal msTaxAmount = BigDecimal.ZERO;
                BigDecimal ckmsAmount = BigDecimal.ZERO;
                for (DynamicObject object : genericObjects) {
                    taxAmount = taxAmount.add(object.getBigDecimal("taxamount"));
                    if (TAX_METHOD_JYZS.contains(object.getString("taxmethodtype"))) {
                        jyzsTaxAmount = jyzsTaxAmount.add(object.getBigDecimal("taxamount"));
                    }
                    if ("3".equals(object.getString("taxmethodtype"))) {
                        msTaxAmount = msTaxAmount.add(object.getBigDecimal("taxamount"));
                    }
                    if (!"19".equals(object.getString("taxmethodtype"))) continue;
                    ckmsAmount = ckmsAmount.add(object.getBigDecimal("taxamount"));
                }
                resultMap.put("taxamount", taxAmount);
                resultMap.put("jyzstaxamount", jyzsTaxAmount);
                resultMap.put("mstaxamount", msTaxAmount);
                resultMap.put("ckmsamount", ckmsAmount);
            } else {
                resultMap = (Map)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tcvat", (String)"IncomeEngineService", (String)"execute", (Object[])new Object[]{params});
            }
        }
        return resultMap;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Boolean manualregiste;
        String name = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        if (null == newValue) {
            return;
        }
        if (name.equals("manualregiste") && !((Boolean)newValue).booleanValue()) {
            this.preRunDraf();
            return;
        }
        if (name.equals(ORG) || name.equals("transferouttype")) {
            manualregiste = (Boolean)this.getModel().getValue("manualregiste");
            if (manualregiste.booleanValue()) {
                return;
            }
            this.preRunDraf();
        }
        if (name.equals(TRANSFER_OUT_DATE)) {
            manualregiste = (Boolean)this.getModel().getValue("manualregiste");
            if (manualregiste.booleanValue()) {
                return;
            }
            if (name.equals(TRANSFER_OUT_DATE)) {
                this.getModel().setValue(TRANSFER_OUT_DATE, (Object)DateUtils.getFirstDateOfMonth((Date)((Date)newValue)));
                Date transferOutDate = (Date)this.getModel().getValue(TRANSFER_OUT_DATE);
                if (0 == DateUtils.getDayDiff((Date)((Date)newValue), (Date)transferOutDate)) {
                    this.preRunDraf();
                }
            }
        }
    }
}

