/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.til.formplugin.out;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.FilterContainerInitEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.SearchClickEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgUtils;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.KdToolUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import kd.taxc.til.formplugin.out.TioSaleImportPlugin;
import kd.taxc.til.formplugin.out.bean.TotalBean;
import kd.taxc.til.formplugin.out.enums.OutSaleTypeEnum;
import kd.taxc.til.formplugin.tio.TioCheckCertListPlugin;
import kd.taxc.til.formplugin.utils.SelectStyleUtil;
import kd.taxc.til.formplugin.utils.TilOrgUtil;

public class TioOutLoginSaleListPlugin
extends AbstractListPlugin
implements HyperLinkClickListener,
RowClickEventListener {
    private static final String FILTER_CONTAINER_AP = "filtercontainerap";
    private static final String BILL_LIST_AP = "billlistap";
    private static final String LOGIN_COUNT_FLEX = "logincountflex";
    private static final String LOGIN_TAX_TOTAL_FLEX = "logintaxtotalflex";
    private static final String LOGIN_TOTAL_FLEX = "logintotalflex";
    private static final String TOP_1_FLEX = "top1flex";
    private static final String TOP_2_FLEX = "top2flex";
    private static final String TOP_3_FLEX = "top3flex";
    private static final String TODAY_IDS = "todayids";
    private static Log LOGGER = LogFactory.getLog(TioCheckCertListPlugin.class);

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addClickListeners(new String[]{LOGIN_COUNT_FLEX, LOGIN_TAX_TOTAL_FLEX, LOGIN_TOTAL_FLEX});
        this.addClickListeners(new String[]{TOP_1_FLEX, TOP_2_FLEX, TOP_3_FLEX});
    }

    public void afterCreateNewData(EventObject e) {
        this.initBoard(null);
    }

    public void initialize() {
        FilterContainer filterContainer = (FilterContainer)this.getView().getControl(FILTER_CONTAINER_AP);
        filterContainer.setBillFormId("til_sale");
        filterContainer.addFilterContainerInitListener(event -> this.filterContainerInit(event));
        filterContainer.addSearchClickListener(event -> this.filterSearchClickEvent(event));
        filterContainer.addBeforeF7SelectListener(this::filterContainerBeforeF7Select);
        BillList billList = (BillList)this.getControl(BILL_LIST_AP);
        billList.addSetFilterListener(this::setFilter);
        billList.addHyperClickListener(this::hyperLinkClick);
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        String selectFlexKey = this.getPageCache().get("selectedflexkey");
        if (EmptyCheckUtils.isNotEmpty((Object)selectFlexKey)) {
            String cacheKey = null;
            if (LOGIN_COUNT_FLEX.equalsIgnoreCase(selectFlexKey) || LOGIN_TAX_TOTAL_FLEX.equalsIgnoreCase(selectFlexKey) || LOGIN_TOTAL_FLEX.equalsIgnoreCase(selectFlexKey)) {
                cacheKey = TODAY_IDS;
            } else if (selectFlexKey.startsWith("top") && selectFlexKey.length() > 6) {
                cacheKey = "top" + selectFlexKey.substring(3, 4) + "flexids";
            }
            String ids = this.getPageCache().get(cacheKey);
            QFilter qFilter = new QFilter("id", "in", (Object)(EmptyCheckUtils.isEmpty((Object)ids) ? Collections.singletonList(-1L) : KdToolUtils.stringToLong((String[])ids.split(","))));
            e.getQFilters().add(qFilter);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if ("add".equalsIgnoreCase(itemKey)) {
            this.openBill(null);
        } else if ("delete".equalsIgnoreCase(itemKey)) {
            this.delete();
        } else if ("import".equalsIgnoreCase(itemKey)) {
            this.importData();
        } else if ("export".equalsIgnoreCase(itemKey)) {
            this.exportData();
        } else if ("refresh".equalsIgnoreCase(itemKey)) {
            this.refresh();
        }
    }

    private void exportData() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("bos_exportdataprogress");
        showParameter.setCustomParam("BillFormId", (Object)"til_sale");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("entitynumber", (Object)"til_sale");
        showParameter.setCustomParam("entityname", (Object)ResManager.loadKDString((String)"\u89c6\u540c\u9500\u552e\u767b\u8bb0", (String)"TioOutLoginSaleListPlugin_0", (String)"taxc-til", (Object[])new Object[0]));
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "closeimport"));
        this.getView().showForm(showParameter);
    }

    private void importData() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("bos_importstart");
        showParameter.setCustomParam("BillFormId", (Object)"til_sale");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        ArrayList plugins = new ArrayList();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Enabled", Boolean.TRUE);
        map.put("ClassName", TioSaleImportPlugin.class);
        plugins.add(map);
        showParameter.setCustomParam("ListName", (Object)ResManager.loadKDString((String)"\u89c6\u540c\u9500\u552e", (String)"TioOutLoginSaleListPlugin_1", (String)"taxc-til", (Object[])new Object[0]));
        showParameter.setCustomParam("plugins", plugins);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "closeimport"));
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionid = closedCallBackEvent.getActionId();
        if ("til_sale".equalsIgnoreCase(actionid) || "closeimport".equalsIgnoreCase(actionid)) {
            this.refresh();
        }
    }

    private void refresh() {
        String selkey = this.getPageCache().get("selectedflexkey");
        this.initBoard(this.getPageCache().get("verifyOrg"));
        if (EmptyCheckUtils.isNotEmpty((Object)selkey)) {
            if (LOGIN_COUNT_FLEX.equalsIgnoreCase(selkey) || LOGIN_TAX_TOTAL_FLEX.equalsIgnoreCase(selkey) || LOGIN_TOTAL_FLEX.equalsIgnoreCase(selkey)) {
                this.displayBillList(TODAY_IDS);
            } else if (TOP_1_FLEX.equalsIgnoreCase(selkey) || TOP_2_FLEX.equalsIgnoreCase(selkey) || TOP_3_FLEX.equalsIgnoreCase(selkey)) {
                this.displayBillList(selkey + "ids");
            }
        } else {
            BillList billList = (BillList)this.getControl(BILL_LIST_AP);
            billList.clearSelection();
            billList.refresh();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        if ("delete".equals(messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            BillList billList = (BillList)this.getControl(BILL_LIST_AP);
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            Object[] pkids = selectedRows.getPrimaryKeyValues();
            DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"til_sale"), (Object[])pkids);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f", (String)"TioOutLoginSaleListPlugin_2", (String)"taxc-til", (Object[])new Object[0]));
            billList.clearEntryState();
            billList.clearSelection();
            this.refresh();
        }
    }

    private void delete() {
        BillList billList = (BillList)this.getControl(BILL_LIST_AP);
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (null == selectedRows || selectedRows.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"TioOutLoginSaleListPlugin_3", (String)"taxc-til", (Object[])new Object[0]));
            return;
        }
        ConfirmCallBackListener callBack = new ConfirmCallBackListener("delete", (IFormPlugin)this);
        this.getView().showConfirm(ResManager.loadKDString((String)"\u5220\u9664\u540e\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\u786e\u5b9a\u5220\u9664?", (String)"TioOutLoginSaleListPlugin_4", (String)"taxc-til", (Object[])new Object[0]), MessageBoxOptions.YesNo, callBack);
    }

    private void openBill(Object pkValue) {
        BillShowParameter parameter = new BillShowParameter();
        parameter.setFormId("til_sale");
        if (pkValue == null) {
            parameter.setBillStatus(BillOperationStatus.ADDNEW);
        } else {
            parameter.setStatus(OperationStatus.EDIT);
            parameter.setBillStatus(BillOperationStatus.EDIT);
            parameter.setPageId(String.valueOf(pkValue));
            parameter.setPkId(pkValue);
        }
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "til_sale");
        parameter.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void filterSearchClickEvent(SearchClickEvent searchClickEvent) {
        BillList billList = (BillList)this.getView().getControl(BILL_LIST_AP);
        Map map = searchClickEvent.getFilterValues();
        List customlist = (List)map.get("customfilter");
        List schemelist = (List)map.get("schemefilter");
        List fastlist = (List)map.get("fastfilter");
        FilterParameter fastFilterParameter = searchClickEvent.getFilterModel().getFastFilterParameter(fastlist);
        List fastQFilterList = fastFilterParameter.getQFilters();
        FilterParameter commonFilterParameter = searchClickEvent.getFilterModel().getCommonFilterParameter(customlist);
        List commonQFilterList = commonFilterParameter.getQFilters();
        FilterParameter schemaFilterParameter = searchClickEvent.getFilterModel().getSchemeFilterParameter(schemelist);
        List schemaQFilterList = schemaFilterParameter.getQFilters();
        fastQFilterList.addAll(commonQFilterList);
        fastQFilterList.addAll(schemaQFilterList);
        QFilter orgFilter = this.getOrgFilter(commonQFilterList, billList.getFilterParameter().getQFilters());
        if (EmptyCheckUtils.isNotEmpty((Object)orgFilter)) {
            fastQFilterList.add(orgFilter);
        }
        billList.setFilterParameter(fastFilterParameter);
        billList.clearSelection();
        billList.refresh();
    }

    private QFilter getOrgFilter(List<QFilter> commonQFilterList, List<QFilter> qFilters) {
        for (QFilter qFilter : commonQFilterList) {
            if (!qFilter.getProperty().equalsIgnoreCase("org.id")) continue;
            return null;
        }
        for (int i = qFilters.size() - 1; i >= 0; --i) {
            QFilter qFilter;
            if (!qFilters.get(i).getProperty().equalsIgnoreCase("org")) continue;
            qFilter = qFilters.get(i);
            Object val = qFilter.getValue();
            if (null != val && val instanceof List) {
                qFilter.__setValue(((List)val).stream().map(v -> Long.parseLong(String.valueOf(v))).collect(Collectors.toList()));
            }
            return qFilters.get(i);
        }
        return null;
    }

    private void filterContainerInit(FilterContainerInitEvent event) {
        List filterColumnList = event.getCommonFilterColumns();
        CommonFilterColumn orgColumn = null;
        for (FilterColumn column : filterColumnList) {
            if (!column.getFieldName().startsWith("org.")) continue;
            orgColumn = (CommonFilterColumn)column;
        }
        String oldselectflexkey = this.getPageCache().get("selectedflexkey");
        if (EmptyCheckUtils.isNotEmpty((Object)oldselectflexkey)) {
            this.getPageCache().remove("selectedflexkey");
            SelectStyleUtil.cancelSelect(oldselectflexkey, this.getView());
        }
        QFilter qFilter = null;
        List<Object> allrightorgids = new ArrayList();
        if (orgColumn != null) {
            List<ComboItem> orgCombos = TilOrgUtil.getOrgComboItem(this.getView());
            allrightorgids = orgCombos.stream().map(v -> Long.parseLong(v.getValue())).collect(Collectors.toList());
            if (!orgCombos.isEmpty()) {
                orgColumn.setDefaultValues(Collections.emptyList());
            } else {
                qFilter = new QFilter("org", "=", (Object)-1L);
            }
            orgColumn.setType("enum");
            orgColumn.setMulti(true);
            orgColumn.setComboItems(orgCombos);
        }
        BillList billlist = (BillList)this.getControl(BILL_LIST_AP);
        if (EmptyCheckUtils.isNotEmpty((Object)this.getPageCache().get("isFirst"))) {
            Class<CommonFilterColumn> clas = CommonFilterColumn.class;
            try {
                String newOrgValTemp;
                Field field = clas.getDeclaredField("selectedCommomFilterFieldValues");
                AccessibleObject.setAccessible(new AccessibleObject[]{field}, true);
                List list = (List)field.get(orgColumn);
                if (EmptyCheckUtils.isNotEmpty((Object)list)) {
                    qFilter = new QFilter("org", "in", (Object)list);
                    newOrgValTemp = list.stream().map(v -> String.valueOf(v)).collect(Collectors.joining(","));
                } else if (null != this.getPageCache().get("verifyOrg")) {
                    qFilter = new QFilter("org", "in", allrightorgids);
                    newOrgValTemp = allrightorgids.stream().map(v -> String.valueOf(v)).collect(Collectors.joining(","));
                } else {
                    newOrgValTemp = list.stream().map(v -> String.valueOf(v)).collect(Collectors.joining(","));
                }
                String oldOrgVal = this.getPageCache().get("verifyOrg");
                if (EmptyCheckUtils.isEmpty((Object)oldOrgVal)) {
                    this.getPageCache().put("verifyOrg", newOrgValTemp);
                    this.initBoard(newOrgValTemp);
                } else if (EmptyCheckUtils.isNotEmpty((Object)oldOrgVal) && !this.isSameOrg(newOrgValTemp, oldOrgVal)) {
                    this.initBoard(newOrgValTemp);
                    this.getPageCache().put("verifyOrg", newOrgValTemp);
                }
                billlist.getFilterParameter().setFilter(qFilter);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                LOGGER.error(ResManager.loadKDString((String)"\u83b7\u53d6\u591a\u9009\u7ec4\u7ec7\u5931\u8d25", (String)"TioOutLoginSaleListPlugin_3", (String)"taxc-tctb-formplugin", (Object[])new Object[0]), (Throwable)e);
            }
        } else {
            this.getPageCache().put("isFirst", "false11");
        }
    }

    private boolean isSameOrg(String newOrgValTemp, String oldOrgVal) {
        List newOrgList = Arrays.stream(newOrgValTemp.split(",")).distinct().collect(Collectors.toList());
        List oldOrgList = Arrays.stream(oldOrgVal.split(",")).distinct().collect(Collectors.toList());
        if (EmptyCheckUtils.isEmpty(newOrgList) || EmptyCheckUtils.isEmpty(oldOrgList)) {
            return false;
        }
        if (newOrgList.size() != oldOrgList.size()) {
            return false;
        }
        List list = Stream.of(newOrgList, oldOrgList).flatMap(Collection::stream).distinct().collect(Collectors.toList());
        return list.size() == oldOrgList.size();
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
    }

    public List<Long> getDefaultOrgIds() {
        HasPermOrgResult hasPermOrgResult = PermissionUtils.getAllPermOrgs((IFormView)this.getView());
        if (!hasPermOrgResult.hasAllOrgPerm()) {
            return hasPermOrgResult.getHasPermOrgs();
        }
        return null;
    }

    private void initBoard(String newOrgValTemp) {
        List orgids = null == newOrgValTemp || newOrgValTemp.trim().length() == 0 ? this.getDefaultOrgIds() : KdToolUtils.stringToLong((String[])newOrgValTemp.split(","));
        QFilter orgFilter = null == orgids ? null : new QFilter("org", "in", (Object)orgids);
        this.initToDayBoard(orgFilter);
        this.initTopBoard(orgFilter);
    }

    private void initTopBoard(QFilter orgFilter) {
        QFilter createDateS = new QFilter("postdate", ">=", (Object)DateUtils.getFirstDateOfMonth((Date)new Date()));
        QFilter createDateE = new QFilter("postdate", "<=", (Object)DateUtils.getLastDateOfMonth((Date)new Date()));
        this.doInitTopBoard(null == orgFilter ? QueryServiceHelper.query((String)"til_sale", (String)"id,amount,saletype", (QFilter[])new QFilter[]{createDateE, createDateS}) : QueryServiceHelper.query((String)"til_sale", (String)"id,amount,saletype", (QFilter[])new QFilter[]{orgFilter, createDateE, createDateS}));
    }

    private void doInitTopBoard(DynamicObjectCollection dynamicObjects) {
        int a2;
        Comparator comparator = (a, b) -> {
            BigDecimal bbigDecimal;
            BigDecimal abigDecimal = a.getDynamicObjectList().stream().map(v -> v.getBigDecimal("amount")).reduce(BigDecimal.ZERO, BigDecimal::add);
            if (abigDecimal.compareTo(bbigDecimal = b.getDynamicObjectList().stream().map(v -> v.getBigDecimal("amount")).reduce(BigDecimal.ZERO, BigDecimal::add)) > 0) {
                return -1;
            }
            if (abigDecimal.compareTo(bbigDecimal) < 0) {
                return 1;
            }
            String acode = OutSaleTypeEnum.getEnumByCode(a.getSaleType()).getCode();
            String bcode = OutSaleTypeEnum.getEnumByCode(a.getSaleType()).getCode();
            Integer acodei = Integer.parseInt(acode);
            Integer bcodei = Integer.parseInt(bcode);
            if (acodei > bcodei) {
                return 1;
            }
            return -1;
        };
        List totalBeanList = dynamicObjects.stream().collect(Collectors.groupingBy(k -> k.getString("saletype"))).entrySet().stream().map(m -> new TotalBean(((List)m.getValue()).size(), (String)m.getKey(), (List)m.getValue())).sorted(comparator).limit(3L).collect(Collectors.toList());
        ArrayList<String> names = new ArrayList<String>(10);
        for (int i = 0; i < totalBeanList.size(); ++i) {
            Label label = (Label)this.getControl("top" + (i + 1) + "name");
            String name = OutSaleTypeEnum.getEnumByCode(((TotalBean)totalBeanList.get(i)).getSaleType()).getName();
            names.add(name);
            label.setText(name);
            this.getModel().setValue("top" + (i + 1) + "total", (Object)((TotalBean)totalBeanList.get(i)).getDynamicObjectList().stream().map(v -> v.getBigDecimal("amount")).reduce(BigDecimal.ZERO, BigDecimal::add));
            this.getPageCache().put("top" + (i + 1) + "flexids", ((TotalBean)totalBeanList.get(i)).getDynamicObjectList().stream().map(v -> v.getString("id")).collect(Collectors.joining(",")));
        }
        int index = 0;
        for (int i = a2 = names.size() + 1; i < 4; ++i) {
            Label label = (Label)this.getControl("top" + i + "name");
            String name = OutSaleTypeEnum.values()[index].getName();
            while (names.contains(name)) {
                name = OutSaleTypeEnum.values()[++index].getName();
            }
            names.add(name);
            label.setText(name);
            this.getModel().setValue("top" + i + "total", (Object)BigDecimal.ZERO);
            this.getPageCache().put("top" + i + "flexids", "-1");
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        if ("bos_org".equals(args.getRefEntityId())) {
            HasPermOrgResult result = PermissionUtils.getAllPermOrgs((IFormView)this.getView());
            if (result == null || result.hasAllOrgPerm()) {
                return;
            }
            OrgUtils.addFilterByConditionBeforeF7Select((Object)args, (IFormView)this.getView(), (String[])new String[]{"til_sign_ticket"}, null, null);
        }
    }

    private void initToDayBoard(QFilter orgFilter) {
        QFilter createDateS = new QFilter("createdatefield", ">=", (Object)DateUtils.getDayFirst((Date)new Date()));
        QFilter createDateE = new QFilter("createdatefield", "<=", (Object)DateUtils.getDayLast((Date)new Date()));
        this.doInitToDayBoard(null == orgFilter ? QueryServiceHelper.query((String)"til_sale", (String)"id,amount,taxamount", (QFilter[])new QFilter[]{createDateE, createDateS}) : QueryServiceHelper.query((String)"til_sale", (String)"id,amount,taxamount", (QFilter[])new QFilter[]{orgFilter, createDateE, createDateS}));
    }

    private void doInitToDayBoard(DynamicObjectCollection dynamicObjects) {
        BigDecimal total = BigDecimal.ZERO;
        BigDecimal taxTotal = BigDecimal.ZERO;
        ArrayList<String> ids = new ArrayList<String>(10);
        for (DynamicObject dynamicObject : dynamicObjects) {
            ids.add(dynamicObject.getString("id"));
            total = BigDecimalUtil.addObject((Object)total, (Object)dynamicObject.get("amount"));
            taxTotal = BigDecimalUtil.addObject((Object)taxTotal, (Object)dynamicObject.get("taxamount"));
        }
        this.getModel().setValue("logincount", (Object)dynamicObjects.size());
        this.getModel().setValue("logintotal", (Object)total);
        this.getModel().setValue("logintaxtotal", (Object)taxTotal);
        this.getPageCache().put(TODAY_IDS, ids.stream().collect(Collectors.joining(",")));
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        BillList billList = (BillList)this.getControl(BILL_LIST_AP);
        ListSelectedRow listSelectedRow = billList.getCurrentSelectedRowInfo();
        this.openBill(listSelectedRow.getPrimaryKeyValue());
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (EmptyCheckUtils.isNotEmpty((Object)this.getPageCache().get("selectedflexkey"))) {
            String oldselectflexkey = this.getPageCache().get("selectedflexkey");
            if (!oldselectflexkey.equalsIgnoreCase(key)) {
                SelectStyleUtil.cancelSelect(oldselectflexkey, this.getView());
                SelectStyleUtil.select(key, this.getView());
            }
        } else {
            SelectStyleUtil.select(key, this.getView());
        }
        if (LOGIN_COUNT_FLEX.equalsIgnoreCase(key) || LOGIN_TAX_TOTAL_FLEX.equalsIgnoreCase(key) || LOGIN_TOTAL_FLEX.equalsIgnoreCase(key)) {
            this.displayBillList(TODAY_IDS);
        } else if (TOP_1_FLEX.equalsIgnoreCase(key) || TOP_2_FLEX.equalsIgnoreCase(key) || TOP_3_FLEX.equalsIgnoreCase(key)) {
            this.displayBillList(key + "ids");
        }
    }

    private void displayBillList(String cacheKey) {
        String ids = this.getPageCache().get(cacheKey);
        QFilter qFilter = new QFilter("id", "in", (Object)(EmptyCheckUtils.isEmpty((Object)ids) ? Collections.singletonList(-1L) : KdToolUtils.stringToLong((String[])ids.split(","))));
        BillList billList = (BillList)this.getControl(BILL_LIST_AP);
        billList.getFilterParameter().getFilters().clear();
        billList.getFilterParameter().getQFilters().clear();
        billList.getFilterParameter().setFilter(qFilter);
        FilterParameter filterParameter = billList.getFilterParameter();
        billList.setFilterParameter(filterParameter);
        billList.refresh();
    }
}

