/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.til.formplugin.out;

import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgCheckUtil;
import kd.taxc.til.formplugin.out.enums.OutSaleTypeEnum;

public class TioSaleFormPlugin
extends AbstractFormPlugin {
    private static final String SALE_TYPE = "saletype";
    private static final String SECEND_TYPE = "secendtype";
    private static final String ORG = "org";

    public void afterCreateNewData(EventObject e) {
        this.initOrg();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if (SALE_TYPE.equalsIgnoreCase(name)) {
            this.dealSecondType(e.getChangeSet());
        }
    }

    private void dealSecondType(ChangeData[] changeData) {
        if (changeData != null && changeData.length > 0) {
            String newSaleType = (String)changeData[0].getNewValue();
            OutSaleTypeEnum outSaleTypeEnum = OutSaleTypeEnum.getEnumByCode(newSaleType);
            ComboEdit comboEdit = (ComboEdit)this.getControl(SECEND_TYPE);
            List items = outSaleTypeEnum.getSecondEnumList().stream().map(v -> new ComboItem(new LocaleString(v.getName()), v.getCode())).collect(Collectors.toList());
            comboEdit.setComboItems(items);
            this.getModel().setValue(SECEND_TYPE, (Object)((ComboItem)items.get(0)).getValue());
        }
    }

    private void initOrg() {
        String orgid = OrgCheckUtil.findTaxOrg((IFormView)this.getView(), (String)ORG, (IPageCache)this.getPageCache());
        if (null != orgid) {
            this.getModel().setValue(ORG, (Object)orgid);
            this.getPageCache().put("orgid", orgid);
        }
    }
}

