/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.til.formplugin.project;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Button;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public class TilDevideDetailPlugin
extends AbstractFormPlugin {
    public static final String BTNOK = "btnok";
    public static final String ENTRYENTITY = "entryentity";
    public static final String COMMA = ",";
    public static final String SUMTAX = "sumtax";
    public static final String SELECTSUMTAX = "selectsumtax";
    public static final String INVOICES = "invoices";
    public static final String DIVIDE_TYPE = "radiogroupfield";
    public static final String DIVIDE_TYPE_COMCTRACT = "a";
    public static final String DIVIDE_TYPE_CUSTOMERATIO = "b";
    public static final String DIVIDE_TYPE_AMOUNT = "c";
    public static final String ENTITY_DEVIDE_DETAIL = "til_devide_detail";
    public static final String ENTITY_PROJECT_INFO = "tcvat_prepay_project_info";
    public static final String AMOUNT = "amount";
    public static final String ID = "id";
    public static final String PROJECTID = "projectid";
    public static final String PROJECT = "project";
    public static final String CONTRACTAMOUNT = "contractamount";
    public static final String INTTAXAMOUNT = "inttaxamount";
    public static final String TEXTSEQ = "textseq";
    public static final String INTAMOUNT = "intamount";
    public static final String FLOATRATIO = "floatratio";
    public static final String INTTAXAMOUNT1 = "inttaxamount";
    public static final String DEVICERATIO = "deviceratio";
    public static final String DEVIDETAX = "devidetax";
    public static final String PROJECT_ID = "project.id";
    public static final String INVOICEID = "invoiceid";
    public static final String TYPE = "type";
    public static final String NEW_INVOICE_TYPE_ENTITY = "baseinvoicetype";
    public static final String ORG = "org";
    public static final String INVOICECODE = "invoicecode";
    public static final String INVOICENO = "invoiceno";
    public static final String SUMTAXAMOUNT = "sumtaxamount";
    public static final String DEVIDETYPE = "devidetype";
    public static final String INVOICENO1 = "invoiceno";
    public static final String ORG1 = "org";
    public static final String TAXAMOUNT = "taxamount";
    public static final String PROJECT_FILEDS = "contractentity.amount as amount,id,name,number,levytype";
    public static final String CREATETIME = "createtime";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTNOK});
    }

    public void afterCreateNewData(EventObject e) {
        List invoices;
        BigDecimal selectsumtax = (BigDecimal)this.getView().getFormShowParameter().getCustomParam(SELECTSUMTAX);
        if (selectsumtax != null) {
            this.getModel().setValue(SUMTAX, (Object)selectsumtax);
        }
        this.initEntity();
        Object selectRows = this.getView().getFormShowParameter().getCustomParam(INVOICES);
        if (selectRows != null && (invoices = (List)selectRows).size() > 1) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"radiofield2"});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Object radiogroupfield;
        Object newValue;
        String name = e.getProperty().getName();
        if (DIVIDE_TYPE.equals(name) && DIVIDE_TYPE_COMCTRACT.equals(newValue = e.getChangeSet()[0].getNewValue())) {
            this.initEntity();
            this.getModel().setDataChanged(false);
        }
        if (FLOATRATIO.equals(name) && DIVIDE_TYPE_CUSTOMERATIO.equals(radiogroupfield = this.getModel().getValue(DIVIDE_TYPE))) {
            int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTRYENTITY);
            Object sumtax = this.getModel().getValue(SUMTAX);
            if (sumtax != null) {
                BigDecimal sumtaxValue = (BigDecimal)sumtax;
                BigDecimal newValue2 = (BigDecimal)e.getChangeSet()[0].getNewValue();
                this.getModel().setValue("inttaxamount", (Object)newValue2.multiply(sumtaxValue).setScale(2, 4), rowIndex);
            }
        }
    }

    public void click(EventObject evt) {
        Button btn;
        super.click(evt);
        Object source = evt.getSource();
        if (source instanceof Button && (btn = (Button)source).getKey().equals(BTNOK)) {
            Object radiogroup = this.getModel().getValue(DIVIDE_TYPE);
            if (radiogroup.equals(DIVIDE_TYPE_CUSTOMERATIO) ? !this.checkDivideRatio() : radiogroup.equals(DIVIDE_TYPE_AMOUNT) && !this.checkDivideAmount()) {
                return;
            }
            this.saveDivideDetail(radiogroup.toString());
            this.getView().returnDataToParent((Object)"save_success");
            this.getView().close();
        }
    }

    private void saveDivideDetail(String divideType) {
        JSONArray selectRows = (JSONArray)this.getView().getFormShowParameter().getCustomParam(INVOICES);
        int entryRowCount = this.getModel().getEntryRowCount(ENTRYENTITY);
        String projectid = (String)this.getView().getFormShowParameter().getCustomParam(PROJECTID);
        List<Long> projectids = Arrays.stream(projectid.split(COMMA)).map(a -> Long.valueOf(a)).collect(Collectors.toList());
        Map<Long, Object> projectAmount = this.getProjectAmount(projectids);
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
        ArrayList<QFilter> deleteFilter = new ArrayList<QFilter>();
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"bd_invoicetype", (String)"id,name,number", null);
        Map<String, DynamicObject> invoiceTypeMap = Arrays.stream(dynamicObjects).collect(Collectors.toMap(o -> o.getString("number"), o -> o));
        for (Object selectRow : selectRows) {
            JSONObject invoice = (JSONObject)selectRow;
            DynamicObject divideDetail = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_DEVIDE_DETAIL);
            BigDecimal taxamount = invoice.getBigDecimal(TAXAMOUNT);
            divideDetail.set(NEW_INVOICE_TYPE_ENTITY, (Object)invoiceTypeMap.get(invoice.get((Object)TYPE)));
            divideDetail.set("org", invoice.getJSONObject("org").get((Object)ID));
            divideDetail.set(INVOICEID, (Object)invoice.get((Object)ID).toString());
            divideDetail.set(INVOICECODE, invoice.get((Object)INVOICECODE));
            divideDetail.set("invoiceno", invoice.get((Object)"invoiceno"));
            divideDetail.set(SUMTAXAMOUNT, (Object)taxamount);
            divideDetail.set(DEVIDETYPE, (Object)divideType);
            divideDetail.set(CREATETIME, (Object)new Date());
            deleteFilter.add(new QFilter(INVOICEID, "=", (Object)invoice.get((Object)ID).toString()).and(new QFilter(NEW_INVOICE_TYPE_ENTITY, "=", (Object)invoiceTypeMap.get(invoice.get((Object)TYPE)).getLong(ID))));
            DynamicObjectCollection entryentity = divideDetail.getDynamicObjectCollection(ENTRYENTITY);
            for (int i = 0; i < entryRowCount; ++i) {
                DynamicObject entryObject = entryentity.addNew();
                DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(ENTRYENTITY, i);
                BigDecimal ratio = entryRowEntity.getBigDecimal(FLOATRATIO);
                Long project = entryRowEntity.getLong(PROJECT_ID);
                entryObject.set(PROJECT, (Object)project);
                entryObject.set(CONTRACTAMOUNT, projectAmount.get(project));
                if (divideType.equals(DIVIDE_TYPE_COMCTRACT) || divideType.equals(DIVIDE_TYPE_CUSTOMERATIO)) {
                    entryObject.set(DEVICERATIO, (Object)ratio);
                    entryObject.set(DEVIDETAX, (Object)taxamount.multiply(ratio).setScale(2, 4));
                    continue;
                }
                if (!divideType.equals(DIVIDE_TYPE_AMOUNT)) continue;
                entryObject.set(DEVIDETAX, entryRowEntity.get("inttaxamount"));
            }
            list.add(divideDetail);
        }
        deleteFilter.stream().reduce((q1, q2) -> q1.or(q2)).ifPresent(qFilter -> DeleteServiceHelper.delete((String)ENTITY_DEVIDE_DETAIL, (QFilter[])new QFilter[]{qFilter}));
        SaveServiceHelper.save((DynamicObject[])list.toArray(new DynamicObject[list.size()]));
    }

    private boolean checkDivideRatio() {
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity(ENTRYENTITY);
        BigDecimal total = BigDecimal.valueOf(0.0);
        for (DynamicObject dynamicObject : entryentity) {
            total = total.add(dynamicObject.getBigDecimal(FLOATRATIO));
        }
        if (total.compareTo(new BigDecimal(1)) != 0) {
            String lessorlarge = total.compareTo(new BigDecimal(1)) < 0 ? ResManager.loadKDString((String)"\u5c0f\u4e8e", (String)"TilDevideDetailPlugin_0", (String)"taxc-til", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5927\u4e8e", (String)"TilDevideDetailPlugin_1", (String)"taxc-til", (Object[])new Object[0]);
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5206\u644a\u6bd4\u4f8b\u5408\u8ba1\u4e3a\u3010%1$s%\u3011,%2$s,100%,\u8bf7\u91cd\u65b0\u8f93\u5165", (String)"TilDevideDetailPlugin_2", (String)"taxc-til", (Object[])new Object[0]), total.multiply(new BigDecimal(100)).setScale(2) + "%\u3011\uff0c", lessorlarge));
            return false;
        }
        return true;
    }

    private boolean checkDivideAmount() {
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity(ENTRYENTITY);
        BigDecimal total = BigDecimal.valueOf(0.0);
        for (DynamicObject dynamicObject : entryentity) {
            total = total.add(dynamicObject.getBigDecimal("inttaxamount"));
        }
        BigDecimal sumtax = (BigDecimal)this.getModel().getValue(SUMTAX);
        if (total.compareTo(sumtax) != 0) {
            String lessorlarge = total.compareTo(sumtax) < 0 ? ResManager.loadKDString((String)"\u5c0f\u4e8e", (String)"TilDevideDetailPlugin_0", (String)"taxc-til", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5927\u4e8e", (String)"TilDevideDetailPlugin_1", (String)"taxc-til", (Object[])new Object[0]);
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5206\u644a\u7a0e\u989d\u5408\u8ba1\u4e3a\u3010%1$s\u3011,%2$s\u3010\u53ef\u5206\u644a\u7a0e\u989d\u3011\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165", (String)"TilDevideDetailPlugin_3", (String)"taxc-til", (Object[])new Object[0]), total, lessorlarge));
            return false;
        }
        return true;
    }

    private void initEntity() {
        BigDecimal selectsumtax = (BigDecimal)this.getView().getFormShowParameter().getCustomParam(SELECTSUMTAX);
        String projectid = (String)this.getView().getFormShowParameter().getCustomParam(PROJECTID);
        if (StringUtil.isNotEmpty((CharSequence)projectid)) {
            List<Long> projectids = Arrays.stream(projectid.split(COMMA)).map(a -> Long.valueOf(a)).collect(Collectors.toList());
            DynamicObjectCollection projects = this.getProjects(projectids);
            BigDecimal total = BigDecimal.valueOf(0.0);
            Map<Long, Object> projectAmount = this.getProjectAmount(projectids);
            for (Object value : projectAmount.values()) {
                total = total.add((BigDecimal)value);
            }
            int entryRowCount = this.getModel().getEntryRowCount(ENTRYENTITY);
            this.getModel().beginInit();
            if (entryRowCount > 0) {
                this.getModel().deleteEntryData(ENTRYENTITY);
            }
            int[] rows = this.getModel().batchCreateNewEntryRow(ENTRYENTITY, projects.size());
            for (int i = 0; i < rows.length; ++i) {
                int row = rows[i];
                this.getModel().setValue(TEXTSEQ, (Object)String.valueOf(row + 1), row);
                this.getModel().setValue(PROJECT, ((DynamicObject)projects.get(i)).get(ID), row);
                Object id = ((DynamicObject)projects.get(i)).get(ID);
                Object amount = projectAmount.get(id);
                if (amount == null) continue;
                this.getModel().setValue(INTAMOUNT, amount, row);
                BigDecimal amountDecimal = (BigDecimal)amount;
                BigDecimal divide = total.compareTo(BigDecimal.valueOf(0.0)) <= 0 ? BigDecimal.ZERO : amountDecimal.divide(total, 4, 4);
                this.getModel().setValue(FLOATRATIO, (Object)divide, row);
                if (selectsumtax == null) continue;
                BigDecimal multiply = divide.multiply(selectsumtax);
                this.getModel().setValue("inttaxamount", (Object)multiply, row);
            }
            this.getModel().endInit();
            this.getView().updateView(ENTRYENTITY);
        }
    }

    private DynamicObjectCollection getProjects(List<Long> projectids) {
        return QueryServiceHelper.query((String)ENTITY_PROJECT_INFO, (String)PROJECT_FILEDS, (QFilter[])new QFilter[]{new QFilter(ID, "in", projectids)});
    }

    private Map<Long, Object> getProjectAmount(List<Long> projectids) {
        HashMap<Long, Object> objectObjectHashMap = new HashMap<Long, Object>();
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)ENTITY_PROJECT_INFO, (String)PROJECT_FILEDS, (QFilter[])new QFilter[]{new QFilter(ID, "in", projectids)}, (String)ID);
        GroupbyDataSet groupbyDataSet = dataSet.groupBy(new String[]{ID}).sum(AMOUNT);
        DataSet finish = groupbyDataSet.finish();
        while (finish.hasNext()) {
            Row next = finish.next();
            Long id = next.getLong(ID);
            BigDecimal amount = next.getBigDecimal(AMOUNT) == null ? BigDecimal.ZERO : next.getBigDecimal(AMOUNT);
            objectObjectHashMap.put(id, amount);
        }
        return objectObjectHashMap;
    }
}

