/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.til.formplugin.project;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.orm.query.QEmptyValue;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.tctb.common.util.TreeUtils;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.til.formplugin.project.enums.InvoiceProjectBoardFilterEnum;
import org.apache.commons.collections4.CollectionUtils;

public class TilInputInvoiceSignFormPlugin
extends AbstractReportFormPlugin
implements RowClickEventListener {
    public static final String ENTITY_DEVIDE_DETAIL = "til_devide_detail";
    public static final String ENTITY_INVOICE_PROJECT = "til_in_invoice_project";
    public static final String SPLIT_DO = "true";
    public static final String SPLIT_UNDO = "false";
    public static final String INVOICE_TYPE = "baseinvoicetype.id";
    private static final String TYPEARRAY = "1,3,4,2,26,27";
    public static final String COMMA = ",";
    private static final String SELECTED_FLEX_KEY = "selectedflexkey";
    private static final Map<String, String> FILTER_MAP = new HashMap<String, String>();
    private static final Map<String, String> INVOICE_TYPE_MAP = new LinkedHashMap<String, String>(16);

    public void initialize() {
        ReportList reportlist = (ReportList)this.getView().getControl("reportlistap");
        reportlist.addPackageDataListener(arg_0 -> ((TilInputInvoiceSignFormPlugin)this).packageData(arg_0));
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"ygjflex", "wgjflex", "bqyftflex", "wftflex", "bqfbflex"});
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        List<QFilter> boardFilters = this.getBoardFilters(queryParam);
        if (CollectionUtils.isEmpty(boardFilters)) {
            return;
        }
        if (StringUtil.isBlank((CharSequence)this.getPageCache().get("verifyOrg"))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u4e0d\u5b58\u5728\u6709\u6548\u7684\u53d6\u6570\u5173\u7cfb,\u8bf7\u524d\u5f80\u7a0e\u52a1\u4e91\u57fa\u7840\u8d44\u6599\u7a0e\u52a1\u7ec4\u7ec7\u7ba1\u7406\u8fdb\u884c\u7ef4\u62a4", (String)"TilInputInvoiceSignFormPlugin_0", (String)"taxc-til", (Object[])new Object[0]));
            return;
        }
        Date date = new Date();
        int month = DateUtils.getMonthOfDate((Date)date);
        int year = DateUtils.getYearOfDate((Date)date);
        String cardTitleFormat = ResManager.loadKDString((String)"\u672c\u671f\u7a0e\u671f\u770b\u677f", (String)"TilInputInvoiceSignFormPlugin_1", (String)"taxc-til", (Object[])new Object[0]);
        this.getModel().setValue("bqzykb", (Object)cardTitleFormat);
        String months = StringUtil.fillCharAtLeft((Object)month, (int)2, (char)'0');
        String taxperiod = Stream.of(Integer.valueOf(year), months).map(v -> String.valueOf(v)).collect(Collectors.joining("-"));
        this.getPageCache().put("taxperiod", taxperiod);
        this.loadBoard(boardFilters);
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        String oldselectflexkey = this.getPageCache().get(SELECTED_FLEX_KEY);
        this.removeOldSelectFlex(oldselectflexkey);
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        QFilter filter = InvoiceProjectBoardFilterEnum.getQFilterByFlexKey(key);
        String selectFiled = InvoiceProjectBoardFilterEnum.getFieldByFlexKey(key);
        QFilter[] qFilter = null;
        if (EmptyCheckUtils.isEmpty((Object)filter) && EmptyCheckUtils.isEmpty((Object)selectFiled)) {
            return;
        }
        qFilter = EmptyCheckUtils.isNotEmpty((Object)filter) && EmptyCheckUtils.isEmpty((Object)selectFiled) ? new QFilter[]{filter} : (EmptyCheckUtils.isEmpty((Object)filter) && EmptyCheckUtils.isNotEmpty((Object)selectFiled) ? new QFilter[]{new QFilter(selectFiled, "=", (Object)this.getPageCache().get("taxperiod"))} : new QFilter[]{filter, new QFilter(selectFiled, "=", (Object)this.getPageCache().get("taxperiod"))});
        if (EmptyCheckUtils.isEmpty((Object)qFilter)) {
            return;
        }
        if (EmptyCheckUtils.isNotEmpty((Object)this.getPageCache().get(SELECTED_FLEX_KEY))) {
            String oldselectflexkey = this.getPageCache().get(SELECTED_FLEX_KEY);
            this.removeOldSelectFlex(oldselectflexkey);
            this.addNewSelectFlex(key);
        } else {
            this.addNewSelectFlex(key);
        }
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(Arrays.asList(qFilter));
        List<QFilter> boardQfilters = this.getBoardFilters(this.getQueryParam());
        if (CollectionUtils.isEmpty(boardQfilters)) {
            return;
        }
        qFilterList.addAll(boardQfilters);
        this.displayDataByBoardSelected(qFilterList);
    }

    private void displayDataByBoardSelected(List<QFilter> qFilters) {
        this.getQueryParam().getFilter().setQFilters(qFilters);
        this.getView().refresh();
    }

    private void addNewSelectFlex(String key) {
        HashMap stylemap1 = new HashMap(8);
        String selectedlinestyle = "2px_solid_#5582F3";
        HashMap style = new HashMap();
        HashMap<String, String> border = new HashMap<String, String>();
        border.put("b", selectedlinestyle);
        style.put("b", border);
        stylemap1.put("s", style);
        this.getView().updateControlMetadata(key, stylemap1);
        this.getPageCache().put(SELECTED_FLEX_KEY, key);
    }

    private void removeOldSelectFlex(String oldselectflexkey) {
        HashMap stylemap1 = new HashMap(8);
        String selectedlinestyle = "1px_solid_#d9d9d9";
        HashMap style = new HashMap();
        HashMap<String, String> border = new HashMap<String, String>();
        border.put("b", selectedlinestyle);
        style.put("b", border);
        stylemap1.put("s", style);
        this.getView().updateControlMetadata(oldselectflexkey, stylemap1);
    }

    private List<QFilter> getBoardFilters(ReportQueryParam reportQueryParam) {
        FilterInfo filterInfo = reportQueryParam.getFilter();
        List list = filterInfo.getFilterItems();
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(16);
        this.getPageCache().put("verifyOrg", String.valueOf(RequestContext.get().getOrgId()));
        if (null != list && list.size() > 0) {
            HashSet<Long> typeSet = new HashSet<Long>(4);
            List orgList = null;
            for (int i = 0; i < list.size(); ++i) {
                FilterItemInfo item = (FilterItemInfo)list.get(i);
                String name = item.getPropName();
                Object value = item.getValue();
                if (StringUtils.equals((CharSequence)INVOICE_TYPE, (CharSequence)name)) {
                    if ("=".equals(item.getCompareType())) {
                        typeSet.add(Long.parseLong(String.valueOf(value)));
                        continue;
                    }
                    typeSet.addAll((List)value);
                    continue;
                }
                if (StringUtils.equals((CharSequence)"orgs.id", (CharSequence)name) || StringUtils.equals((CharSequence)"orgs.name", (CharSequence)name) || StringUtils.equals((CharSequence)"org", (CharSequence)name) || StringUtils.equals((CharSequence)"taxorgs.id", (CharSequence)name) || StringUtils.equals((CharSequence)"taxorgs.name", (CharSequence)name) || StringUtils.equals((CharSequence)"taxorg", (CharSequence)name)) {
                    if (StringUtils.equals((CharSequence)"orgs.name", (CharSequence)name) || StringUtils.equals((CharSequence)"taxorgs.name", (CharSequence)name)) {
                        if (value instanceof QEmptyValue || null == value) {
                            throw new KDBizException(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u4e0d\u80fd\u9009\u62e9\u4e3a\u7a7a\u6216\u4e0d\u4e3a\u7a7a", (String)"TilInputInvoiceSignFormPlugin_2", (String)"taxc-til", (Object[])new Object[0]));
                        }
                        DynamicObjectCollection dynamicObject = TreeUtils.queryOrgListByCondition((Map)TreeUtils.convertParam((String)"name", (Object)value));
                        if (null != dynamicObject && dynamicObject.size() > 0) {
                            value = ((DynamicObject)dynamicObject.get(0)).getString("id");
                        }
                    }
                    if (name.startsWith("org")) {
                        name = "org";
                    }
                    if (name.startsWith("taxorg")) {
                        name = "tax_org";
                    }
                    if (value instanceof List) {
                        orgList = (List)value;
                    } else if (value.getClass().isArray()) {
                        orgList = Lists.newArrayList((Object[])((Long[])value));
                    } else if (value instanceof Long) {
                        orgList = Lists.newArrayList((Object[])new Long[]{(Long)value});
                    } else if (value instanceof String) {
                        orgList = Lists.newArrayList((Object[])new Long[]{Long.valueOf(String.valueOf(value))});
                    }
                    if (orgList == null) continue;
                    qFilterList.add(new QFilter(name, "in", (Object)orgList));
                    continue;
                }
                if (StringUtils.equals((CharSequence)"projectname", (CharSequence)name) || StringUtils.equals((CharSequence)"splitsigns", (CharSequence)name) || StringUtils.equals((CharSequence)"devidestatus", (CharSequence)name)) continue;
                if (StringUtil.equals((CharSequence)"authenticateflag", (CharSequence)name)) {
                    qFilterList.add(new QFilter("authenticate_flag", item.getCompareType(), item.getValue()));
                    continue;
                }
                if (StringUtil.equals((CharSequence)"deductionpurpose", (CharSequence)name)) {
                    qFilterList.add(new QFilter("deduction_purpose", item.getCompareType(), item.getValue()));
                    continue;
                }
                qFilterList.add(new QFilter(item.getPropName(), item.getCompareType(), item.getValue()));
            }
            if (orgList != null && orgList.size() > 0) {
                this.getPageCache().put("verifyOrg", ((Long)orgList.get(0)).toString());
            }
            QFilter qFilterType = new QFilter("number", "in", (Object)TYPEARRAY.split(COMMA));
            DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"bd_invoicetype", (String)"name,number", (QFilter[])new QFilter[]{qFilterType});
            Long[] ids = Arrays.stream(dynamicObjects).map(o -> o.getLong("id")).collect(Collectors.toList());
            qFilterList.add(new QFilter("invoice_type", "in", typeSet.size() > 0 ? typeSet.toArray(new Long[0]) : ids));
        }
        return qFilterList;
    }

    private QFilter getPeriodQFilter(List<Date> periods) {
        int monthDiff;
        Date date2;
        Date date1 = periods.get(0);
        if (date1.after(date2 = periods.get(1))) {
            Date date3 = date1;
            date1 = date2;
            date2 = date3;
        }
        if ((monthDiff = DateUtils.getMonthDiff((Date)date1, (Date)date2)) == 1) {
            return new QFilter("tax_period", ">=", (Object)DateUtils.getFirstDateOfMonth((Date)date1)).and(new QFilter("tax_period", "<=", (Object)DateUtils.getLastDateOfMonth((Date)date1)));
        }
        List monthBetween = DateUtils.getMonthBetween((Date)date1, (Date)date2, (String)"yyyy-MM-dd");
        List monthList = monthBetween.stream().map(m -> DateUtils.stringToDate((String)m)).collect(Collectors.toList());
        return new QFilter("tax_period", ">=", (Object)date1).and(new QFilter("tax_period", "<=", (Object)date2));
    }

    private void loadBoard(List<QFilter> qFilter) {
        DynamicObjectCollection dynamicObjectCollection = this.queryAllData(qFilter);
        this.doLoadBoard(dynamicObjectCollection);
    }

    private DynamicObjectCollection queryAllData(List<QFilter> qFilterList) {
        DynamicObject[] dynamicObjects;
        Object invoiceTypeIds = null;
        if (CollectionUtils.isNotEmpty(qFilterList)) {
            for (QFilter qFilter : qFilterList) {
                if (!qFilter.getProperty().startsWith("invoice_type")) continue;
                invoiceTypeIds = qFilter.getValue();
            }
        }
        DynamicObjectCollection dynamicObjectCollection = new DynamicObjectCollection();
        if (invoiceTypeIds != null) {
            dynamicObjects = BusinessDataServiceHelper.load((String)"bd_invoicetype", (String)"id,name,number", (QFilter[])new QFilter[]{new QFilter("id", "in", invoiceTypeIds)});
            Arrays.stream(dynamicObjects).forEach(o -> {
                DynamicObjectCollection objs = this.queryData(qFilterList, Collections.singletonList(o.getLong("id")), INVOICE_TYPE_MAP.get(o.getString("number")));
                if (CollectionUtils.isNotEmpty((Collection)objs)) {
                    dynamicObjectCollection.addAll((Collection)objs);
                }
            });
        } else {
            dynamicObjects = BusinessDataServiceHelper.load((String)"bd_invoicetype", (String)"id,name,number", (QFilter[])new QFilter[]{new QFilter("issystem", "=", (Object)"1")});
            Map<String, Long> invoiceTypeMap = Arrays.stream(dynamicObjects).collect(Collectors.toMap(o -> o.getString("number"), o -> o.getLong("id")));
            for (Map.Entry<String, String> entityMap : INVOICE_TYPE_MAP.entrySet()) {
                DynamicObjectCollection objs = this.queryData(qFilterList, Collections.singletonList(invoiceTypeMap.get(entityMap.getKey())), entityMap.getValue());
                if (!CollectionUtils.isNotEmpty((Collection)objs)) continue;
                dynamicObjectCollection.addAll((Collection)objs);
            }
        }
        return dynamicObjectCollection;
    }

    private DynamicObjectCollection queryData(List<QFilter> qFilterList, List<Long> baseinvoicetypeIds, String entity) {
        ArrayList<QFilter> newlist = new ArrayList<QFilter>(16);
        newlist.addAll(qFilterList);
        newlist.add(new QFilter("invoice_type", "in", baseinvoicetypeIds));
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)entity, (String)FILTER_MAP.get(entity), (QFilter[])newlist.toArray(new QFilter[newlist.size()]), null);
        return dynamicObjects;
    }

    private void doLoadBoard(DynamicObjectCollection dynamicObjects) {
        List idsList = null;
        DynamicObjectCollection query = null;
        Map<String, List<DynamicObject>> invoiceProjectMap = null;
        DynamicObjectCollection devideQuery = null;
        Map<String, DynamicObject> devideDetailMap = null;
        Date startDate = null;
        Date endDate = null;
        if (CollectionUtils.isNotEmpty((Collection)dynamicObjects)) {
            idsList = dynamicObjects.stream().map(o -> o.getString("id")).collect(Collectors.toList());
            query = QueryServiceHelper.query((String)ENTITY_INVOICE_PROJECT, (String)"id,project.id,project.name,split,invoiceid,baseinvoicetype,createtime", (QFilter[])new QFilter[]{new QFilter("invoiceid", "in", idsList), QFilter.isNotNull((String)"project.name")});
            invoiceProjectMap = query.stream().collect(Collectors.groupingBy(v -> v.getString("invoiceid") + v.getString("baseinvoicetype")));
            devideQuery = QueryServiceHelper.query((String)ENTITY_DEVIDE_DETAIL, (String)"id,baseinvoicetype,devidetype,sumtaxamount,invoiceid,createtime", (QFilter[])new QFilter[]{new QFilter("invoiceid", "in", idsList)});
            devideDetailMap = devideQuery.stream().collect(Collectors.toMap(v -> v.getString("invoiceid") + v.getString("baseinvoicetype"), a -> a, (k1, k2) -> k1));
        }
        Long bqgjsl = 0L;
        BigDecimal bqygjje = BigDecimal.ZERO;
        Long wgjsl = 0L;
        BigDecimal wgjje = BigDecimal.ZERO;
        BigDecimal bqyftje = BigDecimal.ZERO;
        BigDecimal wftje = BigDecimal.ZERO;
        BigDecimal yfbzse = BigDecimal.ZERO;
        if (dynamicObjects != null && dynamicObjects.size() > 0) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                DynamicObject project;
                String split;
                List<DynamicObject> projects;
                DynamicObject obj;
                boolean isMatch2;
                List<DynamicObject> projects2;
                String id = dynamicObject.getString("id");
                String idtype = id + dynamicObject.getString("baseinvoicetype");
                if (invoiceProjectMap != null && invoiceProjectMap.get(idtype) != null && (projects2 = invoiceProjectMap.get(idtype)) != null && projects2.size() > 0 && (isMatch2 = this.verifyIsCurrentTaxPeriod(projects2.get(0).getDate("createtime"), startDate, endDate))) {
                    Long l = bqgjsl;
                    Long l2 = bqgjsl = Long.valueOf(bqgjsl + 1L);
                    bqygjje = BigDecimalUtil.addObject((Object)bqygjje, (Object)dynamicObject.get("taxamount"));
                }
                if (invoiceProjectMap == null || !invoiceProjectMap.containsKey(idtype)) {
                    projects2 = wgjsl;
                    Long isMatch2 = wgjsl = Long.valueOf(wgjsl + 1L);
                    wgjje = BigDecimalUtil.addObject((Object)wgjje, (Object)dynamicObject.get("taxamount"));
                }
                if (devideDetailMap != null && devideDetailMap.get(idtype) != null && (isMatch2 = this.verifyIsCurrentTaxPeriod((obj = devideDetailMap.get(idtype)).getDate("createtime"), startDate, endDate))) {
                    bqyftje = BigDecimalUtil.addObject((Object)bqyftje, (Object)obj.get("sumtaxamount"));
                }
                if ((devideDetailMap == null || !devideDetailMap.containsKey(idtype)) && invoiceProjectMap != null && (projects2 = invoiceProjectMap.get(idtype)) != null && projects2.size() > 0 && (isMatch2 = this.verifyIsCurrentTaxPeriod(projects2.get(0).getDate("createtime"), startDate, endDate))) {
                    wftje = BigDecimalUtil.addObject((Object)wftje, (Object)dynamicObject.get("taxamount"));
                }
                String splitsign = SPLIT_UNDO;
                if (invoiceProjectMap == null || invoiceProjectMap.get(idtype) == null || (projects = invoiceProjectMap.get(idtype)) == null || projects.size() <= 0) continue;
                if (projects.size() == 1 && SPLIT_DO.equals(split = (project = projects.get(0)).getString("split"))) {
                    splitsign = split;
                }
                boolean isMatch3 = this.verifyIsCurrentTaxPeriod(projects.get(0).getDate("createtime"), startDate, endDate);
                if (!SPLIT_DO.equals(splitsign) || !isMatch3) continue;
                yfbzse = BigDecimalUtil.addObject((Object)yfbzse, (Object)dynamicObject.get("taxamount"));
            }
        }
        this.getModel().setValue("bqgjsl", (Object)bqgjsl);
        this.getModel().setValue("bqygjje", (Object)bqygjje);
        this.getModel().setValue("wgjsl", (Object)wgjsl);
        this.getModel().setValue("wgjje", (Object)wgjje);
        this.getModel().setValue("bqyftje", (Object)bqyftje);
        this.getModel().setValue("wftje", (Object)wftje);
        this.getModel().setValue("yfbzse", (Object)yfbzse);
    }

    private boolean verifyIsCurrentTaxPeriod(Date date, Date startDate, Date endDate) {
        return date != null && startDate != null && endDate != null && date.before(endDate) && date.after(startDate);
    }

    static {
        INVOICE_TYPE_MAP.put("4", "rim_inv_special");
        INVOICE_TYPE_MAP.put("2", "rim_inv_special");
        INVOICE_TYPE_MAP.put("1", "rim_inv_ordinary");
        INVOICE_TYPE_MAP.put("3", "rim_inv_ordinary");
        INVOICE_TYPE_MAP.put("26", "rim_inv_electric");
        INVOICE_TYPE_MAP.put("27", "rim_inv_electric");
        FILTER_MAP.put("rim_inv_special", "id,org,tax_org as taxorg,invoice_type as baseinvoicetype,invoice_code as invoicecode,invoice_no as invoiceno,deduction_purpose as deductionpurpose,authenticate_flag as authenticateflag,tax_period as taxperiod,saler_name as salername,saler_tax_no as salertaxno,total_amount as totalamount,invoice_amount as invoiceamount,total_tax_amount as taxamount, authenticate_flag as selectstatus,deduction_purpose as selectresult,authenticate_flag as certstatus,remark,invoice_date as invoicedate");
        FILTER_MAP.put("rim_inv_ordinary", "id,org,tax_org as taxorg,invoice_type as baseinvoicetype,invoice_code as invoicecode,invoice_no as invoiceno,transport_deduction as deductionpurpose,deduction_flag as authenticateflag,tax_period as taxperiod,saler_name as salername,saler_tax_no as salertaxno,total_amount as totalamount,invoice_amount as invoiceamount,total_tax_amount as taxamount, '0' as selectstatus, '0' as selectresult, '0' as certstatus,remark,invoice_date as invoicedate");
        FILTER_MAP.put("rim_inv_electric", "id,org,tax_org as taxorg,invoice_type as baseinvoicetype,'' as invoicecode,invoice_no as invoiceno,deduction_purpose as deductionpurpose,authenticate_flag as authenticateflag,tax_period as taxperiod,saler_name as salername,saler_tax_no as salertaxno,total_amount as totalamount,invoice_amount as invoiceamount,total_tax_amount as taxamount, authenticate_flag as selectstatus,deduction_purpose as selectresult,authenticate_flag as certstatus,remark,invoice_date as invoicedate");
    }
}

