/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.til.formplugin.project;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowMetaFactory;
import kd.bos.algo.input.CollectionInput;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FastFilter;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.tctb.common.util.TreeUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import org.apache.commons.collections4.CollectionUtils;

public class TilInputInvoiceSignRptQueryPlugin
extends AbstractReportListDataPlugin {
    public static final String DEVIDESTATE_UNDEVIDE = "0";
    public static final String DEVIDESTATE_DEVIDED = "1";
    public static final String SPLIT_DO = "true";
    public static final String SPLIT_UNDO = "false";
    public static final String COMMA = ",";
    public static final String COMPATIBLE_FIELDS = "Cast(id as String) id,org,taxorg,baseinvoicetype,invoicecode,invoiceno,deductionpurpose,authenticateflag,taxperiod,salername,salertaxno,invoiceamount,totalamount,taxamount,totaldeduct,availdeduct,currentdeduct,remaindeduct,remark,invoicedate";
    public static final String ENTITY_DEVIDE_DETAIL = "til_devide_detail";
    public static final String ENTITY_INVOICE_PROJECT = "til_in_invoice_project";
    public static final String INVOICE_TYPE = "baseinvoicetype.id";
    private static String[] FIELDS = new String[]{"id", "org", "taxorg", "type", "projectname", "splitsign", "invoicecode", "invoiceno", "deductionpurpose", "authenticateflag", "taxperiod", "salername", "salertaxno", "totalamount", "invoiceamount", "taxamount", "totaldeduct", "availdeduct", "currentdeduct", "remaindeduct", "remark", "devidestate", "projectid", "fids", "devideid", "invoicedate", "projectcreatetime", "devidetime", "collecttime", "devidecreatetime"};
    private static String[] DYNAMIC_FILTER_FIELDS = new String[]{"devidestate", "splitsign", "projectname", "projectcreatetime", "devidetime"};
    private static DataType[] DATATYPES = new DataType[]{DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.BigDecimalType, DataType.BigDecimalType, DataType.BigDecimalType, DataType.BigDecimalType, DataType.BigDecimalType, DataType.BigDecimalType, DataType.BigDecimalType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.LongType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.DateType, DataType.DateType};
    private static final String TYPEARRAY = "4,1,3,2,26,27";
    private static final Map<String, String> INVOICE_TYPE_MAP = new LinkedHashMap<String, String>();
    private static final Map<String, String> FILTER_MAP = new HashMap<String, String>();

    public DataSet query(ReportQueryParam reportQueryParam, Object o) {
        List<QFilter> qFilterList = this.getFilterList(reportQueryParam);
        if (CollectionUtils.isEmpty(qFilterList)) {
            ArrayList coll = new ArrayList();
            RowMeta rowMeta = RowMetaFactory.createRowMeta((String[])FIELDS, (DataType[])DATATYPES);
            CollectionInput inputs = new CollectionInput(rowMeta, coll);
            return Algo.create((String)((Object)((Object)this)).getClass().getName()).createDataSet(new Input[]{inputs});
        }
        DataSet dataSet = this.collectDateSet(qFilterList);
        if (dataSet == null || dataSet.isEmpty()) {
            ArrayList coll = new ArrayList();
            RowMeta rowMeta = RowMetaFactory.createRowMeta((String[])FIELDS, (DataType[])DATATYPES);
            CollectionInput inputs = new CollectionInput(rowMeta, coll);
            return Algo.create((String)((Object)((Object)this)).getClass().getName()).createDataSet(new Input[]{inputs});
        }
        return dataSet;
    }

    private List<QFilter> getFilterList(ReportQueryParam reportQueryParam) {
        Object value;
        List fastFilters;
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        List qFilterList = reportQueryParam.getFilter().getQFilters();
        FastFilter fastFilter = reportQueryParam.getFilter().getFastFilter();
        if (fastFilter != null && CollectionUtils.isNotEmpty((Collection)fastFilter.getQFilters()) && CollectionUtils.isNotEmpty((Collection)(fastFilters = fastFilter.getFastFilter()))) {
            for (Object fastMap : fastFilters) {
                List nameList = (List)fastMap.get("FieldName");
                List valueList = (List)fastMap.get("Value");
                value = valueList.get(0);
                QFilter qFilter = null;
                for (Object name : nameList) {
                    List ids;
                    DynamicObjectCollection dynamicObject;
                    QFilter filter;
                    if (StringUtils.equals((CharSequence)"fastorg", (CharSequence)((String)name))) {
                        name = "org";
                        filter = null;
                        dynamicObject = QueryServiceHelper.query((String)"bos_org", (String)"id", (QFilter[])new QFilter[]{new QFilter("fisaccounting", "=", (Object)DEVIDESTATE_DEVIDED).and(filter = this.appendFilter(valueList, filter, "name"))});
                        if (CollectionUtils.isNotEmpty((Collection)dynamicObject)) {
                            ids = dynamicObject.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
                            qFilter = qFilter == null ? new QFilter((String)name, "in", ids) : qFilter.or(new QFilter((String)name, "in", ids));
                        }
                    }
                    if (StringUtils.equals((CharSequence)"fasttaxorg", (CharSequence)((String)name))) {
                        name = "tax_org";
                        filter = null;
                        dynamicObject = QueryServiceHelper.query((String)"bos_org", (String)"id", (QFilter[])new QFilter[]{filter = this.appendFilter(valueList, filter, "name")});
                        if (CollectionUtils.isNotEmpty((Collection)dynamicObject)) {
                            ids = dynamicObject.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
                            qFilter = qFilter == null ? new QFilter((String)name, "in", ids) : qFilter.or(new QFilter((String)name, "in", ids));
                        }
                    }
                    if (StringUtils.equals((CharSequence)"fastinvoicecode", (CharSequence)((String)name))) {
                        name = "invoice_code";
                        qFilter = this.appendFilter(valueList, qFilter, (String)name);
                    }
                    if (!StringUtils.equals((CharSequence)"fastinvoiceno", (CharSequence)((String)name))) continue;
                    name = "invoice_no";
                    qFilter = this.appendFilter(valueList, qFilter, (String)name);
                }
                if (null == qFilter) continue;
                qFilters.add(qFilter);
            }
        }
        Boolean ishasInvoiceType = false;
        if (CollectionUtils.isNotEmpty((Collection)qFilterList)) {
            ArrayList<Date> periods = new ArrayList<Date>();
            for (QFilter qFilter : qFilterList) {
                String name = qFilter.getProperty();
                value = qFilter.getValue();
                String compareType = qFilter.getCP();
                if (StringUtils.equals((CharSequence)INVOICE_TYPE, (CharSequence)qFilter.getProperty()) || StringUtils.equals((CharSequence)"baseinvoicetype", (CharSequence)qFilter.getProperty())) {
                    ishasInvoiceType = true;
                    qFilters.add(new QFilter("invoice_type", qFilter.getCP(), qFilter.getValue()));
                    continue;
                }
                if (StringUtils.equals((CharSequence)"orgs.id", (CharSequence)qFilter.getProperty()) || StringUtils.equals((CharSequence)"orgs.name", (CharSequence)qFilter.getProperty()) || StringUtils.equals((CharSequence)"org", (CharSequence)qFilter.getProperty()) || StringUtils.equals((CharSequence)"taxorgs.id", (CharSequence)name) || StringUtils.equals((CharSequence)"taxorgs.name", (CharSequence)name) || StringUtils.equals((CharSequence)"taxorg", (CharSequence)name)) {
                    DynamicObjectCollection dynamicObject;
                    if ((StringUtils.equals((CharSequence)"orgs.name", (CharSequence)qFilter.getProperty()) || StringUtils.equals((CharSequence)"taxorgs.name", (CharSequence)name)) && null != (dynamicObject = TreeUtils.queryOrgListByCondition((Map)TreeUtils.convertParam((String)"name", (Object)value))) && dynamicObject.size() > 0) {
                        value = ((DynamicObject)dynamicObject.get(0)).getString("id");
                    }
                    if (name.startsWith("org")) {
                        name = "org";
                    }
                    if (name.startsWith("taxorg")) {
                        name = "tax_org";
                    }
                    List orgList = null;
                    if (value instanceof List) {
                        orgList = (List)value;
                    } else if (value.getClass().isArray()) {
                        orgList = Lists.newArrayList((Object[])((Long[])value));
                    } else if (value instanceof Long) {
                        orgList = Lists.newArrayList((Object[])new Long[]{(Long)value});
                    } else if (value instanceof String) {
                        orgList = Lists.newArrayList((Object[])new Long[]{Long.valueOf(String.valueOf(value))});
                    } else if (value instanceof Integer) {
                        orgList = Lists.newArrayList((Object[])new Long[]{Long.valueOf(String.valueOf(value))});
                    }
                    if (orgList != null) {
                        qFilters.add(new QFilter(name, "in", (Object)orgList));
                        reportQueryParam.getCustomParam().put("verifyOrg", orgList.get(0));
                        continue;
                    }
                    return null;
                }
                if (StringUtils.equals((CharSequence)"devidestatus", (CharSequence)name)) {
                    name = "devidestate";
                    qFilters.add(new QFilter(name, compareType, value));
                    continue;
                }
                if (StringUtils.equals((CharSequence)"fastinvoicecode", (CharSequence)name)) {
                    name = "fastinvoicecode";
                    qFilters.add(new QFilter(name, compareType, value));
                    continue;
                }
                if (StringUtils.equals((CharSequence)"fastinvoiceno", (CharSequence)name)) {
                    name = "fastinvoiceno";
                    qFilters.add(new QFilter(name, compareType, value));
                    continue;
                }
                if (StringUtils.equals((CharSequence)"splitsigns", (CharSequence)name)) {
                    name = "splitsign";
                    qFilters.add(new QFilter(name, compareType, value));
                    continue;
                }
                if (StringUtils.equals((CharSequence)"projectname", (CharSequence)name) || StringUtils.equals((CharSequence)"fastprojectname", (CharSequence)name)) {
                    name = "projectname";
                    qFilters.add(new QFilter(name, compareType, value));
                    continue;
                }
                if (StringUtils.equals((CharSequence)"projectcreatetime", (CharSequence)name)) {
                    name = "projectcreatetime";
                    qFilters.add(new QFilter(name, compareType, value));
                    continue;
                }
                if (StringUtils.equals((CharSequence)"devidetime", (CharSequence)name)) {
                    name = "devidetime";
                    qFilters.add(new QFilter(name, compareType, value));
                    continue;
                }
                if (StringUtil.equals((CharSequence)"authenticateflag", (CharSequence)name)) {
                    qFilters.add(new QFilter("authenticate_flag", compareType, value));
                    continue;
                }
                if (StringUtil.equals((CharSequence)"deductionpurpose", (CharSequence)name)) {
                    qFilters.add(new QFilter("deduction_purpose", compareType, value));
                    continue;
                }
                qFilters.add(qFilter);
            }
            if (periods.size() > 0) {
                qFilters.add(this.getPeriodQFilter(periods));
            }
        } else {
            reportQueryParam.getCustomParam().put("verifyOrg", RequestContext.get().getOrgId());
        }
        if (!ishasInvoiceType.booleanValue()) {
            QFilter qFilterType = new QFilter("number", "in", (Object)TYPEARRAY.split(COMMA));
            DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"bd_invoicetype", (String)"name,number", (QFilter[])new QFilter[]{qFilterType});
            List ids = Arrays.stream(dynamicObjects).map(o -> o.getString("id")).collect(Collectors.toList());
            qFilters.add(new QFilter("invoice_type", "in", ids));
        }
        return qFilters;
    }

    private QFilter appendFilter(List<Object> valueList, QFilter filter, String name) {
        for (Object value : valueList) {
            if (filter == null) {
                filter = new QFilter(name, "like", (Object)("%" + value + "%"));
                continue;
            }
            filter = filter.or(new QFilter(name, "like", (Object)("%" + value + "%")));
        }
        return filter;
    }

    private QFilter getPeriodQFilter(List<Date> periods) {
        int monthDiff;
        Date date2;
        Date date1 = periods.get(0);
        if (date1.after(date2 = periods.get(1))) {
            Date date3 = date1;
            date1 = date2;
            date2 = date3;
        }
        if ((monthDiff = DateUtils.getMonthDiff((Date)date1, (Date)date2)) == 1) {
            return new QFilter("tax_period", ">=", (Object)DateUtils.getFirstDateOfMonth((Date)date1)).and(new QFilter("tax_period", "<=", (Object)DateUtils.getLastDateOfMonth((Date)date1)));
        }
        List monthBetween = DateUtils.getMonthBetween((Date)date1, (Date)date2, (String)"yyyy-MM-dd");
        List monthList = monthBetween.stream().map(m -> DateUtils.stringToDate((String)m)).collect(Collectors.toList());
        return new QFilter("tax_period", ">=", (Object)date1).and(new QFilter("tax_period", "<=", (Object)date2));
    }

    private DataSet getSumDataSet(DataSet dataSet) {
        ArrayList<Object[]> coll = new ArrayList<Object[]>();
        long primaryId = 0L;
        BigDecimal totalamount = BigDecimalUtil.setScale((Object)BigDecimal.ZERO);
        BigDecimal taxamount = BigDecimalUtil.setScale((Object)BigDecimal.ZERO);
        BigDecimal invoiceamount = BigDecimalUtil.setScale((Object)BigDecimal.ZERO);
        BigDecimal totaldeduct = BigDecimalUtil.setScale((Object)BigDecimal.ZERO);
        BigDecimal availdeduct = BigDecimalUtil.setScale((Object)BigDecimal.ZERO);
        BigDecimal currentdeduct = BigDecimalUtil.setScale((Object)BigDecimal.ZERO);
        BigDecimal remaindeduct = BigDecimalUtil.setScale((Object)BigDecimal.ZERO);
        if (dataSet.copy().count("id", true) > 0) {
            for (Row row : dataSet.copy()) {
                String invoicePrimaryId = row.getString("id");
                if (StringUtils.isBlank((CharSequence)invoicePrimaryId)) continue;
                totaldeduct = totaldeduct.add(BigDecimalUtil.setScale((Object)row.getBigDecimal("totaldeduct")));
                availdeduct = availdeduct.add(BigDecimalUtil.setScale((Object)row.getBigDecimal("availdeduct")));
                currentdeduct = currentdeduct.add(BigDecimalUtil.setScale((Object)row.getBigDecimal("currentdeduct")));
                remaindeduct = remaindeduct.add(BigDecimalUtil.setScale((Object)row.getBigDecimal("remaindeduct")));
                totalamount = totalamount.add(BigDecimalUtil.setScale((Object)row.getString("totalamount")));
                invoiceamount = invoiceamount.add(BigDecimalUtil.setScale((Object)row.getString("invoiceamount")));
                taxamount = taxamount.add(BigDecimalUtil.setScale((Object)row.getString("taxamount")));
            }
            coll.add(new Object[]{primaryId, "", "", "count", "", "", "", "", "", "", "", "", "", totalamount, invoiceamount, taxamount, totaldeduct, availdeduct, currentdeduct, remaindeduct, "", "", "", "", 0L, "", "", "", null, null});
        }
        RowMeta rowMeta = RowMetaFactory.createRowMeta((String[])FIELDS, (DataType[])DATATYPES);
        CollectionInput inputs = new CollectionInput(rowMeta, coll);
        DataSet dataSetCount = Algo.create((String)((Object)((Object)this)).getClass().getName()).createDataSet(new Input[]{inputs});
        dataSet = dataSet.union(dataSetCount);
        return dataSet;
    }

    private DataSet collectDateSet(List<QFilter> qFilterList) {
        DataSet dataSet = null;
        Map<String, String> collect = Arrays.stream(DYNAMIC_FILTER_FIELDS).collect(Collectors.toMap(String::toString, a -> a, (k1, k2) -> k1));
        ArrayList<QFilter> dynamicQFilter = new ArrayList<QFilter>(16);
        ArrayList<QFilter> fieldQFilter = new ArrayList<QFilter>(16);
        QFilter typeQfilter = null;
        for (QFilter qFilter : qFilterList) {
            if (StringUtil.equals((CharSequence)qFilter.getProperty(), (CharSequence)"invoice_type")) {
                typeQfilter = qFilter;
                continue;
            }
            if (collect.get(qFilter.getProperty()) != null) {
                dynamicQFilter.add(qFilter);
                continue;
            }
            fieldQFilter.add(qFilter);
        }
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"bd_invoicetype", (String)"id,name,number", null);
        Map<Long, String> invoiceTypeMap = Arrays.stream(dynamicObjects).collect(Collectors.toMap(o -> o.getLong("id"), o -> o.getString("number")));
        if (typeQfilter != null) {
            if (typeQfilter.getCP().equals("in")) {
                Object qfilterValue = typeQfilter.getValue();
                Object[] types = qfilterValue instanceof List ? ((List)typeQfilter.getValue()).toArray() : (Object[])typeQfilter.getValue();
                for (int i = 0; i < types.length; ++i) {
                    String value = INVOICE_TYPE_MAP.get(invoiceTypeMap.get(Long.valueOf(types[i].toString())));
                    if (StringUtils.isBlank((CharSequence)value)) continue;
                    DataSet newDateSet = this.queryDataSet(fieldQFilter, value, types[i].toString(), FILTER_MAP.get(value));
                    newDateSet = newDateSet.select(COMPATIBLE_FIELDS);
                    dataSet = null == dataSet ? newDateSet : dataSet.union(newDateSet);
                }
            } else if (typeQfilter.getCP().equals("=")) {
                String value = INVOICE_TYPE_MAP.get(invoiceTypeMap.get(Long.parseLong(String.valueOf(typeQfilter.getValue()))));
                DataSet newDateSet = this.queryDataSet(fieldQFilter, value, String.valueOf(typeQfilter.getValue()), FILTER_MAP.get(value));
                dataSet = newDateSet.select(COMPATIBLE_FIELDS);
            }
        }
        if (dataSet != null) {
            DataSet wholeDataSet = this.dealOtherColumn(dataSet);
            dataSet = this.dealDynamicColumnFilter(wholeDataSet, dynamicQFilter, DYNAMIC_FILTER_FIELDS);
        }
        return null == dataSet ? null : this.getSumDataSet(dataSet);
    }

    private DataSet dealOtherColumn(DataSet dataSet) {
        DataSet copy = dataSet.copy();
        ArrayList<String> idsList = new ArrayList<String>(16);
        while (copy.hasNext()) {
            idsList.add(copy.next().get("id").toString());
        }
        DynamicObjectCollection query = QueryServiceHelper.query((String)ENTITY_INVOICE_PROJECT, (String)"id,project.id,project.name,split,invoiceid,baseinvoicetype,createtime", (QFilter[])new QFilter[]{new QFilter("invoiceid", "in", idsList), QFilter.isNotNull((String)"project.name")});
        Map<String, List<DynamicObject>> invoiceProjectMap = query.stream().collect(Collectors.groupingBy(v -> v.getString("invoiceid") + v.getString("baseinvoicetype")));
        DynamicObjectCollection devideQuery = QueryServiceHelper.query((String)ENTITY_DEVIDE_DETAIL, (String)"id,baseinvoicetype,devidetype,sumtaxamount,invoiceid,createtime", (QFilter[])new QFilter[]{new QFilter("invoiceid", "in", idsList)});
        Map<String, DynamicObject> devideDetailMap = devideQuery.stream().collect(Collectors.toMap(v -> v.getString("invoiceid") + v.getString("baseinvoicetype"), a -> a, (k1, k2) -> k1));
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"bd_invoicetype", (String)"id,name,number", null);
        Map<String, String> invoiceTypeMap = Arrays.stream(dynamicObjects).collect(Collectors.toMap(o -> o.getString("id"), o -> o.getString("number")));
        ArrayList<Object[]> coll = new ArrayList<Object[]>(16);
        Date startDate = null;
        Date endDate = null;
        String period = null;
        if (!ObjectUtils.isEmpty(this.getQueryParam().getCustomParam().get("verifyOrg"))) {
            period = this.getTaxPeriod(new Date());
        }
        copy = dataSet.copy();
        while (copy.hasNext()) {
            String devidestate;
            DynamicObject devideDetail;
            Row row = copy.next();
            String id = String.valueOf(row.get("id"));
            String idtype = id + row.getString("baseinvoicetype");
            String orgName = row.getString("org");
            String taxorgName = row.getString("taxorg");
            String invoiceType = invoiceTypeMap.get(row.getString("baseinvoicetype"));
            String invoiceCode = row.getString("invoicecode");
            String invoicedate = DateUtils.format((Date)row.getDate("invoicedate"));
            String invoiceNo = row.getString("invoiceno");
            String deductionpurpose = row.getString("deductionpurpose");
            String authenticateflag = row.getString("authenticateflag");
            String taxPeriod = null != row.getString("taxperiod") ? row.getString("taxperiod").substring(0, 7) : row.getString("taxperiod");
            String salerName = row.getString("salername");
            String salertaxno = row.getString("salertaxno");
            String remark = row.getString("remark");
            BigDecimal invoiceamount = BigDecimalUtil.setScale((Object)row.getString("invoiceamount"));
            BigDecimal taxamount = BigDecimalUtil.setScale((Object)row.getString("taxamount"));
            BigDecimal totalamount = BigDecimalUtil.setScale((Object)row.getString("totalamount"));
            BigDecimal totaldeduct = BigDecimalUtil.setScale((Object)row.getString("totaldeduct"));
            BigDecimal availdeduct = BigDecimalUtil.setScale((Object)row.getString("availdeduct"));
            BigDecimal currentdeduct = BigDecimalUtil.setScale((Object)row.getString("currentdeduct"));
            BigDecimal remaindeduct = BigDecimalUtil.setScale((Object)row.getString("remaindeduct"));
            String projectTime = "";
            String devideTime = "";
            Date collectTime = null;
            Date devideCreateTime = null;
            String projectName = "";
            List<DynamicObject> projects = invoiceProjectMap.get(idtype);
            String splitsign = SPLIT_UNDO;
            String projectids = "";
            String fids = "";
            if (projects != null && projects.size() > 0) {
                DynamicObject project;
                String split;
                projectName = projects.stream().map(a -> a.getString("project.name")).reduce((acc, item) -> acc + COMMA + item).get();
                Date createtime = projects.get(0).getDate("createtime");
                if (createtime != null) {
                    if (this.verifyIsCurrentTaxPeriod(createtime, startDate, endDate)) {
                        projectTime = period;
                    }
                    collectTime = DateUtils.trunc((Date)createtime, (String)"yyyy-MM-dd HH:mm:ss");
                }
                projectids = projects.stream().map(a -> a.getString("project.id")).reduce((acc, item) -> acc + COMMA + item).get();
                fids = projects.stream().map(a -> a.getString("id")).reduce((acc, item) -> acc + COMMA + item).get();
                if (projects.size() == 1 && SPLIT_DO.equals(split = (project = projects.get(0)).getString("split"))) {
                    splitsign = split;
                }
            }
            if ((devideDetail = devideDetailMap.get(idtype)) != null) {
                devidestate = DEVIDESTATE_DEVIDED;
                Date createtime = devideDetail.getDate("createtime");
                if (createtime != null) {
                    if (this.verifyIsCurrentTaxPeriod(createtime, startDate, endDate)) {
                        devideTime = period;
                    }
                    devideCreateTime = DateUtils.trunc((Date)createtime, (String)"yyyy-MM-dd HH:mm:ss");
                }
            } else {
                devidestate = projects != null && projects.size() > 1 ? DEVIDESTATE_UNDEVIDE : "";
            }
            Long devideid = devideDetail != null ? devideDetail.getLong("id") : 0L;
            coll.add(new Object[]{id, orgName, taxorgName, invoiceType, projectName, splitsign, invoiceCode, invoiceNo, deductionpurpose, authenticateflag, taxPeriod, salerName, salertaxno, totalamount, invoiceamount, taxamount, totaldeduct, availdeduct, currentdeduct, remaindeduct, remark, devidestate, projectids, fids, devideid, invoicedate, projectTime, devideTime, collectTime, devideCreateTime});
        }
        RowMeta rowMeta = RowMetaFactory.createRowMeta((String[])FIELDS, (DataType[])DATATYPES);
        CollectionInput inputs = new CollectionInput(rowMeta, coll);
        return Algo.create((String)((Object)((Object)this)).getClass().getName()).createDataSet(new Input[]{inputs});
    }

    private DataSet dealDynamicColumnFilter(DataSet dataSet, List<QFilter> qFilterList, String[] columnNames) {
        if (qFilterList.size() == 0) {
            return dataSet;
        }
        Map<String, QFilter> filterMap = qFilterList.stream().collect(Collectors.toMap(QFilter::getProperty, a -> a, (k1, k2) -> k1));
        ArrayList<String> whereList = new ArrayList<String>(columnNames.length);
        for (int i = 0; i < columnNames.length; ++i) {
            String columnName = columnNames[i];
            QFilter qFilter = filterMap.get(columnName);
            if (qFilter == null) continue;
            String where = qFilter.toString();
            whereList.add(where);
        }
        for (String where : whereList) {
            dataSet = dataSet.filter(where);
        }
        return dataSet;
    }

    private DataSet queryDataSet(List<QFilter> qFilterList, String entity, String type, String selectFields) {
        ArrayList<QFilter> newlist = new ArrayList<QFilter>();
        newlist.addAll(qFilterList);
        newlist.add(new QFilter("invoice_type", "=", (Object)Long.parseLong(type)));
        return QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)entity, (String)selectFields, (QFilter[])newlist.toArray(new QFilter[newlist.size()]), null);
    }

    private String getTaxPeriod(Date date) {
        int month = DateUtils.getMonthOfDate((Date)date);
        int year = DateUtils.getYearOfDate((Date)date);
        String months = StringUtil.fillCharAtLeft((Object)month, (int)2, (char)'0');
        return Stream.of(Integer.valueOf(year), months).map(v -> String.valueOf(v)).collect(Collectors.joining("-"));
    }

    private boolean verifyIsCurrentTaxPeriod(Date date, Date startDate, Date endDate) {
        return date != null && startDate != null && endDate != null && date.before(endDate) && date.after(startDate);
    }

    static {
        INVOICE_TYPE_MAP.put("4", "rim_inv_special");
        INVOICE_TYPE_MAP.put("2", "rim_inv_special");
        INVOICE_TYPE_MAP.put(DEVIDESTATE_DEVIDED, "rim_inv_ordinary");
        INVOICE_TYPE_MAP.put("3", "rim_inv_ordinary");
        INVOICE_TYPE_MAP.put("26", "rim_inv_electric");
        INVOICE_TYPE_MAP.put("27", "rim_inv_electric");
        FILTER_MAP.put("rim_inv_special", "id,org,tax_org as taxorg,invoice_type as baseinvoicetype,invoice_code as invoicecode,invoice_no as invoiceno,deduction_purpose as deductionpurpose,authenticate_flag as authenticateflag,tax_period as taxperiod,saler_name as salername,saler_tax_no as salertaxno,total_amount as totalamount,invoice_amount as invoiceamount,total_tax_amount as taxamount,total_deduct as totaldeduct,avail_deduct as availdeduct,current_deduct as currentdeduct,remain_deduct as remaindeduct,authenticate_flag as selectstatus,deduction_purpose as selectresult,authenticate_flag as certstatus,remark,invoice_date as invoicedate");
        FILTER_MAP.put("rim_inv_ordinary", "id,org,tax_org as taxorg,invoice_type as baseinvoicetype,invoice_code as invoicecode,invoice_no as invoiceno,transport_deduction as deductionpurpose,deduction_flag as authenticateflag,tax_period as taxperiod,saler_name as salername,saler_tax_no as salertaxno,total_amount as totalamount,invoice_amount as invoiceamount,total_tax_amount as taxamount,total_deduct as totaldeduct,avail_deduct as availdeduct,current_deduct as currentdeduct,remain_deduct as remaindeduct,'0' as selectstatus, '0' as selectresult, '0' as certstatus,remark,invoice_date as invoicedate");
        FILTER_MAP.put("rim_inv_electric", "id,org,tax_org as taxorg,invoice_type as baseinvoicetype,'' as invoicecode,invoice_no as invoiceno,deduction_purpose as deductionpurpose,authenticate_flag as authenticateflag,tax_period as taxperiod,saler_name as salername,saler_tax_no as salertaxno,total_amount as totalamount,invoice_amount as invoiceamount,total_tax_amount as taxamount,total_deduct as totaldeduct,avail_deduct as availdeduct,current_deduct as currentdeduct,remain_deduct as remaindeduct,authenticate_flag as selectstatus,deduction_purpose as selectresult,authenticate_flag as certstatus,remark,invoice_date as invoicedate");
    }
}

