/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.til.formplugin.project;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.Button;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.tctb.helper.TaxOrgTakeRelationServiceHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;

public class TilProjectSelectFormPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String BTNOK = "btnok";
    private static final String PROJECT_ENTITY = "tcvat_prepay_project_info";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTNOK});
    }

    public void initialize() {
        BasedataEdit org = (BasedataEdit)this.getControl("org");
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit project = (BasedataEdit)this.getControl("project");
        project.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void click(EventObject evt) {
        Button btn;
        super.click(evt);
        Object source = evt.getSource();
        if (source instanceof Button && (btn = (Button)source).getKey().equals(BTNOK)) {
            HashMap returnData = new HashMap();
            Object project = this.getModel().getValue("project");
            List<Long> projectids = new ArrayList<Long>(4);
            if (project instanceof DynamicObject) {
                projectids.add(((DynamicObject)project).getLong("id"));
            } else if (project instanceof List) {
                projectids = ((List)project).stream().map(a -> a.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
            }
            returnData.put("project", projectids);
            this.getView().returnDataToParent(returnData);
            this.getView().close();
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        Object isSigle = this.getView().getFormShowParameter().getCustomParam("isSigle");
        ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        ListFilterParameter listFilterParameter = formShowParameter.getListFilterParameter();
        if (beforeF7SelectEvent.getProperty().getName().equals("project")) {
            List projectids;
            DynamicObjectCollection org = (DynamicObjectCollection)this.getModel().getValue("org");
            if (EmptyCheckUtils.isEmpty((Object)org)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7", (String)"TilProjectSelectFormPlugin_0", (String)"taxc-til", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            List orgids = org.stream().map(a -> a.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
            listFilterParameter.setFilter(new QFilter("org", "in", orgids).and("projectstatus", "!=", (Object)"close"));
            formShowParameter.setMultiSelect(!"1".equals(isSigle));
            Object row_project = this.getView().getFormShowParameter().getCustomParam("row_project");
            if (row_project != null && (projectids = (List)row_project).size() > 0) {
                ListSelectedRowCollection listSelectedRowCollection = new ListSelectedRowCollection();
                DynamicObjectCollection query = QueryServiceHelper.query((String)PROJECT_ENTITY, (String)"id,name,number", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)projectids).and("status", "=", (Object)"C")});
                for (DynamicObject project : query) {
                    ListSelectedRow row = new ListSelectedRow();
                    row.setName(project.getString("name"));
                    row.setNumber(project.getString("number"));
                    row.setPrimaryKeyValue(project.get("id"));
                    listSelectedRowCollection.add((Object)row);
                }
                formShowParameter.setListSelectedRowCollection(listSelectedRowCollection);
            }
        } else if (beforeF7SelectEvent.getProperty().getName().equals("org")) {
            List row_org = (List)this.getView().getFormShowParameter().getCustomParam("row_org");
            List orgKakeRelation = TaxOrgTakeRelationServiceHelper.getOrgTakeRelation((List)row_org, (Date)new Date(), (Date)new Date());
            HasPermOrgResult hasPermOrgResult = PermissionUtils.getAllPermOrgs((IFormView)this.getView());
            if (EmptyCheckUtils.isNotEmpty((Object)hasPermOrgResult) && !hasPermOrgResult.hasAllOrgPerm() && EmptyCheckUtils.isNotEmpty((Object)hasPermOrgResult.getHasPermOrgs())) {
                listFilterParameter.setFilter(new QFilter("id", "in", (Object)orgKakeRelation).and("id", "in", (Object)hasPermOrgResult.getHasPermOrgs()));
            } else {
                listFilterParameter.setFilter(new QFilter("id", "in", (Object)orgKakeRelation));
            }
            formShowParameter.setMultiSelect(false);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData[] changeData;
        if (e.getProperty().getName().equals("org") && (changeData = e.getChangeSet()) != null && changeData.length > 0) {
            List orgids;
            QFilter filter;
            DynamicObjectCollection query;
            DynamicObjectCollection org = (DynamicObjectCollection)changeData[0].getNewValue();
            this.getModel().setValue("project", null);
            if (!EmptyCheckUtils.isEmpty((Object)org) && (query = QueryServiceHelper.query((String)PROJECT_ENTITY, (String)"id,name,number,masterid", (QFilter[])(filter = new QFilter("org", "in", orgids = org.stream().map(a -> a.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList())).and("projectstatus", "!=", (Object)"close").and("status", "=", (Object)"C")).toArray(), (String)"number asc")).size() > 0) {
                this.getModel().setValue("project", (Object)new Long[]{((DynamicObject)query.get(0)).getLong("id")});
            }
            this.getView().updateView("project");
        }
    }
}

