/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.til.formplugin.queryscheme;

import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ICloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.isv.ISVService;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.til.formplugin.inputdeduction.enums.NcpJsdkFormEnum;
import kd.taxc.til.formplugin.queryscheme.ISchemeSavePlugin;

public class SchemeSaveExtPlugin
extends AbstractFormPlugin
implements ISchemeSavePlugin,
ICloseCallBack {
    public void preOpenForm(PreOpenFormEventArgs e) {
        FormShowParameter parameter = e.getFormShowParameter();
        String dataSource = (String)parameter.getCustomParam("datasources");
        String entityName = NcpJsdkFormEnum.getEnumByDataSource(dataSource).getDataSourceName();
        parameter.setCaption(entityName);
        super.preOpenForm(e);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Button conditonBtn = (Button)this.getView().getControl("btnok");
        conditonBtn.addClickListener((ClickListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String billType = (String)formShowParameter.getCustomParam("billType");
        if (StringUtils.isEmpty((CharSequence)billType)) {
            return;
        }
        String entryKey = (String)formShowParameter.getCustomParam("entryKey");
        this.getPageCache().put("entryKey", entryKey);
        this.initFilterPage(billType, formShowParameter);
        this.getView().setEnable(Boolean.TRUE, new String[]{"filter"});
        this.getView().updateView("filter");
    }

    private void initFilterPage(String billType, FormShowParameter formShowParameter) {
        String defaultFilter = (String)formShowParameter.getCustomParam("defaultFilter");
        List maps = (List)formShowParameter.getCustomParam("filterConditonField");
        String datasource = (String)formShowParameter.getCustomParam("datasources");
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filter");
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)billType);
        EntityTypeUtil helper = new EntityTypeUtil();
        List allCols = helper.getFilterColumns((IDataEntityType)mainEntityType, false);
        NcpJsdkFormEnum enumByEntityName = NcpJsdkFormEnum.getEnumByEntityName(billType);
        List<String> filterFields = enumByEntityName.getFilterFields();
        List defaultCols = allCols.stream().filter(a -> {
            if (filterFields.contains(a.get("fieldName"))) {
                if ("tax_org.name".equals(a.get("fieldName")) || "org.name".equals(a.get("fieldName"))) {
                    a.put("fieldCaption", ResManager.loadKDString((String)"\u7ec4\u7ec7", (String)"SchemeSaveExtPlugin_0", (String)"taxc-til", (Object[])new Object[0]));
                }
                if ("detail_amount".equals(a.get("fieldName"))) {
                    a.put("fieldCaption", ResManager.loadKDString((String)"\u4e0d\u542b\u7a0e\u91d1\u989d", (String)"SchemeSaveExtPlugin_1", (String)"taxc-til", (Object[])new Object[0]));
                }
                if ("4".equals(datasource) && "tax_period".equals(a.get("fieldName"))) {
                    a.put("fieldCaption", ResManager.loadKDString((String)"\u6240\u5c5e\u8d26\u671f", (String)"SchemeSaveExtPlugin_2", (String)"taxc-til", (Object[])new Object[0]));
                }
                if ("3".equals(datasource)) {
                    if ("tax_period".equals(a.get("fieldName"))) {
                        a.put("fieldCaption", ResManager.loadKDString((String)"\u6240\u5c5e\u7a0e\u671f", (String)"SchemeSaveExtPlugin_3", (String)"taxc-til", (Object[])new Object[0]));
                    }
                    if ("invoice_amount".equals(a.get("fieldName"))) {
                        a.put("fieldCaption", ResManager.loadKDString((String)"\u5408\u8ba1\u91d1\u989d", (String)"SchemeSaveExtPlugin_4", (String)"taxc-til", (Object[])new Object[0]));
                    }
                    if ("transport_deduction".equals(a.get("fieldName"))) {
                        a.put("fieldCaption", ResManager.loadKDString((String)"\u8fdb\u9879\u72b6\u6001", (String)"SchemeSaveExtPlugin_5", (String)"taxc-til", (Object[])new Object[0]));
                    }
                }
                if ("spec_model".equals(a.get("fieldName"))) {
                    a.put("fieldCaption", ResManager.loadKDString((String)"\u89c4\u683c", (String)"SchemeSaveExtPlugin_6", (String)"taxc-til", (Object[])new Object[0]));
                }
                if ("goods_code".equals(a.get("fieldName"))) {
                    a.put("fieldCaption", ResManager.loadKDString((String)"\u7a0e\u6536\u5206\u7c7b\u7f16\u7801", (String)"SchemeSaveExtPlugin_7", (String)"taxc-til", (Object[])new Object[0]));
                }
                a.put("fieldCaption", ((String)a.get("fieldCaption")).replace(ResManager.loadKDString((String)"\u5355\u636e\u4f53.", (String)"SchemeSaveExtPlugin_8", (String)"taxc-til", (Object[])new Object[0]), ""));
                return true;
            }
            return false;
        }).collect(Collectors.toList());
        if (StringUtils.isNotEmpty((CharSequence)defaultFilter)) {
            FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)defaultFilter, FilterCondition.class);
            filterGrid.SetValue(filterCondition);
        }
        defaultCols.addAll(maps);
        filterGrid.setFilterColumns(defaultCols);
        filterGrid.setEntityNumber(billType);
        FilterCondition condition = filterGrid.getFilterGridState().getFilterCondition();
        filterGrid.SetValue(condition);
        String billNameCtl = "filtername";
        Label billNameLab = (Label)this.getControl(billNameCtl);
        if (billNameLab == null) {
            billNameLab = (Label)this.getView().getControl(ISVService.getISVInfo().getId() + billNameCtl);
        }
        billNameLab.setText(mainEntityType.getDisplayName().getLocaleValue());
    }

    @Override
    public void beforeSaveSchemeExt(IFormView view) {
        String filterCtl = "filter";
        FilterGrid filterGrid = (FilterGrid)view.getControl(filterCtl);
        FilterCondition condition = filterGrid.getFilterGridState().getFilterCondition();
        String jsonStr = SerializationUtils.toJsonString((Object)condition);
        view.getModel().setValue("filtervalue", (Object)jsonStr);
    }

    public void click(EventObject e) {
        Control c = (Control)e.getSource();
        String key = c.getKey();
        if (StringUtils.isNotBlank((CharSequence)key) && "btnok".equals(key)) {
            this.returnData();
        }
    }

    private void returnData() {
        int currentRow = this.getView().getModel().getEntryCurrentRowIndex("scheme_entry");
        JSONObject returnData = new JSONObject();
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("scheme_entry");
        int[] selectRows = entryGrid.getSelectRows();
        Long schemeId = null;
        returnData.put("DBData", (Object)"false");
        if (selectRows.length > 0) {
            returnData.put("DBData", (Object)"true");
            schemeId = (Long)this.getView().getModel().getValue("schemeid_entry", currentRow);
        }
        returnData.put("schemeid", schemeId);
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filter");
        FilterCondition condition = filterGrid.getFilterGridState().getFilterCondition();
        String jsonStr = SerializationUtils.toJsonString((Object)condition);
        returnData.put("filtervalue", (Object)jsonStr);
        String entryKey = this.getPageCache().get("entryKey");
        returnData.put("entryKey", (Object)entryKey);
        returnData.put("billEntity", (Object)filterGrid.getEntityNumber());
        returnData.put("pagekey", (Object)this.getWfEntryKey(this.getView()));
        this.getView().returnDataToParent((Object)returnData);
        this.getView().close();
    }

    @Override
    public void selectSchemeDealExt(DynamicObject dbFormDataDyc, IFormView view) {
        FilterGrid filterGrid = (FilterGrid)view.getControl("filter");
        String filterValue = dbFormDataDyc.getString("filtervalue");
        if (StringUtils.isEmpty((CharSequence)filterValue)) {
            FilterCondition filterCondition = new FilterCondition();
            filterGrid.SetValue(filterCondition);
            return;
        }
        FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterValue, FilterCondition.class);
        filterGrid.SetValue(filterCondition);
    }

    @Override
    public DynamicObjectCollection getSaveSchemeListDataExt(IFormView view) {
        String pageKey = this.getWfEntryKey(view);
        QFilter filter = new QFilter("formid", "=", (Object)view.getEntityId());
        filter.and("creator", "=", (Object)RequestContext.get().getCurrUserId());
        filter.and("pagekey", "=", (Object)pageKey);
        DynamicObjectCollection schemeDycs = QueryServiceHelper.query((String)this.getClass().getName(), (String)"til_query_condition_plan", (String)"id,name,isdefault,schemestr,pagekey", (QFilter[])filter.toArray(), (String)"isdefault desc,modifytime desc");
        return schemeDycs;
    }

    @Override
    public void saveSchemeDynaDealExt(IFormView view, DynamicObject schemeDyna) {
        String entryKey = this.getWfEntryKey(view);
        schemeDyna.set("pagekey", (Object)entryKey);
    }

    @Override
    public QFilter checkSchemeNameQfilter(IFormView view) {
        String entryKey = this.getWfEntryKey(view);
        return new QFilter("pagekey", "=", (Object)entryKey);
    }

    private String getWfEntryKey(IFormView view) {
        String entryKey = (String)view.getFormShowParameter().getCustomParam("entryKey");
        String wfType = (String)view.getFormShowParameter().getCustomParam("datasources");
        return wfType + entryKey;
    }

    @Override
    public boolean checkDataChangedExt() {
        return false;
    }
}

