/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.til.formplugin.sign;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.FilterContainerInitEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.SearchClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgUtils;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.metadata.MetadataUtil;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import kd.taxc.til.formplugin.sign.enums.InvoiceSignBoardFilterEnum;
import kd.taxc.til.formplugin.utils.ViewInvokeOperationUtil;
import org.apache.commons.lang3.StringUtils;

public class InvoiceReceiptListPlugin
extends AbstractListPlugin {
    public static final String SPECIALFILTER = "specialfilter";
    private static Log LOGGER = LogFactory.getLog(InvoiceReceiptListPlugin.class);
    private static final String FILTER_CONTAINER_AP = "filtercontainerap";
    private static final String SELECTED_FLEX_KEY = "selectedflexkey";
    private static final String VERIFY_ORG = "VERIFY_ORG";
    private static final String FILTER_PARAM = "filterParameter";

    public void initialize() {
        FilterContainer filterContainer = (FilterContainer)this.getView().getControl(FILTER_CONTAINER_AP);
        filterContainer.setBillFormId("tdm_invoice_input_inherit");
        filterContainer.addFilterContainerInitListener(event -> this.filterContainerInit(event));
        filterContainer.addSearchClickListener(event -> this.filterSearchClickEvent(event));
        filterContainer.addBeforeF7SelectListener(this::filterContainerBeforeF7Select);
        BillList billList = (BillList)this.getControl("billlistap");
        billList.addSetFilterListener(arg_0 -> ((InvoiceReceiptListPlugin)this).setFilter(arg_0));
        billList.addPackageDataListener(this::packageData);
        String specialFilterStr = this.getPageCache().get(SPECIALFILTER);
        if (StringUtils.isNotBlank((CharSequence)specialFilterStr)) {
            List qFilters = (List)SerializationUtils.deSerializeFromBase64((String)specialFilterStr);
            billList.getFilterParameter().setQFilters(qFilters);
        }
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addBoardClickListener(InvoiceSignBoardFilterEnum.values());
    }

    public void itemClick(ItemClickEvent evt) {
        if ("invoicearrivedsign".equals(evt.getItemKey()) || "invoicereceipt".equals(evt.getItemKey()) || "cancelsign".equals(evt.getItemKey()) || "cancelreceipt".equals(evt.getItemKey())) {
            BillList billlist = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection rows = billlist.getSelectedRows();
            if (CollectionUtils.isEmpty((Collection)rows)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"InvoiceReceiptListPlugin_0", (String)"taxc-til", (Object[])new Object[0]));
                return;
            }
            List pks = rows.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
            String targetFiled = "invoicearrivedsign".equals(evt.getItemKey()) || "cancelsign".equals(evt.getItemKey()) ? "id,invoicearriveddate,invoicearriveder,invoicearrivedstatus,certstatus,isgeneratevoucher" : "id,receiptdate,receipter,signstatus,certstatus,isgeneratevoucher";
            DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)billlist.getEntityId(), (String)MetadataUtil.getAllFieldToQuery((String)billlist.getEntityId()), (QFilter[])new QFilter[]{new QFilter("id", "in", pks)});
            String[] targetFields = targetFiled.split(",");
            if (dynamicObjects != null && dynamicObjects.length > 0) {
                String finalTargetFiled = targetFields[3];
                StringBuilder errorMessage = new StringBuilder();
                ArrayList<Object> pkIds = new ArrayList<Object>();
                if ("invoicearrivedsign".equals(evt.getItemKey()) || "invoicereceipt".equals(evt.getItemKey())) {
                    this.validateSignData(evt, dynamicObjects, finalTargetFiled, errorMessage, pkIds);
                } else {
                    int successNum = this.validateCancelData(evt, dynamicObjects, targetFields, finalTargetFiled, errorMessage);
                    if (successNum == dynamicObjects.length) {
                        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\uff01", (String)"InvoiceReceiptListPlugin_1", (String)"taxc-til", (Object[])new Object[0]));
                        this.refreshData();
                        return;
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)errorMessage.toString())) {
                    String[] messages = errorMessage.toString().split(System.getProperty("line.separator"));
                    if (messages.length == 1) {
                        this.getView().showTipNotification(errorMessage.toString());
                    } else {
                        this.getView().getFormShowParameter().getOpenStyle().setShowType(ShowType.Modal);
                        OperationResult operationResult = new OperationResult();
                        operationResult.setSuccess(false);
                        operationResult.setMessage(errorMessage.toString());
                        this.getView().showOperationResult(operationResult);
                    }
                } else if (("invoicearrivedsign".equals(evt.getItemKey()) || "invoicereceipt".equals(evt.getItemKey())) && !CollectionUtils.isEmpty(pkIds)) {
                    this.showDateSelectForm(pkIds, evt.getItemKey());
                }
                this.refreshData();
            }
        } else if ("refresh".equals(evt.getItemKey())) {
            this.refreshData();
        }
    }

    private void refreshData() {
        List oldOrgVal = null;
        QFilter qFilter = null;
        String verifyOrgStr = this.getPageCache().get(VERIFY_ORG);
        if (EmptyCheckUtils.isNotEmpty((Object)verifyOrgStr)) {
            oldOrgVal = (List)SerializationUtils.deSerializeFromBase64((String)verifyOrgStr);
            qFilter = new QFilter("org", "in", (Object)oldOrgVal);
        }
        this.loadBoard(qFilter);
        BillList billList = (BillList)this.getControl("billlistap");
        String filterParamStr = this.getPageCache().get(FILTER_PARAM);
        if (StringUtils.isNotBlank((CharSequence)filterParamStr)) {
            FilterParameter filterParameter = (FilterParameter)SerializationUtils.deSerializeFromBase64((String)filterParamStr);
            billList.getFilterParameter().setQFilters(filterParameter.getQFilters());
        } else {
            String defaultFilterStr = this.getPageCache().get("filterParameterdefault");
            QFilter defaultFilter = (QFilter)SerializationUtils.deSerializeFromBase64((String)defaultFilterStr);
            billList.getFilterParameter().setFilter(defaultFilter);
        }
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(qFilter);
        if (EmptyCheckUtils.isNotEmpty((Object)this.getPageCache().get(SELECTED_FLEX_KEY))) {
            String key = this.getPageCache().get(SELECTED_FLEX_KEY);
            QFilter boardFilter = InvoiceSignBoardFilterEnum.getQFilterByFlexKey(key);
            qFilters.add(boardFilter);
            billList.getFilterParameter().setQFilters(qFilters);
        }
        billList.clearSelection();
        billList.refresh();
    }

    private void validateSignData(ItemClickEvent evt, DynamicObject[] dynamicObjects, String finalTargetFiled, StringBuilder errorMessage, List<Object> pkIds) {
        ArrayList<DynamicObject> dynamicObjectList = new ArrayList<DynamicObject>(Arrays.asList(dynamicObjects));
        for (DynamicObject obj : dynamicObjectList) {
            if ("1".equals(obj.getString(finalTargetFiled))) {
                if ("invoicearrivedsign".equals(evt.getItemKey())) {
                    errorMessage.append(String.format(ResManager.loadKDString((String)"\u53d1\u7968\u4ee3\u7801\uff1a%1$s \u53d1\u7968\u53f7\u7801\uff1a%2$s\u5df2\u5230\u7968,\u4e0d\u53ef\u8fdb\u884c\u767b\u8bb0\u3002", (String)"InvoiceReceiptListPlugin_2", (String)"taxc-til", (Object[])new Object[0]), obj.getString("invoicecode"), obj.getString("invoiceno"))).append(System.getProperty("line.separator"));
                    continue;
                }
                errorMessage.append(String.format(ResManager.loadKDString((String)"\u53d1\u7968\u4ee3\u7801\uff1a%1$s \u53d1\u7968\u53f7\u7801\uff1a%2$s\u5df2\u7b7e\u6536,\u4e0d\u53ef\u8fdb\u884c\u7b7e\u6536\u3002", (String)"InvoiceReceiptListPlugin_3", (String)"taxc-til", (Object[])new Object[0]), obj.getString("invoicecode"), obj.getString("invoiceno"))).append(System.getProperty("line.separator"));
                continue;
            }
            pkIds.add(obj.get("id"));
        }
    }

    private int validateCancelData(ItemClickEvent evt, DynamicObject[] dynamicObjects, String[] targetFields, String finalTargetFiled, StringBuilder message) {
        String certStatus = targetFields[4];
        ArrayList<DynamicObject> dynamicObjectList = new ArrayList<DynamicObject>(Arrays.asList(dynamicObjects));
        ArrayList<DynamicObject> validatedDynamicObjectList = new ArrayList<DynamicObject>();
        StringBuilder detailMessage = new StringBuilder();
        for (DynamicObject obj : dynamicObjectList) {
            Boolean isValidate = Boolean.TRUE;
            if ("cancelsign".equals(evt.getItemKey())) {
                if (StringUtils.isBlank((CharSequence)obj.getString(finalTargetFiled)) || "0".equals(obj.getString(finalTargetFiled))) {
                    isValidate = Boolean.FALSE;
                    detailMessage.append(String.format(ResManager.loadKDString((String)"\u53d1\u7968\u4ee3\u7801\uff1a%1$s \u53d1\u7968\u53f7\u7801\uff1a%2$s\u672a\u5230\u7968\uff0c\u4e0d\u53ef\u53d6\u6d88\u767b\u8bb0\u3002", (String)"InvoiceReceiptListPlugin_4", (String)"taxc-til", (Object[])new Object[0]), obj.getString("invoicecode"), obj.getString("invoiceno"))).append(System.getProperty("line.separator"));
                }
                if ("1".equals(obj.getString(certStatus))) {
                    isValidate = Boolean.FALSE;
                    detailMessage.append(String.format(ResManager.loadKDString((String)"\u53d1\u7968\u4ee3\u7801\uff1a%1$s \u53d1\u7968\u53f7\u7801\uff1a%2$s\u5df2\u8ba4\u8bc1\uff0c\u4e0d\u53ef\u53d6\u6d88\u767b\u8bb0\u3002", (String)"InvoiceReceiptListPlugin_5", (String)"taxc-til", (Object[])new Object[0]), obj.getString("invoicecode"), obj.getString("invoiceno"))).append(System.getProperty("line.separator"));
                }
            } else {
                if (StringUtils.isBlank((CharSequence)obj.getString(finalTargetFiled)) || "0".equals(obj.getString(finalTargetFiled))) {
                    isValidate = Boolean.FALSE;
                    detailMessage.append(String.format(ResManager.loadKDString((String)"\u53d1\u7968\u4ee3\u7801\uff1a%1$s \u53d1\u7968\u53f7\u7801\uff1a%2$s\u672a\u7b7e\u6536\uff0c\u4e0d\u53ef\u53d6\u6d88\u7b7e\u6536\u3002", (String)"InvoiceReceiptListPlugin_6", (String)"taxc-til", (Object[])new Object[0]), obj.getString("invoicecode"), obj.getString("invoiceno"))).append(System.getProperty("line.separator"));
                }
                if ("1".equals(obj.getString(certStatus))) {
                    isValidate = Boolean.FALSE;
                    detailMessage.append(String.format(ResManager.loadKDString((String)"\u53d1\u7968\u4ee3\u7801\uff1a%1$s \u53d1\u7968\u53f7\u7801\uff1a%2$s\u5df2\u8ba4\u8bc1\uff0c\u4e0d\u53ef\u53d6\u6d88\u7b7e\u6536\u3002", (String)"InvoiceReceiptListPlugin_7", (String)"taxc-til", (Object[])new Object[0]), obj.getString("invoicecode"), obj.getString("invoiceno")));
                }
            }
            if (!isValidate.booleanValue()) continue;
            validatedDynamicObjectList.add(obj);
        }
        if (!CollectionUtils.isEmpty(validatedDynamicObjectList)) {
            Arrays.stream(dynamicObjects).forEach(o -> {
                o.set(targetFields[1], null);
                o.set(targetFields[2], null);
                o.set(targetFields[3], (Object)"0");
            });
            SaveServiceHelper.update((DynamicObject[])dynamicObjects);
        }
        message.append(String.format(ResManager.loadKDString((String)"\u6210\u529f\u6761\u6570%s", (String)"InvoiceReceiptListPlugin_8", (String)"taxc-til", (Object[])new Object[0]), validatedDynamicObjectList.size())).append(System.getProperty("line.separator")).append(String.format(ResManager.loadKDString((String)"\u5931\u8d25\u6761\u6570%s,\u8be6\u7ec6\u4fe1\u606f\uff1a", (String)"InvoiceReceiptListPlugin_9", (String)"taxc-til", (Object[])new Object[0]), dynamicObjectList.size() - validatedDynamicObjectList.size())).append(System.getProperty("line.separator")).append((CharSequence)detailMessage);
        return validatedDynamicObjectList.size();
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        QFilter qFilter = InvoiceSignBoardFilterEnum.getQFilterByFlexKey(key);
        if (EmptyCheckUtils.isEmpty((Object)qFilter)) {
            return;
        }
        if (EmptyCheckUtils.isNotEmpty((Object)this.getPageCache().get(SELECTED_FLEX_KEY))) {
            String oldselectflexkey = this.getPageCache().get(SELECTED_FLEX_KEY);
            this.removeOldSelectFlex(oldselectflexkey);
            this.addNewSelectFlex(key);
        } else {
            this.addNewSelectFlex(key);
        }
        this.displayDataByBoardSelected(qFilter);
    }

    private void displayDataByBoardSelected(QFilter qFilter) {
        BillList billList = (BillList)this.getControl("billlistap");
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
        String verifyOrgStr = this.getPageCache().get(VERIFY_ORG);
        if (verifyOrgStr != null) {
            List orgId = (List)SerializationUtils.deSerializeFromBase64((String)verifyOrgStr);
            if (EmptyCheckUtils.isEmpty((Object)orgId)) {
                throw new KDBizException("tax org can not be null");
            }
            QFilter orgFilter = new QFilter("org", "in", (Object)orgId);
            qFilters.add(orgFilter);
        }
        qFilters.add(qFilter);
        this.getPageCache().put(SPECIALFILTER, SerializationUtils.serializeToBase64(qFilters));
        billList.getFilterParameter().setQFilters(qFilters);
        billList.clearSelection();
        billList.refresh();
    }

    private void addBoardClickListener(InvoiceSignBoardFilterEnum[] invoiceSignBoardFilterEnum) {
        for (InvoiceSignBoardFilterEnum invoiceSignBoardEnum : invoiceSignBoardFilterEnum) {
            this.addClickListeners(new String[]{invoiceSignBoardEnum.getFlexKey()});
        }
    }

    private void addNewSelectFlex(String key) {
        HashMap stylemap1 = new HashMap(8);
        String selectedlinestyle = "2px_solid_#5582F3";
        HashMap style = new HashMap();
        HashMap<String, String> border = new HashMap<String, String>();
        border.put("b", selectedlinestyle);
        style.put("b", border);
        stylemap1.put("s", style);
        this.getView().updateControlMetadata(key, stylemap1);
        this.getPageCache().put(SELECTED_FLEX_KEY, key);
    }

    private void removeOldSelectFlex(String oldselectflexkey) {
        HashMap stylemap1 = new HashMap(8);
        String selectedlinestyle = "1px_solid_#d9d9d9";
        HashMap style = new HashMap();
        HashMap<String, String> border = new HashMap<String, String>();
        border.put("b", selectedlinestyle);
        style.put("b", border);
        stylemap1.put("s", style);
        this.getView().updateControlMetadata(oldselectflexkey, stylemap1);
    }

    private void showDateSelectForm(List<Object> pks, String itemKey) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("til_arrived_invoice_date");
        showParameter.setCustomParam("selectrows", pks);
        showParameter.setCustomParam("itemkey", (Object)itemKey);
        if ("invoicearrivedsign".equals(itemKey)) {
            showParameter.setCaption(ResManager.loadKDString((String)"\u786e\u8ba4\u5230\u7968\u65e5\u671f", (String)"InvoiceReceiptListPlugin_10", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
        } else {
            showParameter.setCaption(ResManager.loadKDString((String)"\u786e\u8ba4\u7b7e\u6536\u65e5\u671f", (String)"InvoiceReceiptListPlugin_11", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
        }
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "closesync"));
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        if ("closesync".equals(closedCallBackEvent.getActionId())) {
            this.refreshData();
        }
    }

    public void afterBindData(EventObject e) {
        String verifyOrgStr = this.getPageCache().get(VERIFY_ORG);
        if (EmptyCheckUtils.isNotEmpty((Object)verifyOrgStr)) {
            List verifyOrg = (List)SerializationUtils.deSerializeFromBase64((String)verifyOrgStr);
            List params = (List)SerializationUtils.fromJsonString((String)("[{\"key\":\"filtercontainerap\",\"methodName\":\"commonSearch\",\"args\":[[],[{\"FieldName\":[\"org.id\"],\"Value\":[\"" + verifyOrg.get(0) + "\"],\"Compare\":[\"\"]},{\"FieldName\":[\"invoicedate\"],\"Value\":[\"63\"],\"Compare\":[\"63\"]},{\"FieldName\":[\"invoicearrivedstatus\"],\"Value\":[\"\"],\"Compare\":[\"\"]},{\"FieldName\":[\"signstatus\"],\"Value\":[\"\"],\"Compare\":[\"\"]},{\"FieldName\":[\"certstatus\"],\"Value\":[\"0\"],\"Compare\":[\"\"]}],\"tdm_invoice_input_inherit\"],\"postData\":[]}]"), List.class);
            ViewInvokeOperationUtil.invokeOperation(this.getView(), params);
        }
    }

    public void packageData(PackageDataEvent e) {
        String signStatus;
        String invoiceArrivedStatus;
        String isGenerateVoucher;
        DynamicObject data = e.getRowData();
        String certStatus = data.getString("certstatus");
        if (StringUtils.isBlank((CharSequence)certStatus)) {
            data.set("certStatus", (Object)"0");
        }
        if (StringUtils.isBlank((CharSequence)(isGenerateVoucher = data.getString("isgeneratevoucher")))) {
            data.set("isgeneratevoucher", (Object)"0");
        }
        if (StringUtils.isBlank((CharSequence)(invoiceArrivedStatus = data.getString("invoicearrivedstatus")))) {
            data.set("invoicearrivedstatus", (Object)"0");
        }
        if (StringUtils.isBlank((CharSequence)(signStatus = data.getString("signstatus")))) {
            data.set("signstatus", (Object)"0");
        }
    }

    private void filterSearchClickEvent(SearchClickEvent searchClickEvent) {
        QFilter orgFilter;
        BillList billList = (BillList)this.getView().getControl("billlistap");
        Map map = searchClickEvent.getFilterValues();
        List customlist = (List)map.get("customfilter");
        List schemelist = (List)map.get("schemefilter");
        List fastlist = (List)map.get("fastfilter");
        FilterParameter fastFilterParameter = searchClickEvent.getFilterModel().getFastFilterParameter(fastlist);
        List fastQFilterList = fastFilterParameter.getQFilters();
        FilterParameter commonFilterParameter = searchClickEvent.getFilterModel().getCommonFilterParameter(customlist);
        List commonQFilterList = commonFilterParameter.getQFilters();
        FilterParameter schemaFilterParameter = searchClickEvent.getFilterModel().getSchemeFilterParameter(schemelist);
        List schemaQFilterList = schemaFilterParameter.getQFilters();
        fastQFilterList.addAll(commonQFilterList);
        fastQFilterList.addAll(schemaQFilterList);
        String verifyOrgStr = this.getPageCache().get(VERIFY_ORG);
        if (verifyOrgStr != null && EmptyCheckUtils.isNotEmpty((Object)(orgFilter = this.getOrgFilter(commonQFilterList, billList.getFilterParameter().getQFilters())))) {
            fastQFilterList.add(orgFilter);
        }
        for (QFilter qFilter : fastQFilterList) {
            if (qFilter.getProperty().equalsIgnoreCase("invoicearrivedstatus") && "0".equals(qFilter.getValue())) {
                qFilter.or(new QFilter("invoicearrivedstatus", "is null", null)).or(new QFilter("invoicearrivedstatus", "=", (Object)""));
            }
            if (qFilter.getProperty().equalsIgnoreCase("signstatus") && "0".equals(qFilter.getValue())) {
                qFilter.or(new QFilter("signstatus", "is null", null)).or(new QFilter("signstatus", "=", (Object)""));
            }
            if (!qFilter.getProperty().equalsIgnoreCase("certstatus") || !"0".equals(qFilter.getValue())) continue;
            qFilter.or(new QFilter("certstatus", "is null", null)).or(new QFilter("certstatus", "=", (Object)""));
        }
        this.getPageCache().put(FILTER_PARAM, SerializationUtils.serializeToBase64((Object)fastFilterParameter));
        String oldselectflexkey = this.getPageCache().get(SELECTED_FLEX_KEY);
        if (EmptyCheckUtils.isNotEmpty((Object)oldselectflexkey)) {
            this.getPageCache().remove(SELECTED_FLEX_KEY);
            this.removeOldSelectFlex(oldselectflexkey);
        }
        billList.setFilterParameter(fastFilterParameter);
        billList.clearSelection();
        billList.refresh();
    }

    private QFilter getOrgFilter(List<QFilter> commonQFilterList, List<QFilter> qFilters) {
        for (QFilter qFilter : commonQFilterList) {
            if (!qFilter.getProperty().equalsIgnoreCase("org.id")) continue;
            return null;
        }
        for (int i = qFilters.size() - 1; i >= 0; --i) {
            if (!qFilters.get(i).getProperty().equalsIgnoreCase("org")) continue;
            return qFilters.get(i);
        }
        return null;
    }

    private void filterContainerInit(FilterContainerInitEvent event) {
        List filterColumnList = event.getCommonFilterColumns();
        CommonFilterColumn orgColumn = null;
        CommonFilterColumn invoiceDateColumn = null;
        CommonFilterColumn certStatusColumn = null;
        for (FilterColumn column : filterColumnList) {
            if (column.getFieldName().startsWith("org.")) {
                orgColumn = (CommonFilterColumn)column;
            }
            if (column.getFieldName().equals("invoicedate")) {
                invoiceDateColumn = (CommonFilterColumn)column;
            }
            if (!column.getFieldName().equals("certstatus")) continue;
            certStatusColumn = (CommonFilterColumn)column;
        }
        QFilter qFilter = null;
        QFilter orgFilter = null;
        QFilter dateFilter = null;
        QFilter certStatusFilter = null;
        if (orgColumn != null) {
            List<ComboItem> orgCombos = this.getOrgComboItem();
            if (this.getPageCache().get("CACHE_DEFAULT_ORG") == null) {
                if (!orgCombos.isEmpty()) {
                    this.getPageCache().put("CACHE_DEFAULT_ORG", orgCombos.get(0).getValue());
                    orgColumn.setDefaultValue(orgCombos.get(0).getValue());
                    orgFilter = new QFilter("org", "in", Collections.singletonList(Long.parseLong(orgCombos.get(0).getValue())));
                } else {
                    orgFilter = new QFilter("org", "in", Collections.singletonList("-1"));
                }
            }
            orgColumn.setType("enum");
            orgColumn.setComboItems(orgCombos);
        }
        if (invoiceDateColumn != null && this.getPageCache().get("defaultinvoicedate") == null) {
            this.getPageCache().put("defaultinvoicedate", "-1");
            qFilter = dateFilter = new QFilter("invoicedate", ">=", (Object)DateUtils.getFirstDateOfMonth((Date)new Date())).and(new QFilter("invoicedate", "<", (Object)DateUtils.getFirstDateOfMonth((Date)DateUtils.addMonth((Date)new Date(), (int)1))));
        }
        if (certStatusColumn != null && this.getPageCache().get("defaultcertstatus") == null) {
            this.getPageCache().put("defaultcertstatus", "0");
            certStatusFilter = new QFilter("certstatus", "=", (Object)"0");
            qFilter = qFilter == null ? certStatusFilter : qFilter.and(certStatusFilter);
        }
        BillList billlist = (BillList)this.getControl("billlistap");
        Class<CommonFilterColumn> clas = CommonFilterColumn.class;
        try {
            Field field = clas.getDeclaredField("selectedCommomFilterFieldValues");
            AccessibleObject.setAccessible(new AccessibleObject[]{field}, true);
            List list = (List)field.get(orgColumn);
            if (EmptyCheckUtils.isNotEmpty((Object)list)) {
                list = list.stream().map(o -> Long.parseLong(String.valueOf(o))).collect(Collectors.toList());
                orgFilter = new QFilter("org", "in", list);
            }
            if (orgFilter != null) {
                List newOrgValTemp = (List)orgFilter.getValue();
                List oldOrgVal = new ArrayList();
                String verifyOrgStr = this.getPageCache().get(VERIFY_ORG);
                if (EmptyCheckUtils.isNotEmpty((Object)verifyOrgStr)) {
                    oldOrgVal = (List)SerializationUtils.deSerializeFromBase64((String)verifyOrgStr);
                }
                oldOrgVal.retainAll(newOrgValTemp);
                if (newOrgValTemp.size() != oldOrgVal.size()) {
                    this.getPageCache().remove(SPECIALFILTER);
                    String oldselectflexkey = this.getPageCache().get(SELECTED_FLEX_KEY);
                    this.removeOldSelectFlex(oldselectflexkey);
                }
                this.getPageCache().put(VERIFY_ORG, SerializationUtils.serializeToBase64((Object)orgFilter.getValue()));
            } else {
                this.getPageCache().remove(VERIFY_ORG);
            }
            this.loadBoard(orgFilter);
            qFilter = qFilter != null ? qFilter.and(orgFilter) : orgFilter;
            this.getPageCache().put("filterParameterdefault", SerializationUtils.serializeToBase64((Object)qFilter));
            billlist.getFilterParameter().setFilter(qFilter);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            LOGGER.error(ResManager.loadKDString((String)"\u83b7\u53d6\u591a\u9009\u7ec4\u7ec7\u5931\u8d25", (String)"InvoiceReceiptListPlugin_12", (String)"taxc-tctb-formplugin", (Object[])new Object[0]), (Throwable)e);
        }
    }

    private List<ComboItem> getOrgComboItem() {
        String orgListCache = "orgListCache";
        String orgListCacheString = this.getPageCache().get(orgListCache);
        List orgList = new ArrayList();
        if (orgListCacheString == null || StringUtils.equals((CharSequence)orgListCacheString, (CharSequence)"[]")) {
            orgList = OrgUtils.queryOrgListForInitOrgComboItems((IFormView)this.getView(), (String[])new String[]{"til_sign_ticket"}, null, null);
            this.getPageCache().put(orgListCache, SerializationUtils.toJsonString(orgList));
        } else {
            orgList = (List)SerializationUtils.fromJsonString((String)orgListCacheString, orgList.getClass());
        }
        return OrgUtils.getComboItems(orgList);
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        if ("bos_org".equals(args.getRefEntityId())) {
            HasPermOrgResult result = PermissionUtils.getAllPermOrgs((IFormView)this.getView());
            if (result == null || result.hasAllOrgPerm()) {
                return;
            }
            OrgUtils.addFilterByConditionBeforeF7Select((Object)args, (IFormView)this.getView(), (String[])new String[]{"til_sign_ticket"}, null, null);
        }
    }

    private void loadBoard(QFilter qFilter) {
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"tdm_invoice_input", (String)"id,invoicearriveddate,invoicearrivedstatus,invoiceamount,taxamount,receiptdate,signstatus", (QFilter[])new QFilter[]{qFilter});
        this.doLoadBoard(dynamicObjectCollection);
    }

    private void doLoadBoard(DynamicObjectCollection dynamicObjects) {
        Long jrArrivedNum = 0L;
        BigDecimal jrTotalAmount = BigDecimal.ZERO;
        BigDecimal jrTotalTaxAmount = BigDecimal.ZERO;
        Long byArrivedNum = 0L;
        Long wdpNum = 0L;
        Long jrSignNum = 0L;
        BigDecimal jrSignTotalAmount = BigDecimal.ZERO;
        BigDecimal jrSignTotalTaxAmount = BigDecimal.ZERO;
        Long bySignNum = 0L;
        Long noSignNum = 0L;
        if (!CollectionUtils.isEmpty((Collection)dynamicObjects)) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                Long l;
                Long l2;
                Long l3;
                Long l4;
                Date invoiceArrivedDate = dynamicObject.getDate("invoicearriveddate");
                String invoiceArrivedStatus = dynamicObject.getString("invoicearrivedstatus");
                if (StringUtils.equals((CharSequence)"1", (CharSequence)invoiceArrivedStatus) && invoiceArrivedDate != null && DateUtils.format((Date)invoiceArrivedDate, (String)"yyyy-MM-dd").equals(DateUtils.format((Date)new Date(), (String)"yyyy-MM-dd"))) {
                    l4 = jrArrivedNum;
                    l3 = jrArrivedNum = Long.valueOf(jrArrivedNum + 1L);
                    jrTotalAmount = BigDecimalUtil.addObject((Object)jrTotalAmount, (Object)dynamicObject.get("invoiceamount"));
                    jrTotalTaxAmount = BigDecimalUtil.addObject((Object)jrTotalTaxAmount, (Object)dynamicObject.get("taxamount"));
                }
                if (StringUtils.equals((CharSequence)"0", (CharSequence)invoiceArrivedStatus) || StringUtils.isBlank((CharSequence)invoiceArrivedStatus)) {
                    l4 = wdpNum;
                    l3 = wdpNum = Long.valueOf(wdpNum + 1L);
                }
                if (invoiceArrivedDate != null && DateUtils.format((Date)invoiceArrivedDate, (String)"yyyy-MM").equals(DateUtils.format((Date)new Date(), (String)"yyyy-MM"))) {
                    l4 = byArrivedNum;
                    l3 = byArrivedNum = Long.valueOf(byArrivedNum + 1L);
                }
                Date receiptDate = dynamicObject.getDate("receiptdate");
                String signStatus = dynamicObject.getString("signstatus");
                if (StringUtils.equals((CharSequence)"1", (CharSequence)signStatus) && receiptDate != null && DateUtils.format((Date)receiptDate, (String)"yyyy-MM-dd").equals(DateUtils.format((Date)new Date(), (String)"yyyy-MM-dd"))) {
                    l2 = jrSignNum;
                    l = jrSignNum = Long.valueOf(jrSignNum + 1L);
                    jrSignTotalAmount = BigDecimalUtil.addObject((Object)jrSignTotalAmount, (Object)dynamicObject.get("invoiceamount"));
                    jrSignTotalTaxAmount = BigDecimalUtil.addObject((Object)jrSignTotalTaxAmount, (Object)dynamicObject.get("taxamount"));
                }
                if (StringUtils.equals((CharSequence)"0", (CharSequence)signStatus) || StringUtils.isBlank((CharSequence)signStatus)) {
                    l2 = noSignNum;
                    l = noSignNum = Long.valueOf(noSignNum + 1L);
                }
                if (receiptDate == null || !DateUtils.format((Date)receiptDate, (String)"yyyy-MM").equals(DateUtils.format((Date)new Date(), (String)"yyyy-MM"))) continue;
                l2 = bySignNum;
                l = bySignNum = Long.valueOf(bySignNum + 1L);
            }
        }
        this.getModel().setValue("jrdpsl", (Object)jrArrivedNum);
        this.getModel().setValue("totalinvoiceamount", (Object)jrTotalAmount);
        this.getModel().setValue("totaltaxamount", (Object)jrTotalTaxAmount);
        this.getModel().setValue("bydpsl", (Object)byArrivedNum);
        this.getModel().setValue("wdpsl", (Object)wdpNum);
        this.getModel().setValue("jrqssl", (Object)jrSignNum);
        this.getModel().setValue("qstotalamount", (Object)jrSignTotalAmount);
        this.getModel().setValue("qstotaltaxamount", (Object)jrSignTotalTaxAmount);
        this.getModel().setValue("receiptsl", (Object)bySignNum);
        this.getModel().setValue("wqssl", (Object)noSignNum);
    }
}

