/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.til.formplugin.sign;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.ext.fi.ai.DapVoucherUtil;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.taxc.til.formplugin.sign.enums.SelectFieldsEnum;
import kd.taxc.til.formplugin.sign.enums.VoucherCheckEnum;
import kd.taxc.til.formplugin.tio.enums.TioCheckCertEnum;
import kd.taxc.til.formplugin.utils.VoucherOperationEnum;

public class TilGenerateVoucherPlugin
extends AbstractListPlugin {
    private static final String TOOL_BAR = "toolbarap";
    private static final String BILL_LIST = "billlistap";
    private static final String VOUCHER_CALLBACK = "voucher_callback";
    private static final String TAB_AP = "tabap";

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{TOOL_BAR});
    }

    public void itemClick(ItemClickEvent evt) {
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String itemKey = afterDoOperationEventArgs.getOperateKey();
        if (VoucherOperationEnum.getKeys().contains(itemKey)) {
            this.doVoucherOperation(itemKey);
        }
    }

    private void doVoucherOperation(String itemKey) {
        BillList billlist = this.getBillList();
        ListSelectedRowCollection rows = billlist.getSelectedRows();
        if (CollectionUtils.isEmpty((Collection)rows)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"TilGenerateVoucherPlugin_0", (String)"taxc-til", (Object[])new Object[0]));
            return;
        }
        HashSet<Object> billNoList = new HashSet<Object>(rows.size());
        List<Object> pkIdList = rows.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)billlist.getEntityId(), (String)SelectFieldsEnum.getFieldsByEntityId(billlist.getEntityId()), (QFilter[])new QFilter[]{new QFilter("id", "in", pkIdList)});
        if (dynamicObjects != null && dynamicObjects.length > 0) {
            StringBuilder message = new StringBuilder();
            for (DynamicObject dynamicObject : dynamicObjects) {
                if (StringUtils.isBlank((CharSequence)dynamicObject.getString("id"))) continue;
                billNoList.add(dynamicObject.get("id"));
                VoucherCheckEnum voucherCheckEnum = VoucherCheckEnum.findVoucherCheckEnumByCode(billlist.getEntityId());
                voucherCheckEnum.getCheckConsumer().accept((Object)dynamicObject, (Object)message, (Object)itemKey);
            }
            if (StringUtils.isNotBlank((CharSequence)message.toString())) {
                String[] messages = message.toString().split(System.getProperty("line.separator"));
                if (messages.length == 1) {
                    this.getView().showTipNotification(message.toString());
                    return;
                }
                this.getView().getFormShowParameter().getOpenStyle().setShowType(ShowType.Modal);
                OperationResult operationResult = new OperationResult();
                operationResult.setSuccess(false);
                operationResult.setMessage(message.toString());
                this.getView().showOperationResult(operationResult);
                return;
            }
            if (VoucherOperationEnum.PREVIEW_VOUCHER.getOperationKey().equals(itemKey)) {
                this.doPreviewVoucher(itemKey, pkIdList, billNoList, billlist.getEntityId());
                return;
            }
            OperationResult result = OperationServiceHelper.executeOperate((String)itemKey, (String)billlist.getEntityId(), (Object[])pkIdList.toArray(), (OperateOption)OperateOption.create());
            if (!result.isSuccess()) {
                this.getView().showOperationResult(result);
                return;
            }
            if (VoucherOperationEnum.GENERATE_VOUCHER.getOperationKey().equals(itemKey)) {
                this.showVoucherView(result, billNoList, this.getView(), billlist.getEntityId());
            }
            if (VoucherOperationEnum.DELETE_VOUCHER.getOperationKey().equals(itemKey)) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u51ed\u8bc1\u6210\u529f\u3002", (String)"TilGenerateVoucherPlugin_1", (String)"taxc-til", (Object[])new Object[0]));
            }
        }
        billlist.refresh();
    }

    private BillList getBillList() {
        String billap = BILL_LIST;
        Tab tabap = (Tab)this.getControl(TAB_AP);
        if (null != tabap) {
            String currentTab = tabap.getCurrentTab();
            TioCheckCertEnum tioCheckCertEnum = TioCheckCertEnum.getEnumByPageAp(currentTab);
            billap = tioCheckCertEnum.getBillap();
        }
        return (BillList)this.getControl(billap);
    }

    private void doPreviewVoucher(String itemKey, List<Object> pkIdList, Set<Object> billIds, String entityNumber) {
        Set voucherids = DapVoucherUtil.getBuildVch(billIds, (String)entityNumber);
        if (voucherids != null && voucherids.size() != 0) {
            this.showTipVoucherForm(voucherids);
            return;
        }
        OperateOption create = OperateOption.create();
        create.setVariableValue("previewpageid", this.getView().getPageId());
        OperationResult result = OperationServiceHelper.executeOperate((String)itemKey, (String)entityNumber, (Object[])pkIdList.toArray(), (OperateOption)create);
        if (!result.isSuccess()) {
            this.getView().showOperationResult(result);
            return;
        }
        this.showPreVoucher(this.getView());
    }

    private void showTipVoucherForm(Set<Long> voucherids) {
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(VOUCHER_CALLBACK, (IFormPlugin)this);
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"TilGenerateVoucherPlugin_2", (String)"taxc-til", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u8ba4", (String)"TilGenerateVoucherPlugin_3", (String)"taxc-til", (Object[])new Object[0]));
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        String msg = ResManager.loadKDString((String)"\u51ed\u8bc1\u5df2\u751f\u6210\uff0c\u662f\u5426\u7ee7\u7eed\u8054\u67e5\u51ed\u8bc1?", (String)"TilGenerateVoucherPlugin_4", (String)"taxc-til", (Object[])new Object[0]);
        this.getView().showConfirm(msg, "", options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps, SerializationUtils.toJsonString(voucherids));
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        if (VOUCHER_CALLBACK.equals(messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
            Set voucherids = (Set)SerializationUtils.fromJsonString((String)messageBoxClosedEvent.getCustomVaule(), Set.class);
            this.traceVoucher(voucherids);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void traceVoucher(Set<Long> voucherids) {
        if (voucherids != null && voucherids.size() != 0) {
            if (voucherids.size() == 1) {
                long billId = voucherids.iterator().next();
                BillShowParameter showParameter = new BillShowParameter();
                showParameter.setPkId((Object)billId);
                showParameter.setFormId("gl_voucher");
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                long orgId = 0L;
                Throwable var9 = null;
                try (DataSet ds = QueryServiceHelper.queryDataSet((String)"TraceVoucher_queryvoucher", (String)"gl_voucher", (String)"org", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)billId)}, (String)null);){
                    try {
                        for (Row row : ds) {
                            orgId = row.getLong("org");
                        }
                    }
                    catch (Throwable var19) {
                        var9 = var19;
                        throw var19;
                    }
                }
                long userId = Long.parseLong(RequestContext.get().getUserId());
                int i = PermissionServiceHelper.checkPermission((long)userId, (String)"DIM_ORG", (long)orgId, (String)"83bfebc8000017ac", (String)"gl_voucher", (String)"4715a0df000000ac");
                if (i == 1) {
                    showParameter.setStatus(OperationStatus.EDIT);
                } else {
                    showParameter.setStatus(OperationStatus.VIEW);
                }
                this.getView().showForm((FormShowParameter)showParameter);
            } else {
                ListShowParameter showParameter = new ListShowParameter();
                showParameter.setBillFormId("gl_voucher");
                ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
                qFilters.add(new QFilter("id", "in", voucherids));
                showParameter.getListFilterParameter().setQFilters(qFilters);
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                showParameter.setShowFilter(false);
                showParameter.setShowQuickFilter(false);
                showParameter.getCustomParams().put("org", "");
                showParameter.getCustomParams().put("booktype", "");
                this.getView().showForm((FormShowParameter)showParameter);
            }
            return;
        }
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u6ca1\u6709\u5173\u8054\u7684\u51ed\u8bc1", (String)"TilGenerateVoucherPlugin_5", (String)"taxc-til", (Object[])new Object[0]));
    }

    private void showVoucherView(OperationResult opResult, Set<? extends Object> sourceId, IFormView view, String entityNumber) {
        if (sourceId != null) {
            ArrayList<QFilter> filterList = new ArrayList<QFilter>();
            filterList.add(new QFilter("sourcebillid", "in", sourceId));
            DapVoucherUtil.addBillTypeFilter((String)entityNumber, filterList);
            DynamicObject[] daptrackers = BusinessDataServiceHelper.load((String)"ai_daptracker", (String)"voucherid,booktype", (QFilter[])filterList.toArray(new QFilter[0]));
            if (daptrackers == null || daptrackers.length == 0) {
                String commonError = ResManager.loadKDString((String)"\u751f\u6210\u51ed\u8bc1\u5931\u8d25,\u6ca1\u6709\u5408\u9002\u7684\u51ed\u8bc1\u6a21\u677f\uff0c\u8bf7\u68c0\u67e5\u6a21\u677f\u9002\u7528\u6761\u4ef6\u7b49\u914d\u7f6e\uff0c\u6216\u67e5\u770b\u51ed\u8bc1\u751f\u6210\u62a5\u544a", (String)"TilGenerateVoucherPlugin_6", (String)"taxc-til", (Object[])new Object[0]);
                if (StringUtils.isNotBlank((CharSequence)opResult.getMessage())) {
                    commonError = opResult.getMessage();
                }
                view.showTipNotification(commonError);
                return;
            }
            Long booktype = 0L;
            DynamicObject[] var8 = daptrackers;
            int var9 = daptrackers.length;
            HashSet<Object> pks = new HashSet<Object>(var9);
            for (int var10 = 0; var10 < var9; ++var10) {
                DynamicObject tracker = var8[var10];
                pks.add(tracker.get("voucherid"));
                booktype = tracker.getLong("booktype.id");
            }
            if (pks.size() == 1) {
                BillShowParameter showParameter = new BillShowParameter();
                Long voucherID = daptrackers[0].getLong("voucherid");
                long count = (Long)DB.query((DBRoute)DBRoute.of((String)"gl"), (String)"select count(1) as c from t_gl_voucherentry where fid = ? ", (Object[])new Object[]{voucherID}, e -> e.next() ? e.getLong("c") : 0L);
                if (count > 10000L) {
                    String billno = (String)DB.query((DBRoute)DBRoute.of((String)"gl"), (String)"select fnumber as billno from t_gl_voucher where fid = ? ", (Object[])new Object[]{voucherID}, e -> e.next() ? e.getString("billno") : "");
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u751f\u6210\u51ed\u8bc1[%s]\u6210\u529f!", (String)"TilGenerateVoucherPlugin_7", (String)"taxc-til", (Object[])new Object[0]), billno));
                    return;
                }
                showParameter.setPkId((Object)voucherID);
                showParameter.setFormId("gl_voucher");
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                showParameter.setStatus(OperationStatus.EDIT);
                view.showForm((FormShowParameter)showParameter);
                opResult.setShowMessage(false);
            } else {
                ListShowParameter showParameter = new ListShowParameter();
                showParameter.setBillFormId("gl_voucher");
                ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
                if (booktype != 0L) {
                    showParameter.getCustomParams().put("booktype", booktype.toString());
                }
                qFilters.add(new QFilter("id", "in", pks));
                showParameter.getListFilterParameter().setQFilters(qFilters);
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                showParameter.setShowFilter(false);
                showParameter.setShowQuickFilter(false);
                DynamicObject vch = BusinessDataServiceHelper.loadSingle(pks.iterator().next(), (String)"gl_voucher", (String)"id,org,period.id,period.begindate,period.enddate");
                showParameter.getCustomParams().put("org", "");
                showParameter.getCustomParams().put("booktype", "");
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                DynamicObject period = vch.getDynamicObject("period");
                showParameter.setCustomParam("bookeddate", (Object)new Object[]{sdf.format(period.get("begindate")), sdf.format(period.get("enddate"))});
                view.showForm((FormShowParameter)showParameter);
                opResult.setShowMessage(false);
            }
        }
    }

    private void showPreVoucher(IFormView view) {
        IAppCache cache = AppCache.get((String)"gl");
        String string = (String)cache.get("accSys_" + view.getPageId() + "_perviewvoucher", String.class);
        if (StringUtils.isNotBlank((CharSequence)string)) {
            String tempId = (String)cache.get("accSys_" + view.getPageId() + "_tempId", String.class);
            FormShowParameter form = new FormShowParameter();
            form.setFormId("ai_previewvoucher");
            form.setCustomParam("voucher", (Object)string);
            form.setCustomParam("tempId", (Object)tempId);
            form.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            form.setStatus(OperationStatus.VIEW);
            view.showForm(form);
        }
        cache.remove("accSys_" + view.getPageId() + "_perviewvoucher");
    }
}

