/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.til.formplugin.tio;

import com.alibaba.fastjson.JSONArray;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import kd.bos.coderule.api.ICodeRuleService;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.SelectRowsEventListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgUtils;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.til.formplugin.tio.enums.InvoiceSignTypeEnum;
import kd.taxc.til.formplugin.utils.SbbQueryUtils;

public abstract class ExtendInvoiceSignDialogPlugin
extends AbstractFormPlugin
implements SelectRowsEventListener,
RowClickEventListener {
    private static Log logger = LogFactory.getLog(ExtendInvoiceSignDialogPlugin.class);
    private static final String BTN_OK = "btnok";

    public void initialize() {
        EntryGrid entryentity = (EntryGrid)this.getControl("entryentity");
        entryentity.addSelectRowsListener((SelectRowsEventListener)this);
        entryentity.addRowClickListener((RowClickEventListener)this);
    }

    public void entryRowClick(RowClickEvent evt) {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows == null || selectRows.length == 0) {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"sign3"});
            this.getModel().setValue("ruleradio", (Object)"1");
        } else if (selectRows == null || selectRows.length == 1) {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"sign3"});
        } else {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"sign3"});
            String radiogroup = (String)this.getModel().getValue("ruleradio");
            if ("3".equals(radiogroup)) {
                this.getModel().setValue("ruleradio", (Object)"1");
            }
        }
        this.setCanSignTaxAmount();
    }

    private void setRightFlexCount() {
        BigDecimal availtaxamount = this.getCanSignTaxAmount("availtaxamount");
        BigDecimal signedtaxamount = this.getCanSignTaxAmount("signedtaxamount");
        BigDecimal currentsigntaxamount = (BigDecimal)this.getModel().getValue("currentsigntaxamount");
        BigDecimal remain = availtaxamount.subtract(signedtaxamount).subtract(currentsigntaxamount);
        this.getModel().setValue("text1", (Object)availtaxamount);
        this.getModel().setValue("text2", (Object)signedtaxamount);
        this.getModel().setValue("text3", (Object)currentsigntaxamount);
        this.getModel().setValue("text4", (Object)remain);
    }

    private BigDecimal getCanSignTaxAmount(String column) {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        int[] selectRows = entryGrid.getSelectRows();
        BigDecimal result = BigDecimal.ZERO;
        for (int selectRow : selectRows) {
            DynamicObject row = entryGrid.getModel().getEntryRowEntity("entryentity", selectRow);
            result = result.add(row.getBigDecimal(column));
        }
        return result;
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTN_OK});
    }

    public void afterCreateNewData(EventObject e) {
        this.initQueryData();
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String name = args.getProperty().getName();
        if ("ruleradio".equals(name) || "signrate".equals(name)) {
            this.setCanSignTaxAmount();
        }
        if ("currentsigntaxamount".equals(name)) {
            this.vaildCurrentsigntaxamount(args);
            this.setRightFlexCount();
        }
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        if (BTN_OK.equals(control.getKey())) {
            EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
            int[] selectRows = entryGrid.getSelectRows();
            if (selectRows.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u9009\u4e2d\u53d1\u7968", (String)"ExtendInvoiceSignDialogPlugin_0", (String)"taxc-til", (Object[])new Object[0]));
                return;
            }
            String radiogroup = (String)this.getModel().getValue("ruleradio");
            BigDecimal signrate = (BigDecimal)this.getModel().getValue("signrate");
            if ("2".equals(radiogroup) && (signrate == null || signrate.compareTo(BigDecimal.ZERO) <= 0)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u767b\u8bb0\u6bd4\u4f8b", (String)"ExtendInvoiceSignDialogPlugin_1", (String)"taxc-til", (Object[])new Object[0]));
                return;
            }
            BigDecimal currentsigntaxamount = (BigDecimal)this.getModel().getValue("currentsigntaxamount");
            BigDecimal maxsigntaxamount = (BigDecimal)this.getModel().getValue("maxsigntaxamount");
            if ("3".equals(radiogroup) && (currentsigntaxamount.compareTo(BigDecimal.ZERO) <= 0 || currentsigntaxamount.compareTo(maxsigntaxamount) > 0)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672c\u6b21\u767b\u8bb0\u7a0e\u989d\u9700\u5927\u4e8e0\u4e14\u5c0f\u4e8e\u7b49\u4e8e\u672c\u6b21\u6700\u5927\u53ef\u767b\u8bb0\u7a0e\u989d", (String)"ExtendInvoiceSignDialogPlugin_2", (String)"taxc-til", (Object[])new Object[0]));
                return;
            }
            Date transferdate = (Date)this.getModel().getValue("transferdate");
            List entryentity = Arrays.stream(selectRows).boxed().map(index -> entryGrid.getModel().getEntryRowEntity("entryentity", index.intValue())).collect(Collectors.toList());
            boolean anyMatch = entryentity.stream().anyMatch(s -> SbbQueryUtils.existsSbb(s.getDynamicObject("taxorg").getLong("id"), transferdate));
            if (anyMatch) {
                int yearOfDate = DateUtils.getYearOfDate((Date)transferdate);
                int monthOfDate = DateUtils.getMonthOfDate((Date)transferdate);
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u7684\u201c\u8f6c\u51fa\u6240\u5c5e\u7a0e\u671f%1$s\u5e74%2$s\u6708\u201d\u5df2\u5b58\u5728\u7533\u62a5\u8bb0\u5f55\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"ExtendInvoiceSignDialogPlugin_3", (String)"taxc-til", (Object[])new Object[0]), yearOfDate, monthOfDate));
                return;
            }
            this.saveData();
            IFormView parentView = this.getView().getParentView();
            BillList billList = (BillList)parentView.getControl("billlistap");
            billList.refresh();
            this.getView().close();
        }
    }

    private void saveData() {
        String radiogroup = (String)this.getModel().getValue("ruleradio");
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        int[] selectRows = entryGrid.getSelectRows();
        List entryentity = Arrays.stream(selectRows).boxed().map(index -> entryGrid.getModel().getEntryRowEntity("entryentity", index.intValue())).collect(Collectors.toList());
        List filterLargeZeros = entryentity.stream().filter(s -> s.getBigDecimal("cansigntaxamount").compareTo(BigDecimal.ZERO) > 0).collect(Collectors.toList());
        filterLargeZeros.sort(Comparator.comparing(s -> s.getBigDecimal("cansigntaxamount")));
        BigDecimal sum = BigDecimal.ZERO;
        BiPredicate<List, DynamicObject> lastPredicate = (list, r) -> list.size() > 1 && ((DynamicObject)list.get(list.size() - 1)).equals(r);
        DynamicObjectCollection saveDatas = new DynamicObjectCollection();
        for (DynamicObject row : filterLargeZeros) {
            DynamicObject bill = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"til_in_transfer_out_bill"));
            bill.set("org", row.get("taxorg"));
            bill.set("billno", (Object)this.getNumber(bill));
            BigDecimal signamount = this.getSignamount(row, radiogroup, sum, lastPredicate.test(filterLargeZeros, row));
            bill.set("signamount", (Object)signamount);
            String signtype = (String)this.getModel().getValue("signtype");
            bill.set("signtype", (Object)signtype);
            String projecttype = this.getProjecttype(signtype);
            bill.set("projecttype", (Object)projecttype);
            bill.set("allocatestate", (Object)(signtype.equals("1") ? "1" : "2"));
            bill.set("transferdate", (Object)DateUtils.getFirstDateOfMonth((Date)((Date)this.getModel().getValue("transferdate"))));
            bill.set("datasource", (Object)"1");
            bill.set("billstatus", (Object)"C");
            bill.set("mark", this.getModel().getValue("mark"));
            bill.set("invoicecode", (Object)(this.hasColumn(row, "invoicecode") != false ? row.getString("invoicecode") : ""));
            bill.set("invoiceno", (Object)(this.hasColumn(row, "invoiceno") != false ? row.getString("invoiceno") : ""));
            bill.set("modifier", (Object)RequestContext.get().getUserId());
            bill.set("modifytime", (Object)new Date());
            bill.set("invoicetype", (Object)row.getDynamicObject("invoicetype"));
            bill.set("invoiceid", (Object)row.getLong("invoiceid"));
            bill.set("look", (Object)ResManager.loadKDString((String)"\u67e5\u770b", (String)"ExtendInvoiceSignDialogPlugin_4", (String)"taxc-til", (Object[])new Object[0]));
            bill.set("invoicesigntype", (Object)this.getInvoiceSignType().getType());
            bill.set("checkorg", row.get("org"));
            DynamicObjectCollection subTable = bill.getDynamicObjectCollection("entryentity");
            this.createSubTable(signamount, signtype, projecttype, subTable);
            sum = sum.add(signamount);
            saveDatas.add((Object)bill);
        }
        SaveServiceHelper.save((DynamicObject[])((DynamicObject[])saveDatas.toArray((Object[])new DynamicObject[0])));
    }

    public Boolean hasColumn(DynamicObject row, String column) {
        DataEntityPropertyCollection properties = row.getDataEntityType().getProperties();
        return properties.stream().anyMatch(s -> s.getName().equals(column));
    }

    private void createSubTable(BigDecimal signamount, String signtype, String projecttype, DynamicObjectCollection subTable) {
        BigDecimal amount;
        BigDecimal bigDecimal = amount = signtype.equals("1") ? signamount : BigDecimal.ZERO;
        if ("4".equals(projecttype)) {
            this.createRow(subTable, "\u2014\u2014", amount, 1);
            this.createRow(subTable, "\u2014\u2014", amount, 2);
        } else if ("3".equals(projecttype) || "2".equals(projecttype)) {
            this.createRow(subTable, "\u2014\u2014", amount, 1);
        } else {
            this.createRow(subTable, (String)this.getModel().getValue("type"), amount, 1);
        }
    }

    private void createRow(DynamicObjectCollection subTable, String type, BigDecimal amount, int seq) {
        DynamicObject row = subTable.addNew();
        row.set("type", (Object)type);
        row.set("amount", (Object)amount);
        row.set("seq", (Object)seq);
    }

    private String getNumber(DynamicObject bill) {
        ICodeRuleService codeRuleService = (ICodeRuleService)ServiceFactory.getService(ICodeRuleService.class);
        return codeRuleService.getNumber("til_in_transfer_out_bill", bill, null);
    }

    private BigDecimal getSignamount(DynamicObject row, String radiogroup, BigDecimal total, Boolean last) {
        BigDecimal result = BigDecimal.ZERO;
        if ("1".equals(radiogroup)) {
            result = row.getBigDecimal("cansigntaxamount");
        } else if ("2".equals(radiogroup)) {
            if (!last.booleanValue()) {
                BigDecimal signrate = (BigDecimal)this.getModel().getValue("signrate");
                result = row.getBigDecimal("cansigntaxamount").multiply(signrate).divide(new BigDecimal("100"), 2, 4);
            } else {
                result = ((BigDecimal)this.getModel().getValue("currentsigntaxamount")).subtract(total);
            }
        } else if ("3".equals(radiogroup)) {
            result = (BigDecimal)this.getModel().getValue("currentsigntaxamount");
        }
        return result;
    }

    private String getProjecttype(String signtype) {
        return "1".equals(signtype) ? "1" : (String)this.getModel().getValue("projecttype");
    }

    private void vaildCurrentsigntaxamount(PropertyChangedArgs args) {
        BigDecimal canSignTaxAmount;
        BigDecimal newValue = (BigDecimal)args.getChangeSet()[0].getNewValue();
        if (newValue.compareTo(canSignTaxAmount = this.getCanSignTaxAmount("cansigntaxamount")) > 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672c\u6b21\u767b\u8bb0\u7a0e\u989d\u4e0d\u80fd\u5927\u4e8e\u672c\u6b21\u6700\u5927\u53ef\u767b\u8bb0\u7a0e\u989d", (String)"ExtendInvoiceSignDialogPlugin_5", (String)"taxc-til", (Object[])new Object[0]));
            this.rollbackPropertyChange(args);
            return;
        }
    }

    private void setCanSignTaxAmount() {
        String radiogroup = (String)this.getModel().getValue("ruleradio");
        BigDecimal canSignTaxAmount = this.getCanSignTaxAmount("cansigntaxamount");
        if ("1".equals(radiogroup)) {
            this.getModel().setValue("currentsigntaxamount", (Object)canSignTaxAmount);
            this.getModel().setValue("maxsigntaxamount", (Object)canSignTaxAmount);
        } else if ("2".equals(radiogroup)) {
            BigDecimal signrate = (BigDecimal)this.getModel().getValue("signrate");
            this.getModel().setValue("currentsigntaxamount", (Object)canSignTaxAmount.multiply(signrate).divide(new BigDecimal("100"), 2, 4));
            this.getModel().setValue("maxsigntaxamount", (Object)canSignTaxAmount);
        } else if ("3".equals(radiogroup)) {
            this.getModel().setValue("currentsigntaxamount", (Object)canSignTaxAmount);
            this.getModel().setValue("maxsigntaxamount", (Object)canSignTaxAmount);
        }
        BigDecimal maxsigntaxamount = (BigDecimal)this.getModel().getValue("maxsigntaxamount");
        this.getView().setEnable(Boolean.valueOf(maxsigntaxamount.compareTo(BigDecimal.ZERO) > 0), new String[]{"currentsigntaxamount", "signtype", "type", "projecttype", "transferdate", "mark"});
        this.setRightFlexCount();
    }

    public String getGoodsName(DynamicObject dynamicObject, String entityName, String selectFields, String alias) {
        String goodsName = "";
        DynamicObjectCollection query = QueryServiceHelper.query((String)entityName, (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)dynamicObject.getLong("id"))});
        if (!CollectionUtils.isEmpty((Collection)query)) {
            goodsName = query.stream().filter(s -> s.getString(alias) != null).map(s -> s.getString(alias)).collect(Collectors.joining(","));
        }
        return goodsName;
    }

    public Map<String, String> getGoodsNameByIds(List<Long> ids, String entityName, String selectFields, String alias, Map<String, String> idGoodsName) {
        DynamicObjectCollection query = QueryServiceHelper.query((String)entityName, (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
        Map<String, List<DynamicObject>> listMap = query.stream().filter(s -> s.getString(alias) != null).collect(Collectors.groupingBy(a -> entityName + a.getString("id")));
        listMap.forEach((a, b) -> idGoodsName.put((String)a, b.stream().map(s -> s.getString(alias)).collect(Collectors.joining(","))));
        return idGoodsName;
    }

    public BigDecimal getSignedtaxamount(DynamicObject row, DynamicObjectCollection bills) {
        if (CollectionUtils.isEmpty((Collection)bills)) {
            return BigDecimal.ZERO;
        }
        BiPredicate<DynamicObject, DynamicObject> predicate = (r, b) -> b.getString("invoiceid").equals(r.getString("id"));
        List collect = bills.stream().filter(b -> predicate.test(row, (DynamicObject)b)).map(f -> f.getBigDecimal("signamount")).collect(Collectors.toList());
        return collect.stream().reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    public DynamicObjectCollection getBillByOrgId(Map<String, Object> customParams) {
        String mainorg = (String)customParams.get("mainorg");
        QFilter orgFilter = null;
        if ("tax_org".equals(mainorg)) {
            Object orgid = customParams.get("orgid");
            ArrayList orgIds = this.isNullOrEmpty(orgid) ? this.getDefaultOrgIds(this.getView().getParentView(), mainorg) : Lists.newArrayList((Object[])new Long[]{Long.parseLong(orgid.toString())});
            orgFilter = orgIds.isEmpty() ? new QFilter("org", "is not null", null) : new QFilter("org", "in", (Object)orgIds);
        } else if ("check_org".equals(mainorg)) {
            List<Object> checkorgIds = new ArrayList();
            Object checkorgid = customParams.get("checkorgid");
            if (checkorgid != null) {
                JSONArray jsonArray = (JSONArray)checkorgid;
                checkorgIds = jsonArray.stream().map(s -> Long.valueOf(s.toString())).collect(Collectors.toList());
            }
            checkorgIds = checkorgIds.isEmpty() ? this.getDefaultOrgIds(this.getView().getParentView(), mainorg) : checkorgIds;
            orgFilter = checkorgIds.isEmpty() ? new QFilter("checkorg", "is not null", null) : new QFilter("checkorg", "in", checkorgIds);
        }
        return QueryServiceHelper.query((String)"til_in_transfer_out_bill", (String)"org,signamount,invoicecode,invoiceno,invoiceid", (QFilter[])new QFilter[]{orgFilter});
    }

    public List<Long> getInvoiceTypeId(String ... number) {
        List<Long> result = new ArrayList<Long>();
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"bd_invoicetype", (String)"id,name,number", (QFilter[])new QFilter[]{new QFilter("number", "in", (Object)number)});
        if (dynamicObjects != null && dynamicObjects.length > 0) {
            result = Arrays.stream(dynamicObjects).map(s -> s.getLong("id")).collect(Collectors.toList());
        }
        return result;
    }

    private void rollbackPropertyChange(PropertyChangedArgs args) {
        String name = args.getProperty().getName();
        ChangeData[] changeSet = args.getChangeSet();
        int rowIndex = changeSet[0].getRowIndex();
        Object oldValue = changeSet[0].getOldValue();
        this.getModel().setValue(name, oldValue, rowIndex);
    }

    public List<Long> getDefaultOrgIds(IFormView view, String mainorg) {
        HasPermOrgResult hasPermOrgResult;
        List<Long> orgIds = new ArrayList<Long>();
        if ("tax_org".equals(mainorg)) {
            HasPermOrgResult hasPermOrgResult2 = PermissionUtils.getAllPermOrgs((IFormView)view);
            if (EmptyCheckUtils.isNotEmpty((Object)hasPermOrgResult2) && !hasPermOrgResult2.hasAllOrgPerm()) {
                List permOrgs = hasPermOrgResult2.getHasPermOrgs();
                DynamicObject[] taxOrg = BusinessDataServiceHelper.load((String)"bastax_taxorg", (String)"org", (QFilter[])new QFilter[]{new QFilter("org", "in", (Object)permOrgs)}, (String)"org desc");
                if (taxOrg.length > 0) {
                    orgIds = Arrays.stream(taxOrg).filter(s -> s.getDynamicObject("org") != null).map(s -> s.getDynamicObject("org").getLong("id")).collect(Collectors.toList());
                }
            } else {
                List orgList = OrgUtils.queryOrgListForInitOrgComboItems((IFormView)this.getView(), (String[])new String[]{"til_in_transfer_out_bill"}, null, null);
                orgIds = orgList.stream().map(s -> Long.valueOf((String)s.get("id"))).collect(Collectors.toList());
            }
        } else if ("check_org".equals(mainorg) && EmptyCheckUtils.isNotEmpty((Object)(hasPermOrgResult = PermissionUtils.getAllPermOrgs((IFormView)view))) && !hasPermOrgResult.hasAllOrgPerm()) {
            orgIds = OrgUnitServiceHelper.filterOrgDuty((List)hasPermOrgResult.getHasPermOrgs(), (String)"10");
        }
        return orgIds;
    }

    public boolean isNullOrEmpty(Object orgId) {
        return orgId == null || StringUtil.isEmpty((CharSequence)orgId.toString());
    }

    public abstract void initQueryData();

    public abstract QFilter[] buildQFilter();

    public abstract InvoiceSignTypeEnum getInvoiceSignType();
}

