/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.til.formplugin.tio;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.til.business.tio.InTransferOutAllocateService;

public class InTransferOutAllocatePlugin
extends AbstractFormPlugin {
    private static Log logger = LogFactory.getLog(InTransferOutAllocatePlugin.class);
    private static final String BTN_OK = "btnok";
    private static final Map<String, String> mapper = new HashMap<String, String>();

    public InTransferOutAllocatePlugin() {
        mapper.put("2", "3");
        mapper.put("5", "4,5");
    }

    public void initialize() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.addPackageDataListener(event -> this.packageData((PackageDataEvent)event));
    }

    public void packageData(PackageDataEvent e) {
        FieldEdit columnDesc = (FieldEdit)e.getSource();
        DynamicObject d = e.getRowData();
        if ("rate".equals(columnDesc.getKey())) {
            BigDecimal multiply = d.getBigDecimal("rate").multiply(new BigDecimal("100")).setScale(2, 4);
            e.setFormatValue((Object)(multiply.toString() + "%"));
        }
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTN_OK});
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        if (BTN_OK.equals(control.getKey())) {
            DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
            Predicate<BigDecimal> decimalPredicate = a -> a.compareTo(BigDecimal.ZERO) <= 0;
            List pjSeqs = entryentity.stream().filter(s -> decimalPredicate.test(s.getBigDecimal("projectamount"))).map(s -> s.getString("seq")).collect(Collectors.toList());
            if (pjSeqs.size() > 0) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u9879\u76ee\u6536\u5165\u5e94\u8be5\u5927\u4e8e0\uff0c\u8bf7\u4fee\u6539\u6570\u636e", (String)"InTransferOutAllocatePlugin_2", (String)"taxc-til", (Object[])new Object[0]), pjSeqs.stream().collect(Collectors.joining(","))));
                return;
            }
            List sumIncomeSeqs = entryentity.stream().filter(s -> decimalPredicate.test(s.getBigDecimal("sumincome"))).map(s -> s.getString("seq")).collect(Collectors.toList());
            if (sumIncomeSeqs.size() > 0) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u6536\u5165\u603b\u989d\u5e94\u8be5\u5927\u4e8e0\uff0c\u8bf7\u4fee\u6539\u6570\u636e", (String)"InTransferOutAllocatePlugin_1", (String)"taxc-til", (Object[])new Object[0]), sumIncomeSeqs.stream().collect(Collectors.joining(","))));
                return;
            }
            Map<String, List<DynamicObject>> billno = entryentity.stream().collect(Collectors.groupingBy(s -> s.getString("mainid")));
            DynamicObjectCollection saveDatas = new DynamicObjectCollection();
            HashMap<String, List<DynamicObject>> map = new HashMap<String, List<DynamicObject>>(16);
            for (Map.Entry<String, List<DynamicObject>> entry : billno.entrySet()) {
                String key = entry.getKey();
                List<DynamicObject> value = entry.getValue();
                map.put(key, value);
            }
            DynamicObject[] dynamicObjectAry = BusinessDataServiceHelper.load((Object[])map.keySet().toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"til_in_transfer_out_bill"));
            if (dynamicObjectAry != null) {
                for (DynamicObject dynamicObject : dynamicObjectAry) {
                    dynamicObject.set("allocatestate", (Object)"3");
                    DynamicObjectCollection entryentity1 = dynamicObject.getDynamicObjectCollection("entryentity");
                    for (DynamicObject object : entryentity1) {
                        DynamicObject filterObj = ((List)map.get(dynamicObject.getPkValue().toString())).stream().filter(s -> s.getLong("entityid") == object.getLong("id")).findFirst().get();
                        object.set("projectamount", (Object)filterObj.getBigDecimal("projectamount"));
                        object.set("sumincome", (Object)filterObj.getBigDecimal("sumincome"));
                        object.set("amount", (Object)filterObj.getBigDecimal("allocateamount"));
                        object.set("type", (Object)filterObj.getString("type"));
                    }
                    saveDatas.add((Object)dynamicObject);
                }
            }
            this.getView().close();
            SaveServiceHelper.save((DynamicObject[])((DynamicObject[])saveDatas.toArray((Object[])new DynamicObject[0])));
            BillList billList = (BillList)this.getView().getParentView().getControl("billlistap");
            billList.refreshData();
            this.getView().sendFormAction(this.getView().getParentView());
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        if ("projectamount".equals(name) || "sumincome".equals(name)) {
            this.setRateValue(e);
            this.setAllocateamount(rowIndex);
        }
        this.getView().updateView("entryentity");
        this.getView().sendFormAction(this.getView());
    }

    private void setRateValue(PropertyChangedArgs e) {
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        BigDecimal projectamount = (BigDecimal)this.getModel().getValue("projectamount", rowIndex);
        BigDecimal sumincome = (BigDecimal)this.getModel().getValue("sumincome", rowIndex);
        if (sumincome.compareTo(BigDecimal.ZERO) == 0) {
            this.getModel().setValue("rate", (Object)BigDecimal.ZERO, rowIndex);
            return;
        }
        BigDecimal rate = projectamount.divide(sumincome, 4, 4);
        if (rate.compareTo(BigDecimal.ONE) > 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5206\u644a\u7a0e\u989d\u5e94\u5c0f\u4e8e\u7b49\u4e8e\u672c\u6b21\u767b\u8bb0\u7a0e\u989d\uff0c\u8bf7\u4fee\u6539\u6570\u636e", (String)"InTransferOutAllocatePlugin_0", (String)"taxc-til", (Object[])new Object[0]));
            this.rollbackPropertyChange(e);
            return;
        }
        this.getModel().setValue("rate", (Object)rate, rowIndex);
    }

    private void setAllocateamount(int rowIndex) {
        BigDecimal signtaxamount = (BigDecimal)this.getModel().getValue("signtaxamount", rowIndex);
        BigDecimal rate = (BigDecimal)this.getModel().getValue("rate", rowIndex);
        BigDecimal allocateamount = signtaxamount.multiply(rate);
        this.getModel().setValue("allocateamount", (Object)allocateamount, rowIndex);
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String type = (String)customParams.get("type");
        List pkids = (List)customParams.get("pkids");
        String selectFields = "id,org,checkorg,billno,datasource,transferdate,signamount,signtype,projecttype,entryentity.id as entityid ,entryentity.seq as seq ,entryentity.type as type,entryentity.amount as amount, entryentity.projectamount as projectamount,entryentity.sumincome as sumincome";
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"til_in_transfer_out_bill", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)pkids)});
        if (dynamicObjects.size() == 0) {
            return;
        }
        IDataModel model = this.getModel();
        model.beginInit();
        model.deleteEntryData("entryentity");
        model.batchCreateNewEntryRow("entryentity", dynamicObjects.size());
        int index = 0;
        for (DynamicObject dynamicObject : dynamicObjects) {
            this.getModel().setValue("mainid", dynamicObject.get("id"), index);
            this.getModel().setValue("org", dynamicObject.get("org"), index);
            this.getModel().setValue("checkorg", dynamicObject.get("checkorg"), index);
            this.getModel().setValue("billno", (Object)dynamicObject.getString("billno"), index);
            this.getModel().setValue("datasource", (Object)dynamicObject.getString("datasource"), index);
            this.getModel().setValue("transferdate", (Object)dynamicObject.getDate("transferdate"), index);
            this.getModel().setValue("signtaxamount", (Object)dynamicObject.getBigDecimal("signamount"), index);
            this.getModel().setValue("signtype", (Object)dynamicObject.getString("signtype"), index);
            this.getModel().setValue("projecttype", (Object)dynamicObject.getString("projecttype"), index);
            this.getModel().setValue("entityid", (Object)dynamicObject.getLong("entityid"), index);
            if (type.equals("look")) {
                this.getModel().setValue("type", (Object)dynamicObject.getString("type"), index);
                this.getModel().setValue("projectamount", (Object)dynamicObject.getBigDecimal("projectamount"), index);
                this.getModel().setValue("sumincome", (Object)dynamicObject.getBigDecimal("sumincome"), index);
                BigDecimal rate = this.getRate(dynamicObject.getBigDecimal("projectamount"), dynamicObject.getBigDecimal("sumincome"));
                this.getModel().setValue("rate", (Object)rate, index);
                this.getModel().setValue("allocateamount", (Object)dynamicObject.getBigDecimal("amount"), index);
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"entryentity"});
            } else if (type.equals("edit")) {
                DynamicObjectCollection incomeSummary = InTransferOutAllocateService.getIncomeSummary(dynamicObject);
                String jxType = this.getType(dynamicObject);
                this.getModel().setValue("type", (Object)jxType, index);
                BigDecimal projectamount = incomeSummary.stream().filter(s -> this.getMapItems(jxType).contains(s.getString("taxmethodtype"))).map(s -> s.getBigDecimal("taxamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
                this.getModel().setValue("projectamount", (Object)projectamount, index);
                BigDecimal sumincome = incomeSummary.stream().map(s -> s.getBigDecimal("taxamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
                this.getModel().setValue("sumincome", (Object)sumincome, index);
                BigDecimal rate = this.getRate(projectamount, sumincome);
                this.getModel().setValue("rate", (Object)rate, index);
                this.getModel().setValue("allocateamount", (Object)dynamicObject.getBigDecimal("signamount").multiply(rate), index);
            }
            ++index;
        }
        model.endInit();
        this.getView().updateView("entryentity");
    }

    private String getType(DynamicObject dynamicObject) {
        String projecttype = dynamicObject.getString("projecttype");
        if ("4".equals(projecttype)) {
            return this.getRowType(dynamicObject.getInt("seq"));
        }
        if ("3".equals(projecttype)) {
            return "5";
        }
        if ("2".equals(projecttype)) {
            return "2";
        }
        return dynamicObject.getString("type");
    }

    private String getRowType(int seq) {
        HashMap<Integer, String> rowMap = new HashMap<Integer, String>();
        rowMap.put(1, "2");
        rowMap.put(2, "5");
        return (String)rowMap.get(seq);
    }

    private BigDecimal getRate(BigDecimal projectamount, BigDecimal sumincome) {
        if (sumincome.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        return projectamount.divide(sumincome, 4, 4);
    }

    private List getMapItems(String type) {
        String list = mapper.get(type);
        if (StringUtil.isBlank((CharSequence)list)) {
            return Lists.newArrayList();
        }
        return Arrays.stream(mapper.get(type).split(",")).collect(Collectors.toList());
    }

    private void rollbackPropertyChange(PropertyChangedArgs args) {
        String name = args.getProperty().getName();
        ChangeData[] changeSet = args.getChangeSet();
        int rowIndex = changeSet[0].getRowIndex();
        Object oldValue = changeSet[0].getOldValue();
        this.getModel().setValue(name, oldValue, rowIndex);
    }
}

