/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.til.formplugin.tio;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.coderule.api.ICodeRuleService;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.plugin.IImportPlugin;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import kd.taxc.til.formplugin.tio.enums.InvoiceSignTypeEnum;

public class InTransferOutImportPlugin
implements IImportPlugin {
    private static final String RIM_INV_ORDINARY = "rim_inv_ordinary";
    private static final String RIM_INV_SPECIAL = "rim_inv_special";
    private static final String TIL_IN_TRANSFER_OUT_BILL = "til_in_transfer_out_bill";
    private String invoiceType = null;
    private String currentInvoice = null;
    private HashMap<Object, BigDecimal> sumAmount = new HashMap();

    public boolean beforeImportData(Map<String, Object> data, Map<String, Object> option, List<ImportLogger.ImportLog> importlogs) {
        if (this.validateMustInput(data, importlogs)) {
            return false;
        }
        this.validateInvTypeName(data, importlogs);
        if (!importlogs.isEmpty()) {
            return false;
        }
        DynamicObjectCollection query = QueryServiceHelper.query((String)this.currentInvoice, (String)"id,tax_org,tax_org.number,org,org.number", (QFilter[])new QFilter[]{new QFilter("invoice_code", "=", data.get("invoicecode")), new QFilter("invoice_no", "=", data.get("invoiceno"))});
        HashMap<String, Object> taxorg = new HashMap<String, Object>();
        taxorg.put("importprop", "number");
        taxorg.put("number", ((DynamicObject)query.get(0)).get("tax_org.number"));
        data.put("org", taxorg);
        HashMap<String, Object> org = new HashMap<String, Object>();
        org.put("importprop", "number");
        org.put("number", ((DynamicObject)query.get(0)).get("org.number"));
        data.put("checkorg", org);
        DynamicObject bill = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)TIL_IN_TRANSFER_OUT_BILL));
        data.put("billno", this.getNumber(bill));
        Object amount = ((JSONObject)((JSONArray)data.get("entryentity")).get(0)).get((Object)"amount");
        data.put("signamount", amount);
        data.put("signtype", "1");
        data.put("projecttype", "1");
        data.put("allocatestate", "1");
        data.put("datasource", "3");
        data.put("invoiceid", ((DynamicObject)query.get(0)).get("id"));
        data.put("look", ResManager.loadKDString((String)"\u67e5\u770b", (String)"InTransferOutImportPlugin_0", (String)"taxc-til", (Object[])new Object[0]));
        if (RIM_INV_ORDINARY.equals(this.currentInvoice)) {
            data.put("invoicesigntype", (Object)InvoiceSignTypeEnum.einvoicesign);
        } else if (RIM_INV_SPECIAL.equals(this.currentInvoice)) {
            data.put("invoicesigntype", (Object)InvoiceSignTypeEnum.invoicesign);
        }
        data.put("isvoucher", "false");
        HashMap<String, Object> modifier = new HashMap<String, Object>();
        modifier.put("importprop", "id");
        modifier.put("id", RequestContext.get().getCurrUserId());
        data.put("modifier", modifier);
        return super.beforeImportData(data, option, importlogs);
    }

    private String getNumber(DynamicObject bill) {
        ICodeRuleService codeRuleService = (ICodeRuleService)ServiceFactory.getService(ICodeRuleService.class);
        return codeRuleService.getNumber(TIL_IN_TRANSFER_OUT_BILL, bill, null);
    }

    private boolean validateMustInput(Map<String, Object> data, List<ImportLogger.ImportLog> importlogs) {
        if (null == data.get("invoicecode")) {
            importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u3010\u53d1\u7968\u4ee3\u7801\u3011\u5b57\u6bb5\u5c1a\u672a\u5f55\u5165", (String)"InTransferOutImportPlugin_1", (String)"taxc-til", (Object[])new Object[0])));
        }
        if (null == data.get("invoiceno")) {
            importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u3010\u53d1\u7968\u53f7\u7801\u3011\u5b57\u6bb5\u5c1a\u672a\u5f55\u5165", (String)"InTransferOutImportPlugin_2", (String)"taxc-til", (Object[])new Object[0])));
        }
        if (null == data.get("invoicetype")) {
            importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u3010\u53d1\u7968\u7c7b\u578b\u3011\u5b57\u6bb5\u5c1a\u672a\u5f55\u5165", (String)"InTransferOutImportPlugin_3", (String)"taxc-til", (Object[])new Object[0])));
        }
        if (null == data.get("transferdate")) {
            importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u3010\u8f6c\u51fa\u6240\u5c5e\u7a0e\u671f\u3011\u5b57\u6bb5\u5c1a\u672a\u5f55\u5165", (String)"InTransferOutImportPlugin_4", (String)"taxc-til", (Object[])new Object[0])));
        }
        Object type = ((JSONObject)((JSONArray)data.get("entryentity")).get(0)).get((Object)"type");
        Object amount = ((JSONObject)((JSONArray)data.get("entryentity")).get(0)).get((Object)"amount");
        if (null == type) {
            importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u3010\u8fdb\u9879\u8f6c\u51fa\u7c7b\u578b\u3011\u5b57\u6bb5\u5c1a\u672a\u5f55\u5165", (String)"InTransferOutImportPlugin_5", (String)"taxc-til", (Object[])new Object[0])));
        }
        if (null == amount) {
            importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u3010\u8fdb\u9879\u8f6c\u51fa\u7a0e\u989d\u3011\u5b57\u6bb5\u5c1a\u672a\u5f55\u5165", (String)"InTransferOutImportPlugin_6", (String)"taxc-til", (Object[])new Object[0])));
        }
        return !importlogs.isEmpty();
    }

    private void validateInvTypeName(Map<String, Object> data, List<ImportLogger.ImportLog> importlogs) {
        String name = String.valueOf(((Map)data.get("invoicetype")).get("name"));
        this.invoiceType = null;
        if (ResManager.loadKDString((String)"\u589e\u503c\u7a0e\u7535\u5b50\u666e\u901a\u53d1\u7968", (String)"InTransferOutImportPlugin_7", (String)"taxc-til", (Object[])new Object[0]).equals(name)) {
            this.invoiceType = "1";
        } else if (ResManager.loadKDString((String)"\u589e\u503c\u7a0e\u7535\u5b50\u4e13\u7528\u53d1\u7968", (String)"InTransferOutImportPlugin_8", (String)"taxc-til", (Object[])new Object[0]).equals(name)) {
            this.invoiceType = "2";
        } else if (ResManager.loadKDString((String)"\u7eb8\u8d28\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968", (String)"InTransferOutImportPlugin_9", (String)"taxc-til", (Object[])new Object[0]).equals(name)) {
            this.invoiceType = "4";
            HashMap<String, String> invoiceTypeMap = new HashMap<String, String>();
            invoiceTypeMap.put("importprop", "name");
            invoiceTypeMap.put("name", ResManager.loadKDString((String)"\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968", (String)"InTransferOutImportPlugin_10", (String)"taxc-til", (Object[])new Object[0]));
            data.put("invoicetype", invoiceTypeMap);
        }
        if (null == this.invoiceType || this.invoiceType.isEmpty()) {
            importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u3010\u53d1\u7968\u7c7b\u578b\u3011\u586b\u5199\u9519\u8bef", (String)"InTransferOutImportPlugin_14", (String)"taxc-til", (Object[])new Object[0])));
        } else {
            this.validateInvCodeNo(data, importlogs);
        }
    }

    private void validateInvCodeNo(Map<String, Object> data, List<ImportLogger.ImportLog> importlogs) {
        if ("1".equals(this.invoiceType)) {
            this.currentInvoice = RIM_INV_ORDINARY;
        } else if ("2".equals(this.invoiceType) || "4".equals(this.invoiceType)) {
            this.currentInvoice = RIM_INV_SPECIAL;
        }
        DynamicObjectCollection query = QueryServiceHelper.query((String)this.currentInvoice, (String)"id,invoice_code,invoice_no", (QFilter[])new QFilter[]{new QFilter("invoice_code", "=", data.get("invoicecode")), new QFilter("invoice_no", "=", data.get("invoiceno"))});
        if (query.isEmpty()) {
            importlogs.add(new ImportLogger.ImportLog(String.format(ResManager.loadKDString((String)"\u8fdb\u9879\u5168\u7968\u6c60\u4e0d\u5b58\u5728\u53d1\u7968\u4ee3\u7801\u4e3a%1$s\uff0c\u53d1\u7968\u53f7\u7801\u4e3a%2$s\u7684\u53d1\u7968\uff0c\u8bf7\u67e5\u770b\u5e76\u91cd\u8bd5", (String)"InTransferOutImportPlugin_11", (String)"taxc-til", (Object[])new Object[0]), data.get("invoicecode"), data.get("invoiceno"))));
        } else {
            this.validateAmount(data, importlogs);
        }
    }

    private void validateAmount(Map<String, Object> data, List<ImportLogger.ImportLog> importlogs) {
        DynamicObjectCollection query = QueryServiceHelper.query((String)this.currentInvoice, (String)"effective_tax_amount", (QFilter[])new QFilter[]{new QFilter("invoice_code", "=", data.get("invoicecode")), new QFilter("invoice_no", "=", data.get("invoiceno"))});
        BigDecimal effectiveAmount = ((DynamicObject)query.get(0)).getBigDecimal("effective_tax_amount");
        String codeAndNo = data.get("invoicecode") + "-" + data.get("invoiceno");
        if (null == this.sumAmount.get(codeAndNo)) {
            DynamicObjectCollection recordAmount = QueryServiceHelper.query((String)TIL_IN_TRANSFER_OUT_BILL, (String)"entryentity.amount", (QFilter[])new QFilter[]{new QFilter("invoicecode", "=", data.get("invoicecode")), new QFilter("invoiceno", "=", data.get("invoiceno"))});
            BigDecimal tempAmount = BigDecimalUtil.toBigDecimal((Object)"0");
            for (DynamicObject dynamicObject : recordAmount) {
                tempAmount = BigDecimalUtil.addObject((Object)tempAmount, (Object)dynamicObject.getBigDecimal("entryentity.amount"));
            }
            this.sumAmount.put(codeAndNo, tempAmount);
        }
        BigDecimal oneAmount = BigDecimalUtil.toBigDecimal((Object)((JSONObject)((JSONArray)data.get("entryentity")).get(0)).get((Object)"amount"));
        if (BigDecimalUtil.toBigDecimal((Object)"0").compareTo(oneAmount) > 0) {
            importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u8fdb\u9879\u8f6c\u51fa\u7a0e\u989d\u4e0d\u5f97\u5c0f\u4e8e\u96f6", (String)"InTransferOutImportPlugin_12", (String)"taxc-til", (Object[])new Object[0])));
            return;
        }
        BigDecimal currentAmount = BigDecimalUtil.addObject((Object)oneAmount, (Object)this.sumAmount.get(codeAndNo));
        if (currentAmount.compareTo(effectiveAmount) > 0) {
            importlogs.add(new ImportLogger.ImportLog(String.format(ResManager.loadKDString((String)"\u53d1\u7968\u4ee3\u7801\u4e3a%1$s\uff0c\u53d1\u7968\u53f7\u7801\u4e3a%2$s\u7684\u53d1\u7968\uff0c\u8fdb\u9879\u8f6c\u51fa\u7a0e\u989d\u4e0d\u5f97\u5927\u4e8e\u53ef\u62b5\u6263\u7a0e\u989d", (String)"InTransferOutImportPlugin_13", (String)"taxc-til", (Object[])new Object[0]), data.get("invoicecode"), data.get("invoiceno"))));
        } else {
            this.sumAmount.put(codeAndNo, currentAmount);
        }
    }
}

