/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.til.formplugin.tio;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.filter.ControlFilter;
import kd.bos.entity.filter.ControlFilters;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgCheckUtil;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.tctb.common.util.TreeUtils;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.OperatorDialogUtils;
import kd.taxc.bdtaxr.common.util.showpage.PageShowCommon;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.til.formplugin.tio.enums.InvoiceSignTypeEnum;
import kd.taxc.til.formplugin.utils.DataFormat;
import kd.taxc.til.formplugin.utils.SbbQueryUtils;

public class InTransferOutListPlugin
extends AbstractListPlugin {
    private static final String TIL_IN_TRANSFER_OUT_BILL = "til_in_transfer_out_bill";
    private static Log LOGGER = LogFactory.getLog(InTransferOutListPlugin.class);
    private static String DEFAULT_ORG = "tax_org";
    private static String CHECK_ORG = "check_org";

    public void initialize() {
        BillList billList = (BillList)this.getControl("billlistap");
        billList.addSetFilterListener(this::setFilter);
        billList.addPackageDataListener(this::packageData);
    }

    public void packageData(PackageDataEvent e) {
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)e.getSource();
        DynamicObject d = e.getRowData();
        if (columnDesc.getKey().equals("amount")) {
            if ("1".equals(d.getString("allocatestate"))) {
                BigDecimal amount = d.getBigDecimal("entryentity.amount");
                e.setNoLinkKey(Collections.singletonList("amount"));
                e.setFormatValue((Object)DataFormat.formatMicrometer(amount.toString()));
            } else if ("2".equals(d.getString("allocatestate"))) {
                e.setNoLinkKey(Collections.singletonList("amount"));
                e.setFormatValue((Object)"\u2014\u2014");
            }
        } else if (columnDesc.getKey().equals("invoiceno")) {
            if ("2".equals(d.getString("datasource"))) {
                e.setNoLinkKey(Collections.singletonList("invoiceno"));
                e.setFormatValue((Object)"\u2014\u2014");
            }
        } else if (columnDesc.getKey().equals("invoicecode") && "2".equals(d.getString("datasource"))) {
            e.setNoLinkKey(Collections.singletonList("invoicecode"));
            e.setFormatValue((Object)"\u2014\u2014");
        }
    }

    public void registerListener(EventObject e) {
    }

    public void destory() {
        super.destory();
    }

    public void itemClick(ItemClickEvent evt) {
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String itemKey = afterDoOperationEventArgs.getOperateKey();
        if (InvoiceSignTypeEnum.exists(itemKey).booleanValue()) {
            this.sign(itemKey);
        } else if ("unsign".equalsIgnoreCase(itemKey)) {
            this.unsign(itemKey);
        } else if ("allocate".equalsIgnoreCase(itemKey)) {
            this.allocate();
        } else if ("unallocate".equalsIgnoreCase(itemKey)) {
            this.unallocate(itemKey);
        } else if ("refresh".equalsIgnoreCase(itemKey)) {
            this.refreshData();
        } else {
            return;
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String customVaule;
        if ("unsign".equals(messageBoxClosedEvent.getCallBackId())) {
            if (messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
                InTransferOutListPlugin.confirmTips("unsignReconfirm", "", this.getView(), (IFormPlugin)this);
            }
        } else if ("unsignReconfirm".equals(messageBoxClosedEvent.getCallBackId())) {
            if (messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
                String string = messageBoxClosedEvent.getResultValue();
            }
        } else if ("allocateConfirm".equals(messageBoxClosedEvent.getCallBackId())) {
            if (messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
                BillList billList = (BillList)this.getControl("billlistap");
                ListSelectedRowCollection listSelectedRows = billList.getSelectedRows();
                if (EmptyCheckUtils.isEmpty((Object)listSelectedRows) || listSelectedRows.size() == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u9009\u4e2d\u8bb0\u5f55", (String)"InTransferOutListPlugin_0", (String)"taxc-til", (Object[])new Object[0]));
                    return;
                }
                Object[] pkids = listSelectedRows.getPrimaryKeyValues();
                this.openAllocateForm("edit", pkids);
            }
        } else if ("unallocate".equals(messageBoxClosedEvent.getCallBackId())) {
            if (messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
                this.cancelAllocate();
                this.refreshData();
            }
        } else if ("unallocateReconfirm".equals(messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes) && "reReconfirm".equals(customVaule = messageBoxClosedEvent.getCustomVaule())) {
            InTransferOutListPlugin.confirmTips("unallocate", "", this.getView(), (IFormPlugin)this);
        }
    }

    public void setFilter(SetFilterEvent e) {
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        ListSelectedRow currentRow = ((BillListHyperLinkClickEvent)args.getHyperLinkClickEvent()).getCurrentRow();
        Object primaryKeyValue = currentRow.getPrimaryKeyValue();
        if (args.getFieldName().equals("look")) {
            this.OpenDetailForm(primaryKeyValue);
        }
        if (args.getFieldName().equals("amount")) {
            this.openAllocateForm("look", new Object[]{primaryKeyValue});
        }
    }

    private void allocate() {
        Collection values;
        boolean allocatestate;
        HashMap<String, String> errors = new HashMap<String, String>();
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection listSelectedRows = billList.getSelectedRows();
        if (EmptyCheckUtils.isEmpty((Object)listSelectedRows) || listSelectedRows.size() == 0) {
            return;
        }
        Object[] pkids = listSelectedRows.getPrimaryKeyValues();
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)TIL_IN_TRANSFER_OUT_BILL, (String)" org,transferdate,allocatestate ", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)pkids)});
        boolean exists = Arrays.stream(dynamicObjects).anyMatch(s -> SbbQueryUtils.existsSbb(((DynamicObject)s.get("org")).getLong("id"), s.getDate("transferdate")));
        if (exists) {
            errors.put("1", ResManager.loadKDString((String)"\u5df2\u7533\u62a5\u7684\u5c5e\u671f\u4e0d\u652f\u6301\u767b\u8bb0\u7a0e\u989d\u5206\u644a\u8ba1\u7b97\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"InTransferOutListPlugin_1", (String)"taxc-til", (Object[])new Object[0]));
        }
        if (allocatestate = Arrays.stream(dynamicObjects).anyMatch(s -> s.getString("allocatestate").equals("1"))) {
            errors.put("2", ResManager.loadKDString((String)"\u76f4\u63a5\u767b\u8bb0\u8f6c\u51fa\u7684\u6570\u636e\u4e0d\u9700\u8981\u8fdb\u884c\u7a0e\u989d\u5206\u644a\u8ba1\u7b97\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"InTransferOutListPlugin_2", (String)"taxc-til", (Object[])new Object[0]));
        }
        if (!CollectionUtils.isEmpty(values = errors.values())) {
            values.stream().forEach(s -> this.getView().showErrorNotification(s));
            return;
        }
        boolean hasAllocated = Arrays.stream(dynamicObjects).anyMatch(s -> s.getString("allocatestate").equals("3"));
        if (hasAllocated) {
            InTransferOutListPlugin.confirmTips("allocateConfirm", "", this.getView(), (IFormPlugin)this);
        } else {
            this.openAllocateForm("edit", pkids);
        }
    }

    private void unallocate(String itemKey) {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection listSelectedRows = billList.getSelectedRows();
        if (EmptyCheckUtils.isEmpty((Object)listSelectedRows) || listSelectedRows.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u9009\u4e2d\u8bb0\u5f55", (String)"InTransferOutListPlugin_0", (String)"taxc-til", (Object[])new Object[0]));
            return;
        }
        Object[] pkids = listSelectedRows.getPrimaryKeyValues();
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)TIL_IN_TRANSFER_OUT_BILL, (String)" org,transferdate,allocatestate ", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)pkids)});
        boolean exists = Arrays.stream(dynamicObjects).anyMatch(s -> SbbQueryUtils.existsSbb(((DynamicObject)s.get("org")).getLong("id"), s.getDate("transferdate")));
        if (exists) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5df2\u9009\u6570\u636e\u5f53\u4e2d\u5305\u542b\u4e86\u5df2\u5b8c\u6210\u589e\u503c\u7a0e\u7533\u62a5\u7684\u6570\u636e\uff0c\u5df2\u7533\u62a5\u589e\u503c\u7a0e\u7684\u6570\u636e\u4e0d\u5141\u8bb8\u64cd\u4f5c\u53d6\u6d88\u5206\u644a\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e", (String)"InTransferOutListPlugin_3", (String)"taxc-til", (Object[])new Object[0]));
            return;
        }
        boolean hasAllocated = Arrays.stream(dynamicObjects).allMatch(s -> s.getString("allocatestate").equals("3"));
        boolean hasLessOne = Arrays.stream(dynamicObjects).anyMatch(s -> s.getString("allocatestate").equals("3"));
        if (hasAllocated) {
            InTransferOutListPlugin.confirmTips(itemKey, "", this.getView(), (IFormPlugin)this);
        } else if (hasLessOne) {
            InTransferOutListPlugin.confirmTips("unallocateReconfirm", "reReconfirm", this.getView(), (IFormPlugin)this);
        } else {
            InTransferOutListPlugin.confirmTips("unallocateReconfirm", "", this.getView(), (IFormPlugin)this);
        }
    }

    private void refreshData() {
        BillList billList = (BillList)this.getControl("billlistap");
        billList.clearSelection();
        billList.refresh();
    }

    private void unsign(String itemKey) {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection listSelectedRows = billList.getSelectedRows();
        if (EmptyCheckUtils.isEmpty((Object)listSelectedRows) || listSelectedRows.size() == 0) {
            return;
        }
        Object[] pkids = listSelectedRows.getPrimaryKeyValues();
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)TIL_IN_TRANSFER_OUT_BILL, (String)" org,billno,transferdate,allocatestate ", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)pkids)});
        Boolean canCancel = this.canCancel(dynamicObjects);
        if (canCancel.booleanValue()) {
            List billno = Arrays.stream(dynamicObjects).map(s -> s.getString("billno")).collect(Collectors.toList());
            String operateName = ResManager.loadKDString((String)"\u53d6\u6d88\u767b\u8bb0", (String)"InTransferOutListPlugin_4", (String)"taxc-til", (Object[])new Object[0]);
            String operateDescription = String.format(String.format(ResManager.loadKDString((String)"\u7f16\u53f7%s,\u53d6\u6d88\u767b\u8bb0\u6210\u529f", (String)"InTransferOutListPlugin_5", (String)"taxc-til", (Object[])new Object[0]), billno.toString().substring(1, billno.toString().length() - 1)), new Object[0]);
            OperatorDialogUtils.operateDialog((String)"zzs", (String)TIL_IN_TRANSFER_OUT_BILL, (String)operateName, (String)operateDescription);
            DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)TIL_IN_TRANSFER_OUT_BILL), (Object[])pkids);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u767b\u8bb0\u6210\u529f", (String)"InTransferOutListPlugin_6", (String)"taxc-til", (Object[])new Object[0]));
            this.refreshData();
        } else {
            InTransferOutListPlugin.confirmTips(itemKey, "", this.getView(), (IFormPlugin)this);
        }
    }

    private Boolean canCancel(DynamicObject[] dynamicObjects) {
        Boolean result;
        boolean exists = Arrays.stream(dynamicObjects).anyMatch(s -> SbbQueryUtils.existsSbb(((DynamicObject)s.get("org")).getLong("id"), s.getDate("transferdate")));
        if (exists) {
            boolean allocatestate = Arrays.stream(dynamicObjects).allMatch(s -> s.getString("allocatestate").equals("2"));
            result = allocatestate;
        } else {
            result = Boolean.TRUE;
        }
        return result;
    }

    public void sign(String code) {
        ControlFilters controlFilters = ((IListView)this.getView()).getControlFilters();
        Map mapFilter = controlFilters.getFilters();
        Map customMap = this.getView().getFormShowParameter().getCustomParams();
        long org = RequestContext.get().getOrgId();
        HasPermOrgResult hasPermOrgs = PermissionUtils.getAllPermOrgs((IFormView)this.getView());
        DynamicObjectCollection col = TreeUtils.queryOrgListHasPermission((HasPermOrgResult)hasPermOrgs, (boolean)true);
        Long orgid = OrgCheckUtil.setDefaultOrg(null, (Long)org, (DynamicObjectCollection)col);
        List checkorgids = mapFilter.containsKey("checkorg.id") ? ((ControlFilter)mapFilter.get("checkorg.id")).getValue().stream().filter(s -> StringUtil.isNotBlank((CharSequence)s.toString())).collect(Collectors.toList()) : null;
        customMap.put("orgid", String.valueOf(orgid));
        customMap.put("checkorgid", checkorgids);
        customMap.put("mainorg", this.getMainOrg());
        PageShowCommon.showForm((ShowType)ShowType.Modal, (String)InvoiceSignTypeEnum.valueOf(code).getSignPop(), (IFormView)this.getView(), (Map)customMap, (IFormPlugin)this);
        String operateName = ResManager.loadKDString((String)"\u767b\u8bb0", (String)"InTransferOutListPlugin_7", (String)"taxc-til", (Object[])new Object[0]);
        String operateDescription = String.format(String.format(ResManager.loadKDString((String)"\u8fdb\u9879\u8f6c\u51fa\u624b\u5de5\u767b\u8bb0\u5f39\u7a97\u6253\u5f00\u6210\u529f", (String)"InTransferOutListPlugin_8", (String)"taxc-til", (Object[])new Object[0]), new Object[0]), new Object[0]);
        OperatorDialogUtils.operateDialog((String)"zzs", (String)TIL_IN_TRANSFER_OUT_BILL, (String)operateName, (String)operateDescription);
    }

    public String getMainOrg() {
        return DEFAULT_ORG;
    }

    private void cancelAllocate() {
        DynamicObject[] bills;
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection listSelectedRows = billList.getSelectedRows();
        Object[] pkids = listSelectedRows.getPrimaryKeyValues();
        for (DynamicObject bill : bills = BusinessDataServiceHelper.load((Object[])pkids, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)TIL_IN_TRANSFER_OUT_BILL))) {
            if (!"3".equals(bill.getString("allocatestate"))) continue;
            bill.set("modifier", (Object)RequestContext.get().getUserId());
            bill.set("modifytime", (Object)new Date());
            bill.set("allocatestate", (Object)"2");
            DynamicObjectCollection entryentitys = bill.getDynamicObjectCollection("entryentity");
            for (DynamicObject entryentity : entryentitys) {
                entryentity.set("projectamount", (Object)BigDecimal.ZERO);
                entryentity.set("sumincome", (Object)BigDecimal.ZERO);
                entryentity.set("amount", (Object)BigDecimal.ZERO);
                entryentity.set("type", (Object)"\u2014\u2014");
            }
        }
        SaveServiceHelper.update((DynamicObject[])bills);
    }

    private static void confirmTips(String itemKey, String customValue, IFormView getView, IFormPlugin plugin) {
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(itemKey, plugin);
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
        String msg = "";
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        String ikonw = ResManager.loadKDString((String)"\u6211\u77e5\u9053\u4e86", (String)"InTransferOutListPlugin_9", (String)"taxc-til", (Object[])new Object[0]);
        if ("unsign".equals(itemKey)) {
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ikonw);
            msg = ResManager.loadKDString((String)"\u9009\u4e2d\u6570\u636e\u4e2d\u5b58\u5728\u90e8\u5206\u7533\u62a5\u8868\u975e\u6682\u5b58\u72b6\u6001\uff0c\u8be5\u90e8\u5206\u6570\u636e\u4e0d\u652f\u6301\u53d6\u6d88\u8f6c\u51fa\u767b\u8bb0", (String)"InTransferOutListPlugin_10", (String)"taxc-til", (Object[])new Object[0]);
        } else if ("unsignReconfirm".equals(itemKey)) {
            msg = ResManager.loadKDString((String)"\u53d6\u6d88\u767b\u8bb0\u540e\uff0c\u8f6c\u51fa\u767b\u8bb0\u8bb0\u5f55\u5bf9\u5e94\u7684\u8f6c\u51fa\u7ed3\u679c\u3001\u5206\u644a\u8fc7\u7a0b\u3001\u5206\u644a\u7ed3\u679c\u548c\u5206\u644a\u8bb0\u5f55\u6570\u636e\u5c06\u88ab\u6e05\u7a7a\uff0c\u786e\u8ba4\u53d6\u6d88\u767b\u8bb0\u5417\uff1f", (String)"InTransferOutListPlugin_11", (String)"taxc-til", (Object[])new Object[0]);
        } else if ("allocateConfirm".equals(itemKey)) {
            msg = ResManager.loadKDString((String)"\u60a8\u8981\u5206\u644a\u7684\u767b\u8bb0\u8bb0\u5f55\u4e2d\u5305\u542b\u5df2\u7ecf\u8fdb\u884c\u8fc7\u5206\u644a\u8ba1\u7b97\u7684\u767b\u8bb0\u8bb0\u5f55\uff0c\u7ee7\u7eed\u64cd\u4f5c\u5c06\u4f1a\u5bf9\u5df2\u5206\u644a\u7684\u767b\u8bb0\u8bb0\u5f55\u91cd\u65b0\u8fdb\u884c\u5206\u644a\u3002", (String)"InTransferOutListPlugin_12", (String)"taxc-til", (Object[])new Object[0]);
        } else if ("unallocate".equals(itemKey)) {
            msg = ResManager.loadKDString((String)"\u53d6\u6d88\u5206\u644a\u540e\uff0c\u5df2\u9009\u6570\u636e\u7684\u5206\u644a\u8fc7\u7a0b\u3001\u5206\u644a\u7ed3\u679c\u548c\u5206\u644a\u8bb0\u5f55\u5c06\u88ab\u6e05\u7a7a\uff0c\u786e\u8ba4\u53d6\u6d88\u5206\u644a\u5417\uff1f", (String)"InTransferOutListPlugin_13", (String)"taxc-til", (Object[])new Object[0]);
        } else if ("unallocateReconfirm".equals(itemKey)) {
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ikonw);
            msg = ResManager.loadKDString((String)"\u9009\u4e2d\u6570\u636e\u4e2d\u5b58\u5728\u5c1a\u672a\u5206\u644a\u6216\u8005\u76f4\u63a5\u767b\u8bb0\u8f6c\u51fa\u7684\u767b\u8bb0\u8bb0\u5f55\uff0c\u65e0\u9700\u64cd\u4f5c\u53d6\u6d88\u5206\u644a\u3002", (String)"InTransferOutListPlugin_14", (String)"taxc-til", (Object[])new Object[0]);
        }
        getView.showConfirm(msg, "", options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps, customValue);
    }

    private void OpenDetailForm(Object primaryKeyValue) {
        DynamicObject bill = BusinessDataServiceHelper.loadSingle((Object)primaryKeyValue, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)TIL_IN_TRANSFER_OUT_BILL));
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        customParams.put("orgid", ((DynamicObject)bill.get("org")).getString("id"));
        customParams.put("invoiceid", bill.getString("invoiceid"));
        String invoicesigntype = bill.getString("invoicesigntype");
        String detailPop = InvoiceSignTypeEnum.valueOf(invoicesigntype).getDetailPop();
        this.showForm(customParams, detailPop);
    }

    private void openAllocateForm(String type, Object[] pkids) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        customParams.put("pkids", Arrays.stream(pkids).collect(Collectors.toList()));
        customParams.put("type", type);
        this.showForm(customParams, "til_transfer_allocate_l");
    }

    private void showForm(Map<String, Object> customParams, String formId) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(formId);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setStatus(OperationStatus.ADDNEW);
        parameter.setCustomParams(customParams);
        this.getView().showForm(parameter);
    }
}

