/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.til.formplugin.tio;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.til.formplugin.tio.ExtendInvoiceSignDialogPlugin;
import kd.taxc.til.formplugin.tio.enums.InvoiceSignTypeEnum;

public class IntransferOutAirDialogPlugin
extends ExtendInvoiceSignDialogPlugin {
    private static final String RIM_INV_AIR = "rim_inv_air";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        Search searchAp = (Search)this.getControl("searchap");
        searchAp.addEnterListener(this::searchListener);
    }

    private void searchListener(SearchEnterEvent evt) {
        List<Object> dataResult = this.getDataResult();
        if (null == evt.getSearchFields()) {
            this.showList(dataResult);
            return;
        }
        ArrayList printnumValues = new ArrayList();
        for (Map searchField : evt.getSearchFields()) {
            ArrayList valueList = (ArrayList)searchField.get("value");
            printnumValues.addAll(valueList);
        }
        dataResult = dataResult.stream().filter(e -> printnumValues.stream().anyMatch(s -> e.getString("print_num").contains((CharSequence)s))).collect(Collectors.toList());
        this.showList(dataResult);
    }

    @Override
    public QFilter[] buildQFilter() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object orgid = customParams.get("orgid");
        String mainorg = (String)customParams.get("mainorg");
        ArrayList orgIds = this.isNullOrEmpty(orgid) ? this.getDefaultOrgIds(this.getView().getParentView(), mainorg) : Lists.newArrayList((Object[])new Long[]{Long.parseLong((String)customParams.get("orgid"))});
        QFilter orgFilter = orgIds.isEmpty() ? new QFilter("tax_org", "is not null", null) : new QFilter("tax_org", "in", (Object)orgIds);
        QFilter deductionPurposeFilter = new QFilter("transport_deduction", "in", (Object)new String[]{"1"});
        return new QFilter[]{orgFilter, deductionPurposeFilter};
    }

    @Override
    public void initQueryData() {
        List<DynamicObject> dataResult = this.getDataResult();
        this.showList(dataResult);
    }

    private List<DynamicObject> getDataResult() {
        String selectFields = "id,org,tax_org,invoice_type,print_num,eticket_no,air_num,customer_name,customer_id_no,tax_period,transport_deduction,effective_tax_amount,invoice_date,issue_date,filling_unit,agent_code,total_amount,invoice_amount,airport_construction_fee,fuel_surcharge,insurance_premium,other_amount,total_tax_amount,tax_rate,flight_num,destination,place_of_departure,air_time,seat_grade";
        DynamicObject[] load1 = BusinessDataServiceHelper.load((String)RIM_INV_AIR, (String)selectFields, (QFilter[])this.buildQFilter());
        if (load1 == null || load1.length == 0) {
            return Collections.emptyList();
        }
        return Arrays.asList(load1);
    }

    private void showList(List<DynamicObject> load1) {
        IDataModel model = this.getModel();
        model.deleteEntryData("entryentity");
        if (0 == load1.size()) {
            return;
        }
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        DynamicObjectCollection bills = this.getBillByOrgId(customParams);
        model.beginInit();
        model.batchCreateNewEntryRow("entryentity", load1.size());
        int rowIndex = 0;
        for (DynamicObject dynamicObject : load1) {
            model.setValue("taxorg", dynamicObject.get("tax_org"), rowIndex);
            model.setValue("org", dynamicObject.get("org"), rowIndex);
            model.setValue("invoicetype", dynamicObject.get("invoice_type"), rowIndex);
            model.setValue("printnum", (Object)dynamicObject.getString("print_num"), rowIndex);
            model.setValue("eticketno", (Object)dynamicObject.getString("eticket_no"), rowIndex);
            model.setValue("airnum", (Object)dynamicObject.getString("air_num"), rowIndex);
            model.setValue("customername", (Object)dynamicObject.getString("customer_name"), rowIndex);
            model.setValue("customeridno", (Object)dynamicObject.getString("customer_id_no"), rowIndex);
            model.setValue("taxperiod", (Object)dynamicObject.getDate("tax_period"), rowIndex);
            model.setValue("selectresult", (Object)dynamicObject.getString("transport_deduction"), rowIndex);
            BigDecimal effectivetaxamount = dynamicObject.getBigDecimal("effective_tax_amount");
            BigDecimal signedtaxamount = this.getSignedtaxamount(dynamicObject, bills);
            model.setValue("availtaxamount", (Object)effectivetaxamount, rowIndex);
            model.setValue("signedtaxamount", (Object)signedtaxamount, rowIndex);
            model.setValue("cansigntaxamount", (Object)effectivetaxamount.subtract(signedtaxamount), rowIndex);
            model.setValue("airdate", (Object)dynamicObject.getDate("invoice_date"), rowIndex);
            model.setValue("issuedate", (Object)dynamicObject.getDate("issue_date"), rowIndex);
            model.setValue("fillingunit", (Object)dynamicObject.getString("filling_unit"), rowIndex);
            model.setValue("agentcode", (Object)dynamicObject.getString("agent_code"), rowIndex);
            model.setValue("totalamount", (Object)dynamicObject.getBigDecimal("total_amount"), rowIndex);
            model.setValue("invoiceamount", (Object)dynamicObject.getBigDecimal("invoice_amount"), rowIndex);
            model.setValue("airportconstructionfee", (Object)dynamicObject.getBigDecimal("airport_construction_fee"), rowIndex);
            model.setValue("fuelsurcharge", (Object)dynamicObject.getBigDecimal("fuel_surcharge"), rowIndex);
            model.setValue("insurancepremium", (Object)dynamicObject.getBigDecimal("insurance_premium"), rowIndex);
            model.setValue("otheramount", (Object)dynamicObject.getBigDecimal("other_amount"), rowIndex);
            model.setValue("taxamount", (Object)dynamicObject.getBigDecimal("total_tax_amount"), rowIndex);
            model.setValue("taxrate", (Object)dynamicObject.getBigDecimal("tax_rate"), rowIndex);
            model.setValue("flightnum", (Object)dynamicObject.getString("flight_num"), rowIndex);
            model.setValue("destination", (Object)dynamicObject.getString("destination"), rowIndex);
            model.setValue("placeofdeparture", (Object)dynamicObject.getString("place_of_departure"), rowIndex);
            model.setValue("airtime", (Object)dynamicObject.getString("air_time"), rowIndex);
            model.setValue("seatgrade", (Object)dynamicObject.getString("seat_grade"), rowIndex);
            model.setValue("invoiceid", (Object)dynamicObject.getLong("id"), rowIndex);
            ++rowIndex;
        }
        model.endInit();
        this.getView().updateView("entryentity");
        EntryGrid entryentity = (EntryGrid)this.getControl("entryentity");
        entryentity.setPageIndex(1);
    }

    @Override
    public InvoiceSignTypeEnum getInvoiceSignType() {
        return InvoiceSignTypeEnum.airsign;
    }
}

