/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.til.formplugin.tio;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.til.formplugin.tio.ExtendInvoiceSignDialogPlugin;
import kd.taxc.til.formplugin.tio.enums.InvoiceSignTypeEnum;

public class IntransferOutDialogPlugin
extends ExtendInvoiceSignDialogPlugin {
    private static final String RIM_INV_SPECIAL = "rim_inv_special";
    private static final String RIM_INV_TOLL = "rim_inv_toll";
    private static HashMap<String, String> idGoodsNameMap = null;

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        Search searchAp = (Search)this.getControl("searchap");
        searchAp.addEnterListener(this::searchListener);
    }

    private void searchListener(SearchEnterEvent evt) {
        DynamicObjectCollection dataResult = this.getDataResult();
        if (null == evt.getSearchFields()) {
            this.showList((List<DynamicObject>)dataResult);
            return;
        }
        ArrayList allValues = new ArrayList();
        ArrayList codeValues = new ArrayList();
        ArrayList noValues = new ArrayList();
        for (Map searchField : evt.getSearchFields()) {
            ArrayList fieldNameList = (ArrayList)searchField.get("fieldName");
            ArrayList valueList = (ArrayList)searchField.get("value");
            if (fieldNameList.size() > 1) {
                allValues.addAll(valueList);
                continue;
            }
            if ("invoicecode".equals(fieldNameList.get(0))) {
                codeValues.addAll(valueList);
                continue;
            }
            if (!"invoiceno".equals(fieldNameList.get(0))) continue;
            noValues.addAll(valueList);
        }
        Object list = dataResult;
        if (!allValues.isEmpty()) {
            list = list.stream().filter(e -> allValues.stream().anyMatch(s -> e.getString("invoice_code").contains((CharSequence)s) || e.getString("invoice_no").contains((CharSequence)s))).collect(Collectors.toList());
        }
        if (!codeValues.isEmpty()) {
            list = list.stream().filter(e -> codeValues.stream().anyMatch(s -> e.getString("invoice_code").contains((CharSequence)s))).collect(Collectors.toList());
        }
        if (!noValues.isEmpty()) {
            list = list.stream().filter(e -> noValues.stream().anyMatch(s -> e.getString("invoice_no").contains((CharSequence)s))).collect(Collectors.toList());
        }
        this.showList((List<DynamicObject>)list);
    }

    @Override
    public QFilter[] buildQFilter() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object orgid = customParams.get("orgid");
        String mainorg = (String)customParams.get("mainorg");
        ArrayList orgIds = this.isNullOrEmpty(orgid) ? this.getDefaultOrgIds(this.getView().getParentView(), mainorg) : Lists.newArrayList((Object[])new Long[]{Long.parseLong((String)customParams.get("orgid"))});
        QFilter orgFilter = orgIds.isEmpty() ? new QFilter("tax_org", "is not null", null) : new QFilter("tax_org", "in", (Object)orgIds);
        QFilter authenticateFlagFilter = new QFilter("authenticate_flag", "in", (Object)new String[]{"2", "3"});
        QFilter deductionPurposeFilter = new QFilter("deduction_purpose", "in", (Object)new String[]{"1"}).or(new QFilter("deduction_purpose", "=", (Object)" "));
        return new QFilter[]{orgFilter, authenticateFlagFilter, deductionPurposeFilter};
    }

    @Override
    public void initQueryData() {
        DynamicObjectCollection dataResult = this.getDataResult();
        this.showList((List<DynamicObject>)dataResult);
    }

    private DynamicObjectCollection getDataResult() {
        DynamicObjectCollection resultList = new DynamicObjectCollection();
        String selectFields = "id,org,tax_org,invoice_type,tax_period,invoice_code,invoice_no,saler_name,effective_tax_amount,invoice_status,authenticate_flag,deduction_purpose,invoice_amount,total_tax_amount,total_amount,remark";
        DynamicObject[] load1 = BusinessDataServiceHelper.load((String)RIM_INV_SPECIAL, (String)selectFields, (QFilter[])this.getQfilter(RIM_INV_SPECIAL));
        List collect = Arrays.asList(load1).stream().collect(Collectors.toList());
        List<Long> id = collect.stream().map(a -> a.getLong("id")).collect(Collectors.toList());
        resultList.addAll(collect);
        String selectFields2 = "id,org,tax_org,invoice_type,tax_period,invoice_code,invoice_no,saler_name,effective_tax_amount,invoice_status,authenticate_flag,deduction_purpose,invoice_amount,total_tax_amount,total_amount,remark";
        DynamicObject[] load2 = BusinessDataServiceHelper.load((String)RIM_INV_TOLL, (String)selectFields2, (QFilter[])this.getQfilter(RIM_INV_TOLL));
        List collect1 = Arrays.asList(load2).stream().collect(Collectors.toList());
        resultList.addAll(collect1);
        List<Long> id1 = collect1.stream().map(a -> a.getLong("id")).collect(Collectors.toList());
        if (CollectionUtils.isEmpty((Collection)resultList)) {
            return new DynamicObjectCollection();
        }
        idGoodsNameMap = new HashMap(resultList.size());
        this.getGoodsNameByIds(id, RIM_INV_SPECIAL, "id,items.goods_name as goodsname", "goodsname", idGoodsNameMap);
        this.getGoodsNameByIds(id1, RIM_INV_TOLL, "id,items.goods_name as goodsname", "goodsname", idGoodsNameMap);
        return resultList;
    }

    private QFilter[] getQfilter(String flag) {
        QFilter[] qFilters = this.buildQFilter();
        List<QFilter> collect = Arrays.stream(qFilters).collect(Collectors.toList());
        if (RIM_INV_SPECIAL.equals(flag)) {
            QFilter filter = new QFilter("invoice_type", "in", this.getInvoiceTypeId("2", "4"));
            collect.add(filter);
        } else if (RIM_INV_TOLL.equals(flag)) {
            QFilter filter = new QFilter("invoice_type", "in", this.getInvoiceTypeId("15"));
            collect.add(filter);
        }
        return collect.toArray(new QFilter[0]);
    }

    private void showList(List<DynamicObject> resultList) {
        IDataModel model = this.getModel();
        model.deleteEntryData("entryentity");
        if (resultList.isEmpty()) {
            return;
        }
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        DynamicObjectCollection bills = this.getBillByOrgId(customParams);
        model.beginInit();
        model.batchCreateNewEntryRow("entryentity", resultList.size());
        int rowIndex = 0;
        for (DynamicObject dynamicObject : resultList) {
            model.setValue("taxorg", dynamicObject.get("tax_org"), rowIndex);
            model.setValue("org", dynamicObject.get("org"), rowIndex);
            model.setValue("invoicetype", dynamicObject.get("invoice_type"), rowIndex);
            model.setValue("taxperiod", (Object)dynamicObject.getDate("tax_period"), rowIndex);
            model.setValue("invoicecode", (Object)dynamicObject.getString("invoice_code"), rowIndex);
            model.setValue("invoiceno", (Object)dynamicObject.getString("invoice_no"), rowIndex);
            model.setValue("salername", (Object)dynamicObject.getString("saler_name"), rowIndex);
            BigDecimal effectivetaxamount = dynamicObject.getBigDecimal("effective_tax_amount");
            BigDecimal signedtaxamount = this.getSignedtaxamount(dynamicObject, bills);
            model.setValue("availtaxamount", (Object)effectivetaxamount, rowIndex);
            model.setValue("signedtaxamount", (Object)signedtaxamount, rowIndex);
            model.setValue("cansigntaxamount", (Object)effectivetaxamount.subtract(signedtaxamount), rowIndex);
            model.setValue("certstatus", (Object)dynamicObject.getString("authenticate_flag"), rowIndex);
            model.setValue("selectresult", (Object)dynamicObject.getString("deduction_purpose"), rowIndex);
            model.setValue("invoicestatus", (Object)dynamicObject.getString("invoice_status"), rowIndex);
            model.setValue("invoiceamount", (Object)dynamicObject.getBigDecimal("invoice_amount"), rowIndex);
            model.setValue("taxamount", (Object)dynamicObject.getBigDecimal("total_tax_amount"), rowIndex);
            model.setValue("totalamount", (Object)dynamicObject.getBigDecimal("total_amount"), rowIndex);
            model.setValue("remark", (Object)dynamicObject.getString("remark"), rowIndex);
            model.setValue("goodsname", (Object)idGoodsNameMap.getOrDefault(dynamicObject.getDataEntityType().getName() + dynamicObject.getString("id"), ""), rowIndex);
            model.setValue("invoiceid", (Object)dynamicObject.getLong("id"), rowIndex);
            ++rowIndex;
        }
        model.endInit();
        this.getView().updateView("entryentity");
        EntryGrid entryentity = (EntryGrid)this.getControl("entryentity");
        entryentity.setPageIndex(1);
    }

    @Override
    public InvoiceSignTypeEnum getInvoiceSignType() {
        return InvoiceSignTypeEnum.invoicesign;
    }
}

