/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.til.formplugin.tio;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.til.formplugin.tio.ExtendInvoiceSignDialogPlugin;
import kd.taxc.til.formplugin.tio.enums.InvoiceSignTypeEnum;

public class IntransferOutEInvoiceDialogPlugin
extends ExtendInvoiceSignDialogPlugin {
    private static final String RIM_INV_ORDINARY = "rim_inv_ordinary";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        Search searchAp = (Search)this.getControl("searchap");
        searchAp.addEnterListener(this::searchListener);
    }

    private void searchListener(SearchEnterEvent evt) {
        List<Object> dataResult = this.getDataResult();
        if (null == evt.getSearchFields()) {
            this.showList(dataResult);
            return;
        }
        ArrayList allValues = new ArrayList();
        ArrayList codeValues = new ArrayList();
        ArrayList noValues = new ArrayList();
        for (Map searchField : evt.getSearchFields()) {
            ArrayList fieldNameList = (ArrayList)searchField.get("fieldName");
            ArrayList valueList = (ArrayList)searchField.get("value");
            if (fieldNameList.size() > 1) {
                allValues.addAll(valueList);
                continue;
            }
            if ("invoicecode".equals(fieldNameList.get(0))) {
                codeValues.addAll(valueList);
                continue;
            }
            if (!"invoiceno".equals(fieldNameList.get(0))) continue;
            noValues.addAll(valueList);
        }
        if (!allValues.isEmpty()) {
            dataResult = dataResult.stream().filter(e -> allValues.stream().anyMatch(s -> e.getString("invoice_code").contains((CharSequence)s) || e.getString("invoice_no").contains((CharSequence)s))).collect(Collectors.toList());
        }
        if (!codeValues.isEmpty()) {
            dataResult = dataResult.stream().filter(e -> codeValues.stream().anyMatch(s -> e.getString("invoice_code").contains((CharSequence)s))).collect(Collectors.toList());
        }
        if (!noValues.isEmpty()) {
            dataResult = dataResult.stream().filter(e -> noValues.stream().anyMatch(s -> e.getString("invoice_no").contains((CharSequence)s))).collect(Collectors.toList());
        }
        this.showList(dataResult);
    }

    @Override
    public QFilter[] buildQFilter() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object orgid = customParams.get("orgid");
        String mainorg = (String)customParams.get("mainorg");
        ArrayList orgIds = this.isNullOrEmpty(orgid) ? this.getDefaultOrgIds(this.getView().getParentView(), mainorg) : Lists.newArrayList((Object[])new Long[]{Long.parseLong((String)customParams.get("orgid"))});
        QFilter orgFilter = orgIds.isEmpty() ? new QFilter("tax_org", "is not null", null) : new QFilter("tax_org", "in", (Object)orgIds);
        QFilter deductionPurposeFilter = new QFilter("transport_deduction", "in", (Object)new String[]{"1"});
        QFilter invoiceTypeFilter = new QFilter("invoice_type", "in", this.getInvoiceTypeId("1"));
        return new QFilter[]{orgFilter, deductionPurposeFilter, invoiceTypeFilter};
    }

    @Override
    public void initQueryData() {
        List<DynamicObject> dataResult = this.getDataResult();
        this.showList(dataResult);
    }

    private List<DynamicObject> getDataResult() {
        String selectFields = "id,org,tax_org,invoice_type,invoice_no,invoice_code,tax_period,transport_deduction,effective_tax_amount,invoice_status,invoice_amount,total_tax_amount,total_amount,saler_name,goods_name";
        DynamicObject[] load1 = BusinessDataServiceHelper.load((String)RIM_INV_ORDINARY, (String)selectFields, (QFilter[])this.buildQFilter());
        if (load1 == null || load1.length == 0) {
            return Collections.emptyList();
        }
        return Arrays.asList(load1);
    }

    private void showList(List<DynamicObject> load1) {
        IDataModel model = this.getModel();
        model.deleteEntryData("entryentity");
        if (0 == load1.size()) {
            return;
        }
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        DynamicObjectCollection bills = this.getBillByOrgId(customParams);
        model.beginInit();
        model.batchCreateNewEntryRow("entryentity", load1.size());
        int rowIndex = 0;
        for (DynamicObject dynamicObject : load1) {
            model.setValue("taxorg", dynamicObject.get("tax_org"), rowIndex);
            model.setValue("org", dynamicObject.get("org"), rowIndex);
            model.setValue("invoicetype", dynamicObject.get("invoice_type"), rowIndex);
            model.setValue("invoiceno", (Object)dynamicObject.getString("invoice_no"), rowIndex);
            model.setValue("invoicecode", (Object)dynamicObject.getString("invoice_code"), rowIndex);
            model.setValue("taxperiod", (Object)dynamicObject.getDate("tax_period"), rowIndex);
            model.setValue("selectresult", (Object)dynamicObject.getString("transport_deduction"), rowIndex);
            BigDecimal effectivetaxamount = dynamicObject.getBigDecimal("effective_tax_amount");
            BigDecimal signedtaxamount = this.getSignedtaxamount(dynamicObject, bills);
            model.setValue("availtaxamount", (Object)effectivetaxamount, rowIndex);
            model.setValue("signedtaxamount", (Object)signedtaxamount, rowIndex);
            model.setValue("cansigntaxamount", (Object)effectivetaxamount.subtract(signedtaxamount), rowIndex);
            model.setValue("invoicestatus", (Object)dynamicObject.getString("invoice_status"), rowIndex);
            model.setValue("invoiceamount", (Object)dynamicObject.getBigDecimal("invoice_amount"), rowIndex);
            model.setValue("taxamount", (Object)dynamicObject.getBigDecimal("total_tax_amount"), rowIndex);
            model.setValue("totalamount", (Object)dynamicObject.getBigDecimal("total_amount"), rowIndex);
            model.setValue("salername", (Object)dynamicObject.getString("saler_name"), rowIndex);
            model.setValue("goodsname", (Object)this.getGoodsName(dynamicObject, RIM_INV_ORDINARY, "items.goods_name as goodsname", "goodsname"), rowIndex);
            model.setValue("invoiceid", (Object)dynamicObject.getLong("id"), rowIndex);
            ++rowIndex;
        }
        model.endInit();
        this.getView().updateView("entryentity");
        EntryGrid entryentity = (EntryGrid)this.getControl("entryentity");
        entryentity.setPageIndex(1);
    }

    @Override
    public InvoiceSignTypeEnum getInvoiceSignType() {
        return InvoiceSignTypeEnum.einvoicesign;
    }
}

