/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.til.formplugin.tio;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.coderule.api.ICodeRuleService;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.ext.fi.ai.DapBuildVoucherCommonUtil;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.TaxcCombineDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.bos.orgrelation.OrgRelationDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgCheckUtil;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.tctb.common.util.TreeUtils;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.til.formplugin.tio.enums.InvoiceSignTypeEnum;
import kd.taxc.til.formplugin.utils.SbbQueryUtils;
import org.apache.commons.collections4.CollectionUtils;

public class IntransferOutHandDialogPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final Log LOGGER = LogFactory.getLog(IntransferOutHandDialogPlugin.class);
    private static final String BTN_OK = "btnok";

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTN_OK});
        BasedataEdit org = (BasedataEdit)this.getControl("org");
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit checkorg = (BasedataEdit)this.getControl("checkorg");
        checkorg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        long userId = RequestContext.get().getCurrUserId();
        long bizUnitOrgId = RequestContext.get().getOrgId();
        String appid = this.getView().getFormShowParameter().getAppId();
        TaxResult taxResult = TaxcCombineDataServiceHelper.queryTaxcMainOrgIdByIsTaxpayerWithPerm((Long)userId, (String)appid, (String)"til_in_transfer_out_bill", (String)"2+/L8/818OJN");
        List hasPermOrgIds = (List)taxResult.getData();
        if (this.isTaxOrg(bizUnitOrgId)) {
            if (CollectionUtils.isNotEmpty((Collection)hasPermOrgIds) && hasPermOrgIds.contains(bizUnitOrgId)) {
                this.getModel().setValue("org", (Object)bizUnitOrgId);
            } else {
                TaxResult taxcOrgIdsRs = OrgRelationDataServiceHelper.getTaxcOrgIdByAccountingOrgId((Long)bizUnitOrgId);
                List taxOrgIds = (List)taxcOrgIdsRs.getData();
                if (CollectionUtils.isNotEmpty((Collection)hasPermOrgIds)) {
                    taxOrgIds.retainAll(hasPermOrgIds);
                }
                if (CollectionUtils.isNotEmpty((Collection)taxOrgIds)) {
                    this.getModel().setValue("org", taxOrgIds.get(0));
                } else {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u53ef\u7528\u7684\u7a0e\u52a1\u7ec4\u7ec7\u3002", (String)"IntransferOutHandDialogPlugin_0", (String)"taxc-til", (Object[])new Object[0]));
                }
            }
        } else {
            if (this.isAccountOrg(bizUnitOrgId)) {
                TaxResult taxcOrgIdsRs = OrgRelationDataServiceHelper.getTaxcOrgIdByAccountingOrgId((Long)bizUnitOrgId);
                List taxOrgIds = (List)taxcOrgIdsRs.getData();
                if (CollectionUtils.isNotEmpty((Collection)hasPermOrgIds)) {
                    taxOrgIds.retainAll(hasPermOrgIds);
                }
                this.getModel().setValue("org", CollectionUtils.isNotEmpty((Collection)taxOrgIds) ? taxOrgIds.get(0) : null);
            } else {
                this.getModel().setValue("org", null);
            }
            if (this.getModel().getValue("org") == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u53ef\u7528\u7684\u7a0e\u52a1\u7ec4\u7ec7\u3002", (String)"IntransferOutHandDialogPlugin_0", (String)"taxc-til", (Object[])new Object[0]));
            }
        }
    }

    private boolean isAccountOrg(long bizUnitOrgId) {
        return QueryServiceHelper.exists((String)"bos_org", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)bizUnitOrgId), new QFilter("fisaccounting", "=", (Object)true)});
    }

    private boolean isTaxOrg(long bizUnitOrgId) {
        return (Boolean)TaxcMainDataServiceHelper.isTaxcMainByOrgId((Long)bizUnitOrgId).getData();
    }

    private Long findByOrgRelation(long bizUnitOrgId) {
        QFilter[] qFilter1 = new QFilter[]{new QFilter("number", "=", (Object)"orgunit2tax")};
        DynamicObject relationtype = QueryServiceHelper.queryOne((String)"bos_org_typerelation", (String)"id,number", (QFilter[])qFilter1);
        QFilter[] qFilter2 = new QFilter[]{new QFilter("typerelation", "=", (Object)relationtype.getLong("id")).and("fromorg", "=", (Object)bizUnitOrgId)};
        DynamicObjectCollection toorgs = QueryServiceHelper.query((String)"bos_org_orgrelation", (String)"toorg", (QFilter[])qFilter2);
        return CollectionUtils.isEmpty((Collection)toorgs) ? null : Long.valueOf(((DynamicObject)toorgs.get(0)).getLong("toorg"));
    }

    private Long getDefaultOrgId() {
        HasPermOrgResult hasPermOrgs = PermissionUtils.getAllPermOrgs((IFormView)this.getView().getParentView());
        DynamicObjectCollection col = TreeUtils.queryOrgListHasPermission((HasPermOrgResult)hasPermOrgs, (boolean)true);
        Long orgId = OrgCheckUtil.setDefaultOrg(null, (Long)RequestContext.get().getOrgId(), (DynamicObjectCollection)col);
        return orgId != null ? orgId : 0L;
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        if (BTN_OK.equals(control.getKey())) {
            Date transferdate;
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            if (org == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7a0e\u52a1\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"IntransferOutHandDialogPlugin_1", (String)"taxc-til", (Object[])new Object[0]));
                return;
            }
            if (!((Boolean)TaxcMainDataServiceHelper.isTaxcMainByOrgId((Long)org.getLong("id")).getData()).booleanValue()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u52a1\u7ec4\u7ec7\u672a\u5ba1\u6838\u6216\u4e0d\u53ef\u7528\uff0c\u65e0\u6cd5\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u3002", (String)"IntransferOutHandDialogPlugin_2", (String)"taxc-til", (Object[])new Object[0]));
                return;
            }
            Long orgid = org.getLong("id");
            if (SbbQueryUtils.existsSbb(orgid, transferdate = (Date)this.getModel().getValue("transferdate"))) {
                int yearOfDate = DateUtils.getYearOfDate((Date)transferdate);
                int monthOfDate = DateUtils.getMonthOfDate((Date)transferdate);
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u7684\u201c\u8f6c\u51fa\u6240\u5c5e\u7a0e\u671f%1$s\u5e74%2$s\u6708\u201d\u5df2\u5b58\u5728\u7533\u62a5\u8bb0\u5f55\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"IntransferOutHandDialogPlugin_3", (String)"taxc-til", (Object[])new Object[0]), yearOfDate, monthOfDate));
                return;
            }
            this.submitClick(orgid);
            IFormView parentView = this.getView().getParentView();
            BillList billList = (BillList)parentView.getControl("billlistap");
            billList.refresh();
            this.getView().close();
        }
    }

    private void submitClick(Long orgid) {
        DynamicObject bill = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"til_in_transfer_out_bill"));
        bill.set("org", this.getModel().getValue("org"));
        bill.set("billno", (Object)this.getNumber(bill));
        BigDecimal signamount = (BigDecimal)this.getModel().getValue("signtaxamount");
        bill.set("signamount", this.getModel().getValue("signtaxamount"));
        String signtype = (String)this.getModel().getValue("signtype");
        bill.set("signtype", (Object)signtype);
        bill.set("projecttype", (Object)this.getProjecttype());
        bill.set("allocatestate", (Object)(signtype.equals("1") ? "1" : "2"));
        bill.set("transferdate", (Object)DateUtils.getFirstDateOfMonth((Date)((Date)this.getModel().getValue("transferdate"))));
        bill.set("datasource", (Object)"2");
        bill.set("billstatus", (Object)"C");
        bill.set("mark", this.getModel().getValue("mark"));
        bill.set("invoicecode", (Object)"");
        bill.set("invoiceno", (Object)"");
        bill.set("modifier", (Object)RequestContext.get().getUserId());
        bill.set("modifytime", (Object)new Date());
        bill.set("invoicesigntype", (Object)InvoiceSignTypeEnum.manualsign.getType());
        bill.set("checkorg", this.getModel().getValue("checkorg"));
        DynamicObjectCollection subTable = bill.getDynamicObjectCollection("entryentity");
        this.createSubTable(signamount, signtype, this.getProjecttype(), subTable);
        Object[] save = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bill});
        DynamicObject obj = (DynamicObject)save[0];
        Boolean dapResult = DapBuildVoucherCommonUtil.executeWriteBillDBOperation((String)"til_in_transfer_out_bill", (String)"audit", Collections.singletonList(obj.getLong("id")), (DapBuildVoucherCommonUtil.executeType)DapBuildVoucherCommonUtil.executeType.INSERTWRITE);
        LOGGER.info("til id : {},dapResult:{}", (Object)obj.getLong("id"), (Object)dapResult);
        this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u767b\u8bb0\u6210\u529f", (String)"IntransferOutHandDialogPlugin_4", (String)"taxc-til", (Object[])new Object[0]));
    }

    private String getProjecttype() {
        String signtype = (String)this.getModel().getValue("signtype");
        return "1".equals(signtype) ? "1" : (String)this.getModel().getValue("projecttype");
    }

    private String getNumber(DynamicObject bill) {
        ICodeRuleService codeRuleService = (ICodeRuleService)ServiceFactory.getService(ICodeRuleService.class);
        return codeRuleService.getNumber("til_in_transfer_out_bill", bill, null);
    }

    private void createSubTable(BigDecimal signamount, String signtype, String projecttype, DynamicObjectCollection subTable) {
        BigDecimal amount;
        BigDecimal bigDecimal = amount = signtype.equals("1") ? signamount : BigDecimal.ZERO;
        if ("4".equals(projecttype)) {
            this.createRow(subTable, "\u2014\u2014", amount, 1);
            this.createRow(subTable, "\u2014\u2014", amount, 2);
        } else if ("3".equals(projecttype) || "2".equals(projecttype)) {
            this.createRow(subTable, "\u2014\u2014", amount, 1);
        } else {
            this.createRow(subTable, (String)this.getModel().getValue("type"), amount, 1);
        }
    }

    private void createRow(DynamicObjectCollection subTable, String type, BigDecimal amount, int seq) {
        DynamicObject row = subTable.addNew();
        row.set("type", (Object)type);
        row.set("amount", (Object)amount);
        row.set("seq", (Object)seq);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        long userId = RequestContext.get().getCurrUserId();
        String appid = this.getView().getFormShowParameter().getAppId();
        ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        ListFilterParameter listFilterParameter = formShowParameter.getListFilterParameter();
        HasPermOrgResult hasPermOrgResult = PermissionUtils.getAllPermOrgs((String)appid, (String)"til_in_transfer_out_bill", (String)"2+/L8/818OJN");
        if (beforeF7SelectEvent.getProperty().getName().equals("org")) {
            HasPermOrgResult taxRs = PermissionServiceHelper.getAllPermOrgs((long)userId, (String)"40", (String)appid, (String)"til_in_transfer_out_bill", (String)"2+/L8/818OJN");
            List taxOrgs = taxRs.getHasPermOrgs();
            if (!hasPermOrgResult.hasAllOrgPerm()) {
                HasPermOrgResult accountingRs = PermissionServiceHelper.getAllPermOrgs((long)userId, (String)"10", (String)appid, (String)"til_in_transfer_out_bill", (String)"2+/L8/818OJN");
                List accOrgs = accountingRs.getHasPermOrgs();
                TaxResult taxcOrgIds = OrgRelationDataServiceHelper.getTaxcOrgIdByAccountingOrgIds((List)accOrgs);
                taxOrgs.addAll((Collection)taxcOrgIds.getData());
                if (EmptyCheckUtils.isNotEmpty((Object)taxOrgs)) {
                    listFilterParameter.setFilter(new QFilter("id", "in", (Object)taxOrgs));
                } else {
                    listFilterParameter.setFilter(new QFilter("id", "=", (Object)0));
                }
            }
        } else if (beforeF7SelectEvent.getProperty().getName().equals("checkorg")) {
            HasPermOrgResult accountingRs = PermissionServiceHelper.getAllPermOrgs((long)userId, (String)"10", (String)appid, (String)"til_in_transfer_out_bill", (String)"2+/L8/818OJN");
            List accOrgs = accountingRs.getHasPermOrgs();
            if (!hasPermOrgResult.hasAllOrgPerm()) {
                HasPermOrgResult taxRs = PermissionServiceHelper.getAllPermOrgs((long)userId, (String)"40", (String)appid, (String)"til_in_transfer_out_bill", (String)"2+/L8/818OJN");
                List taxOrgs = taxRs.getHasPermOrgs();
                TaxResult accOrgIds = OrgRelationDataServiceHelper.getAccountingOrgIdByTaxcOrgIds((List)taxOrgs);
                accOrgs.addAll((Collection)accOrgIds.getData());
                if (EmptyCheckUtils.isNotEmpty((Object)accOrgs)) {
                    listFilterParameter.setFilter(new QFilter("id", "in", (Object)accOrgs));
                } else {
                    listFilterParameter.setFilter(new QFilter("id", "=", (Object)0));
                }
            }
        }
    }
}

