/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.til.formplugin.tio;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.til.formplugin.tio.ExtendInvoiceSignDialogPlugin;
import kd.taxc.til.formplugin.tio.enums.InvoiceSignTypeEnum;

public class IntransferOutTrainDialogPlugin
extends ExtendInvoiceSignDialogPlugin {
    private static final String RIM_INV_TRAIN = "rim_inv_train";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        Search searchAp = (Search)this.getControl("searchap");
        searchAp.addEnterListener(this::searchListener);
    }

    private void searchListener(SearchEnterEvent evt) {
        List<Object> dataResult = this.getDataResult();
        if (null == evt.getSearchFields()) {
            this.showList(dataResult);
            return;
        }
        ArrayList sequencenoValues = new ArrayList();
        for (Map searchField : evt.getSearchFields()) {
            ArrayList valueList = (ArrayList)searchField.get("value");
            sequencenoValues.addAll(valueList);
        }
        dataResult = dataResult.stream().filter(e -> sequencenoValues.stream().anyMatch(s -> e.getString("sequence_no").contains((CharSequence)s))).collect(Collectors.toList());
        this.showList(dataResult);
    }

    @Override
    public QFilter[] buildQFilter() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object orgid = customParams.get("orgid");
        String mainorg = (String)customParams.get("mainorg");
        ArrayList orgIds = this.isNullOrEmpty(orgid) ? this.getDefaultOrgIds(this.getView().getParentView(), mainorg) : Lists.newArrayList((Object[])new Long[]{Long.parseLong((String)customParams.get("orgid"))});
        QFilter orgFilter = orgIds.isEmpty() ? new QFilter("tax_org", "is not null", null) : new QFilter("tax_org", "in", (Object)orgIds);
        QFilter deductionPurposeFilter = new QFilter("transport_deduction", "in", (Object)new String[]{"1"});
        return new QFilter[]{orgFilter, deductionPurposeFilter};
    }

    @Override
    public void initQueryData() {
        List<DynamicObject> dataResult = this.getDataResult();
        this.showList(dataResult);
    }

    private List<DynamicObject> getDataResult() {
        String selectFields = "id,org,tax_org,invoice_type,sequence_no,train_num,tax_period,transport_deduction,effective_tax_amount,invoice_date,train_time,passenger_name,total_amount,total_tax_amount,tax_rate,seat_grade,station_get_on,station_get_off";
        DynamicObject[] load1 = BusinessDataServiceHelper.load((String)RIM_INV_TRAIN, (String)selectFields, (QFilter[])this.buildQFilter());
        if (load1 == null || load1.length == 0) {
            return Collections.emptyList();
        }
        return Arrays.asList(load1);
    }

    private void showList(List<DynamicObject> load1) {
        IDataModel model = this.getModel();
        model.deleteEntryData("entryentity");
        if (0 == load1.size()) {
            return;
        }
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        DynamicObjectCollection bills = this.getBillByOrgId(customParams);
        model.beginInit();
        model.batchCreateNewEntryRow("entryentity", load1.size());
        int rowIndex = 0;
        for (DynamicObject dynamicObject : load1) {
            model.setValue("taxorg", dynamicObject.get("tax_org"), rowIndex);
            model.setValue("org", dynamicObject.get("org"), rowIndex);
            model.setValue("invoicetype", dynamicObject.get("invoice_type"), rowIndex);
            model.setValue("sequenceno", (Object)dynamicObject.getString("sequence_no"), rowIndex);
            model.setValue("trainnum", (Object)dynamicObject.getString("train_num"), rowIndex);
            model.setValue("taxperiod", (Object)dynamicObject.getDate("tax_period"), rowIndex);
            model.setValue("transportdeduction", (Object)dynamicObject.getString("transport_deduction"), rowIndex);
            BigDecimal effectivetaxamount = dynamicObject.getBigDecimal("effective_tax_amount");
            BigDecimal signedtaxamount = this.getSignedtaxamount(dynamicObject, bills);
            model.setValue("availtaxamount", (Object)effectivetaxamount, rowIndex);
            model.setValue("signedtaxamount", (Object)signedtaxamount, rowIndex);
            model.setValue("cansigntaxamount", (Object)effectivetaxamount.subtract(signedtaxamount), rowIndex);
            model.setValue("invoicedate", (Object)dynamicObject.getDate("invoice_date"), rowIndex);
            model.setValue("traintime", (Object)dynamicObject.getString("train_time"), rowIndex);
            model.setValue("passengername", (Object)dynamicObject.getString("passenger_name"), rowIndex);
            model.setValue("totalamount", (Object)dynamicObject.getBigDecimal("total_amount"), rowIndex);
            model.setValue("totaltaxamount", (Object)dynamicObject.getBigDecimal("total_tax_amount"), rowIndex);
            model.setValue("taxrate", (Object)dynamicObject.getBigDecimal("tax_rate"), rowIndex);
            model.setValue("seatgrade", (Object)dynamicObject.getString("seat_grade"), rowIndex);
            model.setValue("stationgeton", (Object)dynamicObject.getString("station_get_on"), rowIndex);
            model.setValue("stationgetoff", (Object)dynamicObject.getString("station_get_off"), rowIndex);
            model.setValue("invoiceid", (Object)dynamicObject.getLong("id"), rowIndex);
            ++rowIndex;
        }
        model.endInit();
        this.getView().updateView("entryentity");
        EntryGrid entryentity = (EntryGrid)this.getControl("entryentity");
        entryentity.setPageIndex(1);
    }

    @Override
    public InvoiceSignTypeEnum getInvoiceSignType() {
        return InvoiceSignTypeEnum.trainsign;
    }
}

