/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.til.formplugin.tio;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.exception.KDBizException;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.FilterContainerInitEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.SearchClickEvent;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.list.plugin.IListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.constant.BooleanEnum;
import kd.taxc.bdtaxr.common.taxdeclare.address.RegisterAddressUtil;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgUtils;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.KdToolUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.til.formplugin.tio.enums.TioCheckCertBoardEnum;
import kd.taxc.til.formplugin.tio.enums.TioCheckCertEnum;
import kd.taxc.til.formplugin.utils.SelectStyleUtil;
import kd.taxc.til.formplugin.utils.TilOrgUtil;
import kd.taxc.til.formplugin.utils.ViewInvokeOperationUtil;

public class TioCheckCertListPlugin
extends AbstractListPlugin
implements TabSelectListener,
IListPlugin {
    private static final String FILTER_CONTAINER_AP = "filtercontainerap";
    private static final String TAX_AMOUNT = "taxamount";
    private static final String TAB_AP = "tabap";
    private static final String CARD_TITLE = "cardtitle";
    private static final String CARD_TITLE_FORMAT = "cardtitleformat";
    private static final String SEL_COUNT = "selcount";
    private static final String SEL_TOTAL = "seltotal";
    private static final String SEL_CAN_COUNT = "selcancount";
    private static final String SEL_CAN_TOTAL = "selcantotal";
    private static final String DK_SEL_TOTAL = "dkseltotal";
    private static final String DK_SEL_TOTAL_1 = "dkseltotal1";
    private static final String DK_NO_SEL_TOTAL = "dknoseltotal";
    private static final String AUTH_SEL_COUNT = "authselcount";
    private static final String AUTH_SEL_TOTAL = "authseltotal";
    private static final String AUTH_SEL_AUTH_COUNT = "authselauthcount";
    private static final String AUTH_SEL_AUTH_TOTAL = "authselauthtotal";
    private static final String AUTH_NO_SEL_COUNT = "authnoselcount";
    private static final String AUTH_NO_SEL_TOTAL = "authnoseltotal";
    private static final String ORDER_TOTAL = "ordertotal";
    private static final String ORDERED_TOTAL = "orderedtotal";
    private static final String ORDERUN_TOTAL = "orderuntotal";
    private static Log LOGGER = LogFactory.getLog(TioCheckCertListPlugin.class);
    private static final String FILTER_TAB = "filterTab";

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addTabSelectListener(this, TAB_AP);
        this.addClickListeners(new String[]{"toolbarap"});
        for (TioCheckCertEnum tioCheckCertEnum : TioCheckCertEnum.values()) {
            this.addBoardClickListener(tioCheckCertEnum);
        }
    }

    private void addBoardClickListener(TioCheckCertEnum tioCheckCertEnum) {
        for (TioCheckCertBoardEnum tioCheckCertBoardEnum : TioCheckCertBoardEnum.values()) {
            this.addClickListeners(new String[]{tioCheckCertEnum.getCode() + tioCheckCertBoardEnum.getFlexKey()});
        }
    }

    private void filterSearchClickEvent(SearchClickEvent searchClickEvent) {
        TioCheckCertEnum tioCheckCertEnum = this.getCurrentCheckCertEnum();
        BillList billList = (BillList)this.getView().getControl(tioCheckCertEnum.getBillap());
        Map map = searchClickEvent.getFilterValues();
        List customlist = (List)map.get("customfilter");
        List schemelist = (List)map.get("schemefilter");
        List fastlist = (List)map.get("fastfilter");
        FilterParameter fastFilterParameter = searchClickEvent.getFilterModel().getFastFilterParameter(fastlist);
        List fastQFilterList = fastFilterParameter.getQFilters();
        FilterParameter commonFilterParameter = searchClickEvent.getFilterModel().getCommonFilterParameter(customlist);
        List commonQFilterList = commonFilterParameter.getQFilters();
        FilterParameter schemaFilterParameter = searchClickEvent.getFilterModel().getSchemeFilterParameter(schemelist);
        List schemaQFilterList = schemaFilterParameter.getQFilters();
        fastQFilterList.addAll(commonQFilterList);
        fastQFilterList.addAll(schemaQFilterList);
        QFilter orgFilter = this.getOrgFilter(commonQFilterList, billList.getFilterParameter().getQFilters());
        if (EmptyCheckUtils.isEmpty((Object)schemaQFilterList) && EmptyCheckUtils.isNotEmpty((Object)orgFilter)) {
            fastQFilterList.add(orgFilter);
        }
        Tab tabap = (Tab)this.getControl(TAB_AP);
        String currentTab = tabap.getCurrentTab();
        this.getPageCache().put(FILTER_TAB, currentTab);
        billList.setFilterParameter(fastFilterParameter);
        billList.clearSelection();
        billList.refresh();
    }

    private QFilter getOrgFilter(List<QFilter> commonQFilterList, List<QFilter> qFilters) {
        for (QFilter qFilter : commonQFilterList) {
            if (!qFilter.getProperty().equalsIgnoreCase("org.id")) continue;
            return null;
        }
        for (int i = qFilters.size() - 1; i >= 0; --i) {
            QFilter qFilter;
            if (!qFilters.get(i).getProperty().equalsIgnoreCase("org")) continue;
            qFilter = qFilters.get(i);
            Object val = qFilter.getValue();
            if (null != val && val instanceof List) {
                qFilter.__setValue(((List)val).stream().map(v -> Long.parseLong(String.valueOf(v))).collect(Collectors.toList()));
            }
            return qFilters.get(i);
        }
        return null;
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        String billListKey = ((BillList)e.getSource()).getKey();
        TioCheckCertEnum tioCheckCertEnum = this.getCurrentCheckCertEnum();
        if (tioCheckCertEnum.getBillap().equalsIgnoreCase(billListKey) && EmptyCheckUtils.isNotEmpty((Object)this.getPageCache().get("selectedflexkey"))) {
            String orgid;
            String selectFlexKey = this.getPageCache().get("selectedflexkey");
            if (selectFlexKey.length() < 4) {
                return;
            }
            TioCheckCertBoardEnum boardEnum = TioCheckCertBoardEnum.getEnumByKey(tioCheckCertEnum.getCode(), selectFlexKey.substring(3));
            if (EmptyCheckUtils.isEmpty((Object)((Object)boardEnum))) {
                return;
            }
            List qFilters = e.getQFilters();
            if (EmptyCheckUtils.isNotEmpty((Object)boardEnum.getqFilter())) {
                qFilters.add(boardEnum.getqFilter());
            }
            if (EmptyCheckUtils.isEmpty((Object)(orgid = this.getPageCache().get("verifyOrg")))) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a", (String)"TioCheckCertListPlugin_0", (String)"taxc-til", (Object[])new Object[0]));
            }
            String taxperiod = this.getPageCache().get("taxperiod");
            if (EmptyCheckUtils.isEmpty((Object)taxperiod)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5c5e\u671f\u4e0d\u80fd\u4e3a\u7a7a", (String)"TioCheckCertListPlugin_1", (String)"taxc-til", (Object[])new Object[0]));
            }
            QFilter taxperiodQFilter = new QFilter("taxperiod", "=", (Object)taxperiod);
            qFilters.add(taxperiodQFilter);
            QFilter orgFilter1 = new QFilter("org", "=", (Object)Long.parseLong(orgid));
            qFilters.add(orgFilter1);
        }
    }

    public void afterCreateNewData(EventObject e) {
        Tab tabap = (Tab)this.getControl(TAB_AP);
        if (tabap != null) {
            String currentTab = tabap.getCurrentTab();
            tabap.activeTab(currentTab);
            tabap.selectTab(currentTab);
        }
    }

    public void afterBindData(EventObject e) {
        List params = (List)SerializationUtils.fromJsonString((String)("[{\"key\":\"filtercontainerap\",\"methodName\":\"commonSearch\",\"args\":[[],[{\"FieldName\":[\"taxperioddate\"],\"Value\":[\"63\"],\"Compare\":[\"63\"]},{\"FieldName\":[\"org.id\"],\"Value\":[\"" + this.getPageCache().get("verifyOrg") + "\"],\"Compare\":[\"\"]}],\"tdm_invoice_input_inh\"],\"postData\":[]}]"), List.class);
        ViewInvokeOperationUtil.invokeOperation(this.getView(), params);
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        TioCheckCertEnum tioCheckCertEnum = this.getCurrentCheckCertEnum();
        TioCheckCertBoardEnum boardEnum = TioCheckCertBoardEnum.getEnumByKey(tioCheckCertEnum.getCode(), key);
        if (EmptyCheckUtils.isEmpty((Object)((Object)boardEnum))) {
            return;
        }
        if (EmptyCheckUtils.isNotEmpty((Object)this.getPageCache().get("selectedflexkey"))) {
            String oldselectflexkey = this.getPageCache().get("selectedflexkey");
            if (!oldselectflexkey.equalsIgnoreCase(key)) {
                SelectStyleUtil.cancelSelect(oldselectflexkey, this.getView());
                SelectStyleUtil.select(key, this.getView());
            }
        } else {
            SelectStyleUtil.select(key, this.getView());
        }
        this.displayDataByBoardSelected(boardEnum, tioCheckCertEnum);
    }

    private void displayDataByBoardSelected(TioCheckCertBoardEnum boardEnum, TioCheckCertEnum tioCheckCertEnum) {
        String orgid;
        BillList billList = (BillList)this.getControl(tioCheckCertEnum.getBillap());
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
        if (EmptyCheckUtils.isNotEmpty((Object)boardEnum.getqFilter())) {
            qFilters.add(boardEnum.getqFilter());
        }
        if (EmptyCheckUtils.isEmpty((Object)(orgid = this.getPageCache().get("verifyOrg")))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a", (String)"TioCheckCertListPlugin_0", (String)"taxc-til", (Object[])new Object[0]));
        }
        String taxperiod = this.getPageCache().get("taxperiod");
        if (EmptyCheckUtils.isEmpty((Object)taxperiod)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5c5e\u671f\u4e0d\u80fd\u4e3a\u7a7a", (String)"TioCheckCertListPlugin_1", (String)"taxc-til", (Object[])new Object[0]));
        }
        QFilter taxperiodQFilter = new QFilter("taxperiod", "=", (Object)taxperiod);
        qFilters.add(taxperiodQFilter);
        QFilter orgFilter1 = new QFilter("org", "=", (Object)Long.parseLong(orgid));
        qFilters.add(orgFilter1);
        billList.clearSelection();
        billList.getFilterParameter().getFilters().clear();
        billList.getFilterParameter().getQFilters().clear();
        billList.getFilterParameter().setQFilters(qFilters);
        FilterParameter filterParameter = billList.getFilterParameter();
        billList.setFilterParameter(filterParameter);
        billList.refresh();
    }

    private TioCheckCertEnum getCurrentCheckCertEnum() {
        Tab tabap = (Tab)this.getControl(TAB_AP);
        if (tabap != null) {
            String currentTab = tabap.getCurrentTab();
            return TioCheckCertEnum.getEnumByPageAp(currentTab);
        }
        throw new KDBizException("TAB IS NOT EXIST");
    }

    public void addTabSelectListener(TabSelectListener form, String ... tabName) {
        int len = tabName.length;
        for (int i = 0; i < len; ++i) {
            Tab tab = (Tab)this.getControl(tabName[i]);
            if (tab == null) continue;
            tab.addTabSelectListener(form);
        }
    }

    public void initialize() {
        FilterContainer filterContainer = (FilterContainer)this.getView().getControl(FILTER_CONTAINER_AP);
        filterContainer.setBillFormId("tdm_invoice_input_inh");
        filterContainer.addFilterContainerInitListener(event -> this.filterContainerInit(event));
        filterContainer.addSearchClickListener(event -> this.filterSearchClickEvent(event));
        filterContainer.addBeforeF7SelectListener(this::filterContainerBeforeF7Select);
        for (TioCheckCertEnum tioCheckCertEnum : TioCheckCertEnum.values()) {
            BillList billList = (BillList)this.getControl(tioCheckCertEnum.getBillap());
            billList.addSetFilterListener(this::setFilter);
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        if ("bos_org".equals(args.getRefEntityId())) {
            HasPermOrgResult result = PermissionUtils.getAllPermOrgs((IFormView)this.getView());
            if (result == null || result.hasAllOrgPerm()) {
                return;
            }
            OrgUtils.addFilterByConditionBeforeF7Select((Object)args, (IFormView)this.getView(), (String[])new String[]{"til_sign_ticket"}, null, null);
        }
    }

    private void filterContainerInit(FilterContainerInitEvent event) {
        List filterColumnList = event.getCommonFilterColumns();
        CommonFilterColumn orgColumn = null;
        for (FilterColumn column : filterColumnList) {
            if (!column.getFieldName().startsWith("org.")) continue;
            orgColumn = (CommonFilterColumn)column;
        }
        String oldselectflexkey = this.getPageCache().get("selectedflexkey");
        if (EmptyCheckUtils.isNotEmpty((Object)oldselectflexkey)) {
            this.getPageCache().remove("selectedflexkey");
            SelectStyleUtil.cancelSelect(oldselectflexkey, this.getView());
        }
        QFilter qFilter = null;
        if (orgColumn != null) {
            List<ComboItem> orgCombos = TilOrgUtil.getOrgComboItem(this.getView());
            if (!orgCombos.isEmpty()) {
                orgColumn.setDefaultValue(orgCombos.get(0).getValue());
                qFilter = new QFilter("org", "=", (Object)Long.parseLong(orgCombos.get(0).getValue()));
            } else {
                qFilter = new QFilter("org", "=", (Object)-1L);
            }
            orgColumn.setType("enum");
            orgColumn.setMustInput(true);
            orgColumn.setComboItems(orgCombos);
        }
        TioCheckCertEnum tioCheckCertEnum = this.getCurrentCheckCertEnum();
        BillList billlist = (BillList)this.getControl(tioCheckCertEnum.getBillap());
        if (qFilter != null) {
            Class<CommonFilterColumn> clas = CommonFilterColumn.class;
            try {
                Field field = clas.getDeclaredField("selectedCommomFilterFieldValues");
                AccessibleObject.setAccessible(new AccessibleObject[]{field}, true);
                List list = (List)field.get(orgColumn);
                if (EmptyCheckUtils.isNotEmpty((Object)list)) {
                    qFilter = new QFilter("org", "=", (Object)Long.parseLong(String.valueOf(list.get(0))));
                }
                String newOrgValTemp = String.valueOf(qFilter.getValue());
                String oldOrgVal = this.getPageCache().get("verifyOrg");
                if (EmptyCheckUtils.isEmpty((Object)oldOrgVal)) {
                    this.getPageCache().put("verifyOrg", newOrgValTemp);
                } else if (EmptyCheckUtils.isNotEmpty((Object)oldOrgVal) && !oldOrgVal.equalsIgnoreCase(newOrgValTemp) && this.initBoard(this.getCurrentCheckCertEnum(), newOrgValTemp)) {
                    this.getPageCache().put("verifyOrg", newOrgValTemp);
                }
                billlist.getFilterParameter().setFilter(qFilter);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                LOGGER.error(ResManager.loadKDString((String)"\u83b7\u53d6\u591a\u9009\u7ec4\u7ec7\u5931\u8d25", (String)"TioCheckCertListPlugin_0", (String)"taxc-tctb-formplugin", (Object[])new Object[0]), (Throwable)e);
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if ("checkdeduction".equalsIgnoreCase(itemKey)) {
            this.checkDeduction("1");
            this.refresh();
        } else if ("checknondeduction".equalsIgnoreCase(itemKey)) {
            this.checkDeduction("2");
            this.refresh();
        } else if ("cancelcheck".equalsIgnoreCase(itemKey)) {
            this.cancelCheck();
            this.refresh();
        } else if ("sendcert".equalsIgnoreCase(itemKey)) {
            this.sendCert();
            this.refresh();
        } else if ("refresh".equalsIgnoreCase(itemKey)) {
            this.refresh();
        }
    }

    private void refresh() {
        String selkey = this.getPageCache().get("selectedflexkey");
        TioCheckCertEnum tioCheckCertEnum = this.getCurrentCheckCertEnum();
        this.initBoard(tioCheckCertEnum, this.getPageCache().get("verifyOrg"));
        BillList billList = (BillList)this.getControl(tioCheckCertEnum.getBillap());
        if (EmptyCheckUtils.isNotEmpty((Object)selkey)) {
            TioCheckCertBoardEnum boardEnum = TioCheckCertBoardEnum.getEnumByKey(tioCheckCertEnum.getCode(), selkey.substring(3));
            if (EmptyCheckUtils.isEmpty((Object)((Object)boardEnum))) {
                return;
            }
            this.displayDataByBoardSelected(boardEnum, tioCheckCertEnum);
        } else {
            String filterTab = this.getPageCache().get(FILTER_TAB);
            if (filterTab != null) {
                BillList filterBillList = (BillList)this.getControl(TioCheckCertEnum.getEnumByPageAp(filterTab).getBillap());
                FilterParameter filterParameter = filterBillList.getFilterParameter();
                if (EmptyCheckUtils.isNotEmpty((Object)filterParameter)) {
                    billList.setFilterParameter(filterParameter);
                }
            } else {
                this.refreshCurrentBillWithDefaultCondition(tioCheckCertEnum);
            }
            billList.clearSelection();
            billList.refresh();
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        TioCheckCertEnum tioCheckCertEnum = this.getCurrentCheckCertEnum();
        String actionid = closedCallBackEvent.getActionId();
        if ("sendcert".equalsIgnoreCase(actionid) && null != closedCallBackEvent.getReturnData() && "Yes".equalsIgnoreCase(String.valueOf(closedCallBackEvent.getReturnData()))) {
            DynamicObject[] dynamicObjects;
            String sendcertidstr = this.getPageCache().get("sendcertids");
            List pkids = KdToolUtils.stringToLong((String[])sendcertidstr.split(","));
            for (DynamicObject dynamicObject : dynamicObjects = BusinessDataServiceHelper.load((String)tioCheckCertEnum.getEntityCode(), (String)"id,certstatus,authdate", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)pkids)})) {
                dynamicObject.set("certstatus", (Object)BooleanEnum.YES.getCode());
                dynamicObject.set("authdate", (Object)new Date());
            }
            SaveServiceHelper.update((DynamicObject[])dynamicObjects);
        }
    }

    private void sendCert() {
        DynamicObject[] dynamicObjects;
        TioCheckCertEnum tioCheckCertEnum = this.getCurrentCheckCertEnum();
        BillList billList = (BillList)this.getControl(tioCheckCertEnum.getBillap());
        ListSelectedRowCollection listSelectedRows = billList.getSelectedRows();
        if (EmptyCheckUtils.isEmpty((Object)listSelectedRows) || listSelectedRows.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u9009\u4e2d\u8bb0\u5f55", (String)"TioCheckCertListPlugin_2", (String)"taxc-til", (Object[])new Object[0]));
            return;
        }
        Object[] pkids = listSelectedRows.getPrimaryKeyValues();
        this.getPageCache().put("sendcertids", Arrays.stream(pkids).map(v -> String.valueOf(v)).collect(Collectors.joining(",")));
        for (DynamicObject dynamicObject : dynamicObjects = BusinessDataServiceHelper.load((String)tioCheckCertEnum.getEntityCode(), (String)"id,invoiceno,invoicecode,selectstatus,certstatus,selectresult,invoiceamount,taxamount", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)pkids)})) {
            if (!BooleanEnum.YES.getCode().equalsIgnoreCase(dynamicObject.getString("selectstatus"))) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff1a\u53d1\u7968\u53f7\u7801\u3010%1$s\u3011\u53d1\u7968\u4ee3\u7801\u3010%2$s\u3011\u72b6\u6001\u4e3a\u3010\u672a\u52fe\u9009\u3011", (String)"TioCheckCertListPlugin_3", (String)"taxc-til", (Object[])new Object[0]), dynamicObject.getString("invoiceno"), dynamicObject.getString("invoicecode")));
                return;
            }
            if (!BooleanEnum.YES.getCode().equalsIgnoreCase(dynamicObject.getString("certstatus"))) continue;
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff1a\u53d1\u7968\u53f7\u7801\u3010%1$s\u3011\u53d1\u7968\u4ee3\u7801\u3010%2$s\u3011\u5df2\u8ba4\u8bc1", (String)"TioCheckCertListPlugin_4", (String)"taxc-til", (Object[])new Object[0]), dynamicObject.getString("invoiceno"), dynamicObject.getString("invoicecode")));
            return;
        }
        Map<String, List<DynamicObject>> selectresult2ListMap = Arrays.stream(dynamicObjects).collect(Collectors.groupingBy(k -> k.getString("selectresult")));
        if (1 != selectresult2ListMap.size()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff1a\u53ea\u80fd\u5bf9\u52fe\u9009\u7ed3\u679c\u4e00\u81f4\u7684\u6570\u636e\u8fdb\u884c\u8ba4\u8bc1", (String)"TioCheckCertListPlugin_5", (String)"taxc-til", (Object[])new Object[0]));
            return;
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("til_cert_dialog");
        HashMap<String, Object> customParams = new HashMap<String, Object>(4);
        customParams.put("selectresult", dynamicObjects[0].getString("selectresult"));
        customParams.put("count", dynamicObjects.length);
        customParams.put("total", Arrays.stream(dynamicObjects).map(v -> v.getBigDecimal("invoiceamount")).reduce(BigDecimal.ZERO, BigDecimal::add));
        customParams.put("taxtotal", Arrays.stream(dynamicObjects).map(v -> v.getBigDecimal(TAX_AMOUNT)).reduce(BigDecimal.ZERO, BigDecimal::add));
        parameter.setCustomParams(customParams);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "sendcert"));
        this.getView().showForm(parameter);
    }

    private void cancelCheck() {
        DynamicObject[] dynamicObjects;
        TioCheckCertEnum tioCheckCertEnum = this.getCurrentCheckCertEnum();
        BillList billList = (BillList)this.getControl(tioCheckCertEnum.getBillap());
        ListSelectedRowCollection listSelectedRows = billList.getSelectedRows();
        if (EmptyCheckUtils.isEmpty((Object)listSelectedRows) || listSelectedRows.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u9009\u4e2d\u8bb0\u5f55", (String)"TioCheckCertListPlugin_2", (String)"taxc-til", (Object[])new Object[0]));
            return;
        }
        Object[] pkids = listSelectedRows.getPrimaryKeyValues();
        for (DynamicObject dynamicObject : dynamicObjects = BusinessDataServiceHelper.load((String)tioCheckCertEnum.getEntityCode(), (String)"id,invoicecode,certstatus,invoiceno,selectstatus,selectresult,authenticateflag", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)pkids)})) {
            if (!BooleanEnum.YES.getCode().equalsIgnoreCase(dynamicObject.getString("selectstatus"))) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff1a\u53d1\u7968\u53f7\u7801\u3010%1$s\u3011\u53d1\u7968\u4ee3\u7801\u3010%2$s\u3011\u72b6\u6001\u4e3a\u3010\u672a\u52fe\u9009\u3011", (String)"TioCheckCertListPlugin_3", (String)"taxc-til", (Object[])new Object[0]), dynamicObject.getString("invoiceno"), dynamicObject.getString("invoicecode")));
                return;
            }
            if (!BooleanEnum.YES.getCode().equalsIgnoreCase(dynamicObject.getString("certstatus"))) continue;
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff1a\u53d1\u7968\u53f7\u7801\u3010%1$s\u3011\u53d1\u7968\u4ee3\u7801\u3010%2$s\u3011\u5df2\u8ba4\u8bc1", (String)"TioCheckCertListPlugin_4", (String)"taxc-til", (Object[])new Object[0]), dynamicObject.getString("invoiceno"), dynamicObject.getString("invoicecode")));
            return;
        }
        for (DynamicObject dynamicObject : dynamicObjects) {
            dynamicObject.set("selectstatus", (Object)BooleanEnum.NO.getCode());
            dynamicObject.set("selectresult", (Object)"0");
        }
        SaveServiceHelper.update((DynamicObject[])dynamicObjects);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"TioCheckCertListPlugin_6", (String)"taxc-til", (Object[])new Object[0]));
    }

    private void checkDeduction(String code) {
        TioCheckCertEnum tioCheckCertEnum = this.getCurrentCheckCertEnum();
        BillList billList = (BillList)this.getControl(tioCheckCertEnum.getBillap());
        ListSelectedRowCollection listSelectedRows = billList.getSelectedRows();
        if (EmptyCheckUtils.isEmpty((Object)listSelectedRows) || listSelectedRows.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u9009\u4e2d\u8bb0\u5f55", (String)"TioCheckCertListPlugin_2", (String)"taxc-til", (Object[])new Object[0]));
            return;
        }
        Object[] pkids = listSelectedRows.getPrimaryKeyValues();
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)tioCheckCertEnum.getEntityCode(), (String)"id,invoiceno,invoicecode,selectstatus,selectresult", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)pkids)});
        List notFitList = Arrays.stream(dynamicObjects).filter(v -> BooleanEnum.YES.getCode().equalsIgnoreCase(v.getString("selectstatus"))).collect(Collectors.toList());
        if (EmptyCheckUtils.isNotEmpty(notFitList)) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff1a\u53d1\u7968\u53f7\u7801\u3010%1$s\u3011\u53d1\u7968\u4ee3\u7801\u3010%2$s\u3011\u72b6\u6001\u4e3a\u3010\u5df2\u52fe\u9009\u3011", (String)"TioCheckCertListPlugin_7", (String)"taxc-til", (Object[])new Object[0]), ((DynamicObject)notFitList.get(0)).getString("invoiceno"), ((DynamicObject)notFitList.get(0)).getString("invoicecode")));
            return;
        }
        for (DynamicObject dynamicObject : dynamicObjects) {
            dynamicObject.set("selectstatus", (Object)BooleanEnum.YES.getCode());
            dynamicObject.set("selectresult", (Object)code);
        }
        SaveServiceHelper.update((DynamicObject[])dynamicObjects);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"TioCheckCertListPlugin_6", (String)"taxc-til", (Object[])new Object[0]));
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String filterTab;
        String tabkey = tabSelectEvent.getTabKey();
        TioCheckCertEnum tioCheckCertEnum = TioCheckCertEnum.getEnumByPageAp(tabkey);
        this.initBoard(tioCheckCertEnum, null);
        String oldselectflexkey = this.getPageCache().get("selectedflexkey");
        if (EmptyCheckUtils.isNotEmpty((Object)oldselectflexkey)) {
            this.getPageCache().remove("selectedflexkey");
            SelectStyleUtil.cancelSelect(oldselectflexkey, this.getView());
        }
        if (null != (filterTab = this.getPageCache().get(FILTER_TAB))) {
            this.refreshCurrentBill(tioCheckCertEnum);
        } else {
            this.refreshCurrentBillWithDefaultCondition(tioCheckCertEnum);
        }
    }

    private void refreshCurrentBillWithDefaultCondition(TioCheckCertEnum tioCheckCertEnum) {
        BillList billList = (BillList)this.getControl(tioCheckCertEnum.getBillap());
        billList.clearSelection();
        List qFilters = billList.getFilterParameter().getQFilters();
        String orgid = this.getPageCache().get("verifyOrg");
        if (EmptyCheckUtils.isEmpty((Object)orgid)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a", (String)"TioCheckCertListPlugin_0", (String)"taxc-til", (Object[])new Object[0]));
        }
        Date date = new Date();
        Date startdate = DateUtils.getFirstDateOfMonth((Date)date);
        Date enddate = DateUtils.getLastDateOfMonth((Date)date);
        QFilter taxperioddateS = new QFilter("taxperioddate", ">=", (Object)startdate);
        qFilters.add(taxperioddateS);
        QFilter taxperioddateE = new QFilter("taxperioddate", "<=", (Object)enddate);
        qFilters.add(taxperioddateE);
        QFilter orgFilter1 = new QFilter("org", "=", (Object)Long.parseLong(orgid));
        qFilters.add(orgFilter1);
        billList.clearSelection();
        billList.refresh();
    }

    private void refreshCurrentBill(TioCheckCertEnum tioCheckCertEnum) {
        String filterTab = this.getPageCache().get(FILTER_TAB);
        BillList filterBillList = (BillList)this.getControl(TioCheckCertEnum.getEnumByPageAp(filterTab).getBillap());
        FilterParameter filterParameter = filterBillList.getFilterParameter();
        BillList billList = (BillList)this.getControl(tioCheckCertEnum.getBillap());
        billList.clearSelection();
        billList.setFilterParameter(filterParameter);
        billList.refresh();
    }

    private boolean initBoard(TioCheckCertEnum tioCheckCertEnum, String orgid) {
        List<QFilter> qFilterList = this.getQFilterList(tioCheckCertEnum, orgid);
        if (EmptyCheckUtils.isEmpty(qFilterList)) {
            return false;
        }
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)tioCheckCertEnum.getEntityCode(), (String)"id,selectstatus,taxamount,selectresult,authdate,certstatus,authenticateflag,isgeneratevoucher", (QFilter[])qFilterList.toArray(new QFilter[0]));
        this.doInitBoard(tioCheckCertEnum, dynamicObjects);
        return true;
    }

    private List<QFilter> getQFilterList(TioCheckCertEnum tioCheckCertEnum, String orgid) {
        Date endDate;
        if (EmptyCheckUtils.isEmpty((Object)orgid) && EmptyCheckUtils.isEmpty((Object)(orgid = this.getPageCache().get("verifyOrg")))) {
            return new ArrayList<QFilter>();
        }
        Date date = new Date();
        int month = DateUtils.getMonthOfDate((Date)date);
        int year = DateUtils.getYearOfDate((Date)date);
        try {
            endDate = RegisterAddressUtil.findZZSMonthApplyEndDate((Object)orgid);
        }
        catch (KDBizException e) {
            this.getView().showErrorNotification(e.getMessage());
            return new ArrayList<QFilter>();
        }
        if (null == endDate) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5b8c\u5584\u7ec4\u7ec7\u4fe1\u606f", (String)"TioCheckCertListPlugin_8", (String)"taxc-til", (Object[])new Object[0]));
        }
        if (DateUtils.getDayFirst((Date)endDate).compareTo(DateUtils.getDayFirst((Date)date)) <= 0 && --month == 0) {
            month = 12;
            --year;
        }
        String cardTitleFormat = ResManager.loadKDString((String)"%1$s\u5e74%2$s\u6708\u7a0e\u671f\u770b\u677f", (String)"TioCheckCertListPlugin_9", (String)"taxc-til", (Object[])new Object[0]);
        String preFlag = tioCheckCertEnum.getCode();
        this.getModel().setValue(preFlag + CARD_TITLE, (Object)String.format(cardTitleFormat, year, month));
        String months = StringUtil.fillCharAtLeft((Object)month, (int)2, (char)'0');
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(2);
        String taxperiod = Stream.of(Integer.valueOf(year), months).map(v -> String.valueOf(v)).collect(Collectors.joining("-"));
        this.getPageCache().put("taxperiod", taxperiod);
        QFilter taxperiodQFilter = new QFilter("taxperiod", "=", (Object)taxperiod);
        qFilters.add(taxperiodQFilter);
        QFilter orgFilter1 = new QFilter("org", "=", (Object)Long.parseLong(orgid));
        qFilters.add(orgFilter1);
        return qFilters;
    }

    private void doInitBoard(TioCheckCertEnum tioCheckCertEnum, DynamicObjectCollection dynamicObjects) {
        Long selcount = 0L;
        BigDecimal seltotal = BigDecimal.ZERO;
        Long selcancount = 0L;
        BigDecimal selcantotal = BigDecimal.ZERO;
        BigDecimal dkseltotal = BigDecimal.ZERO;
        BigDecimal dkseltotal1 = BigDecimal.ZERO;
        BigDecimal dknoseltotal = BigDecimal.ZERO;
        Long authselcount = 0L;
        BigDecimal authseltotal = BigDecimal.ZERO;
        Long authselauthcount = 0L;
        BigDecimal authselauthtotal = BigDecimal.ZERO;
        Long authnoselcount = 0L;
        BigDecimal authnoseltotal = BigDecimal.ZERO;
        BigDecimal ordertotal = BigDecimal.ZERO;
        BigDecimal orderedtotal = BigDecimal.ZERO;
        BigDecimal orderuntotal = BigDecimal.ZERO;
        ArrayList<String> quickIds = new ArrayList<String>(10);
        quickIds.add("-1");
        this.getPageCache().put("kq", quickIds.stream().collect(Collectors.joining(",")));
        for (DynamicObject dynamicObject : dynamicObjects) {
            String authenticateflag;
            Object selectResult;
            Long l;
            Long l2;
            if (BooleanEnum.YES.getCode().equalsIgnoreCase(dynamicObject.getString("selectstatus"))) {
                l2 = selcount;
                l = selcount = Long.valueOf(selcount + 1L);
                seltotal = BigDecimalUtil.addObject((Object)seltotal, (Object)dynamicObject.get(TAX_AMOUNT));
            } else {
                l2 = selcancount;
                l = selcancount = Long.valueOf(selcancount + 1L);
                selcantotal = BigDecimalUtil.addObject((Object)selcantotal, (Object)dynamicObject.get(TAX_AMOUNT));
            }
            if (BooleanEnum.YES.getCode().equalsIgnoreCase(dynamicObject.getString("selectstatus"))) {
                selectResult = dynamicObject.getString("selectresult");
                if (!"0".equalsIgnoreCase((String)selectResult)) {
                    dkseltotal = BigDecimalUtil.addObject((Object)dkseltotal, (Object)dynamicObject.get(TAX_AMOUNT));
                }
                if (BooleanEnum.YES.getCode().equalsIgnoreCase((String)selectResult)) {
                    dkseltotal1 = BigDecimalUtil.addObject((Object)dkseltotal1, (Object)dynamicObject.get(TAX_AMOUNT));
                } else if ("2".equalsIgnoreCase((String)selectResult)) {
                    dknoseltotal = BigDecimalUtil.addObject((Object)dknoseltotal, (Object)dynamicObject.get(TAX_AMOUNT));
                }
            }
            if (BooleanEnum.YES.getCode().equalsIgnoreCase(dynamicObject.getString("selectstatus"))) {
                Long l3;
                selectResult = authselcount;
                l = authselcount = Long.valueOf(authselcount + 1L);
                authseltotal = BigDecimalUtil.addObject((Object)authseltotal, (Object)dynamicObject.get(TAX_AMOUNT));
                authenticateflag = dynamicObject.getString("certstatus");
                if ("1".equalsIgnoreCase(authenticateflag)) {
                    l = authselauthcount;
                    l3 = authselauthcount = Long.valueOf(authselauthcount + 1L);
                    authselauthtotal = BigDecimalUtil.addObject((Object)authselauthtotal, (Object)dynamicObject.get(TAX_AMOUNT));
                } else if ("0".equalsIgnoreCase(authenticateflag)) {
                    l = authnoselcount;
                    l3 = authnoselcount = Long.valueOf(authnoselcount + 1L);
                    authnoseltotal = BigDecimalUtil.addObject((Object)authnoseltotal, (Object)dynamicObject.get(TAX_AMOUNT));
                }
            }
            authenticateflag = dynamicObject.getString("certstatus");
            if (!EmptyCheckUtils.isNotEmpty((Object)dynamicObject.get("authdate")) || !"1".equalsIgnoreCase(authenticateflag) && !"0".equalsIgnoreCase(authenticateflag)) continue;
            String isgeneratevoucher = dynamicObject.getString("isgeneratevoucher");
            ordertotal = BigDecimalUtil.addObject((Object)ordertotal, (Object)dynamicObject.get(TAX_AMOUNT));
            if (BooleanEnum.YES.getCode().equals(isgeneratevoucher)) {
                orderedtotal = BigDecimalUtil.addObject((Object)orderedtotal, (Object)dynamicObject.get(TAX_AMOUNT));
                continue;
            }
            orderuntotal = BigDecimalUtil.addObject((Object)orderuntotal, (Object)dynamicObject.get(TAX_AMOUNT));
        }
        String preFlag = tioCheckCertEnum.getCode();
        this.getModel().setValue(preFlag + SEL_COUNT, (Object)selcount);
        this.getModel().setValue(preFlag + SEL_TOTAL, (Object)seltotal);
        this.getModel().setValue(preFlag + SEL_CAN_COUNT, (Object)selcancount);
        this.getModel().setValue(preFlag + SEL_CAN_TOTAL, (Object)selcantotal);
        this.getModel().setValue(preFlag + DK_SEL_TOTAL, (Object)dkseltotal);
        this.getModel().setValue(preFlag + DK_SEL_TOTAL_1, (Object)dkseltotal1);
        this.getModel().setValue(preFlag + DK_NO_SEL_TOTAL, (Object)dknoseltotal);
        this.getModel().setValue(preFlag + AUTH_SEL_COUNT, (Object)authselcount);
        this.getModel().setValue(preFlag + AUTH_SEL_TOTAL, (Object)authseltotal);
        this.getModel().setValue(preFlag + AUTH_SEL_AUTH_COUNT, (Object)authselauthcount);
        this.getModel().setValue(preFlag + AUTH_SEL_AUTH_TOTAL, (Object)authselauthtotal);
        this.getModel().setValue(preFlag + AUTH_NO_SEL_COUNT, (Object)authnoselcount);
        this.getModel().setValue(preFlag + AUTH_NO_SEL_TOTAL, (Object)authnoseltotal);
        this.getModel().setValue(preFlag + ORDER_TOTAL, (Object)ordertotal);
        this.getModel().setValue(preFlag + ORDERED_TOTAL, (Object)orderedtotal);
        this.getModel().setValue(preFlag + ORDERUN_TOTAL, (Object)orderuntotal);
    }
}

