/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.til.formplugin.total;

import com.alibaba.fastjson.JSONArray;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.chart.PointLineChart;
import kd.bos.form.chart.XAlign;
import kd.bos.form.chart.YAlign;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.address.RegisterAddressUtil;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.tctb.common.util.TreeUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.til.formplugin.entity.IncomeDeduction;
import kd.taxc.til.formplugin.entity.IncomeOutTjDeduction;
import kd.taxc.til.formplugin.helper.IncomeOutTotalChartHelper;

public class TilInvoiceOutTotalPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static String QUERYMORE = "querymore";
    private static final String ENTRYENTITY = "entryentity";
    private static final String TIL_JXDK_QUERY_MORE = "til_jxdk_query_more";
    private static final String TIL_IN_TRANSFER_OUT_BILL = "til_in_transfer_out_bill";
    private static Map<String, List<IncomeDeduction>> cacheIncomeDeductionMap = new HashMap<String, List<IncomeDeduction>>(16);

    public void afterCreateNewData(EventObject e) {
        this.initOrg();
        this.loadInitData();
    }

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbarap"});
        BasedataEdit org = (BasedataEdit)this.getControl("org");
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners(new String[]{QUERYMORE});
    }

    private void loadInitData() {
        Long orgid = Long.parseLong(((DynamicObject)this.getView().getModel().getValue("org")).getString("id"));
        Date date = new Date();
        int month = DateUtils.getMonthOfDate((Date)date);
        int year = DateUtils.getYearOfDate((Date)date);
        Date endDate = null;
        try {
            endDate = RegisterAddressUtil.findZZSMonthApplyEndDate((Object)orgid);
        }
        catch (KDBizException e) {
            this.getView().showErrorNotification(e.getMessage());
            return;
        }
        if (null == endDate) {
            Label sqbdlable = (Label)this.getControl("ljzclable");
            sqbdlable.setText(String.format(ResManager.loadKDString((String)"%1$s\u5e74%2$s\u6708\u7a0e\u671f\u8fdb\u884c\u8f6c\u51fa\u60c5\u51b5", (String)"TilInvoiceOutTotalPlugin_0", (String)"taxc-til", (Object[])new Object[0]), year, month));
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5b8c\u5584\u7ec4\u7ec7\u4fe1\u606f", (String)"TilInvoiceOutTotalPlugin_1", (String)"taxc-til", (Object[])new Object[0]));
        }
        if (DateUtils.getDayFirst((Date)endDate).compareTo(DateUtils.getDayFirst((Date)date)) <= 0 && --month == 0) {
            month = 12;
            --year;
        }
        Label sqbdlable = (Label)this.getControl("ljzclable");
        sqbdlable.setText(String.format(ResManager.loadKDString((String)"%1$s\u5e74%2$s\u6708\u7a0e\u671f\u8fdb\u884c\u8f6c\u51fa\u60c5\u51b5", (String)"TilInvoiceOutTotalPlugin_0", (String)"taxc-til", (Object[])new Object[0]), year, month));
        String months = StringUtil.fillCharAtLeft((Object)month, (int)2, (char)'0');
        String taxperiod = Stream.of(Integer.valueOf(year), months).map(v -> String.valueOf(v)).collect(Collectors.joining("-"));
        this.initThreeCard(DateUtils.stringToDate((String)taxperiod, (String)"yyyy-MM"), orgid);
        this.setZCSSDate(DateUtils.stringToDate((String)taxperiod, (String)"yyyy-MM"));
        this.loadRightData(orgid);
    }

    private void loadRightData(Long orgid) {
        Date zcssqDate = (Date)this.getView().getModel().getValue("zcssdateq");
        Date zcsszDate = (Date)this.getView().getModel().getValue("zcssdatez");
        List monthList = DateUtils.getMonthBetween((Date)zcssqDate, (Date)zcsszDate);
        List monthDateList = monthList.stream().map(s -> DateUtils.getFirstDateOfMonth((Date)DateUtils.stringToDate((String)s, (String)"yyyy-MM"))).collect(Collectors.toList());
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(16);
        QFilter orgFilter = new QFilter("org", "=", (Object)orgid);
        qFilters.add(orgFilter);
        QFilter transferdateQFilter = new QFilter("transferdate", "in", monthDateList);
        qFilters.add(transferdateQFilter);
        DynamicObjectCollection inputdynamicObjects = QueryServiceHelper.query((String)TIL_IN_TRANSFER_OUT_BILL, (String)"entryentity.type as type,entryentity.amount as amount", (QFilter[])qFilters.toArray(new QFilter[0]));
        BigDecimal totalAmount = inputdynamicObjects.stream().map(s -> s.getBigDecimal("amount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        ArrayList<IncomeOutTjDeduction> outList = new ArrayList<IncomeOutTjDeduction>(16);
        for (int i = 2; i <= 11; ++i) {
            int finalI = i;
            BigDecimal jxzcAmount = inputdynamicObjects.stream().filter(a -> (finalI + "").equals(a.getString("type"))).map(s -> s.getBigDecimal("amount")).reduce(BigDecimal.ZERO, BigDecimal::add);
            outList.add(new IncomeOutTjDeduction(i + "", BigDecimal.ZERO, jxzcAmount));
        }
        Collections.sort(outList, new Comparator<IncomeOutTjDeduction>(){

            @Override
            public int compare(IncomeOutTjDeduction entry1, IncomeOutTjDeduction entry2) {
                return entry2.getJxzckse().compareTo(entry1.getJxzckse());
            }
        });
        for (IncomeOutTjDeduction out : outList) {
            if (out.getJxzckse() == BigDecimal.ZERO) {
                out.setJxzcScale(new BigDecimal("0.0000000"));
                continue;
            }
            out.setJxzcScale(out.getJxzckse().divide(totalAmount, 6, 4));
        }
        this.getModel().deleteEntryData(ENTRYENTITY);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(outList)) {
            this.getModel().beginInit();
            for (IncomeOutTjDeduction entry : outList) {
                int row = this.getModel().createNewEntryRow(ENTRYENTITY);
                this.getModel().setValue("jxzclx", (Object)entry.getJxzcType(), row);
                this.getModel().setValue("jxzcse", (Object)entry.getJxzckse(), row);
                this.getModel().setValue("bili", (Object)entry.getJxzcScale(), row);
            }
            this.getModel().endInit();
            this.getView().updateView(ENTRYENTITY);
        }
    }

    private void setZCSSDate(Date date) {
        this.getPageCache().put("refresh", "1");
        this.getView().getModel().setValue("zcssdateq", (Object)DateUtils.getFirstDateOfMonth((Date)date));
        this.getView().getModel().setValue("zcssdatez", (Object)DateUtils.getLastDateOfMonth2((Date)date));
        this.getPageCache().put("refresh", "0");
    }

    private void initThreeCard(Date date, Long orgid) {
        this.setJXZCCard(date, orgid);
    }

    private void showCustomChart(Date date, List<BigDecimal> totalzcseList) {
        Date sixBeforeDate = DateUtils.addMonth((Date)date, (int)-5);
        List monthList = DateUtils.getMonthBetween((Date)sixBeforeDate, (Date)date);
        PointLineChart customchart = this.getMainChart();
        customchart.clearData();
        IncomeOutTotalChartHelper incomeOutTotalChartHelper = new IncomeOutTotalChartHelper();
        incomeOutTotalChartHelper.drawChart(customchart, monthList, totalzcseList);
        customchart.setName(new LocaleString(ResManager.loadKDString((String)"\u8fdb\u9879\u8f6c\u51fa\u8d8b\u52bf", (String)"TilInvoiceOutTotalPlugin_2", (String)"taxc-til", (Object[])new Object[0])));
        customchart.setTitleAlign(XAlign.center, YAlign.top);
        customchart.setShowTooltip(true);
        customchart.refresh();
    }

    private boolean validateDate(Date start, Date end) {
        return null == start || null == end || !start.after(end);
    }

    private PointLineChart getMainChart() {
        PointLineChart barChart = (PointLineChart)this.getView().getControl("pointlinechartap");
        return barChart;
    }

    private void setJXZCCard(Date date, Long orgid) {
        ArrayList<BigDecimal> totalzcseList = new ArrayList<BigDecimal>(16);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(16);
        QFilter orgFilter = new QFilter("org", "=", (Object)orgid);
        qFilters.add(orgFilter);
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)TIL_IN_TRANSFER_OUT_BILL, (String)"signtype,datasource,allocatestate,entryentity.amount as amount", (QFilter[])qFilters.toArray(new QFilter[0]));
        DynamicObjectCollection inputdynamicObjects = null;
        for (int i = 5; i >= 0; --i) {
            inputdynamicObjects = new DynamicObjectCollection();
            for (DynamicObject dynamicObject : dynamicObjects) {
                if (DateUtils.getFirstDateOfMonth((Date)DateUtils.addMonth((Date)date, (int)(-i))).compareTo(dynamicObject.getDate("transferdate")) != 0) continue;
                inputdynamicObjects.add((Object)dynamicObject);
            }
            BigDecimal totalAmount = inputdynamicObjects.stream().map(s -> s.getBigDecimal("amount")).reduce(BigDecimal.ZERO, BigDecimal::add);
            if (i == 0) {
                BigDecimal zjdjzcAmount = inputdynamicObjects.stream().filter(a -> "1".equals(a.getString("signtype"))).map(s -> s.getBigDecimal("amount")).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal djhftzcAmount = inputdynamicObjects.stream().filter(a -> "2".equals(a.getString("signtype")) && "3".equals(a.getString("allocatestate"))).map(s -> s.getBigDecimal("amount")).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal afpdjAmount = inputdynamicObjects.stream().filter(a -> "1".equals(a.getString("datasource"))).map(s -> s.getBigDecimal("amount")).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal sgdjAmount = inputdynamicObjects.stream().filter(a -> "2".equals(a.getString("datasource"))).map(s -> s.getBigDecimal("amount")).reduce(BigDecimal.ZERO, BigDecimal::add);
                this.getView().getModel().setValue("amounttotal", (Object)totalAmount);
                this.getView().getModel().setValue("zjdjzcamount", (Object)zjdjzcAmount);
                this.getView().getModel().setValue("djhftzcamount", (Object)djhftzcAmount);
                this.getView().getModel().setValue("afpdjamount", (Object)afpdjAmount);
                this.getView().getModel().setValue("sgdjamount", (Object)sgdjAmount);
            }
            totalzcseList.add(totalAmount.setScale(2, 4));
        }
        this.showCustomChart(date, totalzcseList);
    }

    public void initialize() {
    }

    private void initOrg() {
        HasPermOrgResult hasPermOrgs = PermissionUtils.getAllPermOrgs((IFormView)this.getView());
        DynamicObjectCollection col = TreeUtils.queryOrgListHasPermission((HasPermOrgResult)hasPermOrgs, (boolean)true);
        Object object = this.getModel().getValue("org");
        if (object == null) {
            Long orgId = RequestContext.get().getOrgId();
            if (!CollectionUtils.isEmpty((Collection)col)) {
                boolean useDefault = false;
                for (DynamicObject obj : col) {
                    if (obj.getLong("id") != orgId.longValue()) continue;
                    this.getModel().setValue("org", (Object)orgId);
                    useDefault = true;
                    break;
                }
                if (!useDefault) {
                    this.getModel().setValue("org", ((DynamicObject)col.get(0)).get("id"));
                } else {
                    this.getModel().setValue("org", (Object)RequestContext.get().getOrgId());
                }
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("refresh".equals(itemKey)) {
            this.initOrg();
            this.loadInitData();
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (QUERYMORE.equals(key)) {
            Date date = DateUtils.addMonth((Date)new Date(), (int)-1);
            String months = StringUtil.fillCharAtLeft((Object)DateUtils.getMonthOfDate((Date)date), (int)2, (char)'0');
            String taxperiod = Stream.of(Integer.valueOf(DateUtils.getYearOfDate((Date)date)), months).map(v -> String.valueOf(v)).collect(Collectors.joining("-"));
            this.showMoreDetails(taxperiod);
        }
    }

    private void showMoreDetails(String taxperiod) {
        FormShowParameter showParameter = new FormShowParameter();
        HashMap<String, String> customParams = new HashMap<String, String>();
        List<IncomeDeduction> currentIncomeDeductionList = cacheIncomeDeductionMap.get(this.getView().getPageId());
        customParams.put("showData", JSONArray.toJSONString(currentIncomeDeductionList));
        showParameter.setCustomParams(customParams);
        showParameter.setCaption(ResManager.loadKDString((String)"2021\u5e742\u6708\u7a0e\u671f\u8fdb\u9879\u62b5\u6263\u6392\u540d", (String)"TilInvoiceOutTotalPlugin_3", (String)"taxc-til", (Object[])new Object[0]));
        showParameter.setFormId(TIL_JXDK_QUERY_MORE);
        showParameter.setParentPageId(this.getView().getPageId());
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if ("org".equals(name)) {
            this.loadInitData();
        } else if ("zcssdateq".equals(name) || "zcssdatez".equals(name)) {
            Boolean isPass;
            ChangeData[] changeSet = e.getChangeSet();
            Date newValue = (Date)changeSet[0].getNewValue();
            Date oldValue = (Date)changeSet[0].getOldValue();
            if (newValue == null) {
                this.getModel().setValue(name, (Object)oldValue);
            }
            if (this.getPageCache().get("refresh") != null && "0".equals(this.getPageCache().get("refresh")) && !(isPass = Boolean.valueOf(this.validateDate((Date)this.getView().getModel().getValue("zcssdateq"), (Date)this.getView().getModel().getValue("zcssdatez")))).booleanValue()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8f6c\u51fa\u6240\u5c5e\u7a0e\u671f\u8d77\u4e0d\u80fd\u5927\u4e8e\u8f6c\u51fa\u6240\u5c5e\u7a0e\u671f\u6b62\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"TilInvoiceOutTotalPlugin_4", (String)"taxc-til", (Object[])new Object[0]));
                return;
            }
            Long orgid = Long.parseLong(((DynamicObject)this.getView().getModel().getValue("org")).getString("id"));
            this.loadRightData(orgid);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
    }

    private List<Long> getOrgListHasPermission() {
        ArrayList<Long> orgIds = new ArrayList<Long>();
        HasPermOrgResult hasPermOrgs = PermissionUtils.getAllPermOrgs((IFormView)this.getView());
        DynamicObjectCollection col = TreeUtils.queryOrgListHasPermission((HasPermOrgResult)hasPermOrgs, (boolean)true);
        if (!CollectionUtils.isEmpty((Collection)col)) {
            for (DynamicObject obj : col) {
                orgIds.add(obj.getLong("id"));
            }
        }
        return orgIds;
    }

    public void beforeClosed(BeforeClosedEvent e) {
        cacheIncomeDeductionMap.remove(this.getView().getPageId());
        super.beforeClosed(e);
    }
}

