/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.til.formplugin.upgrade;

import java.util.Collection;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.til.formplugin.tio.enums.InvoiceSignTypeEnum;

public class IntransferOutBillUpgradeService
implements IUpgradeService {
    private static final String RIM_INV_SPECIAL = "rim_inv_special";
    private static final String RIM_INV_TOLL = "rim_inv_toll";
    UpgradeResult result = new UpgradeResult();
    boolean success = true;

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        this.result.setLog(this.updateData());
        this.result.setSuccess(this.success);
        return this.result;
    }

    private String updateData() {
        QFilter q2;
        String selectFields = "id,org,invoiceid,invoicecode,invoiceno,look,invoicesigntype,invoicetype";
        QFilter q1 = new QFilter("invoiceid", "is null", null).or("invoiceid", "=", (Object)0L);
        DynamicObject[] transferOutBills = BusinessDataServiceHelper.load((String)"til_in_transfer_out_bill", (String)selectFields, (QFilter[])new QFilter[]{q1, q2 = new QFilter("datasource", "=", (Object)"1")});
        if (transferOutBills == null || transferOutBills.length == 0) {
            return ResManager.loadKDString((String)"\u6ca1\u6709\u8981\u5347\u7ea7\u7684\u8fdb\u9879\u8f6c\u51fa\u53d1\u7968\u767b\u8bb0\u6570\u636e", (String)"IntransferOutBillUpgradeService_0", (String)"taxc-til", (Object[])new Object[0]);
        }
        DynamicObject[] dynamicObjectArray = transferOutBills;
        int n = dynamicObjectArray.length;
        for (int i = 0; i < n; ++i) {
            DynamicObject dynamicObject;
            DynamicObject detail = this.getInvoiceDetail(dynamicObject = dynamicObjectArray[i]);
            dynamicObject.set("invoiceid", (Object)(detail != null ? detail.getLong("id") : 0L));
            dynamicObject.set("invoicetype", (Object)(detail != null ? detail.getLong("invoice_type") : 0L));
            dynamicObject.set("look", (Object)ResManager.loadKDString((String)"\u67e5\u770b", (String)"IntransferOutBillUpgradeService_1", (String)"taxc-til", (Object[])new Object[0]));
            dynamicObject.set("invoicesigntype", (Object)InvoiceSignTypeEnum.invoicesign.getType());
        }
        SaveServiceHelper.save((DynamicObject[])transferOutBills);
        return ResManager.loadKDString((String)"\u8fdb\u9879\u8f6c\u51fa\u53d1\u7968\u767b\u8bb0\u6570\u636e\u5347\u7ea7\u6210\u529f", (String)"IntransferOutBillUpgradeService_2", (String)"taxc-til", (Object[])new Object[0]);
    }

    private DynamicObject getInvoiceDetail(DynamicObject dynamicObject) {
        long orgid = dynamicObject.getDynamicObject("org").getLong("id");
        String invoicecode = dynamicObject.getString("invoicecode");
        String invoiceno = dynamicObject.getString("invoiceno");
        QFilter orgIdFilter = new QFilter("tax_org", "=", (Object)orgid);
        QFilter codeFilter = new QFilter("invoice_code", "=", (Object)invoicecode);
        QFilter noFilter = new QFilter("invoice_no", "=", (Object)invoiceno);
        String selectFields = "id,org,tax_org,invoice_type,invoice_code,invoice_no";
        QFilter[] qFilters = new QFilter[]{orgIdFilter, codeFilter, noFilter};
        DynamicObjectCollection query = QueryServiceHelper.query((String)RIM_INV_SPECIAL, (String)selectFields, (QFilter[])qFilters);
        if (!CollectionUtils.isEmpty((Collection)query)) {
            return (DynamicObject)query.get(0);
        }
        DynamicObjectCollection query2 = QueryServiceHelper.query((String)RIM_INV_TOLL, (String)selectFields, (QFilter[])qFilters);
        if (!CollectionUtils.isEmpty((Collection)query2)) {
            return (DynamicObject)query2.get(0);
        }
        return null;
    }
}

