/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.til.formplugin.upgrade;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.upgrade.AbstractUpgradeFormPlugin;
import kd.taxc.bdtaxr.common.util.db.DBUtils;
import kd.taxc.til.formplugin.inputdeduction.enums.NcpJsdkFormEnum;
import org.apache.commons.lang3.StringUtils;

public class NcpEntryUpgradePlugin
extends AbstractUpgradeFormPlugin {
    private static final String QUERY_SQL = "select ttjn.fid id,ttjn.fdatasources datasources,ttjn.ftaxrate taxrate,ttjne.fentryid entryentityid,ttjne.fdataid entryentitydataid\nfrom t_til_jxdk_ncpjsdk ttjn \njoin t_til_jxdk_ncpjsdk_entry ttjne on ttjn.fid = ttjne.fid\nwhere ttjn.fdatasources is not null and ttjn.fdatasources != 'xz'\nand ttjne.fdataid is not null and ttjne.fdataid != ''\nand (ttjne.ffpje is null or ttjne.ffpje = 0)\nand (ttjne.ffpdkse is null or ttjne.ffpdkse = 0);";
    private static final String UPDATE_SQL = "update t_til_jxdk_ncpjsdk_entry set ffpje = ?,ffpdkse = ? where fentryid  = ?;";
    private static final Log LOGGER = LogFactory.getLog(NcpEntryUpgradePlugin.class);

    protected IUpgradeService getService() {
        return this;
    }

    protected Log getLogger() {
        return LOGGER;
    }

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        boolean success = true;
        String log = SUCCESS_INFO;
        String info = SUCCESS_INFO;
        this.addLog(INFO, "NcpEntryUpgradePlugin UPGRADE START");
        long l = System.currentTimeMillis();
        try {
            this.update();
        }
        catch (Throwable t) {
            success = true;
            log = this.currentData + '\n' + ERROR_INFO + '\n';
            info = this.currentData + '\n' + this.getStackTraceMessage(t);
            LOGGER.error(ERROR_INFO, (Object)t.getMessage());
            LOGGER.error(ERROR_INFO, t);
        }
        this.addLog(INFO, String.format("NcpEntryUpgradePlugin UPGRADE END,USE TIME(MS)\uff1a%S", System.currentTimeMillis() - l));
        this.logs.append(log);
        this.logs.append('\n');
        result.setLog(this.logs.toString());
        result.setSuccess(success);
        result.setEl("");
        result.setErrorInfo(info);
        return result;
    }

    private void update() {
        List updatePayList = DBUtils.query((String)QUERY_SQL);
        if (CollectionUtils.isEmpty((Collection)updatePayList)) {
            return;
        }
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(updatePayList.size());
        for (Map updateObj : updatePayList) {
            DynamicObjectCollection invoiceCollect;
            NcpJsdkFormEnum enumByDataSource = NcpJsdkFormEnum.getEnumByDataSource((String)updateObj.get("DATASOURCES"));
            String entryDataId = (String)updateObj.get("ENTRYENTITYDATAID");
            if (enumByDataSource == null || StringUtils.isBlank((CharSequence)entryDataId) || CollectionUtils.isEmpty((Collection)(invoiceCollect = this.queryDatasourceById(entryDataId, enumByDataSource)))) continue;
            BigDecimal fpje = invoiceCollect.stream().map(a -> a.getBigDecimal("detailamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal fpjeParam = fpje.setScale(2, 4);
            BigDecimal fpdkeParam = BigDecimal.ZERO;
            String taxrate = (String)updateObj.get("TAXRATE");
            if (StringUtils.isNotEmpty((CharSequence)taxrate)) {
                fpdkeParam = fpje.multiply(new BigDecimal(taxrate)).setScale(2, 4);
            }
            Long entryIdParam = (Long)updateObj.get("ENTRYENTITYID");
            paramsList.add(new Object[]{fpjeParam, fpdkeParam, entryIdParam});
        }
        if (CollectionUtils.isEmpty(paramsList)) {
            return;
        }
        DBUtils.executeBatch((String)UPDATE_SQL, paramsList);
    }

    private DynamicObjectCollection queryDatasourceById(String id, NcpJsdkFormEnum enu) {
        return QueryServiceHelper.query((String)enu.getEntityName(), (String)enu.getSelectFields(), (QFilter[])new QFilter("id", "=", (Object)Long.parseLong(id)).toArray());
    }
}

