/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.til.formplugin.upgrade;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.control.Button;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.engine.PartitionSaveTask;
import kd.taxc.bdtaxr.common.threadpools.Task;
import kd.taxc.bdtaxr.common.threadpools.ThreadPoolsService;
import kd.taxc.bdtaxr.common.util.date.DateUtils;

public class TransferOutUpgradePlugin
extends AbstractFormPlugin {
    private static final String UPGRADEBTN = "upgradebtn";
    private static final String UPGRADEBTN2 = "upgradebtn2";
    private static final String TAXOFFICE = "taxoffice";
    private static final Map<String, String> INVOICE_TYPE_MAP = new HashMap<String, String>();

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{UPGRADEBTN});
        this.addClickListeners(new String[]{UPGRADEBTN2});
        this.addClickListeners(new String[]{TAXOFFICE});
    }

    public void click(EventObject evt) {
        Button source = (Button)evt.getSource();
        if (source.getKey().equals(UPGRADEBTN)) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u786e\u8ba4\u5347\u7ea7\u9664\u624b\u5de5\u767b\u8bb0\u4ee5\u5916\u7684\u5176\u4ed6\u6570\u636e?", (String)"TransferOutUpgradePlugin_0", (String)"taxc-til", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(source.getKey(), (IFormPlugin)this));
        }
        if (source.getKey().equals(UPGRADEBTN2)) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u786e\u8ba4\u4fee\u590d\u9664\u624b\u5de5\u767b\u8bb0\u4ee5\u5916\u7684\u53d1\u7968\u7c7b\u578b\u4e3a\u7a7a\u7684\u6570\u636e?", (String)"TransferOutUpgradePlugin_1", (String)"taxc-til", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(source.getKey(), (IFormPlugin)this));
        }
        if (source.getKey().equals(TAXOFFICE)) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u786e\u8ba4\u5347\u7ea7\u7533\u62a5\u8868\u7a0e\u52a1\u4e3b\u7ba1\u673a\u5173?", (String)"TransferOutUpgradePlugin_2", (String)"taxc-til", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(source.getKey(), (IFormPlugin)this));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        List<DynamicObject> dynamicObjectList;
        DynamicObject[] transferOutCollection;
        if (event.getCallBackId().equals(UPGRADEBTN) && 6 == event.getResult().getValue() && Objects.equals(UPGRADEBTN, event.getCallBackId())) {
            transferOutCollection = QueryServiceHelper.query((String)"til_in_transfer_out_bill", (String)"invoicetype,invoiceid,invoicecode,invoiceno,entryentity.type as type, entryentity.amount as amount, transferdate", (QFilter[])new QFilter[]{new QFilter("datasource", "!=", (Object)"2"), new QFilter("invoicetype", "is not null", null)});
            Map<String, List<DynamicObject>> codeAndNoCollect = transferOutCollection.stream().collect(Collectors.groupingBy(t -> t.getString("invoicecode") + t.getString("invoiceno")));
            Map<String, List<DynamicObject>> invoiceTypeMap = transferOutCollection.stream().collect(Collectors.groupingBy(t -> t.getString("invoicetype")));
            ArrayList serialNo = new ArrayList();
            for (Map.Entry<String, List<DynamicObject>> stringListEntry : invoiceTypeMap.entrySet()) {
                DynamicObject[] invoiceid = stringListEntry.getValue().stream().map(i -> i.getLong("invoiceid")).collect(Collectors.toList());
                if (invoiceid.size() == 0) continue;
                DynamicObjectCollection invoiceDetailCollection = QueryServiceHelper.query((String)INVOICE_TYPE_MAP.get(stringListEntry.getKey()), (String)"serial_no", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)invoiceid)});
                serialNo.addAll(invoiceDetailCollection.stream().map(i -> i.getString("serial_no")).collect(Collectors.toList()));
            }
            DynamicObject[] load = BusinessDataServiceHelper.load((String)"rim_invoice", (String)"id,invoice_code,invoice_no,output_signtype,output_type,real_output_amount,real_transferdate", (QFilter[])new QFilter[]{new QFilter("serial_no", "in", serialNo), new QFilter("real_transferdate", "is null", null)});
            StringBuilder buffer = new StringBuilder();
            for (DynamicObject object : load) {
                dynamicObjectList = codeAndNoCollect.get(object.getString("invoice_code") + object.getString("invoice_no"));
                if (null == dynamicObjectList || dynamicObjectList.size() == 0) continue;
                buffer.append(object.getString("invoice_code")).append('-').append(object.getString("invoice_no")).append(ResManager.loadKDString((String)" \u8f6c\u51fa\u7c7b\u578b", (String)"TransferOutUpgradePlugin_3", (String)"taxc-til", (Object[])new Object[0])).append(':').append(dynamicObjectList.get(0).getString("type")).append(ResManager.loadKDString((String)" \u5b9e\u9645\u8f6c\u51fa\u7a0e\u989d", (String)"TransferOutUpgradePlugin_4", (String)"taxc-til", (Object[])new Object[0])).append(':').append(dynamicObjectList.get(0).getBigDecimal("amount")).append(ResManager.loadKDString((String)" \u5b9e\u9645\u8f6c\u51fa\u7a0e\u671f", (String)"TransferOutUpgradePlugin_5", (String)"taxc-til", (Object[])new Object[0])).append(':').append(dynamicObjectList.get(0).getDate("transferdate")).append("\n\n");
                object.set("output_signtype", (Object)"1");
                object.set("output_type", (Object)dynamicObjectList.get(0).getString("type"));
                object.set("real_output_amount", (Object)dynamicObjectList.get(0).getBigDecimal("amount"));
                object.set("real_transferdate", (Object)DateUtils.stringToDate((String)DateUtils.formatMonth((Date)dynamicObjectList.get(0).getDate("transferdate")), (String)"yyyy-MM"));
            }
            ThreadPoolsService.getInstance().submit((Task)new PartitionSaveTask(Arrays.asList(load)));
            this.getModel().setValue("textareafield", (Object)"");
            this.getModel().setValue("textareafield", (Object)buffer.toString());
        }
        if (event.getCallBackId().equals(UPGRADEBTN2) && 6 == event.getResult().getValue() && (transferOutCollection = BusinessDataServiceHelper.load((String)"til_in_transfer_out_bill", (String)"billno,invoicetype,invoiceid,invoicecode,invoiceno,entryentity.type as type, entryentity.amount as amount, transferdate", (QFilter[])new QFilter[]{new QFilter("datasource", "!=", (Object)"2"), new QFilter("invoicetype", "=", (Object)0L).or(new QFilter("invoiceid", "=", (Object)0L))})).length > 0) {
            StringBuilder buffer = new StringBuilder();
            ArrayList<String> invoiceCode = new ArrayList<String>(transferOutCollection.length);
            ArrayList<String> invoiceNo = new ArrayList<String>(transferOutCollection.length);
            for (DynamicObject object : transferOutCollection) {
                invoiceCode.add(object.getString("invoicecode"));
                invoiceNo.add(object.getString("invoiceno"));
            }
            DynamicObjectCollection invoices = QueryServiceHelper.query((String)"rim_invoice", (String)"id,invoice_type,invoice_code,invoice_no", (QFilter[])new QFilter[]{new QFilter("invoice_code", "in", invoiceCode).and(new QFilter("invoice_no", "in", invoiceNo))});
            Map<String, List<DynamicObject>> codeAndNoCollect = invoices.stream().collect(Collectors.groupingBy(t -> t.getString("invoice_code") + t.getString("invoice_no")));
            for (DynamicObject invoice : transferOutCollection) {
                dynamicObjectList = codeAndNoCollect.get(invoice.getString("invoicecode") + invoice.getString("invoiceno"));
                if (null == dynamicObjectList || dynamicObjectList.size() <= 0) continue;
                buffer.append(invoice.getString("billno")).append('-').append(invoice.getString("invoicecode")).append('-').append(invoice.getString("invoiceno")).append("\n\n");
                invoice.set("invoiceid", (Object)dynamicObjectList.get(0).getLong("id"));
                invoice.set("invoicetype", (Object)dynamicObjectList.get(0).getLong("invoice_type"));
            }
            ThreadPoolsService.getInstance().submit((Task)new PartitionSaveTask(Arrays.asList(transferOutCollection)));
            this.getModel().setValue("textareafield", (Object)"");
            this.getModel().setValue("textareafield", (Object)buffer.toString());
        }
        if (event.getCallBackId().equals(TAXOFFICE) && 6 == event.getResult().getValue()) {
            QFilter taxauthorityFilter = new QFilter("taxauthority", "=", (Object)0L).and("type", "in", Arrays.asList("draft_zzsxgmnsr", "draft_zzsybnsr", "draft_zzsybnsr_ybhz", "fjsf", "qysds_hdzs_nb", "qysdsjb", "qysdsnb", "qysdsnb_dg", "zzsaccount", "zzsaccountmonth", "zzsxgmnsr", "zzsybnsr", "zzsybnsr_ybhz", "zzsyjskb")).and(new QFilter("org", "!=", (Object)0L));
            DynamicObject[] declareMainArray = BusinessDataServiceHelper.load((String)"tcvat_nsrxx", (String)"taxauthority,org,type,skssqq,skssqz", (QFilter[])new QFilter[]{taxauthorityFilter});
            if (declareMainArray.length == 0) {
                return;
            }
            List orgList = Arrays.stream(declareMainArray).filter(d -> null != d.getDynamicObject("org")).map(d -> d.getDynamicObject("org").getLong("id")).collect(Collectors.toList());
            QFilter orgListFilter = new QFilter("taxorg", "in", orgList);
            DynamicObjectCollection taxMainCollection = QueryServiceHelper.query((String)"tctb_tax_main", (String)"taxoffice,taxorg", (QFilter[])new QFilter[]{orgListFilter});
            Map<String, Long> orgToOfficeMap = taxMainCollection.stream().collect(Collectors.toMap(k -> k.getString("taxorg"), v -> v.getLong(TAXOFFICE), (k1, k2) -> k1));
            StringBuilder buffer = new StringBuilder();
            for (DynamicObject object : declareMainArray) {
                if (null == object.getDynamicObject("org")) {
                    buffer.append(object.getString("type")).append('-').append(DateUtils.formatMonth((Date)object.getDate("skssqq"))).append('-').append(DateUtils.formatMonth((Date)object.getDate("skssqz"))).append('-').append("org is null").append("\n\n");
                    continue;
                }
                Long taxauthority = orgToOfficeMap.get(object.getDynamicObject("org").getString("id"));
                if (null == taxauthority) {
                    buffer.append(object.getDynamicObject("org").getString("name")).append('-').append("taxoffice is null").append("\n\n");
                    continue;
                }
                object.set("taxauthority", (Object)taxauthority);
            }
            ThreadPoolsService.getInstance().submit((Task)new PartitionSaveTask(Arrays.asList(declareMainArray)));
            this.getModel().setValue("textareafield", (Object)"");
            this.getModel().setValue("textareafield", (Object)buffer.toString());
        }
    }

    static {
        INVOICE_TYPE_MAP.put("961639304377984000", "rim_inv_special");
        INVOICE_TYPE_MAP.put("961640097369875456", "rim_inv_special");
        INVOICE_TYPE_MAP.put("961634333825754112", "rim_inv_ordinary");
        INVOICE_TYPE_MAP.put("961642468384760832", "rim_inv_toll");
        INVOICE_TYPE_MAP.put("961641064953820160", "rim_inv_air");
        INVOICE_TYPE_MAP.put("961640926684439552", "rim_inv_train");
        INVOICE_TYPE_MAP.put("961642651029877760", "rim_inv_transport");
    }
}

