/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.til.formplugin.withholdingtax;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.address.RegisterAddressUtil;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;

public class WithholdingTaxListPlugin
extends AbstractListPlugin {
    private static final String NONE = "none";
    private static final String ORG_ID = "org.id";
    private static final String ACTIVE_KEY = "active_key";
    private static final String BILLLISTAP = "billlistap";
    private static final String CACHE_ORG = "cache_org";
    private static final String CARD_TITLE = "cardtitle";
    private static final String CACHE_PERIOD = "cache_period";
    private static final String CACHE_ORG_ID = "orgIdCache";
    private static final String TIL_WITHHOLDING_TAX = "til_withholding_tax";
    private static final Map<String, String> initMap = new HashMap<String, String>();
    private static final List<String> cardNames = Arrays.asList("cp421", "cp521");

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbarap"});
        for (String clickCard : cardNames) {
            this.addClickListeners(new String[]{clickCard});
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"cp1", "cp2", "cp3"});
        this.initCardDatas();
        if (StringUtils.isEmpty((CharSequence)this.getPageCache().get("init"))) {
            String orgId = this.getPageCache().get(CACHE_ORG_ID);
            this.doLoadingBoard(orgId);
            this.getPageCache().put("init", "true");
        }
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (cardNames.contains(key)) {
            this.getPageCache().put(ACTIVE_KEY, key);
            List<QFilter> qFilters = this.addFilters(key);
            BillList billList = (BillList)this.getControl(BILLLISTAP);
            billList.getFilterParameter().setQFilters(qFilters);
            billList.getClientQueryFilterParameter().setQFilters(qFilters);
            billList.getQueryFilterParameter().setQFilters(qFilters);
            billList.clearSelection();
            billList.refresh();
        }
    }

    private List<QFilter> addFilters(String key) {
        String orgId = this.getPageCache().get(CACHE_ORG);
        String periodStr = this.getPageCache().get(CACHE_PERIOD);
        Date periodDate = DateUtils.stringToDate((String)periodStr);
        Date startDate = null;
        startDate = "cp521".equals(key) ? DateUtils.getFirstDateOfYear((Date)periodDate) : DateUtils.getFirstDateOfMonth((Date)periodDate);
        Date endDate = DateUtils.getLastDateOfMonth((Date)periodDate);
        List<QFilter> qFilters = this.getFilters(Long.parseLong(orgId), startDate, endDate);
        return qFilters;
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        this.getPageCache().put(ACTIVE_KEY, NONE);
        List commonFilterColumns = args.getCommonFilterColumns();
        CommonFilterColumn orgColumn = null;
        for (FilterColumn column : commonFilterColumns) {
            if (!column.getFieldName().startsWith("org.")) continue;
            orgColumn = (CommonFilterColumn)column;
        }
        if (orgColumn != null) {
            List<ComboItem> orgCombos = this.getOrgComboItem();
            if (!orgCombos.isEmpty()) {
                orgColumn.setDefaultValue(orgCombos.get(0).getValue());
                this.getPageCache().put(CACHE_ORG_ID, orgCombos.get(0).getValue());
            }
            orgColumn.setType("enum");
            orgColumn.setMustInput(true);
            orgColumn.setComboItems(orgCombos);
        }
    }

    public void afterBindData(EventObject e) {
    }

    public void afterDoOperation(AfterDoOperationEventArgs eventArgs) {
        String operateKey = eventArgs.getOperateKey();
        if ("delete".equals(operateKey)) {
            this.refreshData();
        }
    }

    private void refreshData() {
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        billList.refresh();
        this.doLoadingBoard(this.getPageCache().get(CACHE_ORG_ID));
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs searchClickEvent) {
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        Map map = searchClickEvent.getFilterValues();
        List fastlist = (List)map.get("fastfilter");
        List customlist = (List)map.get("customfilter");
        List schemelist = (List)map.get("schemefilter");
        FilterParameter fastFilterParameter = searchClickEvent.getFilterModel().getFastFilterParameter(fastlist);
        List fastQFilterList = fastFilterParameter.getQFilters();
        FilterParameter commonFilterParameter = searchClickEvent.getFilterModel().getCommonFilterParameter(customlist);
        List commonQFilterList = commonFilterParameter.getQFilters();
        FilterParameter schemaFilterParameter = searchClickEvent.getFilterModel().getSchemeFilterParameter(schemelist);
        List schemaQFilterList = schemaFilterParameter.getQFilters();
        fastQFilterList.addAll(commonQFilterList);
        fastQFilterList.addAll(schemaQFilterList);
        String orgId = this.getSchemaOrg(fastFilterParameter.getQFilters());
        if ("EMPTY".equals(orgId) || "null".equals(orgId)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WithholdingTaxListPlugin_4", (String)"taxc-til", (Object[])new Object[0]));
            return;
        }
        this.getPageCache().put(CACHE_ORG_ID, orgId);
        String oldOrgId = this.getPageCache().get(CACHE_ORG);
        if (orgId != null && !orgId.equals(oldOrgId)) {
            this.doLoadingBoard(orgId);
        }
        billList.setFilterParameter(fastFilterParameter);
        billList.clearSelection();
        billList.refresh();
    }

    private String getSchemaOrg(List<QFilter> qFilters) {
        Object org = null;
        QFilter orgFilter = null;
        for (QFilter filter : qFilters) {
            if (ORG_ID.equals(filter.getProperty()) || "org".equals(filter.getProperty())) {
                org = filter.getValue();
                break;
            }
            if (!"org.number".equals(filter.getProperty()) || "is not null".equals(filter.getCP())) continue;
            orgFilter = new QFilter("number", filter.getCP(), filter.getValue());
        }
        if (org == null && orgFilter != null) {
            DynamicObject orgObj = QueryServiceHelper.queryOne((String)"bos_org", (String)"id", (QFilter[])new QFilter[]{orgFilter});
            org = orgObj.getString("id");
        }
        return String.valueOf(org);
    }

    private List<ComboItem> getOrgComboItem() {
        String orgListCache = "orgListCache";
        String orgListCacheString = this.getPageCache().get(orgListCache);
        List orgList = new ArrayList();
        if (orgListCacheString == null || org.apache.commons.lang3.StringUtils.equals((CharSequence)orgListCacheString, (CharSequence)"[]")) {
            orgList = OrgUtils.queryOrgListForInitOrgComboItems((IFormView)this.getView(), (String[])new String[]{TIL_WITHHOLDING_TAX}, null, null);
            this.getPageCache().put(orgListCache, SerializationUtils.toJsonString(orgList));
        } else {
            orgList = (List)SerializationUtils.fromJsonString((String)orgListCacheString, orgList.getClass());
        }
        return OrgUtils.getComboItems(orgList);
    }

    private void setClickStyle(String key) {
        for (String card : cardNames) {
            if (card.equals(key)) {
                this.setCardPanelStyle(key, true);
                continue;
            }
            this.setCardPanelStyle(card, false);
        }
    }

    private void setCardPanelStyle(String key, boolean isActive) {
        HashMap map = new HashMap(8);
        HashMap styleMap = new HashMap();
        HashMap<String, String> borderMap = new HashMap<String, String>();
        if (isActive) {
            borderMap.put("b", "2px_solid_#5582F3");
        } else {
            borderMap.put("b", "1px_solid_#d9d9d9");
        }
        styleMap.put("b", borderMap);
        map.put("s", styleMap);
        this.getView().updateControlMetadata(key, map);
    }

    public void setFilter(SetFilterEvent e) {
        String activeKey = this.getPageCache().get(ACTIVE_KEY);
        if (StringUtils.isNotBlank((CharSequence)activeKey)) {
            this.setClickStyle(activeKey);
            if (!NONE.equals(activeKey)) {
                List qFilters = e.getQFilters();
                int size = qFilters.size();
                for (int i = 0; i < size; ++i) {
                    qFilters.remove(0);
                }
                qFilters.addAll(this.addFilters(activeKey));
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        if ("tblrefresh".equals(evt.getItemKey())) {
            this.getPageCache().put(ACTIVE_KEY, NONE);
            this.setClickStyle(NONE);
            this.refreshData();
        }
    }

    private void doLoadingBoard(Object org) {
        if (org != null) {
            this.getPageCache().put(CACHE_ORG, String.valueOf(org));
            Date taxPeriod = this.getTaxPeriod(org);
            if (taxPeriod == null) {
                return;
            }
            this.setCardTitle(taxPeriod);
            this.getView().updateView(CARD_TITLE);
            this.getPageCache().put(CACHE_PERIOD, DateUtils.format((Date)taxPeriod));
            Date startDate = DateUtils.getFirstDateOfMonth((Date)taxPeriod);
            Date endDate = DateUtils.getLastDateOfMonth((Date)taxPeriod);
            DynamicObjectCollection resultCol = this.queryDatas(org, DateUtils.getFirstDateOfYear((Date)taxPeriod), endDate);
            BigDecimal curAmount = BigDecimal.ZERO;
            BigDecimal yearAmount = BigDecimal.ZERO;
            for (DynamicObject obj : resultCol) {
                Date itemPeriod = obj.getDate("period");
                BigDecimal amount = obj.getBigDecimal("actualpayment");
                if (itemPeriod != null && itemPeriod.compareTo(startDate) >= 0) {
                    curAmount = curAmount.add(amount);
                }
                yearAmount = yearAmount.add(amount);
            }
            this.getModel().setValue("cp4_value1", (Object)curAmount.setScale(2, 4));
            this.getModel().setValue("cp5_value1", (Object)yearAmount.setScale(2, 4));
            this.getView().updateView("cp4_value1");
            this.getView().updateView("cp5_value1");
        }
    }

    private DynamicObjectCollection queryDatas(Object org, Date startDate, Date endDate) {
        String orgId = String.valueOf(org);
        List<QFilter> qFilters = this.getFilters(Long.parseLong(orgId), startDate, endDate);
        DynamicObjectCollection col = QueryServiceHelper.query((String)TIL_WITHHOLDING_TAX, (String)"id,period,withholdingitems.actualpayment as actualpayment", (QFilter[])qFilters.toArray(new QFilter[qFilters.size()]));
        return col;
    }

    private void setCardTitle(Date date) {
        String titleFormat = ResManager.loadKDString((String)"%1$s\u5e74%2$s\u6708\u7a0e\u671f\u770b\u677f", (String)"WithholdingTaxListPlugin_5", (String)"taxc-til", (Object[])new Object[0]);
        this.getModel().setValue(CARD_TITLE, (Object)String.format(titleFormat, DateUtils.getYearOfDate((Date)date), DateUtils.getMonthOfDate((Date)date)));
    }

    private List<QFilter> getFilters(Long orgId, Date startDate, Date endDate) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("org", "=", (Object)orgId));
        qFilters.add(new QFilter("period", ">=", (Object)startDate));
        qFilters.add(new QFilter("period", "<", (Object)endDate));
        qFilters.add(new QFilter("withholdingitems.taxtype", "=", (Object)"zzs"));
        return qFilters;
    }

    private Date getTaxPeriod(Object org) {
        try {
            Date endDate = RegisterAddressUtil.findZZSMonthApplyEndDate((Object)org);
            if (endDate == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5b8c\u5584\u7ec4\u7ec7\u4fe1\u606f\u3002", (String)"WithholdingTaxListPlugin_6", (String)"taxc-til", (Object[])new Object[0]));
                return null;
            }
            endDate = DateUtils.stringToDate((String)DateUtils.format((Date)endDate));
            Date periodDate = DateUtils.stringToDate((String)DateUtils.format((Date)new Date()));
            if (endDate.getTime() >= periodDate.getTime()) {
                periodDate = DateUtils.addMonth((Date)periodDate, (int)-1);
            }
            return periodDate;
        }
        catch (Exception e) {
            this.getView().showErrorNotification(e.getMessage());
            return null;
        }
    }

    private void initCardDatas() {
        for (Map.Entry<String, String> entry : initMap.entrySet()) {
            Label itemLabel = (Label)this.getControl(entry.getKey());
            itemLabel.setText(entry.getValue());
        }
        this.setCardTitle(new Date());
    }

    static {
        initMap.put("cp4_title", ResManager.loadKDString((String)"\u672c\u671f\u589e\u503c\u7a0e\u62b5\u6263\u60c5\u51b5", (String)"WithholdingTaxListPlugin_0", (String)"taxc-til", (Object[])new Object[0]));
        initMap.put("cp4_name1", ResManager.loadKDString((String)"\u672c\u671f\u5df2\u62b5\u6263", (String)"WithholdingTaxListPlugin_1", (String)"taxc-til", (Object[])new Object[0]));
        initMap.put("cp5_title", ResManager.loadKDString((String)"\u672c\u5e74\u589e\u503c\u7a0e\u62b5\u6263\u60c5\u51b5", (String)"WithholdingTaxListPlugin_2", (String)"taxc-til", (Object[])new Object[0]));
        initMap.put("cp5_name1", ResManager.loadKDString((String)"\u672c\u5e74\u5df2\u62b5\u6263", (String)"WithholdingTaxListPlugin_3", (String)"taxc-til", (Object[])new Object[0]));
    }
}

