/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.til.servicehelper;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.instance.Instance;

public class ServiceFactory {
    private static Map<String, String> serviceMap = new ConcurrentHashMap<String, String>();

    public static Object getService(String serviceName) {
        String className = serviceMap.get(serviceName);
        if (className == null) {
            String appName = Instance.getAppName();
            String clusterName = Instance.getClusterName();
            throw new RuntimeException(String.format(ResManager.loadKDString((String)"%1$s\u5bf9\u5e94\u7684\u670d\u52a1\u5b9e\u73b0\u5728%2$s: %3$s\u672a\u627e\u5230", (String)"ServiceFactory_0", (String)"taxc-til-mservice", (Object[])new Object[0]), serviceName, clusterName, appName));
        }
        return TypesContainer.getOrRegisterSingletonInstance((String)className);
    }

    public static <T> T getService(Class<T> clazz) {
        return (T)ServiceFactory.getService(clazz.getSimpleName());
    }

    public static void setServiceMap(String serviceName, String serviceImpl) {
        serviceMap.put(serviceName, serviceImpl);
    }

    static {
        serviceMap.put("IntransferOutBillUpgradeService", "kd.taxc.til.formplugin.upgrade.IntransferOutBillUpgradeService");
        serviceMap.put("NcpEntryUpgradePlugin", "kd.taxc.til.formplugin.upgrade.NcpEntryUpgradePlugin");
        serviceMap.put("JsdjbmUpdateService", "kd.taxc.til.formplugin.upgrade.JsdjbmUpdateService");
    }
}

