/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.totf.mservice.upgrade;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.taxc.bdtaxr.common.i18n.MultiLangEnumBridge;
import kd.taxc.bdtaxr.common.upgrade.AbstractUpgradeFormPlugin;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.db.DBUtils;

public class InvoiceNameUpgradeService
extends AbstractUpgradeFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(InvoiceNameUpgradeService.class);
    private static final String SQL_SELECT2 = "select fentryid,ffconditionjson,ffiltercondition from TABLENAME where ffiltercondition like '%INVOICENAME%' and ftable in (1163062995127970816,1407439936361095168,1407464068331102208);";
    private static final Map<MultiLangEnumBridge, MultiLangEnumBridge> replaceMap = new HashMap<MultiLangEnumBridge, MultiLangEnumBridge>();

    protected IUpgradeService getService() {
        return this;
    }

    protected Log getLogger() {
        return LOGGER;
    }

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        boolean success = true;
        String log = SUCCESS_INFO;
        String info = SUCCESS_INFO;
        this.addLog(INFO, "DATA UPGRADE START");
        long l = System.currentTimeMillis();
        try {
            this.update();
        }
        catch (Throwable t) {
            success = true;
            log = this.currentData + '\n' + ERROR_INFO + '\n';
            info = this.currentData + '\n' + this.getStackTraceMessage(t);
            LOGGER.error(ERROR_INFO, t);
        }
        this.addLog(INFO, String.format("DATA UPGRADE END,USE TIME(MS)\uff1a%S", System.currentTimeMillis() - l));
        this.logs.append(log);
        this.logs.append('\n');
        result.setLog(this.logs.toString());
        result.setSuccess(success);
        result.setEl("");
        result.setErrorInfo(info);
        return result;
    }

    private void update() {
        this.updateTable("t_totf_rule_wafund_entity", SQL_SELECT2);
        this.updateTable("t_totf_rule_whsy_entity", SQL_SELECT2);
    }

    private void updateTable(String table, String seclet) {
        for (Map.Entry<MultiLangEnumBridge, MultiLangEnumBridge> entry : replaceMap.entrySet()) {
            String oldName = entry.getKey().loadKDString();
            String newName = entry.getValue().toString();
            List query1 = DBUtils.query((String)seclet.replace("TABLENAME", table).replace("INVOICENAME", oldName));
            if (!EmptyCheckUtils.isNotEmpty((Object)query1)) continue;
            for (Map map : query1) {
                StringBuilder updateSql = new StringBuilder(String.format("update %s set ", table));
                int i = 0;
                for (Map.Entry objectEntry : map.entrySet()) {
                    if ("FENTRYID".equalsIgnoreCase((String)objectEntry.getKey())) continue;
                    String value = (String)objectEntry.getValue();
                    String replace = value.replace(oldName, newName);
                    updateSql.append((String)objectEntry.getKey()).append("= '").append(replace).append("'");
                    if (i == 0) {
                        updateSql.append(",");
                    }
                    ++i;
                }
                updateSql.append("where fentryid = ").append(map.get("FENTRYID"));
                DBUtils.execute((String)updateSql.toString());
            }
        }
    }

    static {
        replaceMap.put(new MultiLangEnumBridge("\u5168\u7535\u666e\u7968", "InvoiceNameUpgradeService_0", "taxc-totf-mservice"), new MultiLangEnumBridge("\u6570\u7535\u7968\uff08\u666e\u901a\u53d1\u7968\uff09", "InvoiceNameUpgradeService_1", "taxc-totf-mservice"));
        replaceMap.put(new MultiLangEnumBridge("\u5168\u7535\u4e13\u7968", "InvoiceNameUpgradeService_2", "taxc-totf-mservice"), new MultiLangEnumBridge("\u6570\u7535\u7968\uff08\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968\uff09", "InvoiceNameUpgradeService_3", "taxc-totf-mservice"));
    }
}

