/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.totf.mservice.upgrade;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.db.DBUtils;

public class JsxzsyTaxbookDataUpgradeService
implements IUpgradeService {
    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setSuccess(true);
        result.setLog(this.update());
        return result;
    }

    private String update() {
        try {
            String selectSql = "select fid,fstartdate,fenddate from t_totf_jsxzsyxsf_account;";
            String updateYearSql = "update t_totf_jsxzsyxsf_account set fpayperiod = 'year' where fid = ?;";
            String updateHalfyearSql = "update t_totf_jsxzsyxsf_account set fpayperiod = 'halfyear' where fid = ?;";
            String updateSeasonSql = "update t_totf_jsxzsyxsf_account set fpayperiod = 'season' where fid = ?;";
            String updateMonthSql = "update t_totf_jsxzsyxsf_account set fpayperiod = 'month' where fid = ?;";
            List jsxzsyDataList = DBUtils.query((String)selectSql);
            if (!CollectionUtils.isEmpty((Collection)jsxzsyDataList)) {
                ArrayList<Object[]> yearParamList = new ArrayList<Object[]>(jsxzsyDataList.size());
                ArrayList<Object[]> halfyearParamList = new ArrayList<Object[]>(jsxzsyDataList.size());
                ArrayList<Object[]> seasonParamList = new ArrayList<Object[]>(jsxzsyDataList.size());
                ArrayList<Object[]> monthParamList = new ArrayList<Object[]>(jsxzsyDataList.size());
                for (Map row : jsxzsyDataList) {
                    String taxLimit;
                    Object fid = row.get("FID");
                    Date fstartdate = (Date)row.get("FSTARTDATE");
                    Date fenddate = (Date)row.get("FENDDATE");
                    switch (taxLimit = DateUtils.getTaxLimit((Date)fstartdate, (Date)fenddate)) {
                        case "year": {
                            yearParamList.add(new Object[]{fid});
                            break;
                        }
                        case "halfyear": {
                            halfyearParamList.add(new Object[]{fid});
                            break;
                        }
                        case "season": {
                            seasonParamList.add(new Object[]{fid});
                            break;
                        }
                        case "month": {
                            monthParamList.add(new Object[]{fid});
                        }
                    }
                }
                if (EmptyCheckUtils.isNotEmpty(yearParamList)) {
                    DBUtils.executeBatch((String)"taxc", (String)updateYearSql, yearParamList);
                }
                if (EmptyCheckUtils.isNotEmpty(halfyearParamList)) {
                    DBUtils.executeBatch((String)"taxc", (String)updateHalfyearSql, halfyearParamList);
                }
                if (EmptyCheckUtils.isNotEmpty(seasonParamList)) {
                    DBUtils.executeBatch((String)"taxc", (String)updateSeasonSql, seasonParamList);
                }
                if (EmptyCheckUtils.isNotEmpty(monthParamList)) {
                    DBUtils.executeBatch((String)"taxc", (String)updateMonthSql, monthParamList);
                }
            }
            return ResManager.loadKDString((String)"\u6570\u636e\u5347\u7ea7\u6210\u529f", (String)"JsxzsyTaxbookDataUpgradeService_1", (String)"taxc-totf-mservice", (Object[])new Object[0]);
        }
        catch (Exception e) {
            String code = ((KDException)e).getErrorCode().getCode();
            if ("bos.sQLTableNotExist".equals(code)) {
                return ResManager.loadKDString((String)"\u8868\u4e0d\u5b58\u65e0\u9700\u66f4\u540c\u6b65\u6570\u636e", (String)"JsxzsyTaxbookDataUpgradeService_2", (String)"taxc-totf-mservice", (Object[])new Object[0]);
            }
            boolean column = e.getMessage().contains("column");
            if (column) {
                return ResManager.loadKDString((String)"\u5b57\u6bb5\u4e0d\u5b58\u65e0\u9700\u66f4\u540c\u6b65\u6570\u636e", (String)"JsxzsyTaxbookDataUpgradeService_3", (String)"taxc-totf-mservice", (Object[])new Object[0]);
            }
            return e.getLocalizedMessage();
        }
    }
}

