/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.totf.mservice.upgrade;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.taxc.bdtaxr.common.upgrade.AbstractUpgradeFormPlugin;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.db.DBUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public class TaxbookNewDataUpgradeService
extends AbstractUpgradeFormPlugin {
    public static final String T_TOTF_OTHERINCOME = "t_totf_otherincome";
    public static final String T_TOTF_JSXZSYXSF_ACCOUNT = "t_totf_jsxzsyxsf_account";
    public static final String T_TOTF_WATER_FUND = "t_totf_water_fund";
    public static final String FSOURCEDATA = "fsourcedata";
    public static final String TAXC = "taxc";
    private Log LOGGER = LogFactory.getLog(TaxbookNewDataUpgradeService.class);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setSuccess(true);
        result.setLog("TaxbookNewDataUpgradeService start");
        try (TXHandle h = TX.required();){
            try {
                List<Object[]> paramList2;
                List<Object[]> paramList;
                if (DB.existColumn((DBRoute)DBRoute.of((String)TAXC), (String)T_TOTF_OTHERINCOME, (String)FSOURCEDATA) && (paramList = this.getParamList(T_TOTF_OTHERINCOME, "GHJF")).size() > 0) {
                    DBUtils.executeBatch((String)"update t_totf_otherincome set fsourcedata=?,fbillno =? where fid =?;", paramList);
                }
                if (DB.existColumn((DBRoute)DBRoute.of((String)TAXC), (String)T_TOTF_JSXZSYXSF_ACCOUNT, (String)FSOURCEDATA) && (paramList = this.getParamList(T_TOTF_JSXZSYXSF_ACCOUNT, "LJCLF")).size() > 0) {
                    DBUtils.executeBatch((String)"update t_totf_jsxzsyxsf_account set fsourcedata=?,fbillno =? where fid =?;", paramList);
                }
                if (DB.existColumn((DBRoute)DBRoute.of((String)TAXC), (String)T_TOTF_WATER_FUND, (String)FSOURCEDATA) && (paramList2 = this.getParamList2(T_TOTF_WATER_FUND, "SLJS")).size() > 0) {
                    DBUtils.executeBatch((String)"update t_totf_water_fund set fsourcedata=?,fbillno =? where fid =?;", paramList2);
                }
            }
            catch (Throwable t) {
                result.setLog("TaxbookNewDataUpgradeService FAILURE!!!");
                this.LOGGER.error("TaxbookNewDataUpgradeService FAILURE", t);
                result.setSuccess(false);
                result.setErrorInfo(this.getStackTraceMessage(t));
                h.markRollback();
            }
        }
        return result;
    }

    public List<Object[]> getParamList(String entityName, String type) {
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(10);
        List query = DBUtils.query((String)("select FID,FENDDATE from " + entityName + " where fsourcedata is null or fsourcedata =' ' or fsourcedata ='';"));
        HashMap<String, Integer> countMap = new HashMap<String, Integer>(16);
        if (!CollectionUtils.isEmpty((Collection)query)) {
            for (Map map : query) {
                Object id = map.get("FID");
                Date enddate = (Date)map.get("FENDDATE");
                String countStr = String.format("COM-LSTZ-%1$s-%2$s", type, DateUtils.format((Date)enddate, (String)"yyyyMM"));
                Integer count = countMap.merge(countStr, 1, Integer::sum);
                String billno = String.format("%s-%06d", countStr, count);
                paramList.add(new Object[]{"import", billno, id});
            }
        }
        return paramList;
    }

    public List<Object[]> getParamList2(String entityName, String type) {
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(10);
        List query = DBUtils.query((String)("select FID,FENDDATE,FPREPAYTYPE from " + entityName + " where fsourcedata is null or fsourcedata =' ' or fsourcedata ='';"));
        HashMap<String, Integer> countMap = new HashMap<String, Integer>(16);
        if (!CollectionUtils.isEmpty((Collection)query)) {
            for (Map map : query) {
                Object id = map.get("FID");
                Date enddate = (Date)map.get("FENDDATE");
                String fprepaytype = (String)map.get("FPREPAYTYPE");
                String sourcedata = StringUtil.isNoneBlank((CharSequence[])new CharSequence[]{fprepaytype}) ? "zzsprepay" : "autocollect";
                String countStr = String.format("COM-LSTZ-%1$s-%2$s", type, DateUtils.format((Date)enddate, (String)"yyyyMM"));
                Integer count = countMap.merge(countStr, 1, Integer::sum);
                String billno = String.format("%s-%06d", countStr, count);
                paramList.add(new Object[]{sourcedata, billno, id});
            }
        }
        return paramList;
    }

    protected IUpgradeService getService() {
        return this;
    }

    protected Log getLogger() {
        return this.LOGGER;
    }
}

