/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.totf.mservice.upgrade;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.db.DBUtils;

public class WaterFundTaxbookDataUpgradeService
implements IUpgradeService {
    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setSuccess(true);
        result.setLog(this.update());
        return result;
    }

    private String update() {
        try {
            String param = ResManager.loadKDString((String)"\u5730\u65b9\u6c34\u5229\u5efa\u8bbe\u57fa\u91d1", (String)"WaterFundTaxbookDataUpgradeService_1", (String)"taxc-totf-mservice", (Object[])new Object[0]);
            String selectSql = "select a.forgid,b.fstartdate,b.fenddate,a.ftaxauthority,a.fbillno from t_tctb_declare_main as a,t_totf_sjfzsf_dtb as b where a.fid in (select fid from t_totf_sjfzsf_dtb where fzspm = '%s') and a.fid = b.fid;";
            String updateSql = "update t_totf_water_fund set fbillno = ? where forgid = ? and fstartdate = ? and fenddate = ? and ftaxoffice = ?;";
            List waterDataList = DBUtils.query((String)String.format(selectSql, param));
            if (!CollectionUtils.isEmpty((Collection)waterDataList)) {
                ArrayList<Object[]> paramList = new ArrayList<Object[]>(waterDataList.size());
                for (Map row : waterDataList) {
                    Object fbillno = row.get("FBILLNO");
                    Object forgid = row.get("FORGID");
                    Object fstartdate = row.get("FSTARTDATE");
                    Object fenddate = row.get("FENDDATE");
                    Object ftaxoffice = row.get("FTAXAUTHORITY");
                    paramList.add(new Object[]{fbillno, forgid, fstartdate, fenddate, ftaxoffice});
                }
                if (EmptyCheckUtils.isNotEmpty(paramList)) {
                    DBUtils.executeBatch((String)"taxc", (String)updateSql, paramList);
                }
            }
            return ResManager.loadKDString((String)"\u6570\u636e\u5347\u7ea7\u6210\u529f", (String)"WaterFundTaxbookDataUpgradeService_2", (String)"taxc-totf-mservice", (Object[])new Object[0]);
        }
        catch (Exception e) {
            String code = ((KDException)e).getErrorCode().getCode();
            if ("bos.sQLTableNotExist".equals(code)) {
                return ResManager.loadKDString((String)"\u8868\u4e0d\u5b58\u65e0\u9700\u66f4\u540c\u6b65\u6570\u636e", (String)"WaterFundTaxbookDataUpgradeService_3", (String)"taxc-totf-mservice", (Object[])new Object[0]);
            }
            return e.getLocalizedMessage();
        }
    }
}

