/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.totf.business.account;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;

public class AccountDetailAdjustServiceHelper {
    public static DynamicObjectCollection queryAdjustCollection(String serialno, String orgId, String mappingid, String skssqq, String skssqz) {
        String selectPrope = "id,serialno,org,mappingid,skssqq,skssqz,ruleid,adjustamount,totalamount";
        List<QFilter> filters = AccountDetailAdjustServiceHelper.buildQFilterList(serialno, orgId, mappingid, skssqq, skssqz);
        return QueryServiceHelper.query((String)"totf_accountdetail_adjust", (String)selectPrope, (QFilter[])filters.toArray(new QFilter[0]));
    }

    public static BigDecimal calcAdjustAmountWithoutOrg(String serialno, String orgId, String mappingid) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        QFilter orgFilter = new QFilter("org", "!=", (Object)Long.parseLong(orgId)).or(new QFilter("mappingid", "!=", (Object)Long.parseLong(mappingid)));
        filters.add(orgFilter);
        QFilter serialnoFilter = new QFilter("serialno", "=", (Object)serialno);
        filters.add(serialnoFilter);
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"totf_accountdetail_adjust", (String)"adjustamount", (QFilter[])filters.toArray(new QFilter[0]));
        return BigDecimalUtil.sumDynamicObjectAmount((List)dynamicObjects, (String)"adjustamount");
    }

    private static List<QFilter> buildQFilterList(String serialno, String orgId, String mappingid, String skssqq, String skssqz) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        if (EmptyCheckUtils.isNotEmpty((Object)orgId)) {
            QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong(orgId));
            filters.add(orgFilter);
        }
        if (EmptyCheckUtils.isNotEmpty((Object)mappingid)) {
            QFilter mappingIdFilter = new QFilter("mappingid", "=", (Object)Long.parseLong(mappingid));
            filters.add(mappingIdFilter);
        }
        QFilter startFilter = new QFilter("skssqq", "=", (Object)DateUtils.stringToDate((String)skssqq));
        filters.add(startFilter);
        QFilter endFilter = new QFilter("skssqz", "=", (Object)DateUtils.stringToDate((String)skssqz));
        filters.add(endFilter);
        QFilter serialnoFilter = new QFilter("serialno", "=", (Object)serialno);
        filters.add(serialnoFilter);
        return filters;
    }
}

