/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.totf.business.account;

import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;

public class AccountServiceHelper {
    public static DynamicObjectCollection queryTaxableDeductItemAccount(String kpfnsrsbh, String itemname, String vouchertype, String vouchernumber, Long orgId) {
        QFilter kpfnsrsbhFilter = new QFilter("kpfnsrsbh", "=", (Object)kpfnsrsbh);
        QFilter itemnameFilter = new QFilter("itemname", "=", (Object)itemname);
        QFilter vouchertypeFilter = new QFilter("vouchertype", "=", (Object)vouchertype);
        QFilter vouchernumberFilter = new QFilter("vouchernumber", "=", (Object)vouchernumber);
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        DynamicObjectCollection objectCollection = QueryServiceHelper.query((String)"totf_taxable_deduct_item", (String)"id,startdate,enddate", (QFilter[])new QFilter[]{kpfnsrsbhFilter, itemnameFilter, vouchertypeFilter, vouchernumberFilter, orgFilter});
        return objectCollection;
    }

    public static DynamicObjectCollection queryJsxzsyxsfAccount(Long orgId, Long taxofficeId, String zspmNumber, List<Long> zszmIds) {
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter taxofficeFilter = new QFilter("taxoffice", "=", (Object)taxofficeId);
        QFilter zspmFilter = new QFilter("zspm.number", "=", (Object)zspmNumber);
        if (zszmIds.size() > 0) {
            QFilter zszmFilter = new QFilter("zszm", "in", zszmIds);
            zspmFilter.and(zszmFilter);
        }
        DynamicObjectCollection objectCollection = QueryServiceHelper.query((String)"totf_jsxzsyxsf_account", (String)"id,startdate,enddate", (QFilter[])new QFilter[]{orgFilter, taxofficeFilter, zspmFilter});
        return objectCollection;
    }

    public static DynamicObjectCollection queryEmploymentFund(Long orgId, Long taxofficeId, Long zspmId) {
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter taxofficeFilter = new QFilter("taxoffice", "=", (Object)taxofficeId);
        QFilter zspmFilter = new QFilter("zspm", "=", (Object)zspmId);
        DynamicObjectCollection objectCollection = QueryServiceHelper.query((String)"totf_employment_fund", (String)"id,startdate,enddate", (QFilter[])new QFilter[]{orgFilter, taxofficeFilter, zspmFilter});
        return objectCollection;
    }

    public static Map<String, Object> getCjrjybzjAccountDetailBySbbId(Long sbbId) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"totf_employment_fund", (String)"sbbid,startdate,enddate,taxdeduction,taxdeduction.number as taxdeductionnumber,taxdeduction.name as taxdeductionname,taxdeduction.policyname as taxdeductionpolicyname,taxdeduction.secondcode as taxdeductionsecondcode", (QFilter[])new QFilter[]{new QFilter("sbbid", "=", (Object)sbbId)}, (String)"enddate desc");
        Optional<DynamicObject> result = collection.stream().filter(s -> s.getLong("taxdeduction") != 0L).findFirst();
        if (result.isPresent()) {
            DynamicObject dynamicObject = result.get();
            DynamicObjectType dynamicObjectType = dynamicObject.getDynamicObjectType();
            DataEntityPropertyCollection properties = dynamicObjectType.getProperties();
            for (IDataEntityProperty property : properties) {
                String key = property.getName();
                if (property.getPropertyType().isAssignableFrom(Timestamp.class)) {
                    data.put(key, DateUtils.format((Date)dynamicObject.getDate(key)));
                    continue;
                }
                data.put(key, dynamicObject.get(key));
            }
        }
        return data;
    }
}

