/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.totf.business.account;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;

public class OtherIncomeService {
    public static final String TOTF_OTHERINCOME_ACCOUNT = "totf_otherincome_account";
    public static final String TOTF_JSXZSYXSF_ACCOUNT = "totf_jsxzsyxsf_account";
    public static final String TOTF_WATER_FUND = "totf_water_fund";
    public static final String STARTDATE = "startdate";
    public static final String ENDDATE = "enddate";
    public static final String NEXT = "next";
    public static final String LAST = "last";

    public static Optional<DynamicObject> queryExistsAccount(String entityName, Long orgId, Long taxofficeId, Long zspmId) {
        QFilter q1 = new QFilter("org", "=", (Object)orgId);
        QFilter q2 = new QFilter("taxoffice", "=", (Object)taxofficeId);
        QFilter q3 = new QFilter("zspm", "=", (Object)zspmId);
        DynamicObjectCollection query = QueryServiceHelper.query((String)entityName, (String)"id,startdate,enddate", (QFilter[])new QFilter[]{q1, q2, q3}, (String)"startdate desc");
        return CollectionUtils.isEmpty((Collection)query) ? Optional.empty() : Optional.ofNullable(query.get(0));
    }

    public static Optional<DynamicObject> queryExistsAccount(String entityName, Long orgId, Long taxofficeId, Long zspmId, Date start, Date end) {
        QFilter q1 = new QFilter("org", "=", (Object)orgId);
        QFilter q2 = new QFilter("taxoffice", "=", (Object)taxofficeId);
        QFilter q3 = new QFilter("zspm", "=", (Object)zspmId);
        QFilter q4 = new QFilter(STARTDATE, "<=", (Object)end);
        QFilter q5 = new QFilter(ENDDATE, ">=", (Object)start);
        return Optional.ofNullable(QueryServiceHelper.queryOne((String)entityName, (String)"id,billno,startdate,enddate", (QFilter[])new QFilter[]{q1, q2, q3, q4, q5}));
    }

    public static Map<String, Date> getStartOrEndByType(String taxperiod, String type, Date currentStart) {
        HashMap<String, Date> map = new HashMap<String, Date>(16);
        Date start = new Date();
        Date end = new Date();
        Date now = new Date();
        Date init = NEXT.equals(type) ? currentStart : now;
        int abs = NEXT.equals(type) ? 1 : -1;
        switch (taxperiod) {
            case "month": {
                start = DateUtils.getFirstDateOfMonth((Date)DateUtils.addMonth((Date)init, (int)(abs * 1)));
                end = DateUtils.getLastDateOfMonth((Date)DateUtils.addMonth((Date)init, (int)(abs * 1)));
                break;
            }
            case "season": {
                start = DateUtils.getFirstDateOfSeason((Date)DateUtils.addMonth((Date)init, (int)(abs * 3)));
                end = DateUtils.getLastDateOfSeason((Date)DateUtils.addMonth((Date)init, (int)(abs * 3)));
                break;
            }
            case "halfyear": {
                start = DateUtils.getFirstDateOfHalfYear((Date)DateUtils.addMonth((Date)init, (int)(abs * 6)));
                end = DateUtils.getLastDateOfHalfYear((Date)DateUtils.addMonth((Date)init, (int)(abs * 6)));
                break;
            }
            case "year": {
                start = DateUtils.getFirstDateOfYear((Date)DateUtils.addMonth((Date)init, (int)(abs * 12)));
                end = DateUtils.getLastDateOfYear((Date)DateUtils.addMonth((Date)init, (int)(abs * 12)));
                break;
            }
            case "count": {
                start = now;
                end = now;
                break;
            }
            case "single": {
                start = now;
                end = now;
                break;
            }
        }
        map.put(STARTDATE, DateUtils.trunc((Date)start));
        map.put(ENDDATE, DateUtils.trunc((Date)end));
        return map;
    }

    public static boolean isEnableCard(Long orgId) {
        TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainQtsfByOrgId(Collections.singletonList(orgId));
        if (result.isSuccess() && EmptyCheckUtils.isNotEmpty((Object)result.getData())) {
            DynamicObject taxMain = (DynamicObject)((List)result.getData()).get(0);
            DynamicObjectCollection categoryentryentity = taxMain.getDynamicObjectCollection("categoryentryentity");
            return categoryentryentity.stream().filter(s -> "qtsf".equals(s.getString("taxtype"))).anyMatch(s -> "1".equals(s.getString("enable")));
        }
        return false;
    }

    public static DynamicObjectCollection getCardRows(Long orgId, List<Long> zspmIds) {
        TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainQtsfByOrgId(Collections.singletonList(orgId));
        if (result.isSuccess() && EmptyCheckUtils.isNotEmpty((Object)result.getData())) {
            DynamicObject taxMain = (DynamicObject)((List)result.getData()).get(0);
            DynamicObjectCollection categoryentryentity = taxMain.getDynamicObjectCollection("categoryentryentity");
            Optional<DynamicObject> enableCardOpt = categoryentryentity.stream().filter(s -> "qtsf".equals(s.getString("taxtype"))).filter(s -> "1".equals(s.getString("enable"))).findFirst();
            if (!enableCardOpt.isPresent()) {
                return new DynamicObjectCollection();
            }
            DynamicObjectCollection qtsfentity = taxMain.getDynamicObjectCollection("qtsfentity");
            return qtsfentity.stream().filter(s -> zspmIds.contains(s.getLong("collectrate.id"))).collect(Collectors.toCollection(DynamicObjectCollection::new));
        }
        return new DynamicObjectCollection();
    }

    public static Optional<DynamicObject> getCardRow(Long orgId, Long zspmId, Date start, Date end) {
        DynamicObjectCollection cardRows = OtherIncomeService.getCardRows(orgId, Lists.newArrayList((Object[])new Long[]{zspmId}), start, end);
        return CollectionUtils.isEmpty((Collection)cardRows) ? Optional.empty() : Optional.ofNullable(cardRows.get(0));
    }

    public static Optional<DynamicObject> getCardRow(Long orgId, Long zspmId) {
        DynamicObjectCollection cardRows = OtherIncomeService.getCardRows(orgId, Lists.newArrayList((Object[])new Long[]{zspmId}));
        return CollectionUtils.isEmpty((Collection)cardRows) ? Optional.empty() : Optional.ofNullable(cardRows.get(0));
    }

    public static DynamicObjectCollection getCardRows(Long orgId, List<Long> zspmIds, Date start, Date end) {
        DynamicObjectCollection cardRows = OtherIncomeService.getCardRows(orgId, zspmIds);
        return cardRows.stream().filter(s -> {
            Date effectivestart = s.getDate("effectivestart");
            Date effectiveend = s.getDate("effectiveend");
            return OtherIncomeService.isContainAll(effectivestart, effectiveend, start, end);
        }).collect(Collectors.toCollection(DynamicObjectCollection::new));
    }

    public static boolean isContainAll(Date startDate, Date endDate, Date inputStartDate, Date inputEndDate) {
        if (inputStartDate == null) {
            return false;
        }
        if (inputEndDate == null) {
            return !startDate.after(inputStartDate);
        }
        return !startDate.after(inputStartDate) && (endDate == null || !endDate.before(inputEndDate));
    }
}

