/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.totf.business.account;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.constant.ZspmConstant;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;

public class OtherIncomeServiceHelper {
    public static DynamicObjectCollection queryGhjfAccount(String orgId, Date skssqq, Date skssqz, String type, Long taxoffice, Long sbbId, String limit) {
        String selectPrope = "id,startdate,enddate,taxableitem,deductitem,taxrate,quickdeduction,taxdeduction,deductionamount,zzsdeducttype,zzsdeductrate,bqyjse,jbrysfzjlx,operatorno,operator,jbrphone";
        List<QFilter> filters = OtherIncomeServiceHelper.buildGhjfQFilterList(orgId, skssqq, skssqz, type, taxoffice, sbbId, limit);
        return QueryServiceHelper.query((String)"totf_otherincome_account", (String)selectPrope, (QFilter[])filters.toArray(new QFilter[0]));
    }

    private static List<QFilter> buildGhjfQFilterList(String orgId, Date skssqq, Date skssqz, String type, Long taxofficeId, Long sbbId, String limit) {
        QFilter startFilter;
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        if (EmptyCheckUtils.isNotEmpty((Object)orgId)) {
            QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong(orgId));
            filters.add(orgFilter);
        }
        if (skssqq.compareTo(skssqz) == 0) {
            startFilter = new QFilter("startdate", "<=", (Object)skssqq);
            filters.add(startFilter);
            QFilter payperiodFilter = new QFilter("payperiod", "=", (Object)"count");
            filters.add(payperiodFilter);
        } else {
            startFilter = new QFilter("startdate", ">=", (Object)skssqq);
            filters.add(startFilter);
            QFilter endFilter = new QFilter("enddate", "<=", (Object)DateUtils.getLastDateOfMonth2((Date)skssqz));
            filters.add(endFilter);
            QFilter limitFilter = new QFilter("payperiod", "=", (Object)limit);
            filters.add(limitFilter);
        }
        QFilter serialnoFilter = new QFilter("zspm", "=", (Object)Long.valueOf(type));
        filters.add(serialnoFilter);
        QFilter taxofficeFilter = new QFilter("taxoffice", "=", (Object)taxofficeId);
        filters.add(taxofficeFilter);
        QFilter sbbIdFilter = new QFilter("sbbid", "=", (Object)0).or("sbbid", "=", (Object)sbbId);
        filters.add(sbbIdFilter);
        return filters;
    }

    public static DynamicObjectCollection queryLjclfAccount(String orgId, Long taxofficeId, Date skssqq, Date skssqz, List<Long> zszmList, Long sbbId, String zspmId, String limit) {
        String selectPrope = "id,zszm,startdate,enddate,payperiod,taxableitem,deductitem,taxrate,quickdeduction,taxdeduction,deductionamount,bqyjse,remark,jbrysfzjlx,operatorno,operator,jbrphone";
        List<QFilter> filters = OtherIncomeServiceHelper.buildLjclfQFilterList(orgId, taxofficeId, skssqq, skssqz, zszmList, sbbId, limit);
        return QueryServiceHelper.query((String)"totf_jsxzsyxsf_account", (String)selectPrope, (QFilter[])filters.toArray(new QFilter[0]));
    }

    private static List<QFilter> buildLjclfQFilterList(String orgId, Long taxofficeId, Date skssqq, Date skssqz, List<Long> zszmList, Long sbbId, String limit) {
        QFilter zszmFilter;
        QFilter startFilter;
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        if (EmptyCheckUtils.isNotEmpty((Object)orgId)) {
            QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong(orgId));
            filters.add(orgFilter);
        }
        if (skssqq.compareTo(skssqz) == 0) {
            startFilter = new QFilter("startdate", "<=", (Object)skssqq);
            filters.add(startFilter);
            QFilter payperiodFilter = new QFilter("payperiod", "=", (Object)"count");
            filters.add(payperiodFilter);
        } else {
            startFilter = new QFilter("startdate", ">=", (Object)skssqq);
            filters.add(startFilter);
            QFilter endFilter = new QFilter("enddate", "<=", (Object)DateUtils.getLastDateOfMonth2((Date)skssqz));
            filters.add(endFilter);
            QFilter limitFilter = new QFilter("payperiod", "=", (Object)limit);
            filters.add(limitFilter);
        }
        if (!CollectionUtils.isEmpty(zszmList)) {
            zszmFilter = new QFilter("zszm", "in", zszmList);
            filters.add(zszmFilter);
        } else {
            zszmFilter = new QFilter("zszm", "=", (Object)0L);
            filters.add(zszmFilter);
        }
        QFilter sbbIdFilter = new QFilter("sbbid", "=", (Object)0L).or("sbbid", "=", (Object)sbbId);
        filters.add(sbbIdFilter);
        filters.add(new QFilter("taxoffice", "=", (Object)taxofficeId));
        return filters;
    }

    public static String getZszmName(Long id) {
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"tpo_tysbsf_bizdef_entry", (String)"projectname", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
        return dynamicObject == null ? " " : dynamicObject.getString("projectname");
    }

    public static boolean existWaterAccount(String orgid, Long taxofficeId, Date startdate, Date enddate, String zspmId, Long sbbid) {
        QFilter q1 = new QFilter("org", "=", (Object)Long.valueOf(orgid));
        QFilter q2 = new QFilter("startdate", "=", (Object)startdate);
        QFilter q3 = new QFilter("enddate", "=", (Object)enddate);
        QFilter q4 = new QFilter("taxoffice", "=", (Object)taxofficeId);
        QFilter q5 = new QFilter("sbbid", "=", (Object)0L).or("sbbid", "=", (Object)sbbid);
        if (String.valueOf(ZspmConstant.ID_DFSLJSJJ_ZPSM).equals(zspmId)) {
            return QueryServiceHelper.exists((String)"totf_water_fund", (QFilter[])new QFilter[]{q1, q2, q3, q4, q5});
        }
        if (String.valueOf(ZspmConstant.ID_DWFHF_ZPSM).equals(zspmId)) {
            return QueryServiceHelper.exists((String)"totf_embankment_account", (QFilter[])new QFilter[]{q1, q2, q3, q4, q5});
        }
        if (String.valueOf(ZspmConstant.ID_STBCBCF_ZPSM).equals(zspmId) || String.valueOf(ZspmConstant.ID_STBCBCF_JSQSR_ZPSM).equals(zspmId) || String.valueOf(ZspmConstant.ID_STBCBCF_KCQSR_ZPSM).equals(zspmId) || String.valueOf(ZspmConstant.ID_STBCBCF_QTSR_ZPSM).equals(zspmId)) {
            return QueryServiceHelper.exists((String)"totf_stbcbcf_account", (QFilter[])new QFilter[]{q1, q2, q3, q4, q5});
        }
        return false;
    }

    public static DynamicObject[] queryWaterSoilAccount(String orgid, Long taxofficeId, Date startdate, Date enddate, String zspmId, Long sbbid) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        QFilter q1 = new QFilter("org", "=", (Object)Long.valueOf(orgid));
        filters.add(q1);
        if (startdate.compareTo(enddate) == 0) {
            QFilter startFilter = new QFilter("startdate", "<=", (Object)startdate);
            filters.add(startFilter);
            QFilter payperiodFilter = new QFilter("taxperiod", "=", (Object)"count");
            filters.add(payperiodFilter);
        } else {
            QFilter q2 = new QFilter("startdate", "=", (Object)startdate);
            QFilter q3 = new QFilter("enddate", "=", (Object)enddate);
            filters.add(q2);
            filters.add(q3);
        }
        QFilter q4 = new QFilter("taxoffice", "=", (Object)taxofficeId);
        QFilter q5 = new QFilter("sbbid", "=", (Object)0L).or("sbbid", "=", (Object)sbbid);
        QFilter q6 = new QFilter("zspm", "=", (Object)Long.parseLong(zspmId));
        filters.add(q4);
        filters.add(q5);
        filters.add(q6);
        return BusinessDataServiceHelper.load((String)"totf_stbcbcf_account", (String)"startdate,enddate,id,deductionamount,yjfjs, taxdeduction ,billno ,yjfjsjme ,quickdeduction ,bqyjse,zspm.id,zspm,zszm,rate", (QFilter[])filters.toArray(new QFilter[0]));
    }
}

