/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.totf.business.account;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.totf.business.engine.WaterFundHelper;

public class WaterFundServiceHelper {
    public static DynamicObject querySljjAccount(String orgId, Date skssqq, Date skssqz, String type, Long taxoffice, String billno) {
        List<QFilter> filters = WaterFundServiceHelper.buildSljjQFilterList(orgId, skssqq, skssqz, type, taxoffice, billno);
        return QueryServiceHelper.queryOne((String)"totf_water_fund", (String)"zspm", (QFilter[])filters.toArray(new QFilter[0]));
    }

    private static List<QFilter> buildSljjQFilterList(String orgId, Date skssqq, Date skssqz, String type, Long taxoffice, String billno) {
        QFilter startFilter;
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        if (EmptyCheckUtils.isNotEmpty((Object)orgId)) {
            QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong(orgId));
            filters.add(orgFilter);
        }
        if (skssqq.compareTo(skssqz) == 0) {
            startFilter = new QFilter("startdate", "<=", (Object)skssqq);
            filters.add(startFilter);
            QFilter payperiodFilter = new QFilter("payperiod", "=", (Object)"count");
            filters.add(payperiodFilter);
        } else {
            startFilter = new QFilter("startdate", ">=", (Object)skssqq);
            filters.add(startFilter);
            QFilter endFilter = new QFilter("enddate", "<=", (Object)DateUtils.getLastDateOfMonth2((Date)skssqz));
            filters.add(endFilter);
        }
        QFilter serialnoFilter = new QFilter("zspm", "=", (Object)Long.valueOf(type));
        filters.add(serialnoFilter);
        QFilter taxofficeFilter = new QFilter("taxoffice", "=", (Object)taxoffice);
        filters.add(taxofficeFilter);
        QFilter billnoFilter = new QFilter("billno", "=", (Object)" ");
        if (StringUtil.isNotBlank((CharSequence)billno)) {
            billnoFilter.or("billno", "=", (Object)billno);
        }
        filters.add(billnoFilter);
        return filters;
    }

    public static DynamicObjectCollection queryWaterFundDetails(String serialno, String orgId, String mappingid, String skssqq, String skssqz) {
        String selectProperties = "id,org,mappingtype,mappingid,taxorg,ruleid,taxaccountserialno,skssqq,skssqz,table,amountfield,datatype,datadirection,amount,fetchamount,filtercondition";
        List<QFilter> filters = WaterFundServiceHelper.buildQFilterList(serialno, orgId, mappingid, skssqq, skssqz);
        return QueryServiceHelper.query((String)"totf_waterfund_detail", (String)selectProperties, (QFilter[])filters.toArray(new QFilter[0]));
    }

    public static DynamicObject queryWaterFundDetails(String serialno, String orgId, String skssqq, String skssqz) {
        String selectProperties = "id,org,taxorg,taxaccountserialno,skssqq,skssqz,adjustamount,totalamount,tzsm,prepaytype,amount";
        List<QFilter> filters = WaterFundServiceHelper.buildQFilterList(serialno, orgId, null, skssqq, skssqz);
        return QueryServiceHelper.queryOne((String)"totf_wafund_accunt_detail", (String)selectProperties, (QFilter[])filters.toArray(new QFilter[0]));
    }

    private static List<QFilter> buildQFilterList(String serialno, String orgId, String mappingid, String skssqq, String skssqz) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        if (EmptyCheckUtils.isNotEmpty((Object)orgId)) {
            QFilter orgFilter = new QFilter("taxorg", "=", (Object)Long.parseLong(orgId));
            filters.add(orgFilter);
        }
        if (EmptyCheckUtils.isNotEmpty((Object)mappingid)) {
            QFilter mappingidFilter = new QFilter("mappingid", "=", (Object)Long.parseLong(mappingid));
            filters.add(mappingidFilter);
        }
        QFilter startFilter = new QFilter("skssqq", "=", (Object)DateUtils.stringToDate((String)skssqq));
        filters.add(startFilter);
        QFilter endFilter = new QFilter("skssqz", "=", (Object)DateUtils.stringToDate((String)skssqz));
        filters.add(endFilter);
        QFilter serialnoFilter = new QFilter("taxaccountserialno", "=", (Object)serialno);
        filters.add(serialnoFilter);
        return filters;
    }

    public static BigDecimal calcWaterFundDetailAmountsWithoutOrg(String serialno, String orgId, String mappingid) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        QFilter orgFilter = new QFilter("taxorg", "!=", (Object)Long.parseLong(orgId)).or(new QFilter("mappingid", "!=", (Object)Long.parseLong(mappingid)));
        filters.add(orgFilter);
        QFilter serialnoFilter = new QFilter("taxaccountserialno", "=", (Object)serialno);
        filters.add(serialnoFilter);
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"totf_waterfund_detail", (String)"taxorg,mappingid,ruleid,amount", (QFilter[])filters.toArray(new QFilter[0]));
        return WaterFundHelper.calcSumAmountByGroup((List<DynamicObject>)dynamicObjects);
    }
}

