/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.totf.business.account;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.totf.business.engine.WhsyjsfAccountHelper;

public class WhsyjsfAccountServiceHelper {
    private static final String TOTF_TAXABLE_DEDUCT_ITEM = "totf_taxable_deduct_item";
    private static final String TOTF_WHSYJSF_ACCOUNT = "totf_whsyjsf_account";

    public static DynamicObjectCollection queryAccountDetails(String serialno, String orgId, String mappingid, String skssqq, String skssqz) {
        String selectProperties = "id,org,mappingtype,mappingid,taxorg,ruleid,taxaccountserialno,skssqq,skssqz,table,amountfield,datatype,datadirection,amount,fetchamount,filtercondition";
        List<QFilter> filters = WhsyjsfAccountServiceHelper.buildQFilterList(serialno, orgId, mappingid, skssqq, skssqz);
        return QueryServiceHelper.query((String)"totf_whsyjsf_detail", (String)selectProperties, (QFilter[])filters.toArray(new QFilter[0]));
    }

    private static List<QFilter> buildQFilterList(String serialno, String orgId, String mappingid, String skssqq, String skssqz) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        if (EmptyCheckUtils.isNotEmpty((Object)orgId)) {
            QFilter orgFilter = new QFilter("taxorg", "=", (Object)Long.parseLong(orgId));
            filters.add(orgFilter);
        }
        if (EmptyCheckUtils.isNotEmpty((Object)mappingid)) {
            QFilter mappingidFilter = new QFilter("mappingid", "=", (Object)Long.parseLong(mappingid));
            filters.add(mappingidFilter);
        }
        QFilter startFilter = new QFilter("skssqq", "=", (Object)DateUtils.stringToDate((String)skssqq));
        filters.add(startFilter);
        QFilter endFilter = new QFilter("skssqz", "=", (Object)DateUtils.stringToDate((String)skssqz));
        filters.add(endFilter);
        QFilter serialnoFilter = new QFilter("taxaccountserialno", "=", (Object)serialno);
        filters.add(serialnoFilter);
        return filters;
    }

    public static BigDecimal calcAccountDetailAmountsWithoutOrg(String serialno, String orgId, String mappingid) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        QFilter orgFilter = new QFilter("taxorg", "!=", (Object)Long.parseLong(orgId)).or(new QFilter("mappingid", "!=", (Object)Long.parseLong(mappingid)));
        filters.add(orgFilter);
        QFilter serialnoFilter = new QFilter("taxaccountserialno", "=", (Object)serialno);
        filters.add(serialnoFilter);
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"totf_whsyjsf_detail", (String)"taxorg,mappingid,ruleid,amount", (QFilter[])filters.toArray(new QFilter[0]));
        return WhsyjsfAccountHelper.calcSumAmountByGroup((List<DynamicObject>)dynamicObjects);
    }

    public static boolean existWhsyjsfAccount(String orgId, Object taxoffice, Date startDate, Date endDate) {
        QFilter q1 = new QFilter("org", "=", (Object)Long.valueOf(orgId));
        QFilter q2 = new QFilter("startdate", "=", (Object)startDate);
        QFilter q3 = new QFilter("enddate", "=", (Object)endDate);
        QFilter q4 = new QFilter("taxoffice", "=", taxoffice);
        boolean exists = QueryServiceHelper.exists((String)TOTF_TAXABLE_DEDUCT_ITEM, (QFilter[])new QFilter[]{q1, q2, q3, q4});
        boolean exists1 = QueryServiceHelper.exists((String)TOTF_WHSYJSF_ACCOUNT, (QFilter[])new QFilter[]{q1, q2, q3, q4});
        return exists || exists1;
    }
}

