/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.totf.business.declare;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.declare.model.response.DeclareResponseModel;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.enums.ZspmEnum;
import kd.taxc.bdtaxr.common.helper.tctb.taxclicense.TaxcLicenseCheckDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgUtils;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.param.SystemParamUtil;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.common.vo.DeclareRequest;
import kd.taxc.totf.business.declare.IDeclareService;
import kd.taxc.totf.business.declare.OrgHelperService;
import kd.taxc.totf.business.declare.WaterFundAccountService;
import kd.taxc.totf.business.declare.WhsyjsfAccountService;
import kd.taxc.totf.business.declare.impl.TysbDeclareServiceImpl;
import kd.taxc.totf.business.declare.impl.WhsyjsfDeclareServiceImpl;
import kd.taxc.totf.business.engine.impl.WaterFundAutoCollectEngine;
import kd.taxc.totf.business.engine.impl.WhsyjsfAutoCollectEngine;

public class DeclareServiceHelper {
    public static Map<String, Object> generate(DeclareRequest requestVo) {
        String orgId = requestVo.getOrgId();
        Date declareDate = requestVo.getExecuteTime();
        String templateType = requestVo.getCategory();
        Long taxoffice = requestVo.getTaxauthority();
        String taxcatetory = requestVo.getTaxcatetory();
        HashMap<String, Object> paramsMap = new HashMap<String, Object>(16);
        DynamicObject taxMain = OrgHelperService.findTaxMain(Long.parseLong(orgId));
        if (taxMain == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u8868\u4e2d\u4e0d\u5b58\u5728\u8be5orgid\uff1a%s", (String)"DeclareServiceHelper_0", (String)"taxc-totf", (Object[])new Object[0]), orgId));
        }
        DynamicObject taxInfos = OrgHelperService.findTaxInfos(taxMain, "qtsf");
        if (taxInfos == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u4e0d\u5b58\u5728\u5176\u4ed6\u7a0e\u8d39\u7a0e\u79cd\u5361\u7247", (String)"DeclareServiceHelper_1", (String)"taxc-totf", (Object[])new Object[0]));
        }
        Date startdate = DateUtils.getFirstDateOfMonth((Date)declareDate);
        Date date = DateUtils.addMonth((Date)startdate, (int)-1);
        List<DynamicObject> qtsfEntitys = DeclareServiceHelper.getMatchData(orgId, taxMain.getDynamicObjectCollection("qtsfentity"), date, templateType);
        if (qtsfEntitys == null || qtsfEntitys.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7a0e\u79cd\u5361\u7247\u4e2d\u4e0d\u5b58\u5728\u7b26\u5408\u7533\u62a5\u7684\u7a0e\u79cd\u7c7b\u578b", (String)"DeclareServiceHelper_2", (String)"taxc-totf", (Object[])new Object[0]));
        }
        IDeclareService service = DeclareServiceHelper.getService(templateType);
        DeclareRequestModel declareRequestModel = service.builderRequestModel(qtsfEntitys, orgId, templateType, declareDate, taxoffice, taxcatetory);
        paramsMap.put("skssqq", DateUtils.stringToDate((String)declareRequestModel.getSkssqq()));
        paramsMap.put("skssqz", DateUtils.stringToDate((String)declareRequestModel.getSkssqz()));
        String result = (String)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"bdtaxr", (String)"DeclareService", (String)"generateSbb", (Object[])new Object[]{SerializationUtils.toJsonString((Object)declareRequestModel)});
        DeclareResponseModel responseModel = (DeclareResponseModel)SerializationUtils.fromJsonString((String)result, DeclareResponseModel.class);
        if (EmptyCheckUtils.isNotEmpty((Object)responseModel.getErrorMessage())) {
            throw new KDBizException(responseModel.getErrorMessage());
        }
        return paramsMap;
    }

    private static IDeclareService getService(String templateType) {
        if ("whsyjsf".equals(templateType)) {
            return new WhsyjsfDeclareServiceImpl();
        }
        return new TysbDeclareServiceImpl();
    }

    private static List<DynamicObject> getMatchData(String orgId, DynamicObjectCollection qtsfentity, Date date, String type) {
        String taxcType = DeclareServiceHelper.getTaxcType(orgId, date, type);
        if (StringUtil.isBlank((CharSequence)taxcType)) {
            return new ArrayList<DynamicObject>();
        }
        TaxResult licenseResult = TaxcLicenseCheckDataServiceHelper.check((Long)Long.valueOf(orgId), (String)"totf");
        boolean hasLicense = Boolean.FALSE.equals(licenseResult.getData());
        return qtsfentity.stream().filter(s -> {
            boolean isZeroDeclare = false;
            ZspmEnum zspmEnum = ZspmEnum.valueOfNumber((String)s.getString("collectrate.number"));
            if (zspmEnum != null && EmptyCheckUtils.isNotEmpty((Object)zspmEnum.getParamKey())) {
                isZeroDeclare = SystemParamUtil.getZeroDeclareParameter((String)"totf", (String)zspmEnum.getParamKey(), (long)Long.parseLong(orgId));
            }
            if (hasLicense || isZeroDeclare) {
                return taxcType.contains(s.getString("collectrate.number"));
            }
            return false;
        }).filter(s -> date.compareTo(s.getDate("effectivestart")) >= 0).filter(s -> s.getDate("effectiveend") == null || date.compareTo(s.getDate("effectiveend")) <= 0).collect(Collectors.toList());
    }

    private static String getTaxcType(String orgId, Date date, String type) {
        switch (type) {
            case "whsyjsf": {
                return "0096";
            }
            case "qtsf_tysbb": {
                String declaration = OrgUtils.getOrgGroupDeclaration((Long)Long.valueOf(orgId), (String)"sljsjj", (Date)date, (Date)date);
                boolean zerodeclare = SystemParamUtil.getZeroDeclareParameter((String)"totf", (String)"zerodeclare", (long)Long.parseLong(orgId));
                if ("3".equals(declaration) && !zerodeclare) {
                    return "008600870090";
                }
                return "0086008700900089";
            }
            case "qtsf_fsstysbb": {
                String declaration2 = OrgUtils.getOrgGroupDeclaration((Long)Long.valueOf(orgId), (String)"sljsjj", (Date)date, (Date)date);
                boolean zerodeclare2 = SystemParamUtil.getZeroDeclareParameter((String)"totf", (String)"zerodeclare", (long)Long.parseLong(orgId));
                if ("3".equals(declaration2) && !zerodeclare2) {
                    return "0091";
                }
                return "00910089";
            }
        }
        return "";
    }

    public static void createWaterStandingBook(DeclareRequest requestVo) {
        Map<String, Object> map = WaterFundAccountService.getData("", Long.parseLong(requestVo.getOrgId()), requestVo.getExecuteTime());
        boolean zerodeclare = SystemParamUtil.getZeroDeclareParameter((String)"totf", (String)"zerodeclare", (long)Long.parseLong(requestVo.getOrgId()));
        if (!zerodeclare && EmptyCheckUtils.isNotEmpty(map) && DeclareServiceHelper.queryWaterStandingBook(requestVo).size() == 0) {
            if (DeclareServiceHelper.checkIsBranchOrg(requestVo.getOrgId(), (Date)map.get("startdate"), (Date)map.get("enddate"))) {
                return;
            }
            EngineModel engineModel = new EngineModel(requestVo.getOrgId(), DateUtils.format((Date)((Date)map.get("startdate"))), DateUtils.format((Date)((Date)map.get("enddate"))));
            engineModel.getCustom().put("rate", map.get("rate"));
            engineModel.getCustom().put("payperiod", map.get("taxlimit"));
            WaterFundAutoCollectEngine.execute(engineModel);
        }
    }

    public static void createWhsyjsfAccount(DeclareRequest requestVo) {
        Map<String, Object> map = WhsyjsfAccountService.getData("", Long.parseLong(requestVo.getOrgId()), requestVo.getExecuteTime());
        if (EmptyCheckUtils.isNotEmpty(map)) {
            EngineModel engineModel = new EngineModel(requestVo.getOrgId(), DateUtils.format((Date)((Date)map.get("startdate"))), DateUtils.format((Date)((Date)map.get("enddate"))));
            engineModel.getCustom().put("rate", map.get("rate"));
            engineModel.getCustom().put("payperiod", map.get("taxlimit"));
            WhsyjsfAutoCollectEngine.execute(engineModel);
        }
    }

    public static List<Object> queryWaterStandingBook(DeclareRequest requestVo) {
        Map<String, Object> map = WaterFundAccountService.getData("", Long.parseLong(requestVo.getOrgId()), requestVo.getExecuteTime());
        QFilter q1 = new QFilter("org", "=", (Object)Long.parseLong(requestVo.getOrgId()));
        QFilter q2 = new QFilter("startdate", "=", map.get("startdate"));
        QFilter q3 = new QFilter("enddate", "=", map.get("enddate"));
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"totf_water_fund", (String)"taxoffice", (QFilter[])new QFilter[]{q1, q2, q3});
        if (EmptyCheckUtils.isEmpty(map) || requestVo.getCategory().equals("qtsf_fsstysbb")) {
            TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainByOrgId((Long)Long.parseLong(requestVo.getOrgId()));
            ArrayList<Object> list = new ArrayList<Object>();
            if (result.isSuccess() && EmptyCheckUtils.isNotEmpty((Object)result.getData())) {
                list.add(((DynamicObject)result.getData()).get("taxoffice.id"));
            }
            return list;
        }
        return dynamicObjects.stream().map(s -> s.get("taxoffice")).collect(Collectors.toList());
    }

    public static boolean checkIsBranchOrg(String orgId, Date startDate, Date endDate) {
        QFilter statusFilter = new QFilter("status", "=", (Object)"2");
        QFilter q1 = new QFilter("orgrow.orgid", "=", (Object)Long.parseLong(orgId));
        QFilter q2 = new QFilter("taxtype", "=", (Object)"sljsjj");
        QFilter q3 = new QFilter("orgrow.declaration", "=", (Object)"3");
        QFilter q4 = new QFilter("effectdate", "<=", (Object)startDate);
        QFilter q5 = new QFilter("invaliddate", "is null", null).or(new QFilter("invaliddate", ">=", (Object)endDate));
        return QueryServiceHelper.exists((String)"tctb_org_group_latest", (QFilter[])new QFilter[]{statusFilter, q1, q2, q3, q4, q5});
    }
}

