/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.totf.business.declare;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.enums.TemplateEnum;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.common.vo.DeclareRequest;

public class RequestValidator {
    private static final Log LOGGER = LogFactory.getLog(RequestValidator.class);

    public static void validateDeclareRequest(DeclareRequest requestVo) {
        if (EmptyCheckUtils.isEmpty((Object)requestVo.getOrgId())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u6c42\u53c2\u6570\u9519\u8bef\uff0corgId\u4e3a\u7a7a", (String)"RequestValidator_0", (String)"taxc-totf", (Object[])new Object[0]));
        }
        if (EmptyCheckUtils.isEmpty((Object)requestVo.getExecuteTime())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u6c42\u53c2\u6570\u9519\u8bef\uff0cexecuteTime\u4e3a\u7a7a", (String)"RequestValidator_1", (String)"taxc-totf", (Object[])new Object[0]));
        }
        try {
            long orgId = Long.parseLong(requestVo.getOrgId());
            RequestValidator.orgEnable(orgId);
            RequestValidator.isTaxPayerAuth(requestVo.getOrgId());
            RequestValidator.isEnableTaxcCard(orgId);
            boolean verifyRegisterTimeSuccess = RequestValidator.verifyRegistertime(requestVo.getOrgId(), requestVo.getExecuteTime());
            if (!verifyRegisterTimeSuccess) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u786e\u8ba4\u7533\u62a5\u7684\u6240\u5c5e\u7a0e\u671f\u4e0d\u5f97\u65e9\u4e8e\u4f01\u4e1a\u767b\u8bb0\u65f6\u95f4", (String)"RequestValidator_2", (String)"taxc-totf", (Object[])new Object[0]));
            }
        }
        catch (NumberFormatException e) {
            LOGGER.info("totf-logger: check not pass reason: " + e.getMessage());
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u6c42\u53c2\u6570\u9519\u8bef\uff0c\u7ec4\u7ec7ID\u5305\u542b\u975e\u6570\u5b57\u5b57\u7b26", (String)"RequestValidator_3", (String)"taxc-totf", (Object[])new Object[0]));
        }
    }

    private static void orgEnable(Long orgId) {
        Map map = (Map)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tctb", (String)"OrgCheckService", (String)"orgEnable", (Object[])new Object[]{orgId, true});
        if (StringUtils.equalsIgnoreCase((CharSequence)((CharSequence)map.get("code")), (CharSequence)"true")) {
            throw new KDBizException((String)map.get("failInfo"));
        }
    }

    private static void isTaxPayerAuth(String orgId) {
        Map map = (Map)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tctb", (String)"OrgCheckService", (String)"isTaxPayerAuth", (Object[])new Object[]{orgId, TemplateEnum.CCXWS.getDeclarePage(), true});
        if (StringUtils.equalsIgnoreCase((CharSequence)((CharSequence)map.get("code")), (CharSequence)"true")) {
            throw new KDBizException((String)map.get("failInfo"));
        }
    }

    private static void isEnableTaxcCard(Long orgid) {
        TaxResult result = TaxcMainDataServiceHelper.isTaxcMainQtsfEnableByOrgId((Long)orgid);
        if (result.isSuccess()) {
            Boolean qtsfEnable = (Boolean)result.getData();
            if (!qtsfEnable.booleanValue()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5176\u4ed6\u7a0e\u8d39\u7a0e\u79cd\u5c1a\u672a\u542f\u7528\u3002", (String)"RequestValidator_4", (String)"taxc-totf", (Object[])new Object[0]));
            }
        } else {
            throw new KDBizException(result.getMessage());
        }
    }

    public static boolean verifyRegistertime(String orgId, Date executeTime) {
        boolean isSuss = true;
        if (StringUtil.isNotBlank((CharSequence)orgId)) {
            DynamicObject dynamicObject;
            Date fregistertime;
            TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainByOrgId((Long)Long.parseLong(orgId));
            if (result.isSuccess() && EmptyCheckUtils.isNotEmpty((Object)result.getData()) && Objects.nonNull(fregistertime = (dynamicObject = (DynamicObject)result.getData()).getDate("registertime")) && fregistertime.after(executeTime)) {
                isSuss = false;
            }
            return isSuss;
        }
        return true;
    }

    public static boolean checkDeclareItemsExists(boolean combineDeclare, EngineModel engineModel, List<DynamicObject> declareItemList) {
        return true;
    }
}

