/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.totf.business.declare;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;

public class WhsyjsfAccountService {
    private static Log logger = LogFactory.getLog(WhsyjsfAccountService.class);
    private static final String TOTF_WHSYJSF_ACCOUNT = "totf_whsyjsf_account";

    private static List<DynamicObject> getTaxCard(Long orgid) {
        TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainQtsfByOrgId(Collections.singletonList(orgid));
        if (result.isSuccess() && EmptyCheckUtils.isNotEmpty((Object)result.getData())) {
            DynamicObject taxMain = (DynamicObject)((List)result.getData()).get(0);
            return taxMain.getDynamicObjectCollection("qtsfentity").stream().filter(d -> "0096".equals(d.getString("collectrate.number"))).collect(Collectors.toList());
        }
        return new ArrayList<DynamicObject>();
    }

    public static Map<String, Object> getData(String orgname, Long orgid, Date date) {
        DynamicObject dynamicObject;
        String taxlimit;
        Map skssqzMap;
        HashMap<String, Object> map = new HashMap<String, Object>();
        List<DynamicObject> cards = WhsyjsfAccountService.getTaxCard(orgid);
        Date preMonth = DateUtils.addMonth((Date)DateUtils.getFirstDateOfMonth((Date)date), (int)-1);
        Optional<DynamicObject> card = cards.stream().filter(e -> preMonth.equals(e.getDate("effectivestart")) ? true : DateUtils.isEffectiveDate((Date)preMonth, (Date)e.getDate("effectivestart"), (Date)e.getDate("effectiveend"))).findFirst();
        if (card.isPresent() && (skssqzMap = DateUtils.getSkssqzMap((Date)date, (String)(taxlimit = (dynamicObject = card.get()).getString("taxperiod")))) != null) {
            Date startdate = (Date)skssqzMap.get("skssqq");
            Date enddate = (Date)skssqzMap.get("skssqz");
            logger.info("\u6587\u5316\u4e8b\u4e1a\u5efa\u8bbe\u8d39\u53f0\u8d26\u670d\u52a1\u63d2\u4ef6==taxlimit:{} == startdate:{} == enddate:{} == date:{} == premonth:{} == card:{}", new Object[]{taxlimit, startdate, enddate, date, preMonth, cards.size()});
            map.put("org", orgname);
            map.put("taxlimit", taxlimit);
            map.put("startdate", startdate);
            map.put("enddate", DateUtils.getDayFirst((Date)enddate));
            map.put("rate", dynamicObject.get("amountrate"));
            map.put("isgenerated", WhsyjsfAccountService.hasAccount(orgid, startdate, enddate));
        }
        return map;
    }

    private static Boolean hasAccount(Long orgid, Date startdate, Date enddate) {
        QFilter q1 = new QFilter("org", "=", (Object)orgid);
        QFilter q2 = new QFilter("startdate", "=", (Object)startdate);
        QFilter q3 = new QFilter("enddate", "=", (Object)DateUtils.getDayFirst((Date)enddate));
        return QueryServiceHelper.exists((String)TOTF_WHSYJSF_ACCOUNT, (QFilter[])new QFilter[]{q1, q2, q3});
    }
}

