/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.totf.business.declare;

import java.util.Date;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.declare.helper.DeclareServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.totf.common.utils.WhsyjsfUtils;

public class WhsyjsfDeclareService {
    private static final String DECLAREDATE = "declaredate";
    private static final String ORG = "org";
    private static final String TAXOFFICE = "taxoffice";
    private static final String TOTF_WHSYJS_DECLARE_QUERY = "totf_whsyjs_declare_query";

    public static void initPeriod(IDataModel model, IFormView view, IPageCache cache, Long orgId) {
        String sbbbillno;
        Long sbbid;
        QFilter q4;
        QFilter q3;
        QFilter q2;
        QFilter q1;
        DynamicObject nsrxx;
        Date date;
        String taxlimit;
        Date declaredate = (Date)model.getValue(DECLAREDATE);
        if (null == orgId) {
            return;
        }
        DynamicObject taxMain = null;
        DynamicObject org = (DynamicObject)model.getValue(ORG);
        TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainByOrgId((Long)org.getLong("id"));
        if (result.isSuccess() && EmptyCheckUtils.isNotEmpty((Object)result.getData())) {
            taxMain = (DynamicObject)result.getData();
            model.setValue(TAXOFFICE, (Object)taxMain.getLong("taxoffice.id"));
        }
        if (null == (taxlimit = WhsyjsfUtils.getTaxlimit(orgId, date = DateUtils.getFirstDateOfMonth((Date)declaredate)))) {
            view.showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u7b26\u5408\u7eb3\u7a0e\u671f\u9650\u7684\u5f81\u6536\u54c1\u76ee", (String)"WhsyjsfDeclareService_0", (String)"taxc-totf", (Object[])new Object[0]));
            model.setValue(DECLAREDATE, null);
            cache.put(DECLAREDATE, null);
            return;
        }
        Map<String, Date> map = WhsyjsfUtils.getStartAndEndDate(date, taxlimit);
        if (map.isEmpty()) {
            view.showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u7b26\u5408\u7eb3\u7a0e\u671f\u9650\u7684\u5f81\u6536\u54c1\u76ee", (String)"WhsyjsfDeclareService_0", (String)"taxc-totf", (Object[])new Object[0]));
            model.setValue(DECLAREDATE, null);
            cache.put(DECLAREDATE, null);
            return;
        }
        Date startdate = map.get("startdate");
        Date enddate = map.get("enddate");
        String operationStatus = "read";
        boolean refresh = false;
        Long taxofficeid = null;
        if (taxMain != null) {
            taxofficeid = taxMain.getLong("taxoffice.id");
        }
        if ((nsrxx = QueryServiceHelper.queryOne((String)"tcvat_nsrxx", (String)"id,billno,declaredate,taxauthority", (QFilter[])new QFilter[]{q1 = new QFilter(ORG, "=", (Object)orgId), q2 = new QFilter("type", "=", (Object)"whsyjsf"), q3 = new QFilter("skssqz", "=", (Object)enddate).and(new QFilter("skssqq", "=", (Object)startdate)), q4 = new QFilter("taxauthority", "=", (Object)taxofficeid)})) != null) {
            if (!model.getValue(DECLAREDATE).equals(nsrxx.getDate(DECLAREDATE))) {
                operationStatus = "edit";
            }
            sbbid = nsrxx.getLong("id");
            sbbbillno = nsrxx.getString("billno");
            Long taxoffice = nsrxx.getLong("taxauthority");
            model.setValue(TAXOFFICE, (Object)taxoffice);
        } else {
            operationStatus = "edit";
            sbbid = DeclareServiceHelper.generateSBBId((String)TOTF_WHSYJS_DECLARE_QUERY);
            sbbbillno = DeclareServiceHelper.generateSBBNo((String)TOTF_WHSYJS_DECLARE_QUERY);
            refresh = true;
        }
        model.setValue("declarenumber", (Object)sbbbillno);
        model.setValue(DECLAREDATE, (Object)declaredate);
        cache.put("sbbid", String.valueOf(sbbid));
        cache.put("sbbbillno", sbbbillno);
        cache.put(DECLAREDATE, DateUtils.format((Date)declaredate));
        cache.put("skssqq", DateUtils.format((Date)startdate));
        cache.put("skssqz", DateUtils.format((Date)enddate));
        cache.put("operationStatus", operationStatus);
        cache.put("refresh", String.valueOf(refresh));
        cache.put(TAXOFFICE, String.valueOf(taxofficeid));
    }
}

