/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.totf.business.declare.impl;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.taxc.bdtaxr.business.service.taxdeclare.DeclareTemplateService;
import kd.taxc.bdtaxr.business.serviceImpl.taxdeclare.DeclareTemplateServiceImpl;
import kd.taxc.bdtaxr.common.constant.ZspmConstant;
import kd.taxc.bdtaxr.common.declare.helper.DeclareServiceHelper;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.enums.ZspmEnum;
import kd.taxc.bdtaxr.common.helper.SourceOperateHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxclicense.TaxcLicenseCheckDataServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.param.SystemParamUtil;
import kd.taxc.totf.business.account.OtherIncomeServiceHelper;
import kd.taxc.totf.business.account.WaterFundServiceHelper;
import kd.taxc.totf.business.declare.IDeclareService;
import kd.taxc.totf.business.declare.tysb.TysbServiceHelper;
import kd.taxc.totf.common.utils.WhsyjsfUtils;
import kd.taxc.totf.formplugin.declare.TotfTyDeclare;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class TysbDeclareServiceImpl
implements IDeclareService {
    private static DeclareTemplateService declareTemplateService = new DeclareTemplateServiceImpl();
    private static final String QTSRLIST = "jbrysfzjlx,jbrphone,operatorno,operator";
    private static final String FSSQTSRLIST = "jbrysfzjlx,jbrphone,operatorno,operator,remark";
    private static final String SPLIT = "_";

    @Override
    public DeclareRequestModel builderRequestModel(List<DynamicObject> qtsfEntitys, String orgId, String templateType, Date declareDate, Object taxoffice, String taxcatetory) {
        DeclareRequestModel requestModel = this.setRequestModel(qtsfEntitys, templateType, declareDate, orgId, Long.valueOf(taxoffice.toString()), taxcatetory);
        Date startDate = DateUtils.stringToDate((String)requestModel.getSkssqq());
        Date endDate = DateUtils.stringToDate((String)requestModel.getSkssqz());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("taxauthority", taxoffice);
        requestModel.addBusinessValue("taxoffice", taxoffice.toString());
        Long templateId = declareTemplateService.getTemplateId(templateType, orgId, startDate, endDate);
        if (templateId == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u901a\u7528\u7533\u62a5\u6a21\u677f", (String)"TysbDeclareServiceImpl_0", (String)"taxc-totf", (Object[])new Object[0]));
        }
        requestModel.setOrgId(Long.valueOf(orgId));
        requestModel.setTemplateId(templateId);
        requestModel.setTemplateType(templateType);
        requestModel.setRefresh(Boolean.TRUE);
        requestModel.addBusinessValue("declaredate", DateUtils.format((Date)declareDate));
        requestModel.setExtendParams(map);
        return requestModel;
    }

    private DeclareRequestModel setRequestModel(List<DynamicObject> qtsfEntitys, String templateType, Date declareDate, String orgId, Long taxoffice, String taxcatetory) {
        String sbbbillno;
        Long sbbid;
        DeclareRequestModel requestModel = new DeclareRequestModel();
        if ("qtsf_tysbb".equals(templateType)) {
            sbbid = DeclareServiceHelper.generateSBBId((String)"totf_tysb_declare_main");
            sbbbillno = DeclareServiceHelper.generateSBBNo((String)"totf_tysb_declare_main");
        } else {
            sbbid = DeclareServiceHelper.generateSBBId((String)"totf_sjfzsf_dtb");
            sbbbillno = DeclareServiceHelper.generateSBBNo((String)"totf_sjfzsf_dtb");
        }
        requestModel.setId(sbbid);
        requestModel.setBillNo(sbbbillno);
        ArrayList<Map<String, Object>> maps = new ArrayList<Map<String, Object>>(16);
        Boolean hasLicense = Boolean.FALSE.equals(TaxcLicenseCheckDataServiceHelper.check((Long)Long.parseLong(orgId), (String)"totf").getData());
        for (DynamicObject qtsfEntity : qtsfEntitys) {
            List taxcatetorys;
            String taxperiod = qtsfEntity.getString("taxperiod");
            Map<String, Date> map = WhsyjsfUtils.getStartAndEndDate(declareDate, taxperiod);
            if (map.isEmpty()) continue;
            Date startdate = map.get("startdate");
            Date enddate = map.get("enddate");
            if (!"count".equals(taxperiod)) {
                String zspm = qtsfEntity.getString("collectrate.name");
                boolean zspmExists = TysbServiceHelper.zspmExists(Long.parseLong(orgId), taxoffice, startdate, enddate, zspm);
                if (zspmExists) continue;
                if (zspm.equals(ZspmEnum.DFSLJSJJ.getName())) {
                    boolean prePeriodExists1 = TysbServiceHelper.queryPrePeriodExists(templateType, Long.parseLong(orgId), taxoffice, startdate, enddate, zspm);
                    String temp = "qtsf_tysbb".equals(templateType) ? "qtsf_fsstysbb" : "qtsf_tysbb";
                    boolean prePeriodExists2 = TysbServiceHelper.queryPrePeriodExists(temp, Long.parseLong(orgId), taxoffice, startdate, enddate, zspm);
                    if (!prePeriodExists1 && prePeriodExists2) continue;
                }
            }
            if (requestModel.getSkssqq() == null || startdate.compareTo(DateUtils.stringToDate((String)requestModel.getSkssqq())) < 0) {
                requestModel.setSkssqq(DateUtils.format((Date)startdate));
                requestModel.setSkssqz(DateUtils.format((Date)enddate));
            }
            String zspmId = qtsfEntity.getString("collectrate.id");
            if (taxcatetory != null && !(taxcatetorys = Arrays.stream(taxcatetory.split(",")).collect(Collectors.toList())).contains(String.valueOf(ZspmEnum.getTaxcatetoryByZspmId((String)zspmId)))) continue;
            if ("qtsf_tysbb".equals(templateType)) {
                TysbDeclareServiceImpl.QtsrMessage(qtsfEntity, requestModel, zspmId, orgId, maps, startdate, enddate, taxoffice, hasLicense);
                continue;
            }
            TysbDeclareServiceImpl.FssQtsrMessage(qtsfEntity, requestModel, zspmId, orgId, maps, startdate, enddate, taxoffice, hasLicense);
        }
        if (maps.size() <= 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u901a\u7528\u7533\u62a5\u6ca1\u6709\u7b26\u5408\u7684\u5f81\u6536\u54c1\u76ee", (String)"TysbDeclareServiceImpl_1", (String)"taxc-totf", (Object[])new Object[0]));
        }
        Map<String, Date> skssqMap = TysbServiceHelper.getSkssqMap(maps);
        if (skssqMap.get("skssqq") != null && skssqMap.get("skssqz") != null) {
            requestModel.setSkssqq(DateUtils.format((Date)skssqMap.get("skssqq")));
            requestModel.setSkssqz(DateUtils.format((Date)skssqMap.get("skssqz")));
        }
        String jsonString = JSONObject.toJSONString(maps);
        requestModel.addBusinessValue("zspm", jsonString);
        return requestModel;
    }

    private static void QtsrMessage(DynamicObject qtsfEntity, DeclareRequestModel requestModel, String zspmId, String orgid, List<Map<String, Object>> maps, Date start, Date end, Long taxoffice, Boolean hasLicense) {
        TotfTyDeclare.setCommonMessage(requestModel, QTSRLIST, false, null);
        boolean zerodeclareGhjf = SystemParamUtil.getZeroDeclareParameter((String)"totf", (String)"zerodeclare_ghjf", (long)Long.parseLong(orgid));
        boolean zerodeclareGhcbj = SystemParamUtil.getZeroDeclareParameter((String)"totf", (String)"zerodeclare_ghcbj", (long)Long.parseLong(orgid));
        boolean zerodeclare = SystemParamUtil.getZeroDeclareParameter((String)"totf", (String)"zerodeclare", (long)Long.parseLong(orgid));
        if (String.valueOf(ZspmConstant.ID_GHCBJ_ZPSM).equals(zspmId) || String.valueOf(ZspmConstant.ID_GHJH_ZPSM).equals(zspmId)) {
            if (zerodeclareGhcbj || zerodeclareGhjf) {
                TysbDeclareServiceImpl.setDataBlank(orgid, taxoffice, qtsfEntity, maps, start, end, null);
            } else if (hasLicense.booleanValue()) {
                String limit = qtsfEntity.getString("taxperiod");
                DynamicObjectCollection accountList = OtherIncomeServiceHelper.queryGhjfAccount(orgid, start, end, zspmId, taxoffice, requestModel.getId(), limit);
                if (CollectionUtils.isNotEmpty((Collection)accountList)) {
                    if ("count".equals(limit)) {
                        for (DynamicObject result : accountList) {
                            TysbDeclareServiceImpl.setQtsrMessage(qtsfEntity, result, requestModel, start, end, maps);
                        }
                    } else {
                        TysbDeclareServiceImpl.setQtsrMessageBySum(qtsfEntity, accountList, requestModel, start, end, maps);
                    }
                }
                SourceOperateHelper.saveMappingData((String)"totf_otherincome_account", (Long)requestModel.getId(), (List)accountList);
            }
        }
        if (String.valueOf(ZspmConstant.ID_DFSLJSJJ_ZPSM).equals(zspmId) || String.valueOf(ZspmConstant.ID_DWFHF_ZPSM).equals(zspmId)) {
            boolean existWaterAccount;
            if (zerodeclare) {
                TysbDeclareServiceImpl.setDataBlank(orgid, taxoffice, qtsfEntity, maps, start, end, null);
            } else if (hasLicense.booleanValue() && (existWaterAccount = OtherIncomeServiceHelper.existWaterAccount(orgid, taxoffice, start, end, zspmId, requestModel.getId()))) {
                TysbDeclareServiceImpl.setDataBlank(orgid, taxoffice, qtsfEntity, maps, start, end, null);
            }
        }
    }

    public static int setQtsrMessage(DynamicObject object, DynamicObject result, DeclareRequestModel requestModel, Date start, Date end, List<Map<String, Object>> maps) {
        int size = maps.size();
        HashMap<String, Object> resultMap = TysbDeclareServiceImpl.initResultMap(object, start, end);
        if (null != result) {
            resultMap.put("zspmId", object.getString("collectrate.id"));
            resultMap.put(String.format("%1$s#%2$s", "totf_sjfzsf_dtb", "startdate"), DateUtils.format((Date)result.getDate("startdate")));
            resultMap.put(String.format("%1$s#%2$s", "totf_sjfzsf_dtb", "enddate"), DateUtils.format((Date)result.getDate("enddate")));
            resultMap.put("totf_sjfzsf_dtb#ysx", result.getBigDecimal("taxableitem"));
            resultMap.put("totf_sjfzsf_dtb#jcx", result.getBigDecimal("deductitem"));
            resultMap.put("totf_sjfzsf_dtb#yssdl", result.getBigDecimal("taxrate"));
            resultMap.put("totf_sjfzsf_dtb#sskcs", result.getBigDecimal("quickdeduction"));
            resultMap.put("totf_sjfzsf_dtb#jmse", result.getBigDecimal("deductionamount"));
            resultMap.put("totf_sjfzsf_dtb#deductioncode", result.getLong("taxdeduction"));
            resultMap.put("totf_sjfzsf_dtb#xgmjmxz", result.getLong("zzsdeducttype"));
            resultMap.put("totf_sjfzsf_dtb#xgmjzbl", result.getBigDecimal("zzsdeductrate"));
            resultMap.put("totf_sjfzsf_dtb#yjse", result.getBigDecimal("bqyjse"));
            TotfTyDeclare.setCommonMessage(requestModel, QTSRLIST, true, result);
        }
        maps.add(resultMap);
        return maps.size() - size;
    }

    private static HashMap<String, Object> initResultMap(DynamicObject object, Date start, Date end) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        String name = object.getString("collectrate.name");
        resultMap.put(String.format("%1$s#%2$s", "totf_sjfzsf_dtb", "zspm"), name);
        resultMap.put(String.format("%1$s#%2$s", "totf_sjfzsf_dtb", "zsxm"), TotfTyDeclare.CcTypeMap.get(object.getLong("collectrate.id")).loadKDString());
        resultMap.put(String.format("%1$s#%2$s", "totf_sjfzsf_dtb", "flhdwse"), object.getBigDecimal("amountrate").setScale(6, 4));
        resultMap.put(String.format("%1$s#%2$s", "totf_sjfzsf_dtb", "startdate"), DateUtils.format((Date)start));
        resultMap.put(String.format("%1$s#%2$s", "totf_sjfzsf_dtb", "enddate"), DateUtils.format((Date)end));
        resultMap.put("totf_sjfzsf_dtb#symc", "");
        resultMap.put("totf_sjfzsf_dtb#sybh", "");
        resultMap.put("totf_sjfzsf_dtb#xgmjmxz", "");
        return resultMap;
    }

    private static int setQtsrMessageBySum(DynamicObject object, DynamicObjectCollection result, DeclareRequestModel requestModel, Date start, Date end, List<Map<String, Object>> maps) {
        int size = maps.size();
        HashMap<String, Object> resultMap = TysbDeclareServiceImpl.initResultMap(object, start, end);
        if (result != null && result.size() > 0) {
            resultMap.put("zspmId", object.getString("collectrate.id"));
            resultMap.put("totf_sjfzsf_dtb#ysx", TysbDeclareServiceImpl.getSum(result, "taxableitem"));
            resultMap.put("totf_sjfzsf_dtb#jcx", TysbDeclareServiceImpl.getSum(result, "deductitem"));
            resultMap.put("totf_sjfzsf_dtb#yssdl", TysbDeclareServiceImpl.getlastNotEmptyValue(result, "taxrate"));
            resultMap.put("totf_sjfzsf_dtb#sskcs", TysbDeclareServiceImpl.getSum(result, "quickdeduction"));
            resultMap.put("totf_sjfzsf_dtb#jmse", TysbDeclareServiceImpl.getSum(result, "deductionamount"));
            resultMap.put("totf_sjfzsf_dtb#deductioncode", TysbDeclareServiceImpl.getlastNotEmptyValue(result, "taxdeduction"));
            resultMap.put("totf_sjfzsf_dtb#xgmjmxz", TysbDeclareServiceImpl.getlastNotEmptyValue(result, "zzsdeducttype"));
            resultMap.put("totf_sjfzsf_dtb#xgmjzbl", TysbDeclareServiceImpl.getSum(result, "zzsdeductrate"));
            resultMap.put("totf_sjfzsf_dtb#yjse", TysbDeclareServiceImpl.getSum(result, "bqyjse"));
            TotfTyDeclare.setCommonMessage(requestModel, QTSRLIST, true, (DynamicObject)result.get(0));
        }
        maps.add(resultMap);
        return maps.size() - size;
    }

    private static BigDecimal getSum(DynamicObjectCollection result, String field) {
        return result.stream().map(s -> s.getBigDecimal(field)).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    private static Object getlastNotEmptyValue(DynamicObjectCollection result, String field) {
        return result.stream().sorted(Comparator.comparing(s -> s.getDate("startdate")).reversed()).filter(s -> s.get(field) != null).map(s -> s.get(field)).findFirst().orElseGet(() -> null);
    }

    public static void FssQtsrMessage(DynamicObject qtsfEntity, DeclareRequestModel requestModel, String zspmId, String orgid, List<Map<String, Object>> maps, Date start, Date end, Long taxofficeId, Boolean hasLicense) {
        TotfTyDeclare.setCommonMessage(requestModel, FSSQTSRLIST, false, null);
        String zszm = qtsfEntity.getString("collectitem.id");
        String zszmName = qtsfEntity.getString("collectitem.projectname");
        String limit = qtsfEntity.getString("taxperiod");
        ArrayList<Long> zszmList = new ArrayList<Long>();
        boolean zerodeclare = SystemParamUtil.getZeroDeclareParameter((String)"totf", (String)"zerodeclare", (long)Long.parseLong(orgid));
        boolean zerodeclare_czljcl = SystemParamUtil.getZeroDeclareParameter((String)"totf", (String)"zerodeclare_czljcl", (long)Long.parseLong(orgid));
        DynamicObjectCollection accountList = new DynamicObjectCollection();
        if (String.valueOf(ZspmConstant.ID_CZLJCLF_ZPSM).equals(zspmId)) {
            if (zerodeclare_czljcl) {
                TysbDeclareServiceImpl.setDataBlank(orgid, taxofficeId, qtsfEntity, maps, start, end, zszmName);
            } else if (hasLicense.booleanValue()) {
                if (StringUtils.isNotEmpty((CharSequence)zszm)) {
                    zszmList.add(Long.valueOf(zszm));
                }
                accountList = OtherIncomeServiceHelper.queryLjclfAccount(orgid, taxofficeId, start, end, zszmList, requestModel.getId(), zspmId, limit);
            }
            if (CollectionUtils.isNotEmpty((Collection)accountList)) {
                if ("count".equals(limit)) {
                    for (DynamicObject result : accountList) {
                        TysbDeclareServiceImpl.setFssQtsrMessage(requestModel, qtsfEntity, result, maps);
                    }
                } else {
                    TotfTyDeclare.setFssQtsrMessage(requestModel, Collections.singletonList(qtsfEntity), accountList, maps, DateUtils.format((Date)start), DateUtils.format((Date)end));
                }
            }
            SourceOperateHelper.saveMappingData((String)"totf_jsxzsyxsf_account", (Long)requestModel.getId(), (List)accountList);
        }
        if (String.valueOf(ZspmConstant.ID_DFSLJSJJ_ZPSM).equals(zspmId) || String.valueOf(ZspmConstant.ID_DWFHF_ZPSM).equals(zspmId)) {
            boolean existWaterAccount;
            if (zerodeclare) {
                TysbDeclareServiceImpl.setDataBlank(orgid, taxofficeId, qtsfEntity, maps, start, end, null);
            } else if (hasLicense.booleanValue() && (existWaterAccount = OtherIncomeServiceHelper.existWaterAccount(orgid, taxofficeId, start, end, zspmId, requestModel.getId()))) {
                TysbDeclareServiceImpl.setDataBlank(orgid, taxofficeId, qtsfEntity, maps, start, end, zszmName);
            }
        }
        if ((String.valueOf(ZspmConstant.ID_STBCBCF_ZPSM).equals(zspmId) || String.valueOf(ZspmConstant.ID_STBCBCF_JSQSR_ZPSM).equals(zspmId) || String.valueOf(ZspmConstant.ID_STBCBCF_KCQSR_ZPSM).equals(zspmId) || String.valueOf(ZspmConstant.ID_STBCBCF_QTSR_ZPSM).equals(zspmId)) && hasLicense.booleanValue()) {
            DynamicObject[] accounts = OtherIncomeServiceHelper.queryWaterSoilAccount(orgid, taxofficeId, start, end, zspmId, requestModel.getId());
            if (accounts.length > 0) {
                for (DynamicObject account : accounts) {
                    TotfTyDeclare.setFssStbcbcfMessage(account, maps);
                }
            } else {
                TysbDeclareServiceImpl.setDataBlank(orgid, taxofficeId, qtsfEntity, maps, start, end, zszmName);
            }
            SourceOperateHelper.saveMappingData((String)"totf_stbcbcf_account", (Long)requestModel.getId(), Arrays.asList(accounts));
        }
    }

    public static void setFssQtsrMessage(DeclareRequestModel requestModel, DynamicObject object, DynamicObject result, List<Map<String, Object>> maps) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        String name = object.getString("collectrate.name");
        resultMap.put(String.format("%1$s#%2$s", "totf_sjfzsf_dtb", "zspm"), name);
        resultMap.put(String.format("%1$s#%2$s", "totf_sjfzsf_dtb", "zsxm"), TotfTyDeclare.CcTypeMap.get(object.getLong("collectrate.id")).loadKDString());
        resultMap.put(String.format("%1$s#%2$s", "totf_sjfzsf_dtb", "flhdwse"), object.getBigDecimal("amountrate").setScale(6, 4));
        if (null != result) {
            resultMap.put("zspmId", object.getString("collectrate.id"));
            resultMap.put("zszmId", result.getString("zszm"));
            resultMap.put(String.format("%1$s#%2$s", "totf_sjfzsf_dtb", "startdate"), DateUtils.format((Date)result.getDate("startdate")));
            resultMap.put(String.format("%1$s#%2$s", "totf_sjfzsf_dtb", "enddate"), DateUtils.format((Date)result.getDate("enddate")));
            resultMap.put("totf_sjfzsf_dtb#zszm", OtherIncomeServiceHelper.getZszmName(result.getLong("zszm")));
            resultMap.put("totf_sjfzsf_dtb#yjfjs", result.getBigDecimal("taxableitem"));
            resultMap.put("totf_sjfzsf_dtb#yjfjscke", result.getBigDecimal("deductitem"));
            resultMap.put("totf_sjfzsf_dtb#sskcs", result.getBigDecimal("quickdeduction"));
            resultMap.put("totf_sjfzsf_dtb#jmse", result.getBigDecimal("deductionamount"));
            resultMap.put("totf_sjfzsf_dtb#zsbl", result.getBigDecimal("taxrate"));
            resultMap.put("totf_sjfzsf_dtb#deductioncode", result.getLong("taxdeduction"));
            resultMap.put("totf_sjfzsf_dtb#yjse", result.getBigDecimal("bqyjse"));
            TotfTyDeclare.setCommonMessage(requestModel, FSSQTSRLIST, true, result);
        }
        maps.add(resultMap);
    }

    public static void setDataBlank(String orgid, Long taxoffice, DynamicObject object, List<Map<String, Object>> maps, Date start, Date end, String zszm) {
        if (StringUtils.isNotEmpty((CharSequence)zszm)) {
            HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
            String name = object.getString("collectrate.name");
            resultMap.put(String.format("%1$s#%2$s", "totf_sjfzsf_dtb", "zspm"), name);
            resultMap.put(String.format("%1$s#%2$s", "totf_sjfzsf_dtb", "zsxm"), TotfTyDeclare.CcTypeMap.get(object.getLong("collectrate.id")).loadKDString());
            if (Arrays.asList(ZspmConstant.ID_STBCBCF_ZPSM, ZspmConstant.ID_STBCBCF_JSQSR_ZPSM, ZspmConstant.ID_STBCBCF_KCQSR_ZPSM, ZspmConstant.ID_STBCBCF_QTSR_ZPSM).contains(object.getLong("collectrate.id"))) {
                resultMap.put("zspmId", object.getString("collectrate.id"));
            }
            resultMap.put(String.format("%1$s#%2$s", "totf_sjfzsf_dtb", "flhdwse"), object.getBigDecimal("amountrate").setScale(6, 4));
            resultMap.put(String.format("%1$s#%2$s", "totf_sjfzsf_dtb", "startdate"), DateUtils.format((Date)start));
            resultMap.put(String.format("%1$s#%2$s", "totf_sjfzsf_dtb", "enddate"), DateUtils.format((Date)end));
            resultMap.put("totf_sjfzsf_dtb#yssdl", BigDecimal.valueOf(1L));
            resultMap.put("totf_sjfzsf_dtb#zsbl", BigDecimal.valueOf(1L));
            resultMap.put("totf_sjfzsf_dtb#zszm", zszm);
            resultMap.put("totf_sjfzsf_dtb#symc", "");
            resultMap.put("totf_sjfzsf_dtb#sybh", "");
            resultMap.put("totf_sjfzsf_dtb#xgmjmxz", "");
            maps.add(resultMap);
        } else {
            DynamicObject dynamicObjects;
            HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
            String name = object.getString("collectrate.name");
            if (String.valueOf(ZspmConstant.ID_DFSLJSJJ_ZPSM).equals(object.getString("collectrate.id")) && Objects.nonNull(dynamicObjects = WaterFundServiceHelper.querySljjAccount(orgid, start, end, object.getString("collectrate.id"), taxoffice, null))) {
                resultMap.put("zspmId", object.getString("collectrate.id"));
            }
            if (Arrays.asList(ZspmConstant.ID_STBCBCF_ZPSM, ZspmConstant.ID_STBCBCF_JSQSR_ZPSM, ZspmConstant.ID_STBCBCF_KCQSR_ZPSM, ZspmConstant.ID_STBCBCF_QTSR_ZPSM).contains(object.getLong("collectrate.id"))) {
                resultMap.put("zspmId", object.getString("collectrate.id"));
            }
            resultMap.put(String.format("%1$s#%2$s", "totf_sjfzsf_dtb", "zspm"), name);
            resultMap.put(String.format("%1$s#%2$s", "totf_sjfzsf_dtb", "zsxm"), TotfTyDeclare.CcTypeMap.get(object.getLong("collectrate.id")).loadKDString());
            resultMap.put(String.format("%1$s#%2$s", "totf_sjfzsf_dtb", "flhdwse"), object.getBigDecimal("amountrate").setScale(6, 4));
            resultMap.put(String.format("%1$s#%2$s", "totf_sjfzsf_dtb", "startdate"), DateUtils.format((Date)start));
            resultMap.put(String.format("%1$s#%2$s", "totf_sjfzsf_dtb", "enddate"), DateUtils.format((Date)end));
            resultMap.put("totf_sjfzsf_dtb#yssdl", BigDecimal.valueOf(1L));
            resultMap.put("totf_sjfzsf_dtb#zsbl", BigDecimal.valueOf(1L));
            resultMap.put("totf_sjfzsf_dtb#symc", "");
            resultMap.put("totf_sjfzsf_dtb#sybh", "");
            resultMap.put("totf_sjfzsf_dtb#zszm", "");
            resultMap.put("totf_sjfzsf_dtb#xgmjmxz", "");
            maps.add(resultMap);
        }
    }
}

