/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.totf.business.declare.impl;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.taxc.bdtaxr.business.service.taxdeclare.DeclareTemplateService;
import kd.taxc.bdtaxr.business.serviceImpl.taxdeclare.DeclareTemplateServiceImpl;
import kd.taxc.bdtaxr.common.db.table.tctb.YbnsrService;
import kd.taxc.bdtaxr.common.declare.helper.DeclareServiceHelper;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.totf.business.account.WhsyjsfAccountServiceHelper;
import kd.taxc.totf.business.declare.IDeclareService;
import kd.taxc.totf.common.utils.WhsyjsfUtils;

public class WhsyjsfDeclareServiceImpl
implements IDeclareService {
    private static DeclareTemplateService declareTemplateService = new DeclareTemplateServiceImpl();

    @Override
    public DeclareRequestModel builderRequestModel(List<DynamicObject> qtsfEntitys, String orgId, String templateType, Date declareDate, Object taxoffice, String taxcatetory) {
        Date preMonth = DateUtils.getFirstDateOfMonth((Date)declareDate);
        DeclareRequestModel requestModel = new DeclareRequestModel();
        DynamicObject qtsfEntity = qtsfEntitys.get(0);
        Map<String, Date> map = WhsyjsfUtils.getStartAndEndDate(preMonth, qtsfEntity.getString("taxperiod"));
        if (map.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6587\u5316\u4e8b\u4e1a\u5efa\u8bbe\u8d39\u7533\u62a5\u6ca1\u6709\u7b26\u5408\u7684\u5f81\u6536\u54c1\u76ee", (String)"WhsyjsfDeclareServiceImpl_0", (String)"taxc-totf", (Object[])new Object[0]));
        }
        Date startdate = map.get("startdate");
        Date enddate = map.get("enddate");
        DynamicObject dyo = YbnsrService.queryYbnsr((String)orgId, (String)templateType, (String)DateUtils.format((Date)startdate), (String)DateUtils.format((Date)enddate), null);
        if (dyo != null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u5df2\u5b58\u5728\u5bf9\u5e94\u5c5e\u671f\u7684\u6587\u5316\u4e8b\u4e1a\u5efa\u8bbe\u8d39\u7533\u62a5\u6570\u636e", (String)"WhsyjsfDeclareServiceImpl_1", (String)"taxc-totf", (Object[])new Object[0]));
        }
        Long templateId = declareTemplateService.getTemplateId(templateType, orgId, startdate, enddate);
        if (templateId == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u6587\u5316\u4e8b\u4e1a\u5efa\u8bbe\u8d39\u7533\u62a5\u6a21\u677f", (String)"WhsyjsfDeclareServiceImpl_2", (String)"taxc-totf", (Object[])new Object[0]));
        }
        boolean existWhsyjsAccount = WhsyjsfAccountServiceHelper.existWhsyjsfAccount(orgId, taxoffice, startdate, enddate);
        if (!existWhsyjsAccount) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u4e0d\u5b58\u5728\u7b26\u5408\u5f53\u524d\u5c5e\u671f\u7684\u53f0\u8d26\u6570\u636e", (String)"WhsyjsfDeclareServiceImpl_3", (String)"taxc-totf", (Object[])new Object[0]));
        }
        Long sbbid = DeclareServiceHelper.generateSBBId((String)"totf_whsyjs_declare_query");
        String sbbbillno = DeclareServiceHelper.generateSBBNo((String)"totf_whsyjs_declare_query");
        requestModel.setOrgId(Long.valueOf(orgId));
        requestModel.setId(sbbid);
        requestModel.setSkssqq(DateUtils.format((Date)startdate));
        requestModel.setSkssqz(DateUtils.format((Date)enddate));
        requestModel.setBillNo(sbbbillno);
        requestModel.setTemplateId(templateId);
        requestModel.setTemplateType(templateType);
        requestModel.setRefresh(Boolean.TRUE);
        requestModel.addBusinessValue("declaredate", DateUtils.format((Date)declareDate));
        requestModel.addBusinessValue("billno", sbbbillno);
        requestModel.addBusinessValue("taxoffice", taxoffice.toString());
        HashMap<String, Object> extendParams = new HashMap<String, Object>();
        extendParams.put("declaredate", DateUtils.format((Date)declareDate));
        extendParams.put("billno", sbbbillno);
        extendParams.put("taxauthority", taxoffice);
        requestModel.setExtendParams(extendParams);
        return requestModel;
    }
}

