/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.totf.business.declare.tysb;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;

public class TysbServiceHelper {
    public static List<Long> querySbbIds(Long orgid, Long taxoffice, Date declaredate, String templateType) {
        Date firstDateOfMonth = DateUtils.getFirstDateOfMonth((Date)declaredate);
        Date lastDateOfMonth = DateUtils.getLastDateOfMonth((Date)declaredate);
        QFilter q1 = new QFilter("declaredate", ">=", (Object)firstDateOfMonth);
        QFilter q2 = new QFilter("declaredate", "<=", (Object)lastDateOfMonth);
        QFilter q3 = new QFilter("org", "=", (Object)orgid);
        QFilter q4 = new QFilter("taxauthority", "=", (Object)taxoffice);
        QFilter q5 = new QFilter("type", "=", (Object)templateType);
        DynamicObjectCollection objects = QueryServiceHelper.query((String)"totf_tysb_declare_main", (String)"id", (QFilter[])new QFilter[]{q1, q2, q3, q4, q5});
        return objects.stream().map(d -> d.getLong("id")).collect(Collectors.toList());
    }

    public static boolean zspmExists(Long orgId, Long taxoffice, Date skssqq, Date skssqz, String zspm) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("org", "=", (Object)orgId));
        qFilters.add(new QFilter("taxauthority", "=", (Object)taxoffice));
        qFilters.add(new QFilter("entryentity.startdate", "=", (Object)skssqq));
        qFilters.add(new QFilter("entryentity.enddate", "=", (Object)skssqz));
        qFilters.add(new QFilter("entryentity.zspm", "=", (Object)zspm));
        return QueryServiceHelper.exists((String)"totf_tysb_declare_main", (QFilter[])qFilters.toArray(new QFilter[0]));
    }

    public static boolean queryPrePeriodExists(String templateType, long orgId, Long taxoffice, Date startdate, Date enddate, String zspm) {
        List dateList = DateUtils.getPreDate((Date)startdate, (Date)enddate);
        if (EmptyCheckUtils.isNotEmpty((Object)dateList)) {
            Date skssqq = (Date)dateList.get(0);
            Date skssqz = DateUtils.trunc((Date)((Date)dateList.get(1)));
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            qFilters.add(new QFilter("org", "=", (Object)orgId));
            qFilters.add(new QFilter("type", "=", (Object)templateType));
            qFilters.add(new QFilter("taxauthority", "=", (Object)taxoffice));
            qFilters.add(new QFilter("entryentity.startdate", "=", (Object)skssqq));
            qFilters.add(new QFilter("entryentity.enddate", "=", (Object)skssqz));
            qFilters.add(new QFilter("entryentity.zspm", "=", (Object)zspm));
            return QueryServiceHelper.exists((String)"totf_tysb_declare_main", (QFilter[])qFilters.toArray(new QFilter[0]));
        }
        return false;
    }

    public static Map<String, Date> getSkssqMap(List<Map<String, Object>> maps) {
        HashMap<String, Date> skssqMap = new HashMap<String, Date>();
        Date skssqq = null;
        Date skssqz = null;
        for (Map<String, Object> map : maps) {
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                String key = entry.getKey();
                if (key != null && key.endsWith("startdate")) {
                    Date startdate = DateUtils.stringToDate2((String)((String)entry.getValue()));
                    if (skssqq == null) {
                        skssqq = startdate;
                    }
                    if (skssqq == null || startdate == null || skssqq.compareTo(startdate) <= 0) continue;
                    skssqq = startdate;
                    continue;
                }
                if (key == null || !key.endsWith("enddate")) continue;
                Date enddate = DateUtils.stringToDate2((String)((String)entry.getValue()));
                if (skssqz == null) {
                    skssqz = enddate;
                }
                if (skssqz == null || enddate == null || skssqz.compareTo(enddate) >= 0) continue;
                skssqz = enddate;
            }
        }
        if (skssqq != null && skssqz != null) {
            skssqMap.put("skssqq", skssqq);
            skssqMap.put("skssqz", skssqz);
        }
        return skssqMap;
    }
}

