/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.totf.business.dynamicrow;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.taxc.bdtaxr.common.enums.ZspmEnum;
import kd.taxc.bdtaxr.common.helper.SourceOperateHelper;
import kd.taxc.bdtaxr.common.refactor.template.plugin.AbstractDynamicListBasePlugin;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.param.SystemParamUtil;
import kd.taxc.bdtaxr.common.vo.BussinessParamsVo;
import org.apache.commons.lang3.StringUtils;

public class QtsfTysbFetchDataPlugin
extends AbstractDynamicListBasePlugin {
    public List<Map<String, Object>> query(BussinessParamsVo bussinessParamsVo) {
        List<Map<String, Object>> maps = new ArrayList<Map<String, Object>>(16);
        Long sbbid = (Long)bussinessParamsVo.getExtendParams().get("sbbid");
        String zspm = (String)bussinessParamsVo.getExtendParams().get("zspm");
        String zerodeclare = (String)bussinessParamsVo.getExtendParams().get("zerodeclare");
        String taxauthority = (String)bussinessParamsVo.getExtendParams().get("taxoffice");
        String orgId = bussinessParamsVo.getOrgId();
        if (StringUtils.isNotEmpty((CharSequence)zspm)) {
            maps = (List)JSONObject.parseObject((String)zspm, List.class);
            for (Map<String, Object> map : maps) {
                QFilter q5;
                QFilter q4;
                QFilter q3;
                QFilter q2;
                String startdate;
                map.put("totf_sjfzsf_dtb#deductioncode", 0L);
                map.put("totf_sjfzsf_dtb#qmzgrs", 0);
                String name = (String)map.get("totf_sjfzsf_dtb#zspm");
                if (ZspmEnum.DFSLJSJJ.getName().equals(name) && "false".equals(zerodeclare)) {
                    startdate = (String)map.get("totf_sjfzsf_dtb#startdate");
                    String enddate = (String)map.get("totf_sjfzsf_dtb#enddate");
                    if (null != orgId && null != startdate && null != enddate) {
                        QFilter q1 = new QFilter("org", "=", (Object)Long.valueOf(orgId));
                        DynamicObjectCollection object = QueryServiceHelper.query((String)"totf_water_fund", (String)"id,taxableitem,deductionamount,taxdeduction,billno", (QFilter[])new QFilter[]{q1, q2 = new QFilter("startdate", "=", (Object)DateUtils.stringToDate((String)startdate)), q3 = new QFilter("enddate", "=", (Object)DateUtils.stringToDate((String)enddate)), q4 = new QFilter("taxoffice", "=", (Object)Long.valueOf(taxauthority)), q5 = new QFilter("sbbid", "=", (Object)0L).or("sbbid", "=", (Object)sbbid)});
                        if (object != null && object.size() > 0) {
                            map.put("totf_sjfzsf_dtb#ysx", object.stream().map(s -> s.getBigDecimal("taxableitem")).reduce(BigDecimal.ZERO, BigDecimal::add));
                            map.put("totf_sjfzsf_dtb#jmse", object.stream().map(s -> s.getBigDecimal("deductionamount")).reduce(BigDecimal.ZERO, BigDecimal::add));
                            map.put("totf_sjfzsf_dtb#deductioncode", ((DynamicObject)object.get(0)).get("taxdeduction"));
                            SourceOperateHelper.saveMappingData((String)"totf_water_fund", (Long)sbbid, (List)object);
                        } else {
                            map.put("totf_sjfzsf_dtb#ysx", BigDecimal.ZERO);
                        }
                    }
                } else if (ZspmEnum.DWFHF.getName().equals(name) && "false".equals(zerodeclare)) {
                    startdate = (String)map.get("totf_sjfzsf_dtb#startdate");
                    String enddate = (String)map.get("totf_sjfzsf_dtb#enddate");
                    if (null != orgId && null != startdate && null != enddate) {
                        QFilter q1 = new QFilter("org", "=", (Object)Long.valueOf(orgId));
                        DynamicObjectCollection results = QueryServiceHelper.query((String)"totf_embankment_account", (String)"id,taxableitem,deductitem,taxrate,quickdeduction,taxdeduction,deductionamount,zzsdeducttype,zzsdeductrate,bqyjse,startdate", (QFilter[])new QFilter[]{q1, q2 = new QFilter("startdate", ">=", (Object)DateUtils.stringToDate2((String)startdate)), q3 = new QFilter("enddate", "<=", (Object)DateUtils.stringToDate2((String)enddate)), q4 = new QFilter("taxoffice", "=", (Object)Long.valueOf(taxauthority)), q5 = new QFilter("sbbid", "=", (Object)0L).or("sbbid", "=", (Object)sbbid)});
                        if (CollectionUtils.isNotEmpty((Collection)results)) {
                            map.put("totf_sjfzsf_dtb#ysx", QtsfTysbFetchDataPlugin.getSum(results, "taxableitem"));
                            map.put("totf_sjfzsf_dtb#jcx", QtsfTysbFetchDataPlugin.getSum(results, "deductitem"));
                            map.put("totf_sjfzsf_dtb#yssdl", QtsfTysbFetchDataPlugin.getlastNotEmptyValue(results, "taxrate"));
                            map.put("totf_sjfzsf_dtb#sskcs", QtsfTysbFetchDataPlugin.getSum(results, "quickdeduction"));
                            map.put("totf_sjfzsf_dtb#jmse", QtsfTysbFetchDataPlugin.getSum(results, "deductionamount"));
                            map.put("totf_sjfzsf_dtb#deductioncode", QtsfTysbFetchDataPlugin.getlastNotEmptyValue(results, "taxdeduction"));
                            map.put("totf_sjfzsf_dtb#xgmjmxz", QtsfTysbFetchDataPlugin.getlastNotEmptyValue(results, "zzsdeducttype"));
                            map.put("totf_sjfzsf_dtb#xgmjzbl", QtsfTysbFetchDataPlugin.getSum(results, "zzsdeductrate"));
                            map.put("totf_sjfzsf_dtb#yjse", QtsfTysbFetchDataPlugin.getSum(results, "bqyjse"));
                            SourceOperateHelper.saveMappingData((String)"totf_embankment_account", (Long)sbbid, results.stream().collect(Collectors.toList()));
                        } else {
                            map.put("totf_sjfzsf_dtb#ysx", BigDecimal.ZERO);
                        }
                    }
                }
                for (ZspmEnum zspmEnum : ZspmEnum.values()) {
                    String key;
                    boolean zeroDeclare = SystemParamUtil.getZeroDeclareParameter((String)"totf", (String)zspmEnum.getParamKey(), (long)Long.parseLong(orgId));
                    if (!zeroDeclare || !zspmEnum.getName().equals(map.get("totf_sjfzsf_dtb#zspm")) || !"qtsf_tysbb".equals(zspmEnum.getTemplateType())) continue;
                    for (String field : zspmEnum.getZeroFields()) {
                        key = String.format("totf_sjfzsf_dtb#%s", field);
                        map.put(key, "0.00");
                    }
                    for (String emptyField : zspmEnum.getEmptyFields()) {
                        key = String.format("totf_sjfzsf_dtb#%s", emptyField);
                        map.put(key, "");
                    }
                }
            }
        }
        return maps;
    }

    private static BigDecimal getSum(DynamicObjectCollection result, String field) {
        return result.stream().map(s -> s.getBigDecimal(field)).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    private static Object getlastNotEmptyValue(DynamicObjectCollection result, String field) {
        return result.stream().sorted(Comparator.comparing(s -> s.getDate("startdate")).reversed()).filter(s -> s.get(field) != null).map(s -> s.get(field)).findFirst().orElseGet(() -> null);
    }
}

