/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.totf.business.dynamicrow;

import java.util.Date;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.taxc.bdtaxr.common.declare.helper.DeclareServiceHelper;
import kd.taxc.bdtaxr.common.refactor.declare.ImportExcelHandler;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.vo.ImportDataVo;
import kd.taxc.totf.common.utils.WhsyjsfUtils;

public class WhsyjsfImportExcelHandler
implements ImportExcelHandler {
    private static final String TOTF_WHSYJS_DECLARE_QUERY = "totf_whsyjs_declare_query";

    public void initImportData(ImportDataVo importDataVo, Map<String, String> resultMap) {
        Date declaredate = new Date();
        resultMap.put("tcvat_nsrxx#1#declaredate", DateUtils.format((Date)DateUtils.getDayFirst((Date)declaredate)));
        this.cheackDate(resultMap);
    }

    public void cheackDate(Map<String, String> resultMap) {
        if (StringUtils.isNotBlank((CharSequence)resultMap.get("tcvat_nsrxx#1#org")) && StringUtils.isNotBlank((CharSequence)resultMap.get("tcvat_nsrxx#1#skssqq")) && StringUtils.isNotBlank((CharSequence)resultMap.get("tcvat_nsrxx#1#skssqz"))) {
            Long orgid = Long.valueOf(resultMap.get("tcvat_nsrxx#1#org"));
            Date skssqq = DateUtils.stringToDate((String)resultMap.get("tcvat_nsrxx#1#skssqq"), (String)(resultMap.get("tcvat_nsrxx#1#skssqq").contains(ResManager.loadKDString((String)"\u65e5", (String)"WhsyjsfImportExcelHandler_0", (String)"taxc-totf", (Object[])new Object[0])) ? DateUtils.YYYYMMDD_CHINESE : "yyyy-MM-dd"));
            Date skssqz = DateUtils.stringToDate((String)resultMap.get("tcvat_nsrxx#1#skssqz"), (String)(resultMap.get("tcvat_nsrxx#1#skssqq").contains(ResManager.loadKDString((String)"\u65e5", (String)"WhsyjsfImportExcelHandler_0", (String)"taxc-totf", (Object[])new Object[0])) ? DateUtils.YYYYMMDD_CHINESE : "yyyy-MM-dd"));
            String taxlimit = WhsyjsfUtils.getTaxlimit(orgid, DateUtils.addMonth((Date)skssqq, (int)1));
            if (null != taxlimit) {
                Date startdate = null;
                Date enddate = null;
                switch (taxlimit) {
                    case "month": {
                        startdate = DateUtils.getFirstDateOfMonth((Date)skssqq);
                        enddate = DateUtils.getLastDateOfMonth((Date)skssqq);
                        break;
                    }
                    case "season": {
                        startdate = DateUtils.getFirstDateOfSeason((Date)skssqq);
                        enddate = DateUtils.getLastDateOfSeason((Date)skssqq);
                        break;
                    }
                    case "halfyear": {
                        startdate = DateUtils.getFirstDateOfHalfYear((Date)skssqq);
                        enddate = DateUtils.getLastDateOfHalfYear((Date)skssqq);
                        break;
                    }
                    case "year": {
                        startdate = DateUtils.getFirstDateOfYear((Date)skssqq);
                        enddate = DateUtils.getLastDateOfYear((Date)skssqq);
                        break;
                    }
                    default: {
                        startdate = DateUtils.stringToDate((String)"1900-01-31");
                        enddate = DateUtils.stringToDate((String)"1900-01-01");
                    }
                }
                if (startdate.getTime() != skssqq.getTime() || DateUtils.getDayFirst((Date)enddate).getTime() != skssqz.getTime()) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u7b26\u5408\u7eb3\u7a0e\u671f\u9650\u7684\u5f81\u6536\u54c1\u76ee", (String)"WhsyjsfImportExcelHandler_1", (String)"taxc-totf", (Object[])new Object[0]));
                }
            } else {
                throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u7b26\u5408\u7eb3\u7a0e\u671f\u9650\u7684\u5f81\u6536\u54c1\u76ee", (String)"WhsyjsfImportExcelHandler_1", (String)"taxc-totf", (Object[])new Object[0]));
            }
        }
    }

    public String getBillNo(String id, String skssqz) {
        return DeclareServiceHelper.generateSBBNo((String)TOTF_WHSYJS_DECLARE_QUERY);
    }
}

