/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.totf.business.engine;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.bastax.taxcorgan.TaxcOrganDataServiceHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;

public class WaterFundHelper {
    private static final String GROUP_FORMAT = "%s_%s_%s";
    private static final BigDecimal TEN_THOUSAND = new BigDecimal(100000);
    private static final Long JM_ID = 1564586032085696512L;
    private static final Long JM6499042402_ID = 1981893390886886400L;
    private static final Long NINGXIA_TAXOFFICEID = 1010868748409687373L;

    public static void calculateAmounts(DynamicObject dynamicObject, BigDecimal taxableitem) {
        dynamicObject.set("taxableitem", (Object)BigDecimalUtil.checkLength((BigDecimal)taxableitem));
        BigDecimal bqynfe = BigDecimalUtil.multiplyObject((Object)taxableitem, (Object)dynamicObject.getBigDecimal("rate"), (int)2, (int)4);
        dynamicObject.set("amount", (Object)BigDecimalUtil.checkLength((BigDecimal)bqynfe));
        BigDecimal deductionamount = BigDecimal.ZERO;
        if (taxableitem.compareTo(TEN_THOUSAND) < 0) {
            DynamicObject object = BusinessDataServiceHelper.loadSingleFromCache((Object)JM_ID, (String)"tpo_taxdeduction");
            dynamicObject.set("taxdeduction", (Object)object);
            String deductiontype = object.getString("deductiontype");
            deductionamount = WaterFundHelper.calcDeductionAmount(bqynfe, deductiontype);
        } else {
            long taxdeductionId = 0L;
            Object taxoffice = dynamicObject.get("taxoffice");
            long taxofficeId = 0L;
            if (taxoffice != null && taxoffice.getClass().isAssignableFrom(DynamicObject.class)) {
                taxofficeId = ((DynamicObject)taxoffice).getLong("id");
            } else if (taxoffice != null && taxoffice.getClass().isAssignableFrom(Long.class)) {
                taxofficeId = (Long)taxoffice;
            }
            TaxResult result = TaxcOrganDataServiceHelper.getOneLevelTaxcOrganIdById((Long)taxofficeId);
            if (result != null && result.isSuccess() && result.getData() != null && NINGXIA_TAXOFFICEID.equals(result.getData())) {
                taxdeductionId = JM6499042402_ID;
                deductionamount = BigDecimalUtil.multiplyObject((Object)dynamicObject.getBigDecimal("amount"), (Object)new BigDecimal("0.10"), (int)2);
            }
            dynamicObject.set("taxdeduction", (Object)taxdeductionId);
        }
        dynamicObject.set("deductionamount", (Object)deductionamount);
        dynamicObject.set("bqybtse", (Object)BigDecimalUtil.checkLength((BigDecimal)BigDecimalUtil.subtractObject((Object)bqynfe, (Object)deductionamount)));
    }

    public static BigDecimal calcDeductionAmount(BigDecimal bqynfe, String deductiontype) {
        BigDecimal deductionamount = BigDecimal.ZERO;
        if ("1".equals(deductiontype)) {
            deductionamount = bqynfe;
        } else if ("2".equals(deductiontype)) {
            deductionamount = BigDecimalUtil.divideObject((Object)bqynfe, (Object)new BigDecimal(2), (int)2);
        }
        return deductionamount;
    }

    public static BigDecimal calcSumAmountByGroup(List<DynamicObject> genericObjects) {
        BigDecimal total = BigDecimal.ZERO;
        if (EmptyCheckUtils.isEmpty(genericObjects)) {
            return total;
        }
        Map<String, List<DynamicObject>> groupedMap = genericObjects.stream().collect(Collectors.groupingBy(WaterFundHelper.groupFunction()));
        for (Map.Entry<String, List<DynamicObject>> entry : groupedMap.entrySet()) {
            BigDecimal totalAmountByRule = BigDecimalUtil.sumDynamicObjectAmount(entry.getValue(), (String)"amount");
            total = BigDecimalUtil.addObject((Object)total, (Object)totalAmountByRule);
        }
        return total;
    }

    private static Function<DynamicObject, String> groupFunction() {
        return d -> String.format(GROUP_FORMAT, d.getString("taxorg"), d.getString("mappingid"), d.getString("ruleid"));
    }
}

