/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.totf.business.engine;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;

public class WhsyjsfAccountHelper {
    public static void calculateAmounts(DynamicObject dynamicObject, BigDecimal taxableitem) {
        dynamicObject.set("taxableitem", (Object)BigDecimalUtil.checkLength((BigDecimal)taxableitem));
        BigDecimal bqynfe = BigDecimalUtil.multiplyObject((Object)taxableitem, (Object)dynamicObject.getBigDecimal("rate"), (int)2, (int)4);
        dynamicObject.set("amount", (Object)BigDecimalUtil.checkLength((BigDecimal)bqynfe));
        BigDecimal deductionamount = BigDecimal.ZERO;
        dynamicObject.set("taxdeduction", (Object)0L);
        dynamicObject.set("deductionamount", (Object)deductionamount);
        dynamicObject.set("bqybtse", (Object)BigDecimalUtil.checkLength((BigDecimal)BigDecimalUtil.subtractObject((Object)bqynfe, (Object)deductionamount)));
    }

    public static BigDecimal calcSumAmountByGroup(List<DynamicObject> genericObjects) {
        BigDecimal total = BigDecimal.ZERO;
        if (EmptyCheckUtils.isEmpty(genericObjects)) {
            return total;
        }
        Map<String, List<DynamicObject>> groupedMap = genericObjects.stream().collect(Collectors.groupingBy(WhsyjsfAccountHelper.groupFunction()));
        for (Map.Entry<String, List<DynamicObject>> entry : groupedMap.entrySet()) {
            BigDecimal totalAmountByRule = BigDecimalUtil.sumDynamicObjectAmount(entry.getValue(), (String)"amount");
            total = BigDecimalUtil.addObject((Object)total, (Object)totalAmountByRule);
        }
        return total;
    }

    private static Function<DynamicObject, String> groupFunction() {
        return d -> String.format("%s_%s_%s", d.getString("taxorg"), d.getString("mappingid"), d.getString("ruleid"));
    }
}

