/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.totf.business.engine.impl;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.mq.DeclareTaxType;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineTask;
import kd.taxc.bdtaxr.common.threadpools.Task;
import kd.taxc.bdtaxr.common.threadpools.ThreadPoolsService;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.param.SystemParamUtil;
import kd.taxc.totf.business.engine.WaterFundHelper;
import kd.taxc.totf.business.engine.impl.WaterFundAutoCollectEngine;
import kd.taxc.totf.business.engine.task.RuleSettingTask;

public class WaterFundAccrualDataService {
    private static final String TOTF_RULE_WATERFUND = "totf_rule_waterfund";
    private static final String TOTF_WATERFUND_JTDETAIL = "totf_waterfund_jtdetail";
    private static final String TOTF_WATERJT_ADJUST = "totf_waterjt_adjust";
    private static final String TOTF_SHARINGPLAN = "totf_sharingplan";
    private static final String TOTF_EDIT_SHARINGPLAN = "totf_edit_sharingplan";
    private static final String TAXTYPE_SLJSJJ = "sljsjj";
    private static Log logger = LogFactory.getLog(WaterFundAutoCollectEngine.class);

    public static BigDecimal doCalcDetails(Long orgId, Date skssqq, Date skssqz, long id) {
        EngineModel engineModel = new EngineModel(String.valueOf(orgId), DateUtils.format((Date)skssqq), DateUtils.format((Date)skssqz));
        List<Long> orgList = Collections.singletonList(orgId);
        Throwable throwable = null;
        try (TXHandle h = TX.requiresNew();){
            BigDecimal totalAmount;
            BigDecimal bigDecimal = totalAmount = WaterFundAccrualDataService.calAmount(orgId, orgList, skssqq, skssqz, engineModel, id);
            return bigDecimal;
        }
        catch (Throwable t) {
            try {
                h.markRollback();
                throw new RuntimeException(t);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    private static BigDecimal calAmount(Long rootOrgId, List<Long> orgList, Date startDate, Date endDate, EngineModel engineModel, long id) throws Exception {
        logger.info("\u5f00\u59cb\u6267\u884c\u6c34\u5229\u5efa\u8bbe\u57fa\u91d1\u53f0\u8d26\u5f15\u64ce");
        long start = System.currentTimeMillis();
        boolean isprepay = (Boolean)SystemParamUtil.getAppParameter((String)"totf", (String)"prepay", (long)rootOrgId);
        String declaration = "1";
        BigDecimal prepaytotalAmount = BigDecimal.ZERO;
        if (isprepay) {
            List declareserialnoList;
            QFilter accountFilter;
            DynamicObjectCollection prepayAccount;
            List monthBetween = DateUtils.getMonthBetween((Date)startDate, (Date)endDate, (String)"yyyy-MM-dd");
            List<Date> monthList = monthBetween.stream().map(m -> DateUtils.stringToDate((String)m)).collect(Collectors.toList());
            QFilter filter = new QFilter("org", "=", (Object)rootOrgId).and(new QFilter("billstatus", "=", (Object)"C"));
            QFilter timefilter = new QFilter("skssqq", "=", (Object)startDate).and(new QFilter("skssqz", "=", (Object)endDate));
            monthList.forEach(s -> timefilter.or(new QFilter("skssqq", "=", s).and(new QFilter("skssqz", "=", (Object)DateUtils.getLastDateOfMonth2((Date)s)))));
            DynamicObjectCollection prepayDeclareQuery = QueryServiceHelper.query((String)"tcvat_prepay_declare_bill", (String)"sbbid,declareserialno", (QFilter[])new QFilter[]{filter, timefilter});
            if (prepayDeclareQuery != null && prepayDeclareQuery.size() > 0 && (prepayAccount = QueryServiceHelper.query((String)"tcvat_project_account", (String)"orgid,startdate,enddate,taxoffice,prepaytype,declareserialno,entryentity.taxtype,entryentity.prepayrate,entryentity.prepaybase", (QFilter[])new QFilter[]{accountFilter = new QFilter("orgid", "=", (Object)rootOrgId).and(new QFilter("declareserialno", "in", declareserialnoList = prepayDeclareQuery.stream().map(p -> p.getString("declareserialno")).collect(Collectors.toList()))).and(new QFilter("entryentity.taxtype", "=", (Object)ResManager.loadKDString((String)"\u6c34\u5229\u5efa\u8bbe\u57fa\u91d1", (String)"WaterFundAccrualDataService_0", (String)"taxc-totf", (Object[])new Object[0])))})) != null && prepayAccount.size() > 0) {
                prepaytotalAmount = WaterFundAccrualDataService.PrepayAccountCalculate(rootOrgId, startDate, endDate, prepayAccount, id);
            }
        }
        BigDecimal totalAmount = WaterFundAccrualDataService.ruleCalculate(orgList, engineModel, id);
        logger.info("\u7ed3\u675f\u6267\u884c\u6c34\u5229\u5efa\u8bbe\u57fa\u91d1\u8ba1\u63d0\u5f15\u64ce\uff0c\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start));
        return totalAmount.add(prepaytotalAmount);
    }

    private static BigDecimal ruleCalculate(List<Long> orgList, EngineModel engineModel, long id) throws Exception {
        DynamicObject[] rules = WaterFundAccrualDataService.fetchRuleids(orgList.get(0));
        if (rules.length == 0) {
            return BigDecimal.ZERO;
        }
        ArrayList<Future<Object>> futures = new ArrayList<Future<Object>>();
        for (Long orgid : orgList) {
            futures.addAll(WaterFundAccrualDataService.calSummaryAccountByOrg(engineModel, id, orgid));
        }
        List detailList = EngineTask.getFutureList(futures);
        BigDecimal totalAmount = WaterFundHelper.calcSumAmountByGroup(detailList);
        return totalAmount;
    }

    private static List<Future<Object>> calSummaryAccountByOrg(EngineModel engineModel, long id, Long orgid) {
        DynamicObject[] rules = WaterFundAccrualDataService.fetchRuleids(orgid);
        ArrayList<Future<Object>> futures = new ArrayList<Future<Object>>();
        for (DynamicObject rule : rules) {
            RuleSettingTask ruleSettingTask = new RuleSettingTask(orgid, engineModel, rule, rule.getDynamicObjectCollection("entryentity"), String.valueOf(id), TOTF_WATERFUND_JTDETAIL, DeclareTaxType.SLJSJJ.getBaseTaxId());
            futures.addAll(ThreadPoolsService.getInstance().submitReturnFuture((Task)ruleSettingTask));
        }
        return futures;
    }

    private static DynamicObject[] fetchRuleids(Long orgid) {
        ArrayList orgQfilters = Lists.newArrayList((Object[])new QFilter[]{new QFilter("orgentity.org", "=", (Object)orgid)});
        DynamicObjectCollection sharingRules = QueryServiceHelper.query((String)"totf_shareplan", (String)"ruleentity.rule as ruleid, ruleentity.rule.group as groupid", (QFilter[])orgQfilters.toArray(new QFilter[0]));
        List sharingPlanRuleIdList = sharingRules.stream().map(e -> e.getLong("ruleid")).collect(Collectors.toList());
        QFilter orgFilter = new QFilter("org", "=", (Object)orgid);
        QFilter ruletypeFilter = new QFilter("ruletype", "=", (Object)"private");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter ruleIdFilter = new QFilter("id", "in", sharingPlanRuleIdList);
        QFilter rulePurposeFilter = new QFilter("rulepurpose", "like", (Object)"%sjjt%");
        QFilter qFilter = enableFilter.and(rulePurposeFilter).and(ruleIdFilter.or(orgFilter.and(ruletypeFilter)));
        DynamicObjectCollection ruleCollection = QueryServiceHelper.query((String)TOTF_RULE_WATERFUND, (String)"id,name", (QFilter[])new QFilter[]{qFilter});
        return BusinessDataServiceHelper.load((Object[])ruleCollection.stream().map(e -> e.getLong("id")).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)TOTF_RULE_WATERFUND));
    }

    public static BigDecimal PrepayAccountCalculate(Long rootOrgId, Date startDate, Date endDate, DynamicObjectCollection accountList, long id) {
        ArrayList<DynamicObject> prepayDetailList = new ArrayList<DynamicObject>(1);
        BigDecimal taxableitem = WaterFundAccrualDataService.setPrepayDetailList(rootOrgId, startDate, endDate, prepayDetailList, accountList, id);
        return taxableitem;
    }

    public static BigDecimal setPrepayDetailList(Long rootOrgId, Date startDate, Date endDate, List<DynamicObject> summaryAccountingList, DynamicObjectCollection accountList, long id) {
        Optional<BigDecimal> reduce = accountList.stream().filter(s -> startDate.compareTo(s.getDate("startdate")) <= 0 && endDate.compareTo(s.getDate("enddate")) >= 0).map(e -> e.getBigDecimal("entryentity.prepaybase")).reduce(BigDecimal::add);
        if (reduce.isPresent()) {
            return reduce.get();
        }
        return BigDecimal.ZERO;
    }
}

