/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.totf.business.engine.impl;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.mq.DeclareTaxType;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineTask;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgUtils;
import kd.taxc.bdtaxr.common.threadpools.Task;
import kd.taxc.bdtaxr.common.threadpools.ThreadPoolsService;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.db.DBUtils;
import kd.taxc.bdtaxr.common.util.param.SystemParamUtil;
import kd.taxc.totf.business.engine.WaterFundHelper;
import kd.taxc.totf.business.engine.task.RuleSettingTask;
import kd.taxc.totf.business.service.WaterFundAutoCollectEngineService;

public class WaterFundAutoCollectEngine {
    private static final String TOTF_RULE_WATERFUND = "totf_rule_waterfund";
    private static final String TOTF_WATER_FUND = "totf_water_fund";
    private static final String TOTF_WATERFUND_DETAIL = "totf_waterfund_detail";
    private static final String TOTF_DETAIL_ADJUST = "totf_accountdetail_adjust";
    private static final String TOTF_SHARINGPLAN = "totf_sharingplan";
    private static final String TOTF_EDIT_SHARINGPLAN = "totf_edit_sharingplan";
    private static final String TAXTYPE_SLJSJJ = "sljsjj";
    private static Log logger = LogFactory.getLog(WaterFundAutoCollectEngine.class);

    public static void execute(EngineModel engineModel) {
        Long rootOrgId = Long.valueOf(engineModel.getOrgId());
        Date startDate = DateUtils.stringToDate((String)engineModel.getStartDate());
        Date endDate = DateUtils.stringToDate((String)engineModel.getEndDate());
        String declaration = OrgUtils.getOrgGroupDeclaration((Long)rootOrgId, (String)TAXTYPE_SLJSJJ, (Date)startDate, (Date)endDate);
        List orgList = Collections.singletonList(rootOrgId);
        if ("2".equals(declaration)) {
            orgList = OrgUtils.getOrgGroupDetails((Long)rootOrgId, (String)TAXTYPE_SLJSJJ, (Date)startDate, (Date)endDate);
        }
        try (TXHandle h = TX.requiresNew();){
            try {
                WaterFundAutoCollectEngine.deleteExistData(rootOrgId, startDate, endDate);
                WaterFundAutoCollectEngine.runEngine(rootOrgId, orgList, startDate, endDate, engineModel, declaration);
            }
            catch (Throwable t) {
                h.markRollback();
                throw new RuntimeException(t);
            }
        }
    }

    private static void runEngine(Long rootOrgId, List<Long> orgList, Date startDate, Date endDate, EngineModel engineModel, String declaration) throws Exception {
        logger.info("\u5f00\u59cb\u6267\u884c\u6c34\u5229\u5efa\u8bbe\u57fa\u91d1\u53f0\u8d26\u5f15\u64ce");
        long start = System.currentTimeMillis();
        boolean isprepay = (Boolean)SystemParamUtil.getAppParameter((String)"totf", (String)"prepay", (long)rootOrgId);
        if (isprepay) {
            List declareserialnoList;
            QFilter accountFilter;
            DynamicObjectCollection prepayAccount;
            List monthBetween = DateUtils.getMonthBetween((Date)startDate, (Date)endDate, (String)"yyyy-MM-dd");
            List<Date> monthList = monthBetween.stream().map(m -> DateUtils.stringToDate((String)m)).collect(Collectors.toList());
            QFilter filter = new QFilter("org", "=", (Object)rootOrgId).and(new QFilter("billstatus", "=", (Object)"C"));
            QFilter timefilter = new QFilter("skssqq", "=", (Object)startDate).and(new QFilter("skssqz", "=", (Object)endDate));
            monthList.forEach(s -> timefilter.or(new QFilter("skssqq", "=", s).and(new QFilter("skssqz", "=", (Object)DateUtils.getLastDateOfMonth2((Date)s)))));
            DynamicObjectCollection prepayDeclareQuery = QueryServiceHelper.query((String)"tcvat_prepay_declare_bill", (String)"sbbid,declareserialno", (QFilter[])new QFilter[]{filter, timefilter});
            if (prepayDeclareQuery != null && prepayDeclareQuery.size() > 0 && (prepayAccount = QueryServiceHelper.query((String)"tcvat_project_account", (String)"orgid,taxoffice,prepaytype,startdate,enddate,declareserialno,entryentity.taxtype,entryentity.prepayrate,entryentity.prepaybase", (QFilter[])new QFilter[]{accountFilter = new QFilter("orgid", "=", (Object)rootOrgId).and(new QFilter("declareserialno", "in", declareserialnoList = prepayDeclareQuery.stream().map(p -> p.getString("declareserialno")).collect(Collectors.toList()))).and(new QFilter("entryentity.taxtype", "=", (Object)ResManager.loadKDString((String)"\u6c34\u5229\u5efa\u8bbe\u57fa\u91d1", (String)"WaterFundAutoCollectEngine_0", (String)"taxc-totf", (Object[])new Object[0])))})) != null && prepayAccount.size() > 0) {
                Map<String, List<DynamicObject>> accountGroupByMap = prepayAccount.stream().collect(Collectors.groupingBy(p -> p.getString("orgid") + p.getString("taxoffice") + p.getString("prepaytype")));
                WaterFundAutoCollectEngineService.PrepayAccountCalculate(rootOrgId, startDate, endDate, engineModel, declaration, accountGroupByMap);
            }
        }
        WaterFundAutoCollectEngine.ruleCalculate(rootOrgId, orgList, startDate, endDate, engineModel, declaration);
        logger.info("\u7ed3\u675f\u6267\u884c\u6c34\u5229\u5efa\u8bbe\u57fa\u91d1\u53f0\u8d26\u5f15\u64ce\uff0c\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start));
    }

    private static void ruleCalculate(Long rootOrgId, List<Long> orgList, Date startDate, Date endDate, EngineModel engineModel, String declaration) throws Exception {
        ArrayList<DynamicObject> summaryList = new ArrayList<DynamicObject>();
        long id = DBUtils.getLongId((String)TOTF_WATER_FUND);
        DynamicObject[] rules = WaterFundAutoCollectEngine.fetchRuleids(orgList.get(0));
        if (rules.length == 0) {
            return;
        }
        DynamicObject summary = WaterFundAutoCollectEngineService.getSummaryObject(id, rootOrgId, startDate, endDate, engineModel, declaration);
        TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainByOrgId((Long)rootOrgId);
        if (result.isSuccess() && EmptyCheckUtils.isNotEmpty((Object)result.getData())) {
            summary.set("taxoffice", (Object)((DynamicObject)result.getData()).getLong("taxoffice.id"));
        }
        ArrayList<Future<Object>> futures = new ArrayList<Future<Object>>();
        for (Long orgid : orgList) {
            futures.addAll(WaterFundAutoCollectEngine.calSummaryAccountByOrg(engineModel, id, orgid));
        }
        List summaryAccountingList = EngineTask.getFutureList(futures);
        BigDecimal totalTaxableitem = WaterFundHelper.calcSumAmountByGroup(summaryAccountingList);
        WaterFundHelper.calculateAmounts(summary, totalTaxableitem);
        summaryList.add(summary);
        SaveServiceHelper.save((DynamicObject[])summaryAccountingList.toArray(new DynamicObject[0]));
        SaveServiceHelper.save((DynamicObject[])summaryList.toArray(new DynamicObject[0]));
    }

    private static List<Future<Object>> calSummaryAccountByOrg(EngineModel engineModel, long id, Long orgid) {
        DynamicObject[] rules = WaterFundAutoCollectEngine.fetchRuleids(orgid);
        ArrayList<Future<Object>> futures = new ArrayList<Future<Object>>();
        for (DynamicObject rule : rules) {
            RuleSettingTask ruleSettingTask = new RuleSettingTask(orgid, engineModel, rule, rule.getDynamicObjectCollection("entryentity"), String.valueOf(id), TOTF_WATERFUND_DETAIL, DeclareTaxType.SLJSJJ.getBaseTaxId());
            futures.addAll(ThreadPoolsService.getInstance().submitReturnFuture((Task)ruleSettingTask));
        }
        return futures;
    }

    public static void deleteExistData(Long orgId, Date startDate, Date endDate) {
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter dateFilter = new QFilter("startdate", "=", (Object)startDate).and(new QFilter("enddate", "=", (Object)endDate));
        QFilter skssqqzFilter = new QFilter("skssqq", "=", (Object)startDate).and(new QFilter("skssqz", "=", (Object)endDate));
        DeleteServiceHelper.delete((String)TOTF_WATER_FUND, (QFilter[])new QFilter[]{orgFilter, dateFilter});
        DeleteServiceHelper.delete((String)TOTF_WATERFUND_DETAIL, (QFilter[])new QFilter[]{orgFilter, skssqqzFilter});
        DeleteServiceHelper.delete((String)TOTF_DETAIL_ADJUST, (QFilter[])new QFilter[]{orgFilter, skssqqzFilter});
    }

    private static DynamicObject[] fetchRuleids(Long orgid) {
        ArrayList orgQfilters = Lists.newArrayList((Object[])new QFilter[]{new QFilter("orgentity.org", "=", (Object)orgid)});
        DynamicObjectCollection sharingRules = QueryServiceHelper.query((String)"totf_shareplan", (String)"ruleentity.rule as ruleid, ruleentity.rule.group as groupid", (QFilter[])orgQfilters.toArray(new QFilter[0]));
        List sharingPlanRuleIdList = sharingRules.stream().map(e -> e.getLong("ruleid")).collect(Collectors.toList());
        QFilter orgFilter = new QFilter("org", "=", (Object)orgid);
        QFilter ruletypeFilter = new QFilter("ruletype", "=", (Object)"private");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter ruleIdFilter = new QFilter("id", "in", sharingPlanRuleIdList);
        QFilter rulePurposeFilter = new QFilter("rulepurpose", "like", (Object)"%nssb%");
        QFilter qFilter = enableFilter.and(rulePurposeFilter).and(ruleIdFilter.or(orgFilter.and(ruletypeFilter)));
        DynamicObjectCollection ruleCollection = QueryServiceHelper.query((String)TOTF_RULE_WATERFUND, (String)"id,name", (QFilter[])new QFilter[]{qFilter});
        return BusinessDataServiceHelper.load((Object[])ruleCollection.stream().map(e -> e.getLong("id")).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)TOTF_RULE_WATERFUND));
    }
}

