/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.totf.business.engine.impl;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.constant.RequestResult;
import kd.taxc.bdtaxr.common.mq.DeclareTaxType;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineTask;
import kd.taxc.bdtaxr.common.threadpools.Task;
import kd.taxc.bdtaxr.common.threadpools.ThreadPoolsService;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.totf.business.engine.WaterFundHelper;
import kd.taxc.totf.business.engine.task.RuleSettingTask;

public class WaterSoilCompensationEngine {
    private static final String TOTF_RULE_STBCBCF = "totf_rule_stbcbcf";
    private static final String TOTF_STBCBCF_DETAIL = "totf_stbcbcf_detail";
    private static final String TOTF_DETAIL_ADJUST = "totf_adjust_detail";
    private static final String TOTF_DETAIL_EDIT = "totf_detail_edit";
    private static final String TAXTYPE_STBCBCF = "stbcbcf";

    public static RequestResult execute(EngineModel engineModel) {
        Long rootOrgId = Long.valueOf(engineModel.getOrgId());
        Date startDate = DateUtils.stringToDate((String)engineModel.getStartDate());
        Date endDate = DateUtils.stringToDate((String)engineModel.getEndDate());
        Long zspm = (Long)engineModel.getCustom().get("zspm");
        Long zszm = (Long)engineModel.getCustom().get("zszm");
        String itemnumber = (String)engineModel.getCustom().get("itemnumber");
        Throwable throwable = null;
        try (TXHandle h = TX.requiresNew();){
            WaterSoilCompensationEngine.deleteExistData(rootOrgId, startDate, endDate, zspm, zszm, itemnumber);
            RequestResult requestResult = WaterSoilCompensationEngine.runEngine(rootOrgId, zspm, zszm, engineModel);
            return requestResult;
        }
        catch (Throwable t) {
            try {
                h.markRollback();
                throw new RuntimeException(t);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    private static RequestResult runEngine(Long rootOrgId, Long zspm, Long zszm, EngineModel engineModel) throws Exception {
        HashMap<String, Comparable<BigDecimal>> resultMap = new HashMap<String, Comparable<BigDecimal>>(8);
        DynamicObject[] rules = WaterSoilCompensationEngine.fetchRuleids(rootOrgId, zspm, zszm);
        String serialno = String.valueOf(rootOrgId) + zspm;
        if (zszm != null) {
            serialno = serialno + zszm;
        }
        if (rules.length == 0) {
            resultMap.put("amount", BigDecimal.ZERO);
            resultMap.put("isrule", Boolean.FALSE);
            return RequestResult.success(resultMap);
        }
        ArrayList<? extends Future<Object>> futures = new ArrayList<Future<Object>>(WaterSoilCompensationEngine.calSummaryAccountByOrg(engineModel, serialno, rootOrgId, rules));
        List summaryAccountingList = EngineTask.getFutureList(futures);
        SaveServiceHelper.save((DynamicObject[])summaryAccountingList.toArray(new DynamicObject[0]));
        resultMap.put("amount", WaterFundHelper.calcSumAmountByGroup(summaryAccountingList));
        resultMap.put("isrule", Boolean.TRUE);
        return RequestResult.success(resultMap);
    }

    private static Collection<? extends Future<Object>> calSummaryAccountByOrg(EngineModel engineModel, String id, Long orgid, DynamicObject[] rules) {
        ArrayList futures = new ArrayList();
        for (DynamicObject rule : rules) {
            RuleSettingTask ruleSettingTask = new RuleSettingTask(orgid, engineModel, rule, rule.getDynamicObjectCollection("entryentity"), id, TOTF_STBCBCF_DETAIL, DeclareTaxType.STBCBCF.getBaseTaxId());
            futures.addAll(ThreadPoolsService.getInstance().submitReturnFuture((Task)ruleSettingTask));
        }
        return futures;
    }

    private static DynamicObject[] fetchRuleids(Long orgid, Long zspm, Long zszm) {
        ArrayList orgQfilters = Lists.newArrayList((Object[])new QFilter[]{new QFilter("orgentity.org", "=", (Object)orgid)});
        DynamicObjectCollection sharingRules = QueryServiceHelper.query((String)"totf_shareplan", (String)"ruleentity.rule as ruleid, ruleentity.rule.group as groupid", (QFilter[])orgQfilters.toArray(new QFilter[0]));
        List sharingPlanRuleIdList = sharingRules.stream().map(e -> e.getLong("ruleid")).collect(Collectors.toList());
        QFilter orgFilter = new QFilter("org", "=", (Object)orgid);
        QFilter collectionitemFilter = new QFilter("collectionitem", "=", (Object)zspm);
        if (zszm != null) {
            collectionitemFilter.and(new QFilter("zszm", "=", (Object)zszm));
        } else {
            collectionitemFilter.and(new QFilter("zszm", "=", (Object)0L));
        }
        QFilter ruletypeFilter = new QFilter("ruletype", "=", (Object)"private");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter ruleIdFilter = new QFilter("id", "in", sharingPlanRuleIdList);
        QFilter rulePurposeFilter = new QFilter("rulepurpose", "like", (Object)"%nssb%");
        QFilter qFilter = enableFilter.and(rulePurposeFilter).and(ruleIdFilter.or(orgFilter.and(ruletypeFilter)));
        DynamicObjectCollection ruleCollection = QueryServiceHelper.query((String)TOTF_RULE_STBCBCF, (String)"id,name", (QFilter[])new QFilter[]{qFilter, collectionitemFilter});
        return BusinessDataServiceHelper.load((Object[])ruleCollection.stream().map(e -> e.getLong("id")).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)TOTF_RULE_STBCBCF));
    }

    public static void deleteExistData(Long orgId, Date startDate, Date endDate, Long zspm, Long zszm, String itemnumber) {
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter skssqqzFilter = new QFilter("skssqq", "=", (Object)startDate).and(new QFilter("skssqz", "=", (Object)endDate));
        QFilter itemnumberFilter = new QFilter("itemnumber", "=", (Object)itemnumber).or(new QFilter("itemnumber", "=", (Object)(itemnumber + "_")));
        String serialno = String.valueOf(orgId) + zspm;
        if (zszm != null) {
            serialno = serialno + zszm;
        }
        QFilter taxaccountserialnoFilter = new QFilter("taxaccountserialno", "=", (Object)serialno);
        DeleteServiceHelper.delete((String)TOTF_STBCBCF_DETAIL, (QFilter[])new QFilter[]{orgFilter, skssqqzFilter, taxaccountserialnoFilter});
        DeleteServiceHelper.delete((String)TOTF_DETAIL_ADJUST, (QFilter[])new QFilter[]{orgFilter, skssqqzFilter, itemnumberFilter});
        DeleteServiceHelper.delete((String)TOTF_DETAIL_EDIT, (QFilter[])new QFilter[]{orgFilter, skssqqzFilter, itemnumberFilter});
    }
}

